/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.draw2d.internal.ImageUtils;
import org.eclipse.draw2d.internal.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;

public class FileImageDataProvider
implements ImageDataProvider {
    private static final Logger LOGGER = Logger.getLogger(FileImageDataProvider.class);
    private final Class<?> clazz;
    private final String basePath;
    private final String fileExtension;

    private FileImageDataProvider(Class<?> clazz, String path) {
        int separator = path.lastIndexOf(".");
        this.clazz = clazz;
        this.basePath = path.substring(0, separator);
        this.fileExtension = path.substring(separator + 1);
    }

    public ImageData getImageData(int zoom) {
        if (zoom == 100) {
            return this.createImageData(this.basePath + "." + this.fileExtension);
        }
        if (zoom == 200) {
            return this.createImageData(this.basePath + "@2x." + this.fileExtension);
        }
        return null;
    }

    private ImageData createImageData(String name) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = this.clazz.getResourceAsStream(name);){
                return new ImageData(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            LOGGER.error(ioe.getLocalizedMessage(), ioe);
            return null;
        }
    }

    public static Image createImage(Class<?> clazz, String name) {
        String fileName = ImageUtils.getEffectiveFileName(name);
        if (fileName.endsWith(".svg")) {
            return FileImageDataProvider.createSvgImage(clazz, fileName);
        }
        return new Image(null, (ImageDataProvider)new FileImageDataProvider(clazz, fileName));
    }

    private static Image createSvgImage(Class<?> clazz, String name) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = clazz.getResourceAsStream(name);){
                return new Image(null, stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            LOGGER.error(ioe.getLocalizedMessage(), ioe);
            return null;
        }
    }
}

