/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.terminal.ui;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.AdapterTypes;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.model.IBinaryStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.terminal.PtyRuntimeProcess;
import org.eclipse.debug.terminal.ui.ConsoleConnector;
import org.eclipse.debug.terminal.ui.TerminalConsolePage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.osgi.service.component.annotations.Component;

@AdapterTypes(adaptableClass={PtyRuntimeProcess.class}, adapterNames={IPageBookViewPage.class})
@Component
public class PageBookAdapter
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        PtyRuntimeProcess rt;
        Spawner spawner;
        if (adaptableObject instanceof PtyRuntimeProcess && (spawner = (rt = (PtyRuntimeProcess)((Object)adaptableObject)).getSpawner()) != null) {
            return adapterType.cast(new TerminalConsolePage(new ConsoleConnector(spawner), terminal -> {
                IStreamMonitor streamMonitor = rt.getStreamsProxy().getOutputStreamMonitor();
                if (streamMonitor instanceof IBinaryStreamMonitor) {
                    IBinaryStreamMonitor bin = (IBinaryStreamMonitor)streamMonitor;
                    OutputStream outputStream = terminal.getRemoteToTerminalOutputStream();
                    bin.addBinaryListener((data, monitor) -> {
                        try {
                            outputStream.write(data);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    });
                }
            }));
        }
        return null;
    }
}

