/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.Messages;
import org.eclipse.xtext.ui.editor.SchedulingRuleFactory;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.internal.XtextPluginImages;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.validation.Issue;

public class XtextEditorErrorTickUpdater
extends IXtextEditorCallback.NullImpl
implements IAnnotationModelListener {
    private static final ISchedulingRule SEQUENCE_RULE = SchedulingRuleFactory.INSTANCE.newSequence();
    @Inject
    private IImageHelper imageHelper;
    @Inject
    private IssueUtil issueUtil;
    private volatile Image defaultImage;
    private volatile XtextEditor editor;
    private IAnnotationModel annotationModel;

    @Override
    public void beforeDispose(XtextEditor xtextEditor) {
        this.unregisterListener();
        if (this.editor != null) {
            if (this.defaultImage != null && !this.defaultImage.isDisposed()) {
                this.editor.updatedTitleImage(this.defaultImage);
            }
            this.editor = null;
            this.defaultImage = null;
        }
    }

    @Override
    public void afterSetInput(XtextEditor xtextEditor) {
        if (this.editor != null) {
            this.unregisterListener();
            this.updateImageAndRegisterListener();
        }
    }

    @Override
    public void afterCreatePartControl(XtextEditor xtextEditor) {
        this.editor = xtextEditor;
        this.updateImageAndRegisterListener();
    }

    protected void unregisterListener() {
        if (this.annotationModel != null) {
            this.annotationModel.removeAnnotationModelListener((IAnnotationModelListener)this);
            this.annotationModel = null;
        }
    }

    protected void updateImageAndRegisterListener() {
        this.defaultImage = this.editor.getDefaultImage();
        this.updateEditorImage(this.editor);
        ISourceViewer sourceViewer = this.editor.getInternalSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        this.annotationModel = sourceViewer.getAnnotationModel();
        if (this.annotationModel != null) {
            this.annotationModel.addAnnotationModelListener((IAnnotationModelListener)this);
        }
    }

    protected void updateEditorImage(XtextEditor xtextEditor) {
        Severity severity = this.getSeverity(xtextEditor);
        Image locImage = this.defaultImage;
        if (locImage != null && !locImage.isDisposed()) {
            if (severity != null && severity != Severity.INFO) {
                ImageDescriptor descriptor = severity == Severity.ERROR ? XtextPluginImages.DESC_OVR_ERROR : XtextPluginImages.DESC_OVR_WARNING;
                DecorationOverlayIcon decorationOverlayIcon = new DecorationOverlayIcon(locImage, descriptor, 2);
                this.scheduleUpdateEditor((ImageDescriptor)decorationOverlayIcon);
            } else {
                this.scheduleUpdateEditor(locImage);
            }
        }
    }

    protected Severity getSeverity(XtextEditor xtextEditor) {
        if (xtextEditor == null || xtextEditor.getInternalSourceViewer() == null) {
            return null;
        }
        IAnnotationModel model = xtextEditor.getInternalSourceViewer().getAnnotationModel();
        if (model != null) {
            Iterator iterator = model.getAnnotationIterator();
            boolean hasWarnings = false;
            boolean hasInfos = false;
            while (iterator.hasNext()) {
                Issue issue;
                Annotation annotation = (Annotation)iterator.next();
                if (annotation.isMarkedDeleted() || (issue = this.issueUtil.getIssueFromAnnotation(annotation)) == null) continue;
                if (issue.getSeverity() == Severity.ERROR) {
                    return Severity.ERROR;
                }
                if (issue.getSeverity() == Severity.WARNING) {
                    hasWarnings = true;
                    continue;
                }
                if (issue.getSeverity() != Severity.INFO) continue;
                hasInfos = true;
            }
            if (hasWarnings) {
                return Severity.WARNING;
            }
            if (hasInfos) {
                return Severity.INFO;
            }
        }
        return null;
    }

    public void scheduleUpdateEditor(final ImageDescriptor titleImageDescription) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                XtextEditor locEditor = XtextEditorErrorTickUpdater.this.editor;
                if (locEditor != null) {
                    Image image = XtextEditorErrorTickUpdater.this.imageHelper.getImage(titleImageDescription);
                    if (locEditor.getTitleImage() != image) {
                        locEditor.updatedTitleImage(image);
                    }
                }
            }
        });
    }

    public void scheduleUpdateEditor(final Image titleImage) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                XtextEditor locEditor = XtextEditorErrorTickUpdater.this.editor;
                if (locEditor != null && locEditor.getTitleImage() != titleImage) {
                    locEditor.updatedTitleImage(titleImage);
                }
            }
        });
    }

    @Deprecated
    public void scheduleUpdateEditorJob(Image image) {
        UpdateEditorImageJob job = this.createUpdateEditorImageJob();
        job.scheduleFor(image);
    }

    @Deprecated
    protected UpdateEditorImageJob createUpdateEditorImageJob() {
        return new UpdateEditorImageJob(SEQUENCE_RULE);
    }

    public void modelChanged(IAnnotationModel model) {
        this.updateEditorImage(this.editor);
    }

    @Deprecated
    protected class UpdateEditorImageJob
    extends UIJob {
        private volatile Image titleImage;
        private volatile ImageDescriptor titleImageDescription;

        public UpdateEditorImageJob(ISchedulingRule schedulingRule) {
            super(Messages.XtextEditorErrorTickUpdater_JobName);
            this.setRule(schedulingRule);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IEditorSite site;
            XtextEditor locEditor = XtextEditorErrorTickUpdater.this.editor;
            IEditorSite iEditorSite = site = locEditor != null ? locEditor.getEditorSite() : null;
            if (site != null && !monitor.isCanceled() && locEditor != null) {
                if (this.titleImage != null && !this.titleImage.isDisposed()) {
                    locEditor.updatedTitleImage(this.titleImage);
                    this.titleImage = null;
                } else if (this.titleImageDescription != null) {
                    Image image = XtextEditorErrorTickUpdater.this.imageHelper.getImage(this.titleImageDescription);
                    if (locEditor.getTitleImage() != image) {
                        locEditor.updatedTitleImage(image);
                    }
                    this.titleImageDescription = null;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        protected void scheduleFor(Image image) {
            this.titleImage = image;
            this.schedule();
        }

        protected void scheduleFor(ImageDescriptor imageDescription) {
            this.titleImageDescription = imageDescription;
            this.schedule();
        }
    }
}

