/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.gef.header.selection;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.border.CompoundBorder;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.border.MarginBorder;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;
import org.eclipse.wb.internal.swing.MigLayout.gef.GefMessages;

public final class ResizeHintFigure
extends Figure {
    private String m_text;
    private static final Shell HIDDEN_SHELL = new Shell();

    public ResizeHintFigure() {
        this.setOpaque(true);
        this.setBackgroundColor(ColorConstants.tooltipBackground);
        this.setForegroundColor(ColorConstants.tooltipForeground);
        this.setBorder((Border)new CompoundBorder((org.eclipse.wb.draw2d.border.Border)new LineBorder(ColorConstants.tooltipForeground), (org.eclipse.wb.draw2d.border.Border)new MarginBorder(5)));
    }

    public void setText(String text) {
        this.m_text = text;
        this.update();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        GC gc = new GC((Drawable)HIDDEN_SHELL);
        try {
            SWTGraphics graphics = new SWTGraphics(gc);
            Dimension size = this.doPaint((Graphics)graphics);
            Insets insets = this.getInsets();
            Dimension dimension = size.getExpanded(insets.getWidth(), insets.getHeight());
            return dimension;
        }
        finally {
            gc.dispose();
        }
    }

    private void update() {
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    static SizeElement getNewSizeElement(char c) {
        if ((c = Character.toUpperCase(c)) == 'N') {
            return SizeElement.MIN;
        }
        if (c == 'P') {
            return SizeElement.PREF;
        }
        if (c == 'X') {
            return SizeElement.MAX;
        }
        return null;
    }

    static String getNewSizeUnit(char c) {
        if ((c = Character.toUpperCase(c)) == '0') {
            return "";
        }
        if (c == '1') {
            return "px";
        }
        if (c == '2') {
            return "%";
        }
        if (c == '3') {
            return "lp";
        }
        if (c == '4') {
            return "pt";
        }
        if (c == '5') {
            return "mm";
        }
        if (c == '6') {
            return "cm";
        }
        if (c == '7') {
            return "in";
        }
        if (c == '8') {
            return "sp";
        }
        return null;
    }

    protected void paintClientArea(Graphics graphics) {
        this.doPaint(graphics);
    }

    private Dimension doPaint(Graphics graphics) {
        Font font = this.getFont();
        Font boldFont = DrawUtils.getBoldFont((Font)font);
        try {
            int y = ResizeHintFigure.drawText((Graphics)graphics, (String)this.m_text, (int)0, (int)0, (Font)font).height;
            int x = 0;
            Dimension size = ResizeHintFigure.drawText(graphics, GefMessages.ResizeHintFigure_note, x, y + 1, boldFont);
            size = ResizeHintFigure.drawText(graphics, GefMessages.ResizeHintFigure_keyHint, x += size.width, y, font);
            x += size.width;
            x = 10;
            size = ResizeHintFigure.drawHintColumn(graphics, x, y += size.height, boldFont, font, new String[]{"N", "P", "X"}, new String[]{GefMessages.ResizeHintFigure_minimumSize, GefMessages.ResizeHintFigure_preferredSize, GefMessages.ResizeHintFigure_maximumSize});
            size = ResizeHintFigure.drawHintColumn(graphics, x += size.width + 10, y, boldFont, font, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8"}, new String[]{GefMessages.ResizeHintFigure_unit_default, GefMessages.ResizeHintFigure_unit_pixels, GefMessages.ResizeHintFigure_unit_percents, GefMessages.ResizeHintFigure_unit_logicalPixels, GefMessages.ResizeHintFigure_unit_points, GefMessages.ResizeHintFigure_unit_millimeters, GefMessages.ResizeHintFigure_unit_centimeters, GefMessages.ResizeHintFigure_unit_inches, GefMessages.ResizeHintFigure_unit_screenPercents});
            Dimension dimension = new Dimension(x + size.width, y + size.height);
            return dimension;
        }
        finally {
            boldFont.dispose();
        }
    }

    private static Dimension drawText(Graphics graphics, String text, int x, int y, Font font) {
        graphics.setFont(font);
        graphics.drawText(text, x, y);
        return FigureUtils.calculateTextSize((String)text, (Font)font);
    }

    private static Dimension drawHintColumn(Graphics graphics, int x_, int y_, Font keyFont, Font textFont, String[] keyArray, String[] textArray) {
        int lineWidth = 0;
        int lineHeight = 0;
        graphics.pushState();
        try {
            Dimension size;
            int keyWidth = 0;
            String[] stringArray = keyArray;
            int n = keyArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                size = FigureUtils.calculateTextSize((String)key, (Font)keyFont);
                keyWidth = Math.max(keyWidth, size.width);
                lineHeight = size.height;
                ++n2;
            }
            int y = y_;
            int i = 0;
            while (i < keyArray.length) {
                int x = x_;
                String key = keyArray[i];
                graphics.setForegroundColor(ColorConstants.blue);
                ResizeHintFigure.drawText(graphics, key, x, y, keyFont);
                x += keyWidth;
                String text = " - ";
                graphics.setForegroundColor(ColorConstants.black);
                x += ResizeHintFigure.drawText((Graphics)graphics, (String)text, (int)x, (int)y, (Font)textFont).width;
                text = textArray[i];
                int boldEnd = text.indexOf(124);
                if (boldEnd != -1) {
                    String boldText = text.substring(0, boldEnd);
                    graphics.setForegroundColor(ColorConstants.black);
                    x += ResizeHintFigure.drawText((Graphics)graphics, (String)boldText, (int)x, (int)y, (Font)keyFont).width;
                    text = text.substring(boldEnd + 1);
                }
                graphics.setForegroundColor(ColorConstants.black);
                size = ResizeHintFigure.drawText(graphics, text, x, y, textFont);
                lineWidth = Math.max(lineWidth, x - x_ + size.width);
                y += lineHeight;
                ++i;
            }
            Dimension dimension = new Dimension(lineWidth, y - y_);
            return dimension;
        }
        finally {
            graphics.popState();
        }
    }

    static enum SizeElement {
        ALL,
        MIN,
        PREF,
        MAX;

    }
}

