/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.presentation;

import java.util.Optional;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PresentationButton;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;

public abstract class ButtonPropertyEditorPresentation
extends PropertyEditorPresentation {
    @Override
    public IFigure getFigure(PropertyTable propertyTable, Property property) {
        PresentationButton button = new PresentationButton(this, this.getImage());
        button.setPreferredSize(propertyTable.getRowHeight(), propertyTable.getRowHeight());
        this.getTooltip().ifPresent(arg_0 -> ButtonPropertyEditorPresentation.lambda$0((Clickable)button, arg_0));
        button.getModel().addChangeListener(event -> {
            if ("pressed".equals(event.getPropertyName())) {
                propertyTable.deactivateEditor(true);
                propertyTable.setActiveProperty(property);
            }
        });
        button.getModel().addActionListener(event -> {
            try {
                this.onClick(propertyTable, property);
            }
            catch (Throwable e) {
                propertyTable.deactivateEditor(false);
                propertyTable.handleException(e);
            }
        });
        return button;
    }

    protected Image getImage() {
        return CoreImages.getSharedImage(CoreImages.PROPERTIES_DOTS);
    }

    protected Optional<String> getTooltip() {
        return Optional.empty();
    }

    protected abstract void onClick(PropertyTable var1, Property var2) throws Exception;

    private static /* synthetic */ void lambda$0(Clickable clickable, String tooltip) {
        clickable.setToolTip((IFigure)new Label(tooltip));
    }
}

