/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.uml2.common.CommonPlugin;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.osgi.framework.Bundle;

public class UML2Util {
    protected static final URIConverter DEFAULT_URI_CONVERTER = new ExtensibleURIConverterImpl();
    protected static final Map<Resource, Map<Locale, ResourceBundle>> RESOURCE_BUNDLES = Collections.synchronizedMap(new WeakHashMap());
    public static final String EMPTY_STRING = "";
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String URI_SCHEME_PLATFORM = "platform";
    public static final String URI_SEGMENT_PLUGIN = "plugin";
    public static final String URI_SEGMENT_RESOURCE = "resource";
    public static final String PROPERTIES_FILE_EXTENSION = "properties";

    protected UML2Util() {
    }

    protected static List<URI> getResourceBundleURIs(URI baseURI, Locale locale, String baseSegment) {
        ArrayList<URI> resourceBundleURIs = new ArrayList<URI>();
        String language = locale.getLanguage();
        if (language.length() > 0) {
            baseSegment = String.valueOf(baseSegment) + '_' + language;
            resourceBundleURIs.add(0, baseURI.appendSegment(baseSegment).appendFileExtension(PROPERTIES_FILE_EXTENSION));
            String country = locale.getCountry();
            if (country.length() > 0) {
                baseSegment = String.valueOf(baseSegment) + '_' + country;
                resourceBundleURIs.add(0, baseURI.appendSegment(baseSegment).appendFileExtension(PROPERTIES_FILE_EXTENSION));
                String variant = locale.getVariant();
                if (variant.length() > 0) {
                    baseSegment = String.valueOf(baseSegment) + '_' + variant;
                    resourceBundleURIs.add(0, baseURI.appendSegment(baseSegment).appendFileExtension(PROPERTIES_FILE_EXTENSION));
                }
            }
        }
        return resourceBundleURIs;
    }

    protected static List<URI> getResourceBundleURIs(URI uri, Locale locale) {
        ArrayList<URI> resourceBundleURIs = new ArrayList<URI>();
        URI baseURI = uri.trimSegments(1);
        String baseSegment = uri.trimFileExtension().lastSegment();
        if (baseSegment != null) {
            resourceBundleURIs.add(baseURI.appendSegment(baseSegment).appendFileExtension(PROPERTIES_FILE_EXTENSION));
            if (locale != null) {
                Locale defaultLocale = Locale.getDefault();
                resourceBundleURIs.addAll(0, UML2Util.getResourceBundleURIs(baseURI, defaultLocale, baseSegment));
                if (!locale.equals(defaultLocale)) {
                    resourceBundleURIs.addAll(0, UML2Util.getResourceBundleURIs(baseURI, locale, baseSegment));
                }
            }
        }
        return resourceBundleURIs;
    }

    protected static ResourceBundle getResourceBundle(EObject eObject, Locale locale) {
        Resource resource = eObject.eResource();
        if (resource != null) {
            Map<Locale, ResourceBundle> resourceBundles = RESOURCE_BUNDLES.get(resource);
            if (resourceBundles == null) {
                resourceBundles = Collections.synchronizedMap(new HashMap());
                RESOURCE_BUNDLES.put(resource, resourceBundles);
            }
            if (!resourceBundles.containsKey(locale)) {
                ResourceSet resourceSet = resource.getResourceSet();
                URIConverter uriConverter = resourceSet == null ? DEFAULT_URI_CONVERTER : resourceSet.getURIConverter();
                URI uri = resource.getURI();
                List<URI> resourceBundleURIs = UML2Util.getResourceBundleURIs(uri, locale);
                if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                    Bundle[] fragments;
                    Bundle bundle;
                    URI normalizedURI = uriConverter.normalize(uri);
                    int segmentCount = normalizedURI.segmentCount();
                    if (URI_SCHEME_PLATFORM.equals(normalizedURI.scheme()) && segmentCount > 2 && URI_SEGMENT_PLUGIN.equals(normalizedURI.segment(0)) && (bundle = Platform.getBundle((String)normalizedURI.segment(1))) != null && (fragments = Platform.getFragments((Bundle)bundle)) != null) {
                        String[] trailingSegments = normalizedURI.segmentsList().subList(2, segmentCount).toArray(new String[0]);
                        int f = 0;
                        while (f < fragments.length) {
                            resourceBundleURIs.addAll(0, UML2Util.getResourceBundleURIs(normalizedURI.trimSegments(segmentCount - 1).appendSegment(fragments[f].getSymbolicName()).appendSegments(trailingSegments), locale));
                            ++f;
                        }
                    }
                }
                PropertyResourceBundle resourceBundle = null;
                Iterator<URI> rbu = resourceBundleURIs.iterator();
                while (rbu.hasNext()) {
                    try (InputStream inputStream = uriConverter.createInputStream(rbu.next());){
                        resourceBundle = new PropertyResourceBundle(inputStream);
                        break;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                resourceBundles.put(locale, resourceBundle);
            }
            return resourceBundles.get(locale);
        }
        return null;
    }

    protected static ResourceBundle getResourceBundle(EObject eObject, boolean localize) {
        return UML2Util.getResourceBundle(eObject, localize ? Locale.getDefault() : null);
    }

    protected static String getString(EObject eObject, String key, String defaultString, boolean localize) {
        String string = defaultString;
        if (eObject != null) {
            try {
                ResourceBundle resourceBundle = UML2Util.getResourceBundle(eObject, localize);
                if (resourceBundle != null) {
                    string = resourceBundle.getString(key);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string;
    }

    public static String getQualifiedText(EObject eObject, QualifiedTextProvider qualifiedTextProvider) {
        return UML2Util.getQualifiedText(eObject, qualifiedTextProvider, new StringBuffer()).toString();
    }

    protected static StringBuffer getQualifiedText(EObject eObject, QualifiedTextProvider qualifiedTextProvider, StringBuffer qualifiedText) {
        EObject eContainer;
        EObject eObject2 = eContainer = eObject == null ? null : eObject.eContainer();
        if (eContainer != null) {
            UML2Util.getQualifiedText(eContainer, qualifiedTextProvider, qualifiedText);
            if (qualifiedText.length() > 0) {
                qualifiedText.append(qualifiedTextProvider.getSeparator());
            }
        }
        return UML2Util.getQualifiedTextSegment(eObject, qualifiedTextProvider, qualifiedText);
    }

    protected static StringBuffer getQualifiedTextSegment(EObject eObject, QualifiedTextProvider qualifiedTextProvider, StringBuffer qualifiedText) {
        String text = qualifiedTextProvider.getText(eObject);
        if (!UML2Util.isEmpty(text)) {
            return qualifiedText.append(text);
        }
        if (eObject == null) {
            return qualifiedText.append(String.valueOf(eObject));
        }
        qualifiedText.append('{');
        EStructuralFeature eContainingFeature = eObject.eContainingFeature();
        if (eContainingFeature != null) {
            qualifiedText.append(qualifiedTextProvider.getFeatureText(eContainingFeature));
            if (eContainingFeature.isMany()) {
                qualifiedText.append(' ');
                List list = (List)eObject.eContainer().eGet(eContainingFeature, false);
                qualifiedText.append('[');
                qualifiedText.append(list.indexOf(eObject));
                qualifiedText.append(']');
            }
            qualifiedText.append(' ');
        }
        qualifiedText.append(qualifiedTextProvider.getClassText(eObject));
        qualifiedText.append('}');
        return qualifiedText;
    }

    public static String getMessageSubstitution(Map<Object, Object> context, Object object) {
        if (object instanceof EObject) {
            Resource resource;
            EObject eObject = (EObject)object;
            if (context != null) {
                EValidator.SubstitutionLabelProvider substitutionLabelProvider = (EValidator.SubstitutionLabelProvider)context.get(EValidator.SubstitutionLabelProvider.class);
                if (substitutionLabelProvider != null) {
                    return substitutionLabelProvider.getObjectLabel(eObject);
                }
                QualifiedTextProvider qualifiedTestProvider = (QualifiedTextProvider)context.get(QualifiedTextProvider.class);
                if (qualifiedTestProvider != null) {
                    return UML2Util.getQualifiedText(eObject, qualifiedTestProvider);
                }
            }
            if ((resource = eObject.eResource()) != null) {
                return String.valueOf(resource.getURI().lastSegment()) + '#' + resource.getURIFragment(eObject);
            }
            return EcoreUtil.getIdentification((EObject)((EObject)object));
        }
        if (object instanceof Collection) {
            StringBuffer messageSubstitution = new StringBuffer("[");
            for (Object element : (Collection)object) {
                if (messageSubstitution.length() > 1) {
                    messageSubstitution.append(", ");
                }
                messageSubstitution.append(UML2Util.getMessageSubstitution(context, element));
            }
            messageSubstitution.append(']');
            return messageSubstitution.toString();
        }
        return String.valueOf(object);
    }

    public static Object[] getMessageSubstitutions(Map<Object, Object> context, Object object0) {
        return new Object[]{UML2Util.getMessageSubstitution(context, object0)};
    }

    public static Object[] getMessageSubstitutions(Map<Object, Object> context, Object object0, Object object1) {
        return new Object[]{UML2Util.getMessageSubstitution(context, object0), UML2Util.getMessageSubstitution(context, object1)};
    }

    public static Object[] getMessageSubstitutions(Map<Object, Object> context, Object object0, Object object1, Object object2) {
        return new Object[]{UML2Util.getMessageSubstitution(context, object0), UML2Util.getMessageSubstitution(context, object1), UML2Util.getMessageSubstitution(context, object2)};
    }

    public static boolean safeEquals(Object object, Object otherObject) {
        return object == null ? otherObject == null : object.equals(otherObject);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static EObject findEObject(Collection<? extends EObject> eObjects, EObjectMatcher filter) {
        return UML2Util.findEObject(eObjects.iterator(), filter);
    }

    public static EObject findEObject(Iterator<? extends EObject> iterator, EObjectMatcher filter) {
        while (iterator.hasNext()) {
            EObject eObject = iterator.next();
            if (!filter.matches(eObject)) continue;
            return eObject;
        }
        return null;
    }

    protected static EClassifier getCommonEType(EClassifier eType, final EClassifier otherEType) {
        if (eType == null || eType.equals(otherEType)) {
            return eType;
        }
        return (EClassifier)new EcoreSwitch<EClassifier>(){

            public EClassifier caseEClassifier(EClassifier eClassifier) {
                return EcorePackage.eINSTANCE.getEObject();
            }

            public EClassifier caseEClass(EClass eClass) {
                if (otherEType instanceof EClass) {
                    EClass otherEClass = (EClass)otherEType;
                    if (eClass.isSuperTypeOf(otherEClass)) {
                        return eClass;
                    }
                    if (otherEClass.isSuperTypeOf(eClass)) {
                        return otherEClass;
                    }
                    for (EClass eSuperType : eClass.getEAllSuperTypes()) {
                        if (!eSuperType.isSuperTypeOf(otherEClass)) continue;
                        return eSuperType;
                    }
                    for (EClass otherESuperType : otherEClass.getEAllSuperTypes()) {
                        if (!otherESuperType.isSuperTypeOf(eClass)) continue;
                        return otherESuperType;
                    }
                }
                return (EClassifier)super.caseEClass(eClass);
            }

            public EClassifier caseEDataType(EDataType eDataType) {
                return otherEType instanceof EDataType && eDataType.getInstanceClass().equals(((EDataType)otherEType).getInstanceClass()) ? eDataType : EcorePackage.eINSTANCE.getEJavaObject();
            }

            public EClassifier caseEEnum(EEnum eEnum) {
                return otherEType instanceof EEnum ? EcorePackage.eINSTANCE.getEEnumerator() : EcorePackage.eINSTANCE.getEJavaObject();
            }
        }.doSwitch((EObject)eType);
    }

    protected static int getLesserLowerBound(int lowerBound, int otherLowerBound) {
        return Math.min(lowerBound, otherLowerBound);
    }

    protected static int getGreaterUpperBound(int upperBound, int otherUpperBound) {
        return upperBound == -1 || otherUpperBound == -1 ? -1 : Math.max(upperBound, otherUpperBound);
    }

    public static String getValidJavaIdentifier(String name) {
        return UML2Util.getValidJavaIdentifier(name, new StringBuffer()).toString();
    }

    protected static StringBuffer getValidJavaIdentifier(String name, StringBuffer validJavaIdentifier) {
        if (UML2Util.isEmpty(name)) {
            validJavaIdentifier.append('_');
        } else {
            char char_0 = name.charAt(0);
            if (Character.isJavaIdentifierStart(char_0)) {
                validJavaIdentifier.append(char_0);
            } else {
                validJavaIdentifier.append('_');
                if (Character.isJavaIdentifierPart(char_0)) {
                    validJavaIdentifier.append(char_0);
                }
            }
            int i = 1;
            while (i < name.length()) {
                char char_i = name.charAt(i);
                if (Character.isJavaIdentifierPart(char_i)) {
                    validJavaIdentifier.append(char_i);
                }
                ++i;
            }
        }
        return validJavaIdentifier;
    }

    protected static boolean isNCNameStart(char c) {
        return XMLTypeUtil.isNCNameStart((int)c);
    }

    protected static boolean isNCNamePart(char c) {
        return XMLTypeUtil.isNCNamePart((int)c);
    }

    protected static String getValidNCName(String name) {
        return UML2Util.getValidNCName(name, new StringBuffer()).toString();
    }

    protected static StringBuffer getValidNCName(String name, StringBuffer validNCName) {
        if (UML2Util.isEmpty(name)) {
            validNCName.insert(0, '_');
        } else {
            int i = name.length();
            while (--i > 0) {
                char char_i = name.charAt(i);
                if (!UML2Util.isNCNamePart(char_i)) continue;
                validNCName.insert(0, char_i);
            }
            char char_0 = name.charAt(0);
            if (UML2Util.isNCNameStart(char_0)) {
                validNCName.insert(0, char_0);
            } else {
                if (UML2Util.isNCNamePart(char_0)) {
                    validNCName.insert(0, char_0);
                }
                validNCName.insert(0, '_');
            }
        }
        return validNCName;
    }

    public static String getXMIIdentifier(InternalEObject internalEObject) {
        return UML2Util.getXMIIdentifier(internalEObject, new StringBuffer()).toString();
    }

    protected static StringBuffer getXMIIdentifier(InternalEObject internalEObject, StringBuffer xmiIdentifier) {
        InternalEObject eInternalContainer = internalEObject.eInternalContainer();
        Resource.Internal eDirectResource = internalEObject.eDirectResource();
        while (eInternalContainer != null && eDirectResource == null) {
            UML2Util.getValidNCName(eInternalContainer.eURIFragmentSegment(internalEObject.eContainingFeature(), (EObject)internalEObject), xmiIdentifier);
            internalEObject = eInternalContainer;
            eInternalContainer = internalEObject.eInternalContainer();
            eDirectResource = internalEObject.eDirectResource();
            if (eInternalContainer == null || eDirectResource != null) continue;
            xmiIdentifier.insert(0, '-');
        }
        if (eDirectResource != null) {
            int index = eDirectResource.getContents().indexOf((Object)internalEObject);
            int length = xmiIdentifier.length();
            if (index > 0 || length == 0) {
                if (length > 0) {
                    xmiIdentifier.insert(0, '-');
                }
                xmiIdentifier.insert(0, index);
                xmiIdentifier.insert(0, '_');
            }
        }
        return xmiIdentifier;
    }

    public static int getInstanceCount(Iterator<?> iterator, EClassifier eClassifier) {
        int count = 0;
        while (iterator.hasNext()) {
            if (!eClassifier.isInstance(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    protected static boolean addConstraint(EModelElement eModelElement, String constraint) {
        ArrayList<String> constraints;
        boolean result = false;
        if (!UML2Util.isEmpty(constraint) && !(constraints = EcoreUtil.getConstraints((EModelElement)eModelElement)).contains(constraint)) {
            constraints = new ArrayList<String>(constraints);
            result = constraints.add(constraint);
            EcoreUtil.setConstraints((EModelElement)eModelElement, constraints);
        }
        return result;
    }

    protected static void addDocumentation(EModelElement eModelElement, String text, String lineSeparator) {
        if (!UML2Util.isEmpty(text)) {
            String documentation = EcoreUtil.getDocumentation((EModelElement)eModelElement);
            EcoreUtil.setDocumentation((EModelElement)eModelElement, (String)(documentation == null ? text : String.valueOf(documentation) + lineSeparator + text));
        }
    }

    protected static void addDocumentation(EModelElement eModelElement, String text) {
        UML2Util.addDocumentation(eModelElement, text, LINE_SEPARATOR);
    }

    protected static Collection<EObject> getRootContainers(Collection<? extends EObject> eObjects) {
        UniqueEList.FastCompare rootContainers = new UniqueEList.FastCompare();
        Iterator<? extends EObject> i = eObjects.iterator();
        while (i.hasNext()) {
            rootContainers.add(EcoreUtil.getRootContainer((EObject)i.next()));
        }
        return rootContainers;
    }

    public static <T> TreeIterator<T> getAllContents(EObject eObject, boolean includeRoot, final boolean defensiveCopy) {
        return new AbstractTreeIterator<T>(eObject, includeRoot){
            private static final long serialVersionUID = 1L;

            protected Iterator<T> getChildren(Object object) {
                return defensiveCopy ? new ArrayList(((EObject)object).eContents()).iterator() : ((EObject)object).eContents().iterator();
            }
        };
    }

    public static EAnnotation createEAnnotation(EModelElement eModelElement, String source) {
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setEModelElement(eModelElement);
        eAnnotation.setSource(source);
        return eAnnotation;
    }

    public static EAnnotation getEAnnotation(EModelElement eModelElement, String source, boolean createOnDemand) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(source);
        return eAnnotation == null && createOnDemand ? UML2Util.createEAnnotation(eModelElement, source) : eAnnotation;
    }

    public static Collection<EStructuralFeature.Setting> getNonNavigableInverseReferences(EObject eObject) {
        ECrossReferenceAdapter crossReferenceAdapter = CacheAdapter.getInstance().provideCrossReferenceAdapter(eObject);
        return crossReferenceAdapter == null ? Collections.emptyList() : crossReferenceAdapter.getNonNavigableInverseReferences(eObject);
    }

    public static Collection<EStructuralFeature.Setting> getInverseReferences(EObject eObject) {
        ECrossReferenceAdapter crossReferenceAdapter = CacheAdapter.getInstance().provideCrossReferenceAdapter(eObject);
        return crossReferenceAdapter == null ? Collections.emptyList() : crossReferenceAdapter.getInverseReferences(eObject);
    }

    protected static void removeReferences(EObject eObject, EObject ancestorEObject) {
        for (EStructuralFeature.Setting nonNavigableInverseReference : new ArrayList<EStructuralFeature.Setting>(UML2Util.getNonNavigableInverseReferences(eObject))) {
            if (!nonNavigableInverseReference.getEStructuralFeature().isChangeable() || ancestorEObject != null && EcoreUtil.isAncestor((EObject)ancestorEObject, (EObject)nonNavigableInverseReference.getEObject())) continue;
            EcoreUtil.remove((EStructuralFeature.Setting)nonNavigableInverseReference, (Object)eObject);
        }
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            if (!eReference.isChangeable() || eReference.isContainer() || eReference.isContainment() || eReference.isDerived() || !eObject.eIsSet((EStructuralFeature)eReference)) continue;
            if (eReference.isMany()) {
                List values = (List)eObject.eGet((EStructuralFeature)eReference);
                int i = 0;
                while (i < values.size()) {
                    Object value = values.get(i);
                    if (ancestorEObject == null || !EcoreUtil.isAncestor((EObject)ancestorEObject, (EObject)((EObject)value))) {
                        values.remove(i);
                    }
                    ++i;
                }
                continue;
            }
            if (ancestorEObject != null && EcoreUtil.isAncestor((EObject)ancestorEObject, (EObject)((EObject)eObject.eGet((EStructuralFeature)eReference)))) continue;
            eObject.eUnset((EStructuralFeature)eReference);
        }
    }

    protected static void destroy(EObject eObject) {
        if (eObject.eContents().isEmpty()) {
            UML2Util.removeReferences(eObject, eObject);
            eObject.eAdapters().clear();
        } else {
            TreeIterator allContents = UML2Util.getAllContents(eObject, true, false);
            while (allContents.hasNext()) {
                UML2Util.removeReferences((EObject)allContents.next(), eObject);
            }
            allContents = UML2Util.getAllContents(eObject, true, false);
            while (allContents.hasNext()) {
                ((EObject)allContents.next()).eAdapters().clear();
            }
        }
        EcoreUtil.remove((EObject)eObject);
    }

    protected static void destroyAll(Collection<? extends EObject> eObjects) {
        Iterator<? extends EObject> o = eObjects.iterator();
        while (o.hasNext()) {
            UML2Util.destroy(o.next());
        }
    }

    public static <T> T load(ResourceSet resourceSet, URI uri, EClass eClass) {
        try {
            Object objectByType = EcoreUtil.getObjectByType((Collection)resourceSet.getResource(uri, true).getContents(), (EClassifier)eClass);
            return (T)objectByType;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static boolean intersect(Collection<?> collection, Collection<?> otherCollection) {
        return !Collections.disjoint(collection, otherCollection);
    }

    public static <T> T loadClassFromSystemProperty(String systemProperty) {
        String property = System.getProperty(systemProperty);
        if (!UML2Util.isEmpty(property)) {
            try {
                int index = property.indexOf(58);
                if (index != -1) {
                    return org.eclipse.emf.common.CommonPlugin.loadClass((String)property.substring(0, index), (String)property.substring(index + 1)).newInstance();
                }
                return (T)Class.forName(property).newInstance();
            }
            catch (Exception e) {
                CommonPlugin.INSTANCE.log(e);
            }
        }
        return null;
    }

    protected static EObject getContainingEObject(EObject eObject, EClass eClass, boolean resolve) {
        EObject containingEObject = null;
        EObject container = eObject;
        while ((containingEObject = resolve ? container.eContainer() : ((InternalEObject)container).eInternalContainer()) != null && !eClass.isInstance((Object)containingEObject)) {
            container = container.eContainer();
        }
        return containingEObject;
    }

    protected static boolean addInvocationDelegate(EPackage ePackage, String invocationDelegate) {
        ArrayList<String> invocationDelegates;
        boolean result = false;
        if (ePackage != null && !UML2Util.isEmpty(invocationDelegate) && !(invocationDelegates = EcoreUtil.getInvocationDelegates((EPackage)ePackage)).contains(invocationDelegate)) {
            invocationDelegates = new ArrayList<String>(invocationDelegates);
            result = invocationDelegates.add(invocationDelegate);
            EcoreUtil.setInvocationDelegates((EPackage)ePackage, invocationDelegates);
        }
        return result;
    }

    protected static boolean addSettingDelegate(EPackage ePackage, String settingDelegate) {
        ArrayList<String> settingDelegates;
        boolean result = false;
        if (ePackage != null && !UML2Util.isEmpty(settingDelegate) && !(settingDelegates = EcoreUtil.getSettingDelegates((EPackage)ePackage)).contains(settingDelegate)) {
            settingDelegates = new ArrayList<String>(settingDelegates);
            result = settingDelegates.add(settingDelegate);
            EcoreUtil.setSettingDelegates((EPackage)ePackage, settingDelegates);
        }
        return result;
    }

    protected static boolean addValidationDelegate(EPackage ePackage, String validationDelegate) {
        ArrayList<String> validationDelegates;
        boolean result = false;
        if (ePackage != null && !UML2Util.isEmpty(validationDelegate) && !(validationDelegates = EcoreUtil.getValidationDelegates((EPackage)ePackage)).contains(validationDelegate)) {
            validationDelegates = new ArrayList<String>(validationDelegates);
            result = validationDelegates.add(validationDelegate);
            EcoreUtil.setValidationDelegates((EPackage)ePackage, validationDelegates);
        }
        return result;
    }

    public static ResourceSet getResourceSet(EObject eObject) {
        Resource eResource = eObject.eResource();
        return eResource == null ? null : eResource.getResourceSet();
    }

    public static String getQualifiedName(ENamedElement eNamedElement, final String separator) {
        return UML2Util.getQualifiedText((EObject)eNamedElement, new QualifiedTextProvider(){

            @Override
            public String getSeparator() {
                return separator;
            }
        });
    }

    protected static <NE extends ENamedElement> Collection<NE> findENamedElements(Collection<? extends EObject> eObjects, String qualifiedName, String separator, boolean ignoreCase, EClass eClass, Collection<NE> eNamedElements) {
        int index = qualifiedName.indexOf(separator);
        if (index == -1) {
            for (ENamedElement eNamedElement : EcoreUtil.getObjectsByType(eObjects, (EClassifier)eClass)) {
                if (!(ignoreCase ? qualifiedName.equalsIgnoreCase(eNamedElement.getName()) : qualifiedName.equals(eNamedElement.getName()))) continue;
                eNamedElements.add(eNamedElement);
            }
        } else {
            String name = qualifiedName.substring(0, index);
            qualifiedName = qualifiedName.substring(index + separator.length());
            for (ENamedElement eNamedElement : EcoreUtil.getObjectsByType(eObjects, (EClassifier)EcorePackage.Literals.ENAMED_ELEMENT)) {
                if (!(ignoreCase ? name.equalsIgnoreCase(eNamedElement.getName()) : name.equals(eNamedElement.getName()))) continue;
                UML2Util.findENamedElements((Collection<? extends EObject>)eNamedElement.eContents(), qualifiedName, separator, ignoreCase, eClass, eNamedElements);
            }
        }
        return eNamedElements;
    }

    public static <NE extends ENamedElement> Collection<NE> findENamedElements(ResourceSet resourceSet, String qualifiedName, String separator, boolean ignoreCase, EClass eClass) {
        EList resources;
        int size;
        if (!UML2Util.isEmpty(qualifiedName) && EcorePackage.Literals.ENAMED_ELEMENT.isSuperTypeOf(eClass) && (size = (resources = resourceSet.getResources()).size()) > 0) {
            UniqueEList.FastCompare eNamedElements = new UniqueEList.FastCompare();
            int i = 0;
            while (i < size) {
                UML2Util.findENamedElements((Collection<? extends EObject>)((Resource)resources.get(i)).getContents(), qualifiedName, separator, ignoreCase, eClass, eNamedElements);
                ++i;
            }
            return ECollections.unmodifiableEList((EList)eNamedElements);
        }
        return ECollections.emptyEList();
    }

    public static interface Converter {
        public Collection<? extends EObject> convert(Collection<? extends EObject> var1, Map<String, String> var2, DiagnosticChain var3, Map<Object, Object> var4);
    }

    public static class EClassMatcher
    implements EObjectMatcher {
        protected final EObject eObject;

        public EClassMatcher(EObject eObject) {
            this.eObject = eObject;
        }

        @Override
        public boolean matches(EObject otherEObject) {
            return this.eObject == null ? false : (otherEObject == null ? false : this.eObject.eClass() == otherEObject.eClass());
        }
    }

    public static interface EObjectMatcher {
        public boolean matches(EObject var1);
    }

    public static class EStructuralFeatureMatcher
    extends EClassMatcher {
        protected final EStructuralFeature eStructuralFeature;

        public EStructuralFeatureMatcher(EObject eObject, EStructuralFeature eStructuralFeature) {
            super(eObject);
            this.eStructuralFeature = eStructuralFeature;
        }

        @Override
        public boolean matches(EObject otherEObject) {
            return super.matches(otherEObject) && UML2Util.safeEquals(this.eObject.eGet(this.eStructuralFeature), otherEObject.eGet(this.eStructuralFeature));
        }
    }

    public static abstract class QualifiedTextProvider {
        public String getText(EObject eObject) {
            return eObject instanceof ENamedElement ? ((ENamedElement)eObject).getName() : UML2Util.EMPTY_STRING;
        }

        public abstract String getSeparator();

        public String getFeatureText(EStructuralFeature eStructuralFeature) {
            return eStructuralFeature.getName();
        }

        public String getClassText(EObject eObject) {
            return eObject.eClass().getName();
        }
    }
}

