/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.PaperClips;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.Print;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintPiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.RotatePiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

final class SidewaysIterator
implements PrintIterator {
    private final Device device;
    private final PrintIterator target;
    private final int angle;
    private final Point minimumSize;
    private final Point preferredSize;

    SidewaysIterator(Print target, int angle, Device device, GC gc) {
        Util.notNull(target, device, gc);
        this.device = device;
        this.target = target.iterator(device, gc);
        this.angle = SidewaysIterator.checkAngle(angle);
        Point min = this.target.minimumSize();
        Point pref = this.target.preferredSize();
        if (this.angle == 180) {
            this.minimumSize = new Point(min.x, min.y);
            this.preferredSize = new Point(pref.x, pref.y);
        } else {
            this.minimumSize = new Point(min.y, min.x);
            this.preferredSize = new Point(pref.y, pref.x);
        }
    }

    private SidewaysIterator(SidewaysIterator that) {
        this.device = that.device;
        this.target = that.target.copy();
        this.angle = that.angle;
        this.minimumSize = that.minimumSize;
        this.preferredSize = that.preferredSize;
    }

    private static int checkAngle(int angle) {
        switch (angle) {
            case 90: 
            case 180: 
            case 270: {
                break;
            }
            default: {
                PaperClips.error(5, "Angle must be 90, 180, or 270");
            }
        }
        return angle;
    }

    @Override
    public Point minimumSize() {
        return new Point(this.minimumSize.x, this.minimumSize.y);
    }

    @Override
    public Point preferredSize() {
        return new Point(this.preferredSize.x, this.preferredSize.y);
    }

    @Override
    public boolean hasNext() {
        return this.target.hasNext();
    }

    @Override
    public PrintPiece next(int width, int height) {
        PrintPiece target = this.angle == 180 ? PaperClips.next(this.target, width, height) : PaperClips.next(this.target, height, width);
        if (target == null) {
            return null;
        }
        Point size = target.getSize();
        if (this.angle == 90 || this.angle == 270) {
            size = new Point(size.y, size.x);
        }
        return new RotatePiece(this.device, target, this.angle, size);
    }

    @Override
    public PrintIterator copy() {
        return new SidewaysIterator(this);
    }
}

