/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.Category;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionElement;
import org.eclipse.pde.internal.ui.wizards.WizardElement;

public class NewExtensionRegistryReader {
    public static final String TAG_WIZARD = "wizard";
    public static final String TAG_EDITOR_WIZARD = "editorWizard";
    public static final String ATT_CATEGORY = "category";
    public static final String ATT_SHORTCUTTABLE = "availableAsShortcut";
    public static final String CATEGORY_SEPARATOR = "/";
    public static final String TAG_CATEGORY = "category";
    public static final String TAG_DESCRIPTION = "description";
    private static final String UNCATEGORIZED_WIZARD_CATEGORY = "org.eclipse.pde.ui.Other";
    private static final String UNCATEGORIZED_WIZARD_CATEGORY_LABEL = "Other";
    private final boolean editorWizardMode;

    public NewExtensionRegistryReader() {
        this(false);
    }

    public NewExtensionRegistryReader(boolean editorWizardMode) {
        this.editorWizardMode = editorWizardMode;
    }

    protected WizardCollectionElement createCollectionElement(WizardCollectionElement parent, String id, String label) {
        WizardCollectionElement newElement = new WizardCollectionElement(id, label, parent);
        if (parent != null) {
            parent.add(newElement);
        }
        return newElement;
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        String className = config.getAttribute("class");
        String template = config.getAttribute("template");
        if (className == null && template == null) {
            return null;
        }
        return WizardElement.create(config, "name", "id");
    }

    protected WizardElement createEditorWizardElement(IConfigurationElement config) {
        return WizardElement.create(config, "name", "id", "class", "point");
    }

    protected String getCategoryStringFor(IConfigurationElement config) {
        String result = config.getAttribute("category");
        if (result == null) {
            result = UNCATEGORIZED_WIZARD_CATEGORY;
        }
        return result;
    }

    protected WizardCollectionElement getChildWithID(WizardCollectionElement parent, String id) {
        Object[] children = parent.getChildren();
        if (children != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                WizardCollectionElement currentChild = (WizardCollectionElement)child;
                if (currentChild.getId().equals(id)) {
                    return currentChild;
                }
                ++n2;
            }
        }
        return null;
    }

    protected void insertUsingCategory(WizardElement element, ElementList result) {
        WizardCollectionElement currentResult = (WizardCollectionElement)result;
        StringTokenizer familyTokenizer = new StringTokenizer(this.getCategoryStringFor(element.getConfigurationElement()), CATEGORY_SEPARATOR);
        WizardCollectionElement currentCollectionElement = currentResult;
        boolean moveToOther = false;
        while (familyTokenizer.hasMoreElements()) {
            WizardCollectionElement tempCollectionElement = this.getChildWithID(currentCollectionElement, familyTokenizer.nextToken());
            if (tempCollectionElement == null) {
                moveToOther = true;
                break;
            }
            currentCollectionElement = tempCollectionElement;
        }
        if (moveToOther) {
            this.moveElementToUncategorizedCategory(currentResult, element);
        } else {
            currentCollectionElement.getWizards().add(element);
        }
    }

    protected void moveElementToUncategorizedCategory(WizardCollectionElement root, WizardElement element) {
        WizardCollectionElement otherCategory = this.getChildWithID(root, UNCATEGORIZED_WIZARD_CATEGORY);
        if (otherCategory == null) {
            otherCategory = this.createCollectionElement(root, UNCATEGORIZED_WIZARD_CATEGORY, UNCATEGORIZED_WIZARD_CATEGORY_LABEL);
        }
        otherCategory.getWizards().add(element);
    }

    private void processCategory(IConfigurationElement config, ElementList list) {
        WizardCollectionElement result = (WizardCollectionElement)list;
        Category category = new Category(config);
        if (category.getID() == null || category.getLabel() == null) {
            System.out.println(PDEUIMessages.NewExtensionRegistryReader_missingProperty);
            return;
        }
        String[] categoryPath = category.getParentCategoryPath();
        WizardCollectionElement parent = result;
        if (categoryPath != null) {
            String[] stringArray = categoryPath;
            int n = categoryPath.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                WizardCollectionElement tempElement = this.getChildWithID(parent, element);
                if (tempElement == null) {
                    parent = null;
                    break;
                }
                parent = tempElement;
                ++n2;
            }
        }
        if (parent != null) {
            this.createCollectionElement(parent, category.getID(), category.getLabel());
        }
    }

    protected void processElement(IConfigurationElement element, ElementList result, boolean shortcutsOnly) {
        String tag = element.getName();
        if (tag.equals(TAG_WIZARD) && !this.editorWizardMode) {
            WizardElement wizard = this.createWizardElement(element);
            if (shortcutsOnly) {
                String shortcut = element.getAttribute(ATT_SHORTCUTTABLE);
                if (shortcut != null && shortcut.toLowerCase(Locale.ENGLISH).equals("true")) {
                    result.add(wizard);
                }
            } else {
                this.insertUsingCategory(wizard, result);
            }
        } else if (tag.equals(TAG_EDITOR_WIZARD) && this.editorWizardMode) {
            WizardElement wizard = this.createEditorWizardElement(element);
            if (shortcutsOnly) {
                result.add(wizard);
            } else {
                this.insertUsingCategory(wizard, result);
            }
        } else if (tag.equals("category") && !shortcutsOnly) {
            this.processCategory(element, result);
        }
    }

    public ElementList readRegistry(String pluginId, String pluginPointId, boolean shortcutsOnly) {
        IExtension[] extensions;
        ElementList result = shortcutsOnly ? new ElementList("shortcuts") : new WizardCollectionElement("root", "root", null);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(pluginId, pluginPointId);
        if (point == null) {
            return null;
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                this.processElement(config, result, shortcutsOnly);
                ++n4;
            }
            ++n2;
        }
        return result;
    }
}

