/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.security.SecureRandom;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.security.IRandomizer;

public class Randomizer
extends Lifecycle
implements IRandomizer {
    public static final String ALGORITHM_SHA1PRNG = "SHA1PRNG";
    public static final String DEFAULT_ALGORITHM_NAME = "SHA1PRNG";
    private String algorithmName = "SHA1PRNG";
    private String providerName;
    @ReflectUtil.ExcludeFromDump
    private byte[] seed;
    @ReflectUtil.ExcludeFromDump
    private transient SecureRandom secureRandom;

    public synchronized String getAlgorithmName() {
        return this.algorithmName;
    }

    public synchronized void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public synchronized String getProviderName() {
        return this.providerName;
    }

    public synchronized void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public synchronized void setSeed(byte[] seed) {
        this.seed = seed;
        if (this.isActive()) {
            this.setSeed();
        }
    }

    public synchronized void setSeed(long seed) {
        this.setSeed(String.valueOf(seed).getBytes());
    }

    @Override
    public synchronized boolean nextBoolean() {
        this.checkActive();
        return this.secureRandom.nextBoolean();
    }

    @Override
    public synchronized double nextDouble() {
        this.checkActive();
        return this.secureRandom.nextDouble();
    }

    @Override
    public synchronized float nextFloat() {
        this.checkActive();
        return this.secureRandom.nextFloat();
    }

    @Override
    public synchronized double nextGaussian() {
        this.checkActive();
        return this.secureRandom.nextGaussian();
    }

    @Override
    public synchronized int nextInt() {
        this.checkActive();
        return this.secureRandom.nextInt();
    }

    @Override
    public synchronized int nextInt(int n) {
        this.checkActive();
        return this.secureRandom.nextInt(n);
    }

    @Override
    public synchronized long nextLong() {
        this.checkActive();
        return this.secureRandom.nextLong();
    }

    @Override
    public synchronized byte[] generateSeed(int numBytes) {
        this.checkActive();
        return this.secureRandom.generateSeed(numBytes);
    }

    public synchronized String getAlgorithm() {
        this.checkActive();
        return this.secureRandom.getAlgorithm();
    }

    @Override
    public synchronized void nextBytes(byte[] bytes) {
        this.checkActive();
        this.secureRandom.nextBytes(bytes);
    }

    @Override
    public synchronized String nextString(int length, String alphabet) {
        this.checkActive();
        int n = alphabet.length();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            int pos = this.nextInt(n);
            char c = alphabet.charAt(pos);
            builder.append(c);
            ++i;
        }
        return builder.toString();
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.algorithmName, "algorithmName");
        if (this.seed == null) {
            this.setSeed(System.currentTimeMillis());
        }
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        this.secureRandom = this.providerName == null ? SecureRandom.getInstance(this.algorithmName) : SecureRandom.getInstance(this.algorithmName, this.providerName);
        this.setSeed();
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.secureRandom = null;
        super.doDeactivate();
    }

    private void setSeed() {
        this.secureRandom.setSeed(this.seed);
    }
}

