/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.net4j.util.container.PersistableContainer;

public class ListContainer<E>
extends PersistableContainer<E> {
    private final List<E> list;

    public ListContainer(Class<E> componentType) {
        this(componentType, new ArrayList());
    }

    public ListContainer(Class<E> componentType, List<E> list) {
        super(componentType);
        this.list = list;
    }

    protected List<E> getList() {
        return this.list;
    }

    @Override
    protected boolean backingStoreIsEmpty() {
        return this.list.isEmpty();
    }

    @Override
    protected int backingStoreSize() {
        return this.list.size();
    }

    @Override
    protected E[] backingStoreToArray(E[] a) {
        return this.list.toArray(a);
    }

    @Override
    protected void backingStoreForEach(Consumer<E> consumer) {
        if (consumer != null) {
            for (E element : this.list) {
                consumer.accept(element);
            }
        }
    }

    @Override
    protected boolean backingStoreContains(E element) {
        return this.list.contains(element);
    }

    @Override
    protected boolean backingStoreAdd(E element) {
        return this.list.add(element);
    }

    @Override
    protected boolean backingStoreRemove(E element) {
        return this.list.remove(element);
    }

    @Override
    protected void backingStoreClear() {
        this.list.clear();
    }
}

