/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.jeview.views.JEAttribute;
import org.eclipse.jdt.jeview.views.JEJarEntryResource;
import org.eclipse.jdt.jeview.views.JEResource;
import org.eclipse.jdt.jeview.views.JavaElement;
import org.eclipse.jdt.jeview.views.Mapper;

public class JERoot
extends JEAttribute {
    private final List<JEAttribute> fJEAttributes;

    public JERoot(Collection<?> javaElementsOrResources) {
        this.fJEAttributes = new Mapper<Object, JEAttribute>(){

            @Override
            public JEAttribute map(Object element) {
                if (element instanceof IJavaElement) {
                    return new JavaElement(null, (IJavaElement)element);
                }
                if (element instanceof IResource) {
                    return new JEResource(null, null, (IResource)element);
                }
                if (element instanceof IJarEntryResource) {
                    return new JEJarEntryResource(null, null, (IJarEntryResource)element);
                }
                throw new IllegalArgumentException(String.valueOf(element));
            }
        }.mapToList(javaElementsOrResources);
    }

    @Override
    public JEAttribute getParent() {
        return null;
    }

    @Override
    public JEAttribute[] getChildren() {
        return this.fJEAttributes.toArray(new JEAttribute[this.fJEAttributes.size()]);
    }

    @Override
    public Object getWrappedObject() {
        return null;
    }

    @Override
    public String getLabel() {
        StringBuilder buf = new StringBuilder("root: ");
        boolean first = true;
        for (JEAttribute att : this.fJEAttributes) {
            if (!first) {
                buf.append(", ");
            }
            buf.append(att.getLabel());
            first = false;
        }
        return buf.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        JERoot other = (JERoot)obj;
        return this.fJEAttributes.equals(other.fJEAttributes);
    }

    @Override
    public int hashCode() {
        return this.fJEAttributes.hashCode();
    }
}

