/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;

public class SearchUtils {
    public static final int GENERICS_AGNOSTIC_MATCH_RULE = 24;

    public static IJavaElement getEnclosingJavaElement(SearchMatch match) {
        Object element = match.getElement();
        if (element instanceof IJavaElement) {
            return (IJavaElement)element;
        }
        return null;
    }

    public static ICompilationUnit getCompilationUnit(SearchMatch match) {
        IJavaElement jElement;
        IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(match);
        if (enclosingElement != null) {
            if (enclosingElement instanceof ICompilationUnit) {
                return (ICompilationUnit)enclosingElement;
            }
            ICompilationUnit cu = (ICompilationUnit)enclosingElement.getAncestor(5);
            if (cu != null) {
                return cu;
            }
        }
        if ((jElement = JavaCore.create((IResource)match.getResource())) != null && jElement.exists() && jElement.getElementType() == 5) {
            return (ICompilationUnit)jElement;
        }
        return null;
    }

    public static SearchParticipant[] getDefaultSearchParticipants() {
        return new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
    }

    public static boolean isCamelCasePattern(String pattern) {
        return SearchPattern.validateMatchRule((String)pattern, (int)128) == 128;
    }

    private SearchUtils() {
    }
}

