/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.properties.sections;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.util.StatusLineUtil;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractModelerPropertySection;
import org.eclipse.gmf.runtime.diagram.ui.properties.views.TextChangeHelper;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractBasicTextPropertySection
extends AbstractModelerPropertySection {
    private Text textWidget;
    private CLabel propertyNameLabelWidget;
    private TextChangeHelper listener = new TextChangeHelper(){
        boolean textModified = false;

        @Override
        public void handleEvent(Event event) {
            switch (event.type) {
                case 24: {
                    this.textModified = !this.isNonUserChange();
                    break;
                }
                case 1: {
                    if (event.character != '\r') break;
                    this.textChanged((Control)event.widget);
                    break;
                }
                case 16: {
                    this.textChanged((Control)event.widget);
                }
            }
        }

        @Override
        public void textChanged(Control control) {
            if (this.textModified) {
                IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                StatusLineUtil.outputErrorMessage((IWorkbenchPart)part, (String)"");
                AbstractBasicTextPropertySection.this.setPropertyValue(control);
                this.textModified = false;
            }
        }
    };
    private Composite sectionComposite;

    protected abstract String getPropertyNameLabel();

    protected abstract void setPropertyValue(EObject var1, Object var2);

    protected abstract String getPropertyValueString();

    protected abstract String getPropertyChangeCommandName();

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.doCreateControls(parent, aTabbedPropertySheetPage);
    }

    public void doCreateControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.sectionComposite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.textWidget = this.createTextWidget(this.sectionComposite);
        this.propertyNameLabelWidget = this.createLabelWidget(this.sectionComposite);
        this.startTextWidgetEventListener();
    }

    protected void startTextWidgetEventListener() {
        if (!this.isReadOnly()) {
            this.getListener().startListeningTo((Control)this.getTextWidget());
            this.getListener().startListeningForEnter((Control)this.getTextWidget());
        }
    }

    protected void stopTextWidgetEventListener() {
        if (!this.isReadOnly()) {
            this.getListener().stopListeningTo((Control)this.getTextWidget());
        }
    }

    protected Text createTextWidget(Composite parent) {
        Text text = this.getWidgetFactory().createText(parent, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(parent, this.getPropertyNameStringsArray()));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        text.setLayoutData((Object)data);
        if (this.isReadOnly()) {
            text.setEditable(false);
        }
        return text;
    }

    protected String[] getPropertyNameStringsArray() {
        return new String[]{this.getPropertyNameLabel()};
    }

    protected CLabel createLabelWidget(Composite parent) {
        CLabel label = this.getWidgetFactory().createCLabel(parent, this.getPropertyNameLabel());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.getTextWidget(), -5);
        data.top = new FormAttachment((Control)this.getTextWidget(), 0, 0x1000000);
        label.setLayoutData((Object)data);
        return label;
    }

    protected synchronized void setPropertyValue(Control control) {
        final Object value = this.computeNewPropertyValue();
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        for (final EObject next : this.getEObjectList()) {
            commands.add(this.createCommand(this.getPropertyChangeCommandName(), next, new Runnable(){

                @Override
                public void run() {
                    AbstractBasicTextPropertySection.this.setPropertyValue(next, value);
                }
            }));
        }
        this.executeAsCompositeCommand(this.getPropertyChangeCommandName(), commands);
        this.refresh();
    }

    protected Object computeNewPropertyValue() {
        return this.getTextWidget().getText();
    }

    @Override
    public void dispose() {
        this.stopTextWidgetEventListener();
        super.dispose();
    }

    public void refresh() {
        this.getListener().startNonUserChange();
        try {
            this.executeAsReadAction(new Runnable(){

                @Override
                public void run() {
                    AbstractBasicTextPropertySection.this.refreshUI();
                }
            });
        }
        finally {
            this.getListener().finishNonUserChange();
        }
    }

    protected void refreshUI() {
        this.getTextWidget().setText(this.getPropertyValueString());
    }

    protected TextChangeHelper getListener() {
        return this.listener;
    }

    protected Text getTextWidget() {
        return this.textWidget;
    }

    public CLabel getPropertyNameLabelWidget() {
        return this.propertyNameLabelWidget;
    }

    public Composite getSectionComposite() {
        return this.sectionComposite;
    }
}

