/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser.structure.model.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.IClass;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.IMember;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.IMethod;

public class ClassImpl
implements IClass {
    private final List<String> superclasses = new ArrayList<String>();
    private final List<IMember> members = new ArrayList<IMember>();
    private final Stack<IMember.Visibility> visibilities = new Stack();
    private String name;

    @Override
    public void addMember(IMember member) {
        this.members.add(member);
    }

    @Override
    public void addSuperclass(String name) {
        this.superclasses.add(name);
    }

    @Override
    public IMember.Visibility peekVisibility() {
        return this.visibilities.isEmpty() ? IMember.Visibility.PRIVATE : this.visibilities.peek();
    }

    @Override
    public IMember.Visibility popVisibility() {
        return this.visibilities.pop();
    }

    @Override
    public void pushVisibility(IMember.Visibility visibility) {
        this.visibilities.push(visibility);
    }

    @Override
    public String[] getSuperClasses() {
        return this.superclasses.toArray(new String[this.superclasses.size()]);
    }

    @Override
    public List<IMember> getMembers() {
        return this.members;
    }

    @Override
    public IMethod findMethod(String name) {
        for (IMember member : this.members) {
            if (!(member instanceof IMethod) || !name.equals(member.getName())) continue;
            return (IMethod)member;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

