/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index2;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.index2.AbstractIndexer;
import org.eclipse.dltk.core.index2.IIndexer;
import org.eclipse.dltk.core.index2.IIndexerParticipant;

public class IndexerManager {
    private static final String PARTICIPANT_POINT = "org.eclipse.dltk.core.indexerParticipant";
    private static final String INDEXER_POINT = "org.eclipse.dltk.core.indexer";
    private static final String INDEXER_ATTR = "indexer";
    private static final String PARTICIPANT_ELEMENT = "indexerParticipant";
    private static final String CLASS_ATTR = "class";
    private static final String NATURE_ATTR = "nature";
    private static final String ID_ATTR = "id";
    private static IConfigurationElement indexerElement;
    private static AbstractIndexer indexer;
    private static Map<String, IConfigurationElement> indexerParticipants;

    static {
        String name;
        IConfigurationElement element;
        IConfigurationElement[] elements;
        indexerParticipants = new HashMap<String, IConfigurationElement>();
        String indexerdId = IndexerManager.getIndexerID();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(INDEXER_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            name = element.getName();
            String id = element.getAttribute(ID_ATTR);
            if (INDEXER_ATTR.equals(name) && (indexerdId == null || indexerdId.equals(id))) {
                indexerElement = element;
                break;
            }
            ++n2;
        }
        if (indexerElement == null) {
            if (indexerdId != null) {
                DLTKCore.error("Unable to find indexer: " + indexerdId);
            } else {
                DLTKCore.error("Unable to find any indexer");
            }
        }
        iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PARTICIPANT_POINT);
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            name = element.getName();
            if (PARTICIPANT_ELEMENT.equals(name)) {
                String nature = element.getAttribute(NATURE_ATTR);
                indexerParticipants.put(nature, element);
            }
            ++n2;
        }
    }

    public static IIndexer getIndexer() {
        if (indexer == null && indexerElement != null) {
            try {
                indexer = (AbstractIndexer)indexerElement.createExecutableExtension(CLASS_ATTR);
                indexer.setId(indexerElement.getAttribute(ID_ATTR));
            }
            catch (CoreException e) {
                DLTKCore.error(e);
            }
        }
        return indexer;
    }

    private static String getIndexerID() {
        String indexerId = System.getProperty("org.eclipse.dltk.core.indexer.id");
        if (indexerId != null) {
            return indexerId;
        }
        return Platform.getPreferencesService().getString("org.eclipse.dltk.core", "org.eclipse.dltk.core.indexer.id", null, null);
    }

    public static IIndexerParticipant getIndexerParticipant(IIndexer indexer, String natureId) {
        block3: {
            IConfigurationElement element = indexerParticipants.get(natureId);
            if (element != null) {
                try {
                    return (IIndexerParticipant)element.createExecutableExtension(CLASS_ATTR);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

