/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.sqltools.result.ClassVersionIncompatibleException;
import org.eclipse.datatools.sqltools.result.ResultConfiguration;
import org.eclipse.datatools.sqltools.result.ResultManager;
import org.eclipse.datatools.sqltools.result.core.IResultManagerListener;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManager;
import org.eclipse.datatools.sqltools.result.internal.index.HistoryIndexListener;
import org.eclipse.datatools.sqltools.result.internal.index.IResultHistoryIndex;
import org.eclipse.datatools.sqltools.result.internal.index.ResultHistoryLuceneIndex;
import org.eclipse.datatools.sqltools.result.internal.model.ResultInstance;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.internal.utils.StatusLogger;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.osgi.framework.BundleContext;

public class ResultsViewPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.datatools.sqltools.result";
    public static final String BUNDLE_NAME = "org.eclipse.datatools.sqltools.result.PluginResources";
    private static ResultsViewPlugin plugin;
    private String _tempDir;
    private ResourceBundle _bundle = ResourceBundle.getBundle("org.eclipse.datatools.sqltools.result.PluginResources");
    private IResultManager _resultManager;
    private IResultHistoryIndex _historyIndex;
    private static final String RESULTS_FILE_NAME = "results";
    private static final String BACKUP_DIR_NAME = "backup";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ResultManager resultManager = (ResultManager)this.getResultManager();
        if (ResultConfiguration.getInstance().isAutoSave()) {
            String resultsStr = ResultsViewPlugin.getDefault().getStateLocation().append(RESULTS_FILE_NAME).toOSString();
            File resultsFile = new File(resultsStr);
            if (resultsFile.exists() && resultsFile.isFile()) {
                StatusLogger log;
                try {
                    FileInputStream fis = new FileInputStream(resultsFile);
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    Object obj = ois.readObject();
                    if (obj instanceof IResultManager) {
                        resultManager.initializeContent((IResultManager)obj);
                    }
                }
                catch (ClassVersionIncompatibleException e) {
                    log = new StatusLogger(ResultsViewPlugin.getDefault().getLog(), ResultsViewPlugin.getPluginId(), this._bundle);
                    log.info("ResultsViewPlugin_class_incompatible_error", (Throwable)e);
                    this.backupOldVersion();
                }
                catch (Exception e) {
                    log = new StatusLogger(ResultsViewPlugin.getDefault().getLog(), ResultsViewPlugin.getPluginId(), this._bundle);
                    log.error("ResultsViewPlugin_load_history_error", (Throwable)e);
                    this.backupOldVersion();
                }
            }
            this.syncResults();
        }
        this._historyIndex = new ResultHistoryLuceneIndex();
        if (resultManager != null) {
            this._historyIndex.addResults(resultManager.getAllResults());
            IResultInstance[] instances = resultManager.getAllResults();
            int i = 0;
            while (i < instances.length) {
                if (!instances[i].isFinished()) {
                    instances[i].updateStatus(6);
                }
                ++i;
            }
        }
        resultManager.addResultManagerListener(new HistoryIndexListener());
        this.addResultListeners();
    }

    public void stop(BundleContext context) throws Exception {
        ResultManager resultManager = (ResultManager)ResultsViewPlugin.getDefault().getResultManager();
        if (ResultConfiguration.getInstance().isAutoSave() && !ResultConfiguration.getInstance().isAutoClean() && resultManager != null) {
            this.syncResults();
            String resultsStr = ResultsViewPlugin.getDefault().getStateLocation().append(RESULTS_FILE_NAME).toOSString();
            try {
                File resultsFile = new File(resultsStr);
                if (resultsFile.exists()) {
                    resultsFile.delete();
                }
                resultsFile.createNewFile();
                FileOutputStream fos = new FileOutputStream(resultsFile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(resultManager);
            }
            catch (Exception e) {
                StatusLogger log = new StatusLogger(ResultsViewPlugin.getDefault().getLog(), PLUGIN_ID, this._bundle);
                log.error("ResultsViewPlugin_persist_history_error", (Throwable)e);
            }
        }
        if (ResultConfiguration.getInstance().isAutoClean()) {
            File dir = new File(ResultsViewPlugin.getDefault().getStateLocation().toOSString());
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    files[i].delete();
                }
                ++i;
            }
        }
        plugin = null;
        super.stop(context);
    }

    public static ResultsViewPlugin getDefault() {
        return plugin;
    }

    public IResultHistoryIndex getResultHistoryIndex() {
        return this._historyIndex;
    }

    public String getTempDir() {
        if (this._tempDir == null) {
            this._tempDir = this.getStateLocation().append("temp").toOSString();
        }
        return this._tempDir;
    }

    public static ILogger getLogger(ResourceBundle bundle) {
        return new StatusLogger(ResultsViewPlugin.getDefault().getLog(), ResultsViewPlugin.getPluginId(), bundle == null ? ResultsViewPlugin.getDefault()._bundle : bundle);
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultManager getResultManager() {
        ResultsViewPlugin resultsViewPlugin = ResultsViewPlugin.getDefault();
        synchronized (resultsViewPlugin) {
            if (ResultsViewPlugin.getDefault()._resultManager == null) {
                ResultsViewPlugin.getDefault()._resultManager = new ResultManager();
            }
            return ResultsViewPlugin.getDefault()._resultManager;
        }
    }

    private void addResultListeners() {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ResultsViewPlugin.getPluginId(), "resultListener");
        if (point != null && (extensions = point.getExtensions()) != null) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                try {
                    Object listener = elements[0].createExecutableExtension("listener");
                    if (listener instanceof IResultManagerListener) {
                        this.getResultManager().addResultManagerListener((IResultManagerListener)listener);
                    }
                }
                catch (CoreException e) {
                    StatusLogger log = new StatusLogger(ResultsViewPlugin.getDefault().getLog(), PLUGIN_ID, this._bundle);
                    log.error("ResultsViewPlugin_load_listener_error", (Throwable)e);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncResults() {
        ResultManager resultManager = (ResultManager)ResultsViewPlugin.getDefault().getResultManager();
        if (resultManager == null) {
            return;
        }
        ResultManager resultManager2 = resultManager;
        synchronized (resultManager2) {
            ArrayList<String> memoryFiles = new ArrayList<String>();
            ArrayList<String> diskFiles = new ArrayList<String>();
            ArrayList commonFiles = null;
            IResultInstance[] iris = resultManager.getAllResults();
            int i = 0;
            while (i < iris.length) {
                if (iris[i] instanceof ResultInstance) {
                    memoryFiles.add(((ResultInstance)iris[i]).getFileName());
                    for (Object subri : iris[i].getSubResults()) {
                        if (!(subri instanceof ResultInstance)) continue;
                        memoryFiles.add(((ResultInstance)subri).getFileName());
                    }
                }
                ++i;
            }
            File[] files = new File(ResultsViewPlugin.getDefault().getStateLocation().toOSString()).listFiles();
            int i2 = 0;
            while (i2 < files.length) {
                if (files[i2].isFile() && !files[i2].getName().equals(RESULTS_FILE_NAME)) {
                    diskFiles.add(files[i2].getName());
                }
                ++i2;
            }
            if (memoryFiles.containsAll(diskFiles) && !diskFiles.containsAll(memoryFiles)) {
                commonFiles = new ArrayList(diskFiles);
            } else if (!memoryFiles.containsAll(diskFiles) && diskFiles.containsAll(memoryFiles)) {
                commonFiles = new ArrayList(memoryFiles);
            } else if (!memoryFiles.containsAll(diskFiles) && !diskFiles.containsAll(memoryFiles)) {
                ArrayList existingFilesCopy = new ArrayList(diskFiles);
                commonFiles = new ArrayList(diskFiles);
                existingFilesCopy.removeAll(memoryFiles);
                commonFiles.removeAll(existingFilesCopy);
            } else {
                return;
            }
            diskFiles.removeAll(commonFiles);
            memoryFiles.removeAll(commonFiles);
            Iterator iter = diskFiles.iterator();
            while (iter.hasNext()) {
                this.deleteFile(iter.next().toString());
            }
            ArrayList<IResultInstance> parentAndSubResults = new ArrayList<IResultInstance>();
            iris = resultManager.getAllResults();
            int i3 = 0;
            while (i3 < iris.length) {
                parentAndSubResults.add(iris[i3]);
                if (iris[i3].getSubResults().size() > 0) {
                    parentAndSubResults.addAll(iris[i3].getSubResults());
                }
                ++i3;
            }
            for (Object e : parentAndSubResults) {
                if (!(e instanceof ResultInstance) || !memoryFiles.contains(((ResultInstance)e).getFileName())) continue;
                ResultInstance ri = (ResultInstance)e;
                IResultInstance parent = ri.getParentResult() == null ? ri : ri.getParentResult();
                for (Object subri : parent.getSubResults()) {
                    if (!(subri instanceof ResultInstance)) continue;
                    resultManager.removeResultInstance((ResultInstance)subri);
                    this.deleteFile(((ResultInstance)subri).getFileName());
                }
                resultManager.removeResultInstance(parent);
                if (!(parent instanceof ResultInstance)) continue;
                this.deleteFile(((ResultInstance)parent).getFileName());
            }
        }
    }

    private void deleteFile(String fileName) {
        if (fileName == null) {
            return;
        }
        File f = new File(ResultsViewPlugin.getDefault().getStateLocation().append(fileName).toOSString());
        if (f.exists()) {
            f.delete();
        }
    }

    private void backupOldVersion() {
        IPath location = ResultsViewPlugin.getDefault().getStateLocation();
        String backupDirName = location.append(BACKUP_DIR_NAME).toOSString();
        String backupSubDirName = location.append("backup\\results" + String.valueOf(System.currentTimeMillis())).toOSString();
        File backupDir = new File(backupDirName);
        if (!backupDir.exists()) {
            backupDir.mkdir();
        }
        File backupSubDir = new File(backupSubDirName);
        backupSubDir.mkdir();
        File[] files = new File(location.toOSString()).listFiles();
        String targetFilePath = null;
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                targetFilePath = String.valueOf(backupSubDir.getPath()) + "\\" + files[i].getName();
                try {
                    Runtime.getRuntime().exec("cmd /c copy " + files[i].getPath() + " " + targetFilePath);
                }
                catch (IOException e) {
                    StatusLogger log = new StatusLogger(ResultsViewPlugin.getDefault().getLog(), PLUGIN_ID, this._bundle);
                    log.error("File_copy_error", (Throwable)e);
                }
            }
            ++i;
        }
    }
}

