/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.wst.xsd.ui.internal.actions.MoveXSDAttributeAction;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAttributeDeclarationAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDWildcardAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.CompartmentEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ComplexTypeEditPart;
import org.eclipse.wst.xsd.ui.internal.commands.BaseDragAndDropCommand;
import org.eclipse.wst.xsd.ui.internal.design.editparts.AttributeGroupDefinitionEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.TargetConnectionSpacingFigureEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDAttributesForAnnotationEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDBaseFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.design.figures.GenericGroupFigure;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDWildcard;
import org.w3c.dom.Element;

public class XSDAttributeDragAndDropCommand
extends BaseDragAndDropCommand {
    public XSDAttributeDragAndDropCommand(EditPartViewer viewer, ChangeBoundsRequest request, GraphicalEditPart target, XSDBaseFieldEditPart itemToDrag, Point location) {
        super(viewer, request);
        this.setLabel(Messages._UI_ACTION_DRAG_DROP_ATTRIBUTE);
        this.target = target;
        this.itemToDrag = itemToDrag;
        this.location = location;
        this.setup();
    }

    public XSDAttributeDragAndDropCommand(XSDBaseFieldEditPart itemToDrag, XSDBaseFieldEditPart leftField, XSDBaseFieldEditPart rightField, int direction) {
        super(itemToDrag.getViewer(), null);
        this.setLabel(Messages._UI_ACTION_DRAG_DROP_ATTRIBUTE);
        this.itemToDrag = itemToDrag;
        this.canExecute = false;
        this.handleKeyboardDragAndDrop(leftField, rightField, direction);
    }

    protected void handleKeyboardDragAndDrop(XSDBaseFieldEditPart leftField, XSDBaseFieldEditPart rightField, int direction) {
        super.handleKeyboardDragAndDrop(leftField, rightField, direction);
        if (direction == 1) {
            if (this.target == null) {
                this.target = rightField;
                this.location = this.target.getFigure().getBounds().getTop();
            } else if (!(leftField.getModel() instanceof XSDAttributeDeclarationAdapter) || leftField.getModel() instanceof XSDWildcardAdapter) {
                this.target = rightField;
                this.location = this.target.getFigure().getBounds().getTop();
            }
        }
        if (this.location == null) {
            return;
        }
        this.setup();
    }

    protected void setup() {
        this.canExecute = false;
        if (this.target instanceof AttributeGroupDefinitionEditPart) {
            this.parentEditPart = (AttributeGroupDefinitionEditPart)this.target;
            if (((GenericGroupFigure)this.parentEditPart.getFigure()).getIconFigure().getBounds().contains(this.location)) {
                this.xsdComponentToDrag = (XSDConcreteComponent)((XSDAttributeDeclarationAdapter)this.itemToDrag.getModel()).getTarget();
                this.action = new MoveXSDAttributeAction((XSDConcreteComponent)((AttributeGroupDefinitionEditPart)this.parentEditPart).getXSDAttributeGroupDefinition(), this.xsdComponentToDrag, null, null);
                this.canExecute = this.action.canMove();
            }
        } else if (this.target instanceof BaseFieldEditPart) {
            this.targetSpacesList = new ArrayList();
            List targetEditPartSiblings = this.calculateFieldEditParts();
            this.calculateAttributeGroupList();
            this.doDrop(targetEditPartSiblings, (GraphicalEditPart)this.itemToDrag);
        }
    }

    protected Element getElement() {
        XSDAttributeDeclarationAdapter adapter = (XSDAttributeDeclarationAdapter)this.itemToDrag.getModel();
        XSDAttributeDeclaration target = (XSDAttributeDeclaration)adapter.getTarget();
        XSDConcreteComponent parent = (XSDConcreteComponent)target.eContainer();
        return parent.getElement();
    }

    protected void doDrop(List siblings, GraphicalEditPart movingEditPart) {
        this.commonSetup(siblings, movingEditPart);
        if ((this.previousRefComponent instanceof XSDAttributeDeclaration || this.previousRefComponent instanceof XSDWildcard) && (this.nextRefComponent instanceof XSDAttributeDeclaration || this.nextRefComponent instanceof XSDWildcard)) {
            XSDConcreteComponent parent = this.previousRefComponent.getContainer().getContainer();
            if (this.closerSibling == BELOW_IS_CLOSER) {
                parent = this.nextRefComponent.getContainer().getContainer();
            }
            this.action = new MoveXSDAttributeAction(parent, this.xsdComponentToDrag, this.previousRefComponent, this.nextRefComponent);
        } else if (this.previousRefComponent == null && (this.nextRefComponent instanceof XSDAttributeDeclaration || this.nextRefComponent instanceof XSDWildcard)) {
            XSDConcreteComponent parent = this.nextRefComponent.getContainer().getContainer();
            if (this.closerSibling == ABOVE_IS_CLOSER) {
                if (this.leftSiblingEditPart == null) {
                    this.action = new MoveXSDAttributeAction(parent, this.xsdComponentToDrag, this.previousRefComponent, this.nextRefComponent);
                } else if (this.parentEditPart != null) {
                    this.action = new MoveXSDAttributeAction(this.parentEditPart.getXSDConcreteComponent(), this.xsdComponentToDrag, this.previousRefComponent, this.nextRefComponent);
                }
            } else {
                this.action = new MoveXSDAttributeAction(parent, this.xsdComponentToDrag, this.previousRefComponent, this.nextRefComponent);
            }
        } else if (this.previousRefComponent instanceof XSDAttributeDeclaration && this.nextRefComponent == null) {
            XSDConcreteComponent parent = this.previousRefComponent.getContainer().getContainer();
            this.action = this.closerSibling == ABOVE_IS_CLOSER ? new MoveXSDAttributeAction(parent, this.xsdComponentToDrag, this.previousRefComponent, this.nextRefComponent) : (this.rightSiblingEditPart == null ? new MoveXSDAttributeAction(parent, this.xsdComponentToDrag, this.previousRefComponent, this.nextRefComponent) : new MoveXSDAttributeAction(parent, this.xsdComponentToDrag, this.previousRefComponent, this.nextRefComponent));
        }
        if (this.action != null) {
            this.canExecute = this.action.canMove();
        }
    }

    protected void calculateAttributeGroupList() {
        GraphicalEditPart editPart = this.target;
        while (editPart != null) {
            if (editPart instanceof ComplexTypeEditPart) {
                List list = editPart.getChildren();
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    Object child = i.next();
                    if (!(child instanceof CompartmentEditPart)) continue;
                    List compartmentList = ((CompartmentEditPart)child).getChildren();
                    Iterator it = compartmentList.iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (!(obj instanceof XSDAttributesForAnnotationEditPart)) continue;
                        XSDAttributesForAnnotationEditPart groups = (XSDAttributesForAnnotationEditPart)obj;
                        List groupList = groups.getChildren();
                        Iterator iter = groupList.iterator();
                        while (iter.hasNext()) {
                            Object groupChild = iter.next();
                            if (groupChild instanceof TargetConnectionSpacingFigureEditPart) {
                                this.targetSpacesList.add(groupChild);
                                continue;
                            }
                            if (!(groupChild instanceof AttributeGroupDefinitionEditPart)) continue;
                            this.getAttributeGroupEditParts((AttributeGroupDefinitionEditPart)groupChild);
                        }
                    }
                }
            }
            editPart = editPart.getParent();
        }
    }

    protected List getAttributeGroupEditParts(AttributeGroupDefinitionEditPart attributeGroupEditPart) {
        ArrayList<AttributeGroupDefinitionEditPart> groupList = new ArrayList<AttributeGroupDefinitionEditPart>();
        List list = attributeGroupEditPart.getChildren();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof TargetConnectionSpacingFigureEditPart) {
                this.targetSpacesList.add(object);
                continue;
            }
            if (!(object instanceof AttributeGroupDefinitionEditPart)) continue;
            AttributeGroupDefinitionEditPart groupRef = (AttributeGroupDefinitionEditPart)object;
            List groupRefChildren = groupRef.getChildren();
            Iterator it = groupRefChildren.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof TargetConnectionSpacingFigureEditPart) {
                    this.targetSpacesList.add(o);
                    continue;
                }
                if (!(o instanceof AttributeGroupDefinitionEditPart)) continue;
                AttributeGroupDefinitionEditPart aGroup = (AttributeGroupDefinitionEditPart)o;
                groupList.add(aGroup);
                groupList.addAll(this.getAttributeGroupEditParts(aGroup));
            }
        }
        return groupList;
    }
}

