/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.editor.UMLEditorPlugin;
import org.eclipse.uml2.uml.editor.actions.UMLCommandAction;
import org.eclipse.uml2.uml.editor.dialogs.AbstractChoicesDialogDelegate;
import org.eclipse.uml2.uml.editor.dialogs.ChoicesDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnapplyProfileAction
extends UMLCommandAction {
    protected Command createActionCommand(EditingDomain editingDomain, Collection<?> collection) {
        if (collection.size() == 1 && collection.iterator().next() instanceof Package) {
            return IdentityCommand.INSTANCE;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void run(IAction action) {
        if (this.command != UnexecutableCommand.INSTANCE) {
            final Package package_ = (Package)this.collection.iterator().next();
            final ArrayList choiceOfValues = new ArrayList(package_.getAppliedProfiles());
            Collections.sort(choiceOfValues, new UMLCommandAction.TextComparator(this));
            String label = UMLEditorPlugin.INSTANCE.getString("_UI_UnapplyProfileActionCommand_label", new Object[]{this.getLabelProvider().getText((Object)package_)});
            final ChoicesDialog<Profile> dialog = new ChoicesDialog<Profile>(this.workbenchPart.getSite().getShell(), package_, label, new AbstractChoicesDialogDelegate<Profile>(Profile.class){

                @Override
                public String getChoicesLabelText() {
                    return UMLEditorPlugin.INSTANCE.getString("_UI_AppliedProfiles_label");
                }

                @Override
                public String getValuesLabelText() {
                    return UMLEditorPlugin.INSTANCE.getString("_UI_ProfilesToUnapply_label");
                }

                @Override
                public String getAddButtonText() {
                    return UMLEditorPlugin.INSTANCE.getString("_UI_Unapply_label");
                }

                @Override
                public String getRemoveButtonText() {
                    return UMLEditorPlugin.INSTANCE.getString("_UI_Apply_label");
                }

                @Override
                public Collection<Profile> getChoiceOfValues() {
                    return choiceOfValues;
                }

                @Override
                public ILabelProvider getLabelProvider() {
                    return UnapplyProfileAction.this.getLabelProvider();
                }

                @Override
                public boolean allowsReordering() {
                    return false;
                }
            });
            dialog.open();
            if (dialog.getReturnCode() == 0 && !dialog.getResult().isEmpty()) {
                this.editingDomain.getCommandStack().execute((Command)new UMLCommandAction.RefreshingChangeCommand(this, this.editingDomain, new Runnable(){

                    public void run() {
                        for (Profile result : dialog.getResult()) {
                            package_.unapplyProfile(result);
                        }
                    }
                }, label));
            }
        }
    }
}

