/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.HideLabelFilter;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.preferences.SiriusDiagramUiInternalPreferencesKeys;

public class NotationVisibilityUpdater
extends ResourceSetListenerImpl {
    private Session session;

    public NotationVisibilityUpdater(Session session) {
        super(NotificationFilter.NOT_TOUCH.and(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagramElement_Visible()).or(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getDEdge_IsFold()).or(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagramElement_GraphicalFilters()).or(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getHideLabelFilter_HiddenLabels()))))));
        this.session = session;
        session.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        VisibilityUpdateCommand cmd = null;
        HashMap<View, Boolean> viewsToUpdate = new HashMap<View, Boolean>();
        boolean removeHideNote = DiagramUIPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusDiagramUiInternalPreferencesKeys.PREF_REMOVE_HIDE_NOTE_WHEN_ANNOTED_ELEMENT_HIDDEN_OR_REMOVE.name());
        for (Notification notification : event.getNotifications()) {
            if (notification.getNotifier() instanceof DDiagramElement) {
                DDiagramElement dDiagramElement = (DDiagramElement)notification.getNotifier();
                View referencingView = this.getReferencingView(dDiagramElement);
                if (referencingView == null) continue;
                if (notification.getFeature() == DiagramPackage.eINSTANCE.getDDiagramElement_Visible()) {
                    boolean isVisible = notification.getNewBooleanValue();
                    List<Edge> attachedEdge = GMFHelper.getAttachedEdgesRecursively(Collections.singleton(referencingView));
                    attachedEdge = attachedEdge.stream().filter(GMFNotationHelper::isNoteAttachment).toList();
                    viewsToUpdate.put(referencingView, isVisible);
                    for (Edge edge : attachedEdge) {
                        viewsToUpdate.put((View)edge, isVisible);
                    }
                    if (!removeHideNote) continue;
                    List<Node> list = Stream.concat(GMFHelper.getAttachedPGE(referencingView).stream(), GMFHelper.getAttachedPGE(attachedEdge).stream()).toList();
                    List<Node> needChangePGE = isVisible ? list : GMFHelper.getElementWithoutVisibleConnection(list, attachedEdge);
                    for (Node node : needChangePGE) {
                        viewsToUpdate.put((View)node, isVisible);
                    }
                    continue;
                }
                if (notification.getFeature() == DiagramPackage.eINSTANCE.getDEdge_IsFold()) {
                    viewsToUpdate.put(referencingView, Boolean.valueOf(notification.getNewBooleanValue()) == false);
                    continue;
                }
                if (notification.getFeature() != DiagramPackage.eINSTANCE.getDDiagramElement_GraphicalFilters()) continue;
                List<View> correspondingLabelView = this.lookForCorrespondingLabelView(dDiagramElement);
                if (notification.getOldValue() instanceof HideLabelFilter) {
                    for (View view : correspondingLabelView) {
                        viewsToUpdate.put(view, Boolean.TRUE);
                    }
                    continue;
                }
                if (!(notification.getNewValue() instanceof HideLabelFilter)) continue;
                HideLabelFilter hideLabelFilter = (HideLabelFilter)notification.getNewValue();
                for (View view : this.getHiddenViews(correspondingLabelView, hideLabelFilter)) {
                    viewsToUpdate.put(view, Boolean.FALSE);
                }
                continue;
            }
            if (!(notification.getNotifier() instanceof HideLabelFilter) || ((HideLabelFilter)notification.getNotifier()).eContainer() == null) continue;
            HideLabelFilter hideLabelFilter = (HideLabelFilter)notification.getNotifier();
            DDiagramElement dDiagramElement = (DDiagramElement)hideLabelFilter.eContainer();
            List<View> correspondingLabelView = this.lookForCorrespondingLabelView(dDiagramElement);
            Set<View> viewToHide = this.getHiddenViews(correspondingLabelView, hideLabelFilter);
            ArrayList<View> arrayList = new ArrayList<View>(correspondingLabelView);
            arrayList.removeAll(viewToHide);
            for (View view : this.getHiddenViews(correspondingLabelView, hideLabelFilter)) {
                viewsToUpdate.put(view, Boolean.FALSE);
            }
            for (View view : arrayList) {
                viewsToUpdate.put(view, Boolean.TRUE);
            }
        }
        if (!viewsToUpdate.isEmpty()) {
            cmd = new VisibilityUpdateCommand(this.session.getTransactionalEditingDomain(), viewsToUpdate);
        }
        return cmd;
    }

    private Set<View> getHiddenViews(List<View> views, HideLabelFilter hideLabelFilter) {
        HashSet<View> viewToHide = new HashSet<View>();
        if (hideLabelFilter.getHiddenLabels().isEmpty()) {
            viewToHide.addAll(views);
        } else {
            for (View view : views) {
                if (!hideLabelFilter.getHiddenLabels().contains((Object)SiriusVisualIDRegistry.getVisualID(view.getType()))) continue;
                viewToHide.add(view);
            }
        }
        return viewToHide;
    }

    private View getReferencingView(DDiagramElement dDiagramElement) {
        EObject referencingEObject;
        View referencingView = null;
        EObjectQuery eObjectQuery = new EObjectQuery((EObject)dDiagramElement);
        Collection inverseReferences = eObjectQuery.getInverseReferences(NotationPackage.Literals.VIEW__ELEMENT);
        if (!inverseReferences.isEmpty() && (referencingEObject = (EObject)inverseReferences.iterator().next()) instanceof View) {
            referencingView = (View)referencingEObject;
        }
        return referencingView;
    }

    private List<View> lookForCorrespondingLabelView(DDiagramElement elem) {
        ECrossReferenceAdapter crossReferencer = this.session.getSemanticCrossReferencer();
        ArrayList<View> result = new ArrayList<View>();
        if (crossReferencer != null) {
            Iterator it = crossReferencer.getInverseReferences((EObject)elem).iterator();
            while (result.isEmpty() && it.hasNext()) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)it.next();
                if (!(setting.getEObject() instanceof View)) continue;
                EList children = ((View)setting.getEObject()).getChildren();
                for (View view : children) {
                    ViewQuery query = new ViewQuery(view);
                    if (!query.isForNameEditPart()) continue;
                    result.add(view);
                }
            }
        }
        return result;
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
        this.session = null;
    }

    private static class VisibilityUpdateCommand
    extends RecordingCommand {
        private final Map<View, Boolean> viewsToUpdate;

        public VisibilityUpdateCommand(TransactionalEditingDomain domain, Map<View, Boolean> viewsToUpdate) {
            super(domain, Messages.VisibilityUpdateCommand_label);
            this.viewsToUpdate = viewsToUpdate;
        }

        protected void doExecute() {
            for (Map.Entry<View, Boolean> entry : this.viewsToUpdate.entrySet()) {
                entry.getKey().setVisible(entry.getValue().booleanValue());
            }
        }
    }
}

