/*
 * Copyright (c) 2007, 2011, 2012, 2015, 2019 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.net4j.util.container;

import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;

/**
 * An unchecked exception that indicates the absence of a {@link IFactory factory} identified by
 * {@link IFactoryKey#getProductGroup() product group} and {@link IFactoryKey#getType() type}.
 *
 * @author Eike Stepper
 * @noextend This class is not intended to be subclassed by clients.
 */
public class FactoryNotFoundException extends RuntimeException
{
  private static final long serialVersionUID = 1L;

  public FactoryNotFoundException()
  {
  }

  public FactoryNotFoundException(String message)
  {
    super(message);
  }

  public FactoryNotFoundException(Throwable cause)
  {
    super(cause);
  }

  public FactoryNotFoundException(String message, Throwable cause)
  {
    super(message, cause);
  }
}
