/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.internal.collectionextract.HashMapCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class HashSetCollectionExtractor
implements IMapExtractor {
    private final String array_attribute;
    private final String key_attribute;
    private final String size_attribute;
    private final String value_attribute;

    public HashSetCollectionExtractor(String array_attribute, String key_attribute) {
        this(null, array_attribute, key_attribute, null);
    }

    public HashSetCollectionExtractor(String size_attribute, String array_attribute, String key_attribute, String value_attribute) {
        if (array_attribute == null) {
            throw new IllegalArgumentException();
        }
        if (key_attribute == null) {
            throw new IllegalArgumentException();
        }
        this.size_attribute = size_attribute;
        this.array_attribute = array_attribute;
        this.key_attribute = key_attribute;
        this.value_attribute = value_attribute;
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        if (this.size_attribute != null) {
            Integer ret = ExtractionUtils.toInteger(coll.resolveValue(this.size_attribute));
            if (ret != null) {
                return ret;
            }
            ret = this.createHashMapExtractor().getSize(coll);
            if (ret != null) {
                return ret;
            }
            return this.getNumberOfNotNullElements(coll);
        }
        return this.getNumberOfNotNullElements(coll);
    }

    @Override
    public boolean hasCapacity() {
        return true;
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        return this.createHashMapExtractor().getCapacity(coll);
    }

    @Override
    public boolean hasFillRatio() {
        return this.createHashMapExtractor().hasFillRatio();
    }

    @Override
    public Double getFillRatio(IObject coll) throws SnapshotException {
        return this.createHashMapExtractor().getFillRatio(coll);
    }

    @Override
    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean hasExtractableArray() {
        return false;
    }

    @Override
    public boolean hasExtractableContents() {
        return true;
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        ISnapshot snapshot = coll.getSnapshot();
        ArrayInt ret = new ArrayInt();
        int[] entries = this.createHashMapExtractor().extractEntryIds(coll);
        if (this.key_attribute.endsWith("[]")) {
            String attr = this.key_attribute.replaceFirst("\\[\\]$", "");
            int[] nArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                int entryId = nArray[n2];
                IInstance entry = (IInstance)snapshot.getObject(entryId);
                Object f = entry.resolveValue(attr);
                if (f instanceof IObjectArray) {
                    IObjectArray valarr = (IObjectArray)f;
                    int n3 = valarr.getLength();
                    int s = 10;
                    int i = 0;
                    while (i < n3) {
                        s = Math.min(s, n3 - i);
                        long[] b = valarr.getReferenceArray(i, s);
                        int j = 0;
                        while (j < s) {
                            if (b[j] != 0L) {
                                int valueId = snapshot.mapAddressToId(b[j]);
                                ret.add(valueId);
                            }
                            ++j;
                        }
                        i += s;
                    }
                }
                ++n2;
            }
        } else {
            int[] nArray = entries;
            int n = entries.length;
            int n4 = 0;
            while (n4 < n) {
                int entryId = nArray[n4];
                IInstance entry = (IInstance)snapshot.getObject(entryId);
                Object f = entry.resolveValue(this.key_attribute);
                if (f instanceof IObject) {
                    ret.add(((IObject)f).getObjectId());
                }
                ++n4;
            }
            if (ret.size() == 0 && entries.length > 0) {
                HashMapCollectionExtractor hme2 = new HashMapCollectionExtractor(this.size_attribute, this.array_attribute, this.key_attribute, this.value_attribute);
                this.getSetEntries(coll, hme2, entries, ret);
            }
        }
        return ret.toArray();
    }

    int getSetEntries(IObject collection, HashMapCollectionExtractor hme, int[] objects, ArrayInt ret) throws SnapshotException {
        int count = 0;
        ISnapshot snapshot = collection.getSnapshot();
        ArrayInt collRefs1 = new ArrayInt();
        IClass c = collection.getClazz();
        while (c != null) {
            int[] nArray = snapshot.getOutboundReferentIds(c.getObjectId());
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int o = nArray[n2];
                if (snapshot.getClassOf(o).getName().equals("java.lang.Object")) {
                    collRefs1.add(o);
                }
                ++n2;
            }
            c = c.getSuperClass();
        }
        int[] collRefs = collRefs1.toArray();
        BitField seen = new BitField(snapshot.getSnapshotInfo().getNumberOfObjects());
        ArrayInt extra = new ArrayInt();
        int[] nArray = objects;
        int n = objects.length;
        int n3 = 0;
        while (n3 < n) {
            int i = nArray[n3];
            if (!(snapshot.isClass(i) || seen.get(i) || snapshot.getClassOf(i).getName().equals("java.lang.Object"))) {
                extra.clear();
                extra.add(i);
                seen.set(i);
                int k = 0;
                while (k < extra.size()) {
                    int j = extra.get(k);
                    while (j >= 0) {
                        ++count;
                        int val = -1;
                        IClass entryClazz = snapshot.getClassOf(j);
                        int[] nArray2 = snapshot.getOutboundReferentIds(j);
                        int n4 = nArray2.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            String cname;
                            IClass c2;
                            int o = nArray2[n5];
                            if (!(entryClazz.getObjectId() == o || entryClazz.equals(c2 = snapshot.getClassOf(o)) || (cname = c2.getName()).endsWith("$Node") || cname.endsWith("$TreeNode") || cname.endsWith("$Entry"))) {
                                if (cname.equals("java.lang.Object")) {
                                    int[] nArray3 = collRefs;
                                    int n6 = collRefs.length;
                                    int n7 = 0;
                                    while (n7 < n6) {
                                        int o2 = nArray3[n7];
                                        if (o2 != o) {
                                            ++n7;
                                            continue;
                                        }
                                        break;
                                    }
                                } else {
                                    val = val == -1 ? o : -2;
                                }
                            }
                            ++n5;
                        }
                        if (val >= 0) {
                            ret.add(val);
                        }
                        j = hme.resolveNextSameField(snapshot, j, seen, extra);
                    }
                    ++k;
                }
            }
            ++n3;
        }
        return count;
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        return this.createHashMapExtractor().getNumberOfNotNullElements(coll);
    }

    IMapExtractor createHashMapExtractor() {
        return new HashMapCollectionExtractor(this.size_attribute, this.array_attribute, this.key_attribute, this.value_attribute);
    }

    @Override
    public boolean hasCollisionRatio() {
        return this.createHashMapExtractor().hasCollisionRatio();
    }

    @Override
    public Double getCollisionRatio(IObject coll) throws SnapshotException {
        return this.createHashMapExtractor().getCollisionRatio(coll);
    }

    @Override
    public Iterator<Map.Entry<IObject, IObject>> extractMapEntries(IObject coll) throws SnapshotException {
        return this.createHashMapExtractor().extractMapEntries(coll);
    }
}

