/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.pde;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.ProjectDependencyTracker;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class PdeDependencyTracker
extends ProjectDependencyTracker {
    public Set<IProject> getReferencedProjects(IProject project, boolean recursive) {
        HashSet<IProject> allProjects = new HashSet<IProject>();
        this.getReferencedProjectsInternal(project, true, allProjects);
        allProjects.remove(project);
        return allProjects;
    }

    private void getReferencedProjectsInternal(IProject project, boolean recursive, Set<IProject> allProjects) {
        IPluginModelBase plugin;
        if (allProjects.add(project) && (plugin = PdeDependencyTracker.findPluginModelByProject(project)) != null) {
            IPluginImport[] imports;
            IPluginImport[] iPluginImportArray = imports = plugin.getPluginBase().getImports();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginImport nextImport = iPluginImportArray[n2];
                String importID = nextImport.getId();
                IPluginModelBase depPlugin = PdeDependencyTracker.findPluginModelByID(importID);
                if (depPlugin != null && depPlugin.getUnderlyingResource() != null) {
                    IProject projectDep = depPlugin.getUnderlyingResource().getProject();
                    if (recursive) {
                        this.getReferencedProjectsInternal(projectDep, true, allProjects);
                    } else {
                        allProjects.add(projectDep);
                    }
                }
                ++n2;
            }
        }
    }

    private static IPluginModelBase findPluginModelByProject(IProject project) {
        return PluginRegistry.findModel((IProject)project);
    }

    private static IPluginModelBase findPluginModelByID(String importID) {
        return PluginRegistry.findModel((String)importID);
    }
}

