/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.profiler.core.Messages;
import org.eclipse.m2m.atl.profiler.core.exception.InterceptedLeavingStackFrameException;
import org.eclipse.m2m.atl.profiler.core.exception.NoRegisteredOperationFoundException;
import org.eclipse.m2m.atl.profiler.core.vm.IStackFrame;
import org.eclipse.m2m.atl.profiler.model.ATLInstruction;
import org.eclipse.m2m.atl.profiler.model.ATLOperation;
import org.eclipse.m2m.atl.profiler.model.Context;
import org.eclipse.m2m.atl.profiler.model.ExecutionError;
import org.eclipse.m2m.atl.profiler.model.ModelFactory;
import org.eclipse.m2m.atl.profiler.model.ProfilingInstruction;
import org.eclipse.m2m.atl.profiler.model.ProfilingModel;
import org.eclipse.m2m.atl.profiler.model.ProfilingOperation;

public final class ProfilerModelHandler {
    private static ProfilerModelHandler instance;
    private ProfilingModel profilingModel;
    private ProfilingOperation currentOperation;
    private Map<String, ATLOperation> operationRegistry;
    private int currentInstructionID;
    private boolean seeDebugMessages;
    private boolean hasTocreateStep;

    private ProfilerModelHandler() {
    }

    public static ProfilerModelHandler getInstance() {
        if (instance == null) {
            instance = new ProfilerModelHandler();
        }
        return instance;
    }

    public void init() {
        this.profilingModel = ModelFactory.eINSTANCE.createProfilingModel();
        this.currentOperation = null;
        this.currentInstructionID = 0;
        this.operationRegistry = new HashMap<String, ATLOperation>();
    }

    public void newOperation(String sfOpName, IStackFrame frame, ATLOperation atlOperation, EObject atlElement) {
        if (this.currentOperation == null) {
            this.currentOperation = this.profilingModel;
            this.profilingModel.setModelName(sfOpName);
        } else {
            ProfilingOperation operation = ModelFactory.eINSTANCE.createProfilingOperation();
            operation.setParentOperation(this.currentOperation);
            this.currentOperation.getExecutionInstructions().add((Object)operation);
            this.currentOperation = operation;
        }
        ++this.currentInstructionID;
        this.currentOperation.setInstructionID(this.currentInstructionID);
        this.currentOperation.setTotalExecutedInstructions(0);
        this.currentOperation.getStackFrames().add((Object)frame);
        this.currentOperation.setLaunchedTime(System.currentTimeMillis());
        this.currentOperation.setContent(frame.getIOperation().getName());
        this.currentOperation.setHasError(false);
        if (this.currentOperation.getContent().startsWith("__match")) {
            this.currentOperation.setMatchingOperation(true);
        } else {
            this.currentOperation.setMatchingOperation(false);
        }
        this.fillContext(frame);
        if (atlOperation == null) {
            atlOperation = ModelFactory.eINSTANCE.createATLOperation();
            atlOperation.setName(sfOpName);
            this.operationRegistry.put(atlOperation.getName(), atlOperation);
            if (this.seeDebugMessages) {
                ATLLogger.info((String)("*** registered operation <" + atlOperation.getName() + "," + atlOperation + ">"));
            }
            atlOperation.setATLElementRef((Object)atlElement);
            if (this.seeDebugMessages) {
                ATLLogger.info((String)("*** linked to atl element : " + atlOperation.getATLElementRef()));
            }
        }
        atlOperation.setCalls(atlOperation.getCalls() + 1);
        this.currentOperation.setAtlInstruction((ATLInstruction)atlOperation);
        atlOperation.getProfilingInstructions().add((Object)this.currentOperation);
        long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.currentOperation.setLaunchedMemoryUsage(mem);
        if (this.seeDebugMessages) {
            ATLLogger.info((String)("<" + atlOperation.getName() + "> beginning ..."));
        }
    }

    private void fillContext(IStackFrame frame) {
        Object[] objectArray = frame.getLocalVariables().values().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            if (!s.toString().equals("[]")) {
                Context c = ModelFactory.eINSTANCE.createContext();
                c.setContent(s.toString());
                this.currentOperation.getContext().add((Object)c);
            }
            ++n2;
        }
    }

    public void interceptError(IStackFrame frame, String msg, Throwable e) {
        if (msg != null && msg.length() > 0) {
            ExecutionError error = ModelFactory.eINSTANCE.createExecutionError();
            error.setMessage(msg);
            error.setFrames("" + frame);
            this.currentOperation.getExecutionErrors().add((Object)error);
        }
        if (!this.currentOperation.isHasError()) {
            this.currentOperation.setHasError(true);
            ProfilingOperation parentOp = this.currentOperation.getParentOperation();
            while (parentOp != null) {
                parentOp.setHasError(true);
                parentOp = parentOp.getParentOperation();
            }
        }
    }

    public void closeOperation(String sfOpName, IStackFrame frame) throws NoRegisteredOperationFoundException, InterceptedLeavingStackFrameException {
        ATLOperation atlOperation = this.operationRegistry.get(sfOpName);
        if (atlOperation == null) {
            throw new NoRegisteredOperationFoundException(Messages.getString("ProfilerModelHandler.OPERATION_NOT_FOUND", sfOpName));
        }
        if (!sfOpName.equals(this.currentOperation.getAtlInstruction().getName())) {
            throw new InterceptedLeavingStackFrameException(Messages.getString("ProfilerModelHandler.LEAVING_STACK", sfOpName, this.currentOperation.getAtlInstruction().getName()));
        }
        this.currentOperation.setTotalExecutedInstructions(this.countInstructions(this.currentOperation));
        this.currentOperation.setEndTime(System.currentTimeMillis());
        if (this.seeDebugMessages) {
            ATLLogger.info((String)Messages.getString("ProfilerModelHandler.TERMINATED", sfOpName, this.currentOperation.getTotalExecutedInstructions()));
        }
        long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.currentOperation.setEndMemoryUsage(mem);
        long maxMem = 0L;
        if (maxMem < this.currentOperation.getLaunchedMemoryUsage()) {
            maxMem = this.currentOperation.getLaunchedMemoryUsage();
        } else if (maxMem < this.currentOperation.getEndMemoryUsage()) {
            maxMem = this.currentOperation.getEndMemoryUsage();
        }
        for (ProfilingInstruction pi : this.currentOperation.getExecutionInstructions()) {
            long tempMaxMem;
            if (pi instanceof ProfilingOperation) {
                ProfilingOperation po = (ProfilingOperation)pi;
                tempMaxMem = po.getMaxMemoryUsage();
            } else {
                tempMaxMem = pi.getLaunchedMemoryUsage();
            }
            if (tempMaxMem <= maxMem) continue;
            maxMem = tempMaxMem;
        }
        this.currentOperation.setMaxMemoryUsage(maxMem);
        this.currentOperation = this.currentOperation.getParentOperation();
    }

    public void makeStep(IStackFrame frame) {
        ++this.currentInstructionID;
        long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if (this.hasTocreateStep) {
            ProfilingInstruction instr = ModelFactory.eINSTANCE.createProfilingInstruction();
            instr.setInstructionID(this.currentInstructionID);
            instr.setLaunchedTime(System.currentTimeMillis());
            instr.getStackFrames().add((Object)frame);
            instr.setContent(frame.getIOperation().getInstructions().get(frame.getLocation()).toString());
            instr.setLaunchedMemoryUsage(mem);
            this.currentOperation.getExecutionInstructions().add((Object)instr);
        } else {
            if (mem > this.currentOperation.getMaxMemoryUsage()) {
                this.currentOperation.setMaxMemoryUsage(mem);
            }
            if (mem > this.currentOperation.getEndMemoryUsage()) {
                this.currentOperation.setEndMemoryUsage(mem);
            }
        }
        this.currentOperation.setTotalExecutedInstructions(this.currentOperation.getTotalExecutedInstructions() + 1);
    }

    public void endExecution() {
        this.currentOperation = this.profilingModel;
    }

    private int countInstructions(ProfilingOperation op) {
        int result = 0;
        result += op.getTotalExecutedInstructions();
        for (ProfilingInstruction i : op.getExecutionInstructions()) {
            if (!(i instanceof ProfilingOperation)) continue;
            ProfilingOperation tmpOp = (ProfilingOperation)i;
            result += tmpOp.getTotalExecutedInstructions();
        }
        return result;
    }

    public double getModelTotalTime() {
        ProfilingOperation pOp = this.getMainOperation();
        Double time = new Double((double)(pOp.getEndTime() - pOp.getLaunchedTime()) / 1000.0);
        return time;
    }

    public long getModelTotalInstructions() {
        ProfilingOperation po = this.getMainOperation();
        return po.getTotalExecutedInstructions();
    }

    private ProfilingOperation getMainOperation() {
        ATLOperation op = this.operationRegistry.get("main");
        ProfilingOperation po = (ProfilingOperation)op.getProfilingInstructions().get(0);
        return po;
    }

    public ProfilingModel getProfilingModel() {
        return this.profilingModel;
    }

    public void setProfilingModel(ProfilingModel profilingModel) {
        this.profilingModel = profilingModel;
    }

    public Map<String, ATLOperation> getOperationRegistry() {
        return this.operationRegistry;
    }

    public boolean isDebugMessages() {
        return this.seeDebugMessages;
    }

    public void setDebugMessages(boolean debugMessages) {
        this.seeDebugMessages = debugMessages;
    }

    public boolean isHasTocreateStep() {
        return this.hasTocreateStep;
    }

    public void setHasTocreateStep(boolean hasTocreateStep) {
        this.hasTocreateStep = hasTocreateStep;
    }
}

