/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.lib;

import org.eclipse.m2m.atl.engine.emfvm.Messages;
import org.eclipse.m2m.atl.engine.emfvm.VMException;
import org.eclipse.m2m.atl.engine.emfvm.lib.AbstractStackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.HasFields;

public class EnumLiteral
implements HasFields {
    private String name;

    public EnumLiteral() {
    }

    public EnumLiteral(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name == null ? "<unnamed_yet>" : this.name;
    }

    @Override
    public Object get(AbstractStackFrame frame, Object literalName) {
        if ("name".equals(literalName)) {
            return this.name;
        }
        throw new VMException(frame, Messages.getString("EnumLiteral.ACCESSERROR", literalName));
    }

    @Override
    public void set(AbstractStackFrame frame, Object literalName, Object value) {
        if ("name".equals(literalName) && value instanceof String) {
            this.name = ((String)value).startsWith("#") ? ((String)value).substring(1) : (String)value;
        } else {
            throw new VMException(frame, Messages.getString("EnumLiteral.ASSIGNMENTERROR", value, literalName));
        }
    }

    @Override
    public void unset(AbstractStackFrame frame, Object name) {
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object arg) {
        boolean ret = false;
        if (arg instanceof EnumLiteral && this.name != null) {
            ret = this.name.equals(arg.toString());
        }
        return ret;
    }
}

