/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.jaxrslibraryconfiguration.internal;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.ArchiveFile;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.JAXRSLibrary;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryInternalReference;
import org.eclipse.jst.ws.jaxrs.core.jaxrslibraryconfiguration.internal.JAXRSLibraryReference;

public abstract class AbstractJAXRSLibraryReferenceImpl
implements JAXRSLibraryReference {
    protected JAXRSLibraryInternalReference libRef;
    private String _id;
    private String _label;
    private boolean _isDeloyed;

    public AbstractJAXRSLibraryReferenceImpl(String id, String label) {
        this._id = id;
        this._label = label;
    }

    public AbstractJAXRSLibraryReferenceImpl(JAXRSLibraryInternalReference libRef, boolean isDeployed) {
        this.libRef = libRef;
        this._isDeloyed = isDeployed;
    }

    @Override
    public String getId() {
        if (this.libRef != null) {
            return this.libRef.getID();
        }
        return this._id;
    }

    @Override
    public String getLabel() {
        if (this.libRef != null) {
            return this.libRef.getLabel();
        }
        return this._label;
    }

    @Override
    public boolean isDeployed() {
        return this._isDeloyed;
    }

    protected JAXRSLibrary getLibrary() {
        return this.libRef.getLibrary();
    }

    @Override
    public Collection<IClasspathEntry> getJars() {
        HashSet<IClasspathEntry> results = new HashSet<IClasspathEntry>();
        if (this.getLibrary() != null) {
            EList jars = this.getLibrary().getArchiveFiles();
            for (ArchiveFile jar : jars) {
                String path = jar.getResolvedSourceLocation();
                results.add(JavaCore.newLibraryEntry((IPath)new Path(path), null, null));
            }
        }
        return results;
    }

    @Override
    public String getName() {
        if (this.getLibrary() != null) {
            return this.getLibrary().getName();
        }
        return this.getId();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("id: ");
        buf.append(this.getId());
        buf.append(", label: ");
        buf.append(this.getLabel());
        buf.append(", isDeployed: ");
        buf.append(this.isDeployed());
        return buf.toString();
    }
}

