/* The following code was generated by JFlex 1.4.2 on 7/28/08 9:29 AM */

/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*nlsXXX*/
package org.eclipse.jst.jsp.core.internal.contenttype;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

import org.eclipse.wst.xml.core.internal.contenttype.EncodingParserConstants;
import org.eclipse.wst.xml.core.internal.contenttype.XMLHeadTokenizerConstants;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.2
 * on 7/28/08 9:29 AM from the specification file
 * <tt>D:/workspaces/wtp301/workspace/org.eclipse.jst.jsp.core/DevTimeSupport/HeadParsers/JSPHeadTokenizer.jFlex</tt>
 */
public class JSPHeadTokenizer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 8192;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int UnDelimitedString = 12;
  public static final int DQ_STRING = 8;
  public static final int SQ_STRING = 10;
  public static final int ST_XMLDecl = 2;
  public static final int ST_PAGE_DIRECTIVE = 4;
  public static final int QuotedAttributeValue = 6;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7, 7
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\1\11\10\0\1\6\1\10\2\0\1\7\22\0\1\6\1\20\1\37"+
    "\2\0\1\51\1\0\1\40\6\0\1\43\1\34\1\0\1\47\1\0"+
    "\1\44\5\0\1\50\1\41\1\0\1\13\1\12\1\56\1\14\1\52"+
    "\1\53\1\32\1\23\1\21\1\27\1\0\1\46\1\30\1\33\1\54"+
    "\1\0\1\17\1\16\1\35\1\22\1\26\1\0\1\45\1\36\1\24"+
    "\1\31\1\55\1\42\1\15\1\25\7\0\1\53\1\32\1\23\1\21"+
    "\1\27\1\0\1\46\1\30\1\33\1\54\1\0\1\17\1\16\1\35"+
    "\1\22\1\26\1\0\1\45\1\36\1\24\1\31\1\55\1\42\1\15"+
    "\1\25\101\0\1\4\3\0\1\5\17\0\1\3\16\0\1\1\20\0"+
    "\1\3\16\0\1\1\1\2\170\0\1\2\ufe87\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\10\0\24\1\2\2\1\1\1\2\1\3\1\4\1\5"+
    "\1\6\1\1\1\5\1\7\1\5\1\1\1\10\1\1"+
    "\1\11\6\0\1\12\1\13\15\0\1\14\20\0\1\15"+
    "\1\0\1\16\1\0\1\2\1\3\1\4\1\6\3\0"+
    "\1\17\1\7\1\0\1\10\1\11\10\0\1\20\5\0"+
    "\1\14\12\0\1\15\1\16\1\2\1\17\67\0\1\21"+
    "\20\0\1\22\4\0\1\21\17\0\1\22\6\0\1\23"+
    "\15\0\1\24\1\0\1\23\2\0\1\25\14\0\1\24"+
    "\2\0\1\25\34\0\1\26\14\0\1\26\2\0\1\27"+
    "\13\0\1\27\132\0\1\30\1\0\1\30\6\0\2\30"+
    "\11\0\1\31\1\0\1\31\2\0\2\31\11\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[446];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */




        private boolean hasMore = true;
        private final static int MAX_TO_SCAN = 8000;
        StringBuffer string = new StringBuffer();
        // state stack for easier state handling
        private IntStack fStateStack = new IntStack();
        private String valueText = null;
        private boolean isXHTML;
        private boolean isWML;


        public JSPHeadTokenizer() {
                super();
        }

          public void reset (Reader in) {
                /* the input device */
                zzReader = in;

                /* the current state of the DFA */
                zzState = 0;

                /* the current lexical state */
                zzLexicalState = YYINITIAL;

                /* this buffer contains the current text to be matched and is
                 the source of the yytext() string */
                Arrays.fill(zzBuffer, (char)0);

                /* the textposition at the last accepting state */
                zzMarkedPos = 0;

                /* the textposition at the last state to be included in yytext */
                //zzPushbackPos = 0;

                /* the current text position in the buffer */
                zzCurrentPos = 0;

                /* startRead marks the beginning of the yytext() string in the buffer */
                zzStartRead = 0;

                /**
                 * endRead marks the last character in the buffer, that has been read
                 * from input
                 */
                zzEndRead = 0;

                /* number of newlines encountered up to the start of the matched text */
                //yyline = 0;

                /* the number of characters up to the start of the matched text */
                yychar = 0;

                /**
                 * the number of characters from the last newline up to the start
                 * of the matched text
                 */
                //yycolumn = 0;

                /**
                 * yy_atBOL == true <=> the scanner is currently at the beginning
                 * of a line
                 */
                zzAtBOL = true;

                /* yy_atEOF == true <=> the scanner has returned a value for EOF */
                zzAtEOF = false;

                /* denotes if the user-EOF-code has already been executed */
                zzEOFDone = false;


                fStateStack.clear();

                hasMore = true;
                isXHTML=false;
                isWML=false;


        }


        public final HeadParserToken getNextToken() throws IOException, Exception {
                String context = null;
                context = primGetNextToken();
                HeadParserToken result = null;
                if (valueText != null) {
                        result = createToken(context, yychar, valueText);
                        valueText = null;
                } else {
                        result = createToken(context, yychar, yytext());
                }
                return result;
        }

        public final boolean hasMoreTokens() {
                return hasMore && yychar < MAX_TO_SCAN;
        }
        private void pushCurrentState() {
                fStateStack.push(yystate());

        }
 
        private void popState() {
                yybegin(fStateStack.pop());
        }
        private HeadParserToken createToken(String context, int start, String text) {
                return new HeadParserToken(context, start, text);
        }
        
        public boolean isXHTML() {
            return isXHTML;
        }
        public boolean isWML() {
            return isWML;
        }        



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JSPHeadTokenizer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public JSPHeadTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 194) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yychar = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) throws java.lang.Exception {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new java.lang.Exception(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  throws java.lang.Exception {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() {
    if (!zzEOFDone) {
      zzEOFDone = true;
            hasMore=false;

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException, java.lang.Exception {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;


    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          zzInput = zzCMapL[zzInput];

          boolean zzIsFinal = false;
          boolean zzNoLookAhead = false;

          zzForNext: { switch (zzState) {
            case 0:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzState = 9; break zzForNext;
                case 11: zzIsFinal = true; zzState = 10; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 8; break zzForNext;
              }

            case 1:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 11; break zzForNext;
                case 2: zzIsFinal = true; zzState = 12; break zzForNext;
                case 3: zzIsFinal = true; zzState = 13; break zzForNext;
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 14; break zzForNext;
                case 9: zzIsFinal = true; zzState = 15; break zzForNext;
                case 11: zzIsFinal = true; zzState = 16; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 8; break zzForNext;
              }

            case 2:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 17; break zzForNext;
                case 9: zzIsFinal = true; zzState = 18; break zzForNext;
                case 12: zzIsFinal = true; zzState = 19; break zzForNext;
                case 23: zzIsFinal = true; zzState = 20; break zzForNext;
                case 45: zzIsFinal = true; zzState = 21; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 8; break zzForNext;
              }

            case 3:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzState = 22; break zzForNext;
                case 15: zzIsFinal = true; zzState = 23; break zzForNext;
                case 19: zzIsFinal = true; zzState = 24; break zzForNext;
                case 22: zzIsFinal = true; zzState = 25; break zzForNext;
                case 28: zzIsFinal = true; zzState = 26; break zzForNext;
                case 41: zzIsFinal = true; zzState = 27; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 8; break zzForNext;
              }

            case 4:
              switch (zzInput) {
                case 6: 
                case 7: zzIsFinal = true; zzState = 29; break zzForNext;
                case 8: zzIsFinal = true; zzState = 30; break zzForNext;
                case 9: zzIsFinal = true; zzState = 31; break zzForNext;
                case 31: zzIsFinal = true; zzState = 32; break zzForNext;
                case 32: zzIsFinal = true; zzState = 33; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 28; break zzForNext;
              }

            case 5:
              switch (zzInput) {
                case 7: 
                case 8: 
                case 11: zzIsFinal = true; zzState = 35; break zzForNext;
                case 9: zzIsFinal = true; zzState = 36; break zzForNext;
                case 12: zzIsFinal = true; zzState = 37; break zzForNext;
                case 31: zzIsFinal = true; zzState = 38; break zzForNext;
                case 41: zzIsFinal = true; zzState = 39; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 34; break zzForNext;
              }

            case 6:
              switch (zzInput) {
                case 7: 
                case 8: 
                case 11: zzIsFinal = true; zzState = 35; break zzForNext;
                case 32: zzIsFinal = true; zzState = 38; break zzForNext;
                case 41: zzIsFinal = true; zzState = 39; break zzForNext;
                case 9: zzIsFinal = true; zzState = 40; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 34; break zzForNext;
              }

            case 7:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 35; break zzForNext;
                case 12: 
                case 41: zzIsFinal = true; zzState = 39; break zzForNext;
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 41; break zzForNext;
                case 9: zzIsFinal = true; zzState = 42; break zzForNext;
                case 31: 
                case 32: zzIsFinal = true; zzState = 43; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 34; break zzForNext;
              }

            case 9:
              switch (zzInput) {
                case 11: zzState = 44; break zzForNext;
                default: break zzForAction;
              }

            case 10:
              switch (zzInput) {
                case 9: zzState = 45; break zzForNext;
                case 16: zzState = 46; break zzForNext;
                case 24: zzState = 47; break zzForNext;
                case 41: zzState = 48; break zzForNext;
                case 44: zzState = 49; break zzForNext;
                default: break zzForAction;
              }

            case 11:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 50; break zzForNext;
                default: break zzForAction;
              }

            case 12:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzNoLookAhead = true; zzState = 51; break zzForNext;
                default: break zzForAction;
              }

            case 13:
              switch (zzInput) {
                case 4: zzState = 52; break zzForNext;
                default: break zzForAction;
              }

            case 14:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 53; break zzForNext;
                case 9: zzState = 54; break zzForNext;
                case 11: zzState = 55; break zzForNext;
                default: break zzForAction;
              }

            case 15:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 53; break zzForNext;
                case 11: zzState = 56; break zzForNext;
                default: break zzForAction;
              }

            case 16:
              switch (zzInput) {
                case 16: zzState = 46; break zzForNext;
                case 24: zzState = 47; break zzForNext;
                case 41: zzState = 48; break zzForNext;
                case 44: zzState = 49; break zzForNext;
                case 9: zzState = 57; break zzForNext;
                case 12: zzState = 58; break zzForNext;
                default: break zzForAction;
              }

            case 17:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 59; break zzForNext;
                case 9: zzState = 60; break zzForNext;
                case 12: zzState = 61; break zzForNext;
                default: break zzForAction;
              }

            case 18:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 59; break zzForNext;
                case 12: zzState = 61; break zzForNext;
                case 23: zzState = 62; break zzForNext;
                case 45: zzState = 63; break zzForNext;
                default: break zzForAction;
              }

            case 19:
              switch (zzInput) {
                case 9: zzState = 64; break zzForNext;
                case 46: zzIsFinal = true; zzState = 65; break zzForNext;
                default: break zzForAction;
              }

            case 20:
              switch (zzInput) {
                case 9: zzState = 66; break zzForNext;
                case 29: zzState = 67; break zzForNext;
                default: break zzForAction;
              }

            case 21:
              switch (zzInput) {
                case 9: zzState = 68; break zzForNext;
                case 23: zzState = 69; break zzForNext;
                default: break zzForAction;
              }

            case 22:
              switch (zzInput) {
                case 15: zzState = 70; break zzForNext;
                case 19: zzState = 71; break zzForNext;
                case 22: zzState = 72; break zzForNext;
                case 28: zzState = 73; break zzForNext;
                case 41: zzState = 74; break zzForNext;
                default: break zzForAction;
              }

            case 23:
              switch (zzInput) {
                case 9: zzState = 75; break zzForNext;
                case 43: zzState = 76; break zzForNext;
                default: break zzForAction;
              }

            case 24:
              switch (zzInput) {
                case 9: zzState = 77; break zzForNext;
                case 18: zzState = 78; break zzForNext;
                default: break zzForAction;
              }

            case 25:
              switch (zzInput) {
                case 9: zzState = 79; break zzForNext;
                case 43: zzState = 80; break zzForNext;
                default: break zzForAction;
              }

            case 26:
              switch (zzInput) {
                case 9: zzState = 81; break zzForNext;
                case 46: zzIsFinal = true; zzState = 82; break zzForNext;
                default: break zzForAction;
              }

            case 27:
              switch (zzInput) {
                case 9: zzState = 83; break zzForNext;
                case 46: zzIsFinal = true; zzState = 84; break zzForNext;
                default: break zzForAction;
              }

            case 29:
              switch (zzInput) {
                case 6: 
                case 7: zzIsFinal = true; break zzForNext;
                case 8: zzState = 85; break zzForNext;
                case 9: zzIsFinal = true; zzState = 86; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 28; break zzForNext;
              }

            case 30:
              switch (zzInput) {
                case 6: 
                case 7: zzIsFinal = true; zzState = 29; break zzForNext;
                case 8: zzState = 85; break zzForNext;
                case 9: zzIsFinal = true; zzState = 86; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 28; break zzForNext;
              }

            case 31:
              switch (zzInput) {
                case 31: zzIsFinal = true; zzState = 32; break zzForNext;
                case 32: zzIsFinal = true; zzState = 33; break zzForNext;
                case 6: 
                case 7: 
                case 8: zzState = 85; break zzForNext;
                default: break zzForAction;
              }

            case 32:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 87; break zzForNext;
                default: break zzForAction;
              }

            case 33:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 88; break zzForNext;
                default: break zzForAction;
              }

            case 35:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 89; break zzForNext;
                default: break zzForAction;
              }

            case 36:
              switch (zzInput) {
                case 7: 
                case 8: 
                case 11: zzIsFinal = true; zzState = 35; break zzForNext;
                case 31: zzIsFinal = true; zzState = 38; break zzForNext;
                case 12: zzState = 90; break zzForNext;
                case 41: zzState = 91; break zzForNext;
                default: break zzForAction;
              }

            case 37:
              switch (zzInput) {
                case 9: zzState = 92; break zzForNext;
                case 46: zzIsFinal = true; zzState = 93; break zzForNext;
                default: break zzForAction;
              }

            case 38:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 94; break zzForNext;
                default: break zzForAction;
              }

            case 39:
              switch (zzInput) {
                case 46: zzIsFinal = true; zzState = 35; break zzForNext;
                case 9: zzState = 95; break zzForNext;
                default: break zzForAction;
              }

            case 40:
              switch (zzInput) {
                case 7: 
                case 8: 
                case 11: zzIsFinal = true; zzState = 35; break zzForNext;
                case 32: zzIsFinal = true; zzState = 38; break zzForNext;
                case 41: zzState = 91; break zzForNext;
                default: break zzForAction;
              }

            case 41:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 96; break zzForNext;
                default: break zzForAction;
              }

            case 42:
              switch (zzInput) {
                case 11: zzIsFinal = true; zzState = 35; break zzForNext;
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 41; break zzForNext;
                case 31: 
                case 32: zzIsFinal = true; zzState = 43; break zzForNext;
                case 12: 
                case 41: zzState = 91; break zzForNext;
                default: break zzForAction;
              }

            case 43:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 97; break zzForNext;
                default: break zzForAction;
              }

            case 44:
              switch (zzInput) {
                case 9: zzState = 45; break zzForNext;
                case 16: zzState = 46; break zzForNext;
                case 24: zzState = 47; break zzForNext;
                case 41: zzState = 48; break zzForNext;
                case 44: zzState = 49; break zzForNext;
                default: break zzForAction;
              }

            case 45:
              switch (zzInput) {
                case 16: zzState = 46; break zzForNext;
                case 24: zzState = 47; break zzForNext;
                case 41: zzState = 48; break zzForNext;
                case 44: zzState = 49; break zzForNext;
                default: break zzForAction;
              }

            case 46:
              switch (zzInput) {
                case 9: zzState = 98; break zzForNext;
                case 17: zzState = 99; break zzForNext;
                default: break zzForAction;
              }

            case 47:
              switch (zzInput) {
                case 9: zzState = 100; break zzForNext;
                case 20: zzState = 101; break zzForNext;
                default: break zzForAction;
              }

            case 48:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 102; break zzForNext;
                case 42: zzState = 103; break zzForNext;
                default: break zzForAction;
              }

            case 49:
              switch (zzInput) {
                case 9: zzState = 104; break zzForNext;
                case 30: zzState = 105; break zzForNext;
                default: break zzForAction;
              }

            case 52:
              switch (zzInput) {
                case 5: zzIsFinal = true; zzNoLookAhead = true; zzState = 106; break zzForNext;
                default: break zzForAction;
              }

            case 53:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 54; break zzForNext;
                case 11: zzState = 55; break zzForNext;
                default: break zzForAction;
              }

            case 54:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 53; break zzForNext;
                case 11: zzState = 55; break zzForNext;
                case 9: zzState = 107; break zzForNext;
                default: break zzForAction;
              }

            case 55:
              switch (zzInput) {
                case 12: zzState = 58; break zzForNext;
                case 9: zzState = 108; break zzForNext;
                default: break zzForAction;
              }

            case 56:
              switch (zzInput) {
                case 16: zzState = 46; break zzForNext;
                case 24: zzState = 47; break zzForNext;
                case 41: zzState = 48; break zzForNext;
                case 44: zzState = 49; break zzForNext;
                case 9: zzState = 57; break zzForNext;
                case 12: zzState = 58; break zzForNext;
                default: break zzForAction;
              }

            case 57:
              switch (zzInput) {
                case 16: zzState = 46; break zzForNext;
                case 24: zzState = 47; break zzForNext;
                case 41: zzState = 48; break zzForNext;
                case 44: zzState = 49; break zzForNext;
                case 12: zzState = 58; break zzForNext;
                default: break zzForAction;
              }

            case 58:
              switch (zzInput) {
                case 9: zzState = 109; break zzForNext;
                case 13: zzState = 110; break zzForNext;
                default: break zzForAction;
              }

            case 59:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 60; break zzForNext;
                case 12: zzState = 61; break zzForNext;
                default: break zzForAction;
              }

            case 60:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 59; break zzForNext;
                case 12: zzState = 61; break zzForNext;
                case 9: zzState = 111; break zzForNext;
                default: break zzForAction;
              }

            case 61:
              switch (zzInput) {
                case 9: zzState = 64; break zzForNext;
                case 46: zzIsFinal = true; zzState = 65; break zzForNext;
                default: break zzForAction;
              }

            case 62:
              switch (zzInput) {
                case 9: zzState = 66; break zzForNext;
                case 29: zzState = 67; break zzForNext;
                default: break zzForAction;
              }

            case 63:
              switch (zzInput) {
                case 9: zzState = 68; break zzForNext;
                case 23: zzState = 69; break zzForNext;
                default: break zzForAction;
              }

            case 64:
              switch (zzInput) {
                case 46: zzIsFinal = true; zzState = 65; break zzForNext;
                default: break zzForAction;
              }

            case 65:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 112; break zzForNext;
                default: break zzForAction;
              }

            case 66:
              switch (zzInput) {
                case 29: zzState = 67; break zzForNext;
                default: break zzForAction;
              }

            case 67:
              switch (zzInput) {
                case 9: zzState = 113; break zzForNext;
                case 19: zzState = 114; break zzForNext;
                default: break zzForAction;
              }

            case 68:
              switch (zzInput) {
                case 23: zzState = 69; break zzForNext;
                default: break zzForAction;
              }

            case 69:
              switch (zzInput) {
                case 9: zzState = 115; break zzForNext;
                case 37: zzState = 116; break zzForNext;
                default: break zzForAction;
              }

            case 70:
              switch (zzInput) {
                case 9: zzState = 75; break zzForNext;
                case 43: zzState = 76; break zzForNext;
                default: break zzForAction;
              }

            case 71:
              switch (zzInput) {
                case 9: zzState = 77; break zzForNext;
                case 18: zzState = 78; break zzForNext;
                default: break zzForAction;
              }

            case 72:
              switch (zzInput) {
                case 9: zzState = 79; break zzForNext;
                case 43: zzState = 80; break zzForNext;
                default: break zzForAction;
              }

            case 73:
              switch (zzInput) {
                case 9: zzState = 81; break zzForNext;
                case 46: zzIsFinal = true; zzState = 82; break zzForNext;
                default: break zzForAction;
              }

            case 74:
              switch (zzInput) {
                case 9: zzState = 83; break zzForNext;
                case 46: zzIsFinal = true; zzState = 84; break zzForNext;
                default: break zzForAction;
              }

            case 75:
              switch (zzInput) {
                case 43: zzState = 76; break zzForNext;
                default: break zzForAction;
              }

            case 76:
              switch (zzInput) {
                case 9: zzState = 117; break zzForNext;
                case 29: zzState = 118; break zzForNext;
                default: break zzForAction;
              }

            case 77:
              switch (zzInput) {
                case 18: zzState = 78; break zzForNext;
                default: break zzForAction;
              }

            case 78:
              switch (zzInput) {
                case 9: zzState = 119; break zzForNext;
                case 29: zzState = 120; break zzForNext;
                default: break zzForAction;
              }

            case 79:
              switch (zzInput) {
                case 43: zzState = 80; break zzForNext;
                default: break zzForAction;
              }

            case 80:
              switch (zzInput) {
                case 9: zzState = 121; break zzForNext;
                case 38: zzState = 122; break zzForNext;
                default: break zzForAction;
              }

            case 81:
              switch (zzInput) {
                case 46: zzIsFinal = true; zzState = 82; break zzForNext;
                default: break zzForAction;
              }

            case 82:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 123; break zzForNext;
                default: break zzForAction;
              }

            case 83:
              switch (zzInput) {
                case 46: zzIsFinal = true; zzState = 84; break zzForNext;
                default: break zzForAction;
              }

            case 84:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 124; break zzForNext;
                default: break zzForAction;
              }

            case 85:
              switch (zzInput) {
                case 6: 
                case 7: zzIsFinal = true; zzState = 29; break zzForNext;
                case 8: break zzForNext;
                case 9: zzIsFinal = true; zzState = 86; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 28; break zzForNext;
              }

            case 86:
              switch (zzInput) {
                case 6: 
                case 7: zzIsFinal = true; zzState = 29; break zzForNext;
                case 8: zzState = 85; break zzForNext;
                case 9: zzIsFinal = true; zzState = 125; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 28; break zzForNext;
              }

            case 90:
              switch (zzInput) {
                case 9: zzState = 92; break zzForNext;
                case 46: zzIsFinal = true; zzState = 93; break zzForNext;
                default: break zzForAction;
              }

            case 91:
              switch (zzInput) {
                case 46: zzIsFinal = true; zzState = 35; break zzForNext;
                case 9: zzState = 95; break zzForNext;
                default: break zzForAction;
              }

            case 92:
              switch (zzInput) {
                case 46: zzIsFinal = true; zzState = 93; break zzForNext;
                default: break zzForAction;
              }

            case 93:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 126; break zzForNext;
                default: break zzForAction;
              }

            case 95:
              switch (zzInput) {
                case 46: zzIsFinal = true; zzState = 35; break zzForNext;
                default: break zzForAction;
              }

            case 98:
              switch (zzInput) {
                case 17: zzState = 99; break zzForNext;
                default: break zzForAction;
              }

            case 99:
              switch (zzInput) {
                case 9: zzState = 127; break zzForNext;
                case 18: zzState = 128; break zzForNext;
                default: break zzForAction;
              }

            case 100:
              switch (zzInput) {
                case 20: zzState = 101; break zzForNext;
                default: break zzForAction;
              }

            case 101:
              switch (zzInput) {
                case 9: zzState = 129; break zzForNext;
                case 14: zzState = 130; break zzForNext;
                default: break zzForAction;
              }

            case 102:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 48; break zzForNext;
                case 42: zzState = 103; break zzForNext;
                case 9: zzState = 131; break zzForNext;
                default: break zzForAction;
              }

            case 103:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 132; break zzForNext;
                case 20: zzState = 133; break zzForNext;
                case 22: zzState = 134; break zzForNext;
                default: break zzForAction;
              }

            case 104:
              switch (zzInput) {
                case 30: zzState = 105; break zzForNext;
                default: break zzForAction;
              }

            case 105:
              switch (zzInput) {
                case 9: zzState = 135; break zzForNext;
                case 22: zzState = 136; break zzForNext;
                default: break zzForAction;
              }

            case 107:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 53; break zzForNext;
                case 11: zzState = 55; break zzForNext;
                default: break zzForAction;
              }

            case 108:
              switch (zzInput) {
                case 12: zzState = 58; break zzForNext;
                default: break zzForAction;
              }

            case 109:
              switch (zzInput) {
                case 13: zzState = 110; break zzForNext;
                default: break zzForAction;
              }

            case 110:
              switch (zzInput) {
                case 9: zzState = 137; break zzForNext;
                case 14: zzState = 138; break zzForNext;
                default: break zzForAction;
              }

            case 111:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 59; break zzForNext;
                case 12: zzState = 61; break zzForNext;
                default: break zzForAction;
              }

            case 113:
              switch (zzInput) {
                case 19: zzState = 114; break zzForNext;
                default: break zzForAction;
              }

            case 114:
              switch (zzInput) {
                case 9: zzState = 139; break zzForNext;
                case 18: zzState = 140; break zzForNext;
                default: break zzForAction;
              }

            case 115:
              switch (zzInput) {
                case 37: zzState = 116; break zzForNext;
                default: break zzForAction;
              }

            case 116:
              switch (zzInput) {
                case 9: zzState = 141; break zzForNext;
                case 30: zzState = 142; break zzForNext;
                default: break zzForAction;
              }

            case 117:
              switch (zzInput) {
                case 29: zzState = 118; break zzForNext;
                default: break zzForAction;
              }

            case 118:
              switch (zzInput) {
                case 9: zzState = 143; break zzForNext;
                case 38: zzState = 144; break zzForNext;
                default: break zzForAction;
              }

            case 119:
              switch (zzInput) {
                case 29: zzState = 120; break zzForNext;
                default: break zzForAction;
              }

            case 120:
              switch (zzInput) {
                case 9: zzState = 145; break zzForNext;
                case 20: zzState = 146; break zzForNext;
                default: break zzForAction;
              }

            case 121:
              switch (zzInput) {
                case 38: zzState = 122; break zzForNext;
                default: break zzForAction;
              }

            case 122:
              switch (zzInput) {
                case 9: zzState = 147; break zzForNext;
                case 23: zzState = 148; break zzForNext;
                default: break zzForAction;
              }

            case 125:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 85; break zzForNext;
                default: break zzForAction;
              }

            case 127:
              switch (zzInput) {
                case 18: zzState = 128; break zzForNext;
                default: break zzForAction;
              }

            case 128:
              switch (zzInput) {
                case 9: zzState = 149; break zzForNext;
                case 19: zzState = 150; break zzForNext;
                default: break zzForAction;
              }

            case 129:
              switch (zzInput) {
                case 14: zzState = 130; break zzForNext;
                default: break zzForAction;
              }

            case 130:
              switch (zzInput) {
                case 9: zzState = 151; break zzForNext;
                case 15: zzState = 152; break zzForNext;
                default: break zzForAction;
              }

            case 131:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 48; break zzForNext;
                case 42: zzState = 103; break zzForNext;
                default: break zzForAction;
              }

            case 132:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 103; break zzForNext;
                case 20: zzState = 133; break zzForNext;
                case 22: zzState = 134; break zzForNext;
                case 9: zzState = 153; break zzForNext;
                default: break zzForAction;
              }

            case 133:
              switch (zzInput) {
                case 9: zzState = 154; break zzForNext;
                case 43: zzState = 155; break zzForNext;
                default: break zzForAction;
              }

            case 134:
              switch (zzInput) {
                case 9: zzState = 156; break zzForNext;
                case 43: zzState = 157; break zzForNext;
                default: break zzForAction;
              }

            case 135:
              switch (zzInput) {
                case 22: zzState = 136; break zzForNext;
                default: break zzForAction;
              }

            case 136:
              switch (zzInput) {
                case 9: zzState = 158; break zzForNext;
                case 33: zzState = 159; break zzForNext;
                default: break zzForAction;
              }

            case 137:
              switch (zzInput) {
                case 14: zzState = 138; break zzForNext;
                default: break zzForAction;
              }

            case 138:
              switch (zzInput) {
                case 9: zzState = 160; break zzForNext;
                case 15: zzState = 161; break zzForNext;
                default: break zzForAction;
              }

            case 139:
              switch (zzInput) {
                case 18: zzState = 140; break zzForNext;
                default: break zzForAction;
              }

            case 140:
              switch (zzInput) {
                case 9: zzState = 162; break zzForNext;
                case 17: zzState = 163; break zzForNext;
                default: break zzForAction;
              }

            case 141:
              switch (zzInput) {
                case 30: zzState = 142; break zzForNext;
                default: break zzForAction;
              }

            case 142:
              switch (zzInput) {
                case 9: zzState = 164; break zzForNext;
                case 27: zzState = 165; break zzForNext;
                default: break zzForAction;
              }

            case 143:
              switch (zzInput) {
                case 38: zzState = 144; break zzForNext;
                default: break zzForAction;
              }

            case 144:
              switch (zzInput) {
                case 9: zzState = 166; break zzForNext;
                case 25: zzState = 167; break zzForNext;
                default: break zzForAction;
              }

            case 145:
              switch (zzInput) {
                case 20: zzState = 146; break zzForNext;
                default: break zzForAction;
              }

            case 146:
              switch (zzInput) {
                case 9: zzState = 168; break zzForNext;
                case 23: zzState = 169; break zzForNext;
                default: break zzForAction;
              }

            case 147:
              switch (zzInput) {
                case 23: zzState = 148; break zzForNext;
                default: break zzForAction;
              }

            case 148:
              switch (zzInput) {
                case 9: zzState = 170; break zzForNext;
                case 23: zzState = 171; break zzForNext;
                default: break zzForAction;
              }

            case 149:
              switch (zzInput) {
                case 19: zzState = 150; break zzForNext;
                default: break zzForAction;
              }

            case 150:
              switch (zzInput) {
                case 9: zzState = 172; break zzForNext;
                case 20: zzState = 173; break zzForNext;
                default: break zzForAction;
              }

            case 151:
              switch (zzInput) {
                case 15: zzState = 152; break zzForNext;
                default: break zzForAction;
              }

            case 152:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 174; break zzForNext;
                case 13: zzState = 175; break zzForNext;
                default: break zzForAction;
              }

            case 153:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 103; break zzForNext;
                case 20: zzState = 133; break zzForNext;
                case 22: zzState = 134; break zzForNext;
                default: break zzForAction;
              }

            case 154:
              switch (zzInput) {
                case 43: zzState = 155; break zzForNext;
                default: break zzForAction;
              }

            case 155:
              switch (zzInput) {
                case 9: zzState = 176; break zzForNext;
                case 38: zzState = 177; break zzForNext;
                default: break zzForAction;
              }

            case 156:
              switch (zzInput) {
                case 43: zzState = 157; break zzForNext;
                default: break zzForAction;
              }

            case 157:
              switch (zzInput) {
                case 9: zzState = 178; break zzForNext;
                case 38: zzState = 179; break zzForNext;
                default: break zzForAction;
              }

            case 158:
              switch (zzInput) {
                case 33: zzState = 159; break zzForNext;
                default: break zzForAction;
              }

            case 159:
              switch (zzInput) {
                case 9: zzState = 180; break zzForNext;
                case 17: zzState = 181; break zzForNext;
                default: break zzForAction;
              }

            case 160:
              switch (zzInput) {
                case 15: zzState = 161; break zzForNext;
                default: break zzForAction;
              }

            case 161:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 182; break zzForNext;
                case 9: zzState = 183; break zzForNext;
                default: break zzForAction;
              }

            case 162:
              switch (zzInput) {
                case 17: zzState = 163; break zzForNext;
                default: break zzForAction;
              }

            case 163:
              switch (zzInput) {
                case 9: zzState = 184; break zzForNext;
                case 27: zzState = 185; break zzForNext;
                default: break zzForAction;
              }

            case 164:
              switch (zzInput) {
                case 27: zzState = 165; break zzForNext;
                default: break zzForAction;
              }

            case 165:
              switch (zzInput) {
                case 9: zzState = 186; break zzForNext;
                case 18: zzState = 187; break zzForNext;
                default: break zzForAction;
              }

            case 166:
              switch (zzInput) {
                case 25: zzState = 167; break zzForNext;
                default: break zzForAction;
              }

            case 167:
              switch (zzInput) {
                case 9: zzState = 188; break zzForNext;
                case 43: zzState = 189; break zzForNext;
                default: break zzForAction;
              }

            case 168:
              switch (zzInput) {
                case 23: zzState = 169; break zzForNext;
                default: break zzForAction;
              }

            case 169:
              switch (zzInput) {
                case 9: zzState = 190; break zzForNext;
                case 29: zzState = 191; break zzForNext;
                default: break zzForAction;
              }

            case 170:
              switch (zzInput) {
                case 23: zzState = 171; break zzForNext;
                default: break zzForAction;
              }

            case 171:
              switch (zzInput) {
                case 9: zzState = 192; break zzForNext;
                case 29: zzState = 193; break zzForNext;
                default: break zzForAction;
              }

            case 172:
              switch (zzInput) {
                case 20: zzState = 173; break zzForNext;
                default: break zzForAction;
              }

            case 173:
              switch (zzInput) {
                case 9: zzState = 194; break zzForNext;
                case 21: zzState = 195; break zzForNext;
                default: break zzForAction;
              }

            case 174:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 152; break zzForNext;
                case 13: zzState = 175; break zzForNext;
                case 9: zzState = 196; break zzForNext;
                default: break zzForAction;
              }

            case 175:
              switch (zzInput) {
                case 9: zzState = 197; break zzForNext;
                case 14: zzState = 198; break zzForNext;
                default: break zzForAction;
              }

            case 176:
              switch (zzInput) {
                case 38: zzState = 177; break zzForNext;
                default: break zzForAction;
              }

            case 177:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 199; break zzForNext;
                case 9: zzState = 200; break zzForNext;
                default: break zzForAction;
              }

            case 178:
              switch (zzInput) {
                case 38: zzState = 179; break zzForNext;
                default: break zzForAction;
              }

            case 179:
              switch (zzInput) {
                case 23: zzState = 177; break zzForNext;
                case 9: zzState = 201; break zzForNext;
                default: break zzForAction;
              }

            case 180:
              switch (zzInput) {
                case 17: zzState = 181; break zzForNext;
                default: break zzForAction;
              }

            case 181:
              switch (zzInput) {
                case 9: zzState = 202; break zzForNext;
                case 27: zzState = 203; break zzForNext;
                default: break zzForAction;
              }

            case 182:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; break zzForNext;
                case 9: zzIsFinal = true; zzState = 204; break zzForNext;
                default: break zzForAction;
              }

            case 183:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 182; break zzForNext;
                case 9: zzState = 205; break zzForNext;
                default: break zzForAction;
              }

            case 184:
              switch (zzInput) {
                case 27: zzState = 185; break zzForNext;
                default: break zzForAction;
              }

            case 185:
              switch (zzInput) {
                case 9: zzState = 206; break zzForNext;
                case 29: zzState = 207; break zzForNext;
                default: break zzForAction;
              }

            case 186:
              switch (zzInput) {
                case 18: zzState = 187; break zzForNext;
                default: break zzForAction;
              }

            case 187:
              switch (zzInput) {
                case 9: zzState = 208; break zzForNext;
                case 29: zzState = 209; break zzForNext;
                default: break zzForAction;
              }

            case 188:
              switch (zzInput) {
                case 43: zzState = 189; break zzForNext;
                default: break zzForAction;
              }

            case 189:
              switch (zzInput) {
                case 9: zzState = 210; break zzForNext;
                case 38: zzState = 211; break zzForNext;
                default: break zzForAction;
              }

            case 190:
              switch (zzInput) {
                case 29: zzState = 191; break zzForNext;
                default: break zzForAction;
              }

            case 191:
              switch (zzInput) {
                case 9: zzState = 212; break zzForNext;
                case 20: zzState = 213; break zzForNext;
                default: break zzForAction;
              }

            case 192:
              switch (zzInput) {
                case 29: zzState = 193; break zzForNext;
                default: break zzForAction;
              }

            case 193:
              switch (zzInput) {
                case 9: zzState = 214; break zzForNext;
                case 19: zzState = 215; break zzForNext;
                default: break zzForAction;
              }

            case 194:
              switch (zzInput) {
                case 21: zzState = 195; break zzForNext;
                default: break zzForAction;
              }

            case 195:
              switch (zzInput) {
                case 9: zzState = 216; break zzForNext;
                case 22: zzState = 217; break zzForNext;
                default: break zzForAction;
              }

            case 196:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 152; break zzForNext;
                case 13: zzState = 175; break zzForNext;
                default: break zzForAction;
              }

            case 197:
              switch (zzInput) {
                case 14: zzState = 198; break zzForNext;
                default: break zzForAction;
              }

            case 198:
              switch (zzInput) {
                case 9: zzState = 218; break zzForNext;
                case 15: zzState = 219; break zzForNext;
                default: break zzForAction;
              }

            case 199:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; break zzForNext;
                case 9: zzIsFinal = true; zzState = 220; break zzForNext;
                default: break zzForAction;
              }

            case 200:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 199; break zzForNext;
                case 9: zzState = 221; break zzForNext;
                default: break zzForAction;
              }

            case 201:
              switch (zzInput) {
                case 23: zzState = 177; break zzForNext;
                default: break zzForAction;
              }

            case 202:
              switch (zzInput) {
                case 27: zzState = 203; break zzForNext;
                default: break zzForAction;
              }

            case 203:
              switch (zzInput) {
                case 9: zzState = 222; break zzForNext;
                case 37: zzState = 223; break zzForNext;
                default: break zzForAction;
              }

            case 204:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 182; break zzForNext;
                case 9: zzState = 205; break zzForNext;
                default: break zzForAction;
              }

            case 205:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 182; break zzForNext;
                default: break zzForAction;
              }

            case 206:
              switch (zzInput) {
                case 29: zzState = 207; break zzForNext;
                default: break zzForAction;
              }

            case 207:
              switch (zzInput) {
                case 9: zzState = 224; break zzForNext;
                case 38: zzState = 225; break zzForNext;
                default: break zzForAction;
              }

            case 208:
              switch (zzInput) {
                case 29: zzState = 209; break zzForNext;
                default: break zzForAction;
              }

            case 209:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 226; break zzForNext;
                case 10: zzIsFinal = true; zzState = 227; break zzForNext;
                default: break zzForAction;
              }

            case 210:
              switch (zzInput) {
                case 38: zzState = 211; break zzForNext;
                default: break zzForAction;
              }

            case 211:
              switch (zzInput) {
                case 9: zzState = 228; break zzForNext;
                case 23: zzState = 229; break zzForNext;
                default: break zzForAction;
              }

            case 212:
              switch (zzInput) {
                case 20: zzState = 213; break zzForNext;
                default: break zzForAction;
              }

            case 213:
              switch (zzInput) {
                case 9: zzState = 230; break zzForNext;
                case 20: zzState = 231; break zzForNext;
                default: break zzForAction;
              }

            case 214:
              switch (zzInput) {
                case 19: zzState = 215; break zzForNext;
                default: break zzForAction;
              }

            case 215:
              switch (zzInput) {
                case 9: zzState = 232; break zzForNext;
                case 18: zzState = 233; break zzForNext;
                default: break zzForAction;
              }

            case 216:
              switch (zzInput) {
                case 22: zzState = 217; break zzForNext;
                default: break zzForAction;
              }

            case 217:
              switch (zzInput) {
                case 9: zzState = 234; break zzForNext;
                case 23: zzState = 235; break zzForNext;
                default: break zzForAction;
              }

            case 218:
              switch (zzInput) {
                case 15: zzState = 219; break zzForNext;
                default: break zzForAction;
              }

            case 219:
              switch (zzInput) {
                case 9: zzState = 236; break zzForNext;
                case 29: zzState = 237; break zzForNext;
                default: break zzForAction;
              }

            case 220:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 199; break zzForNext;
                case 9: zzState = 221; break zzForNext;
                default: break zzForAction;
              }

            case 221:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 199; break zzForNext;
                default: break zzForAction;
              }

            case 222:
              switch (zzInput) {
                case 37: zzState = 223; break zzForNext;
                default: break zzForAction;
              }

            case 223:
              switch (zzInput) {
                case 9: zzState = 238; break zzForNext;
                case 23: zzState = 239; break zzForNext;
                default: break zzForAction;
              }

            case 224:
              switch (zzInput) {
                case 38: zzState = 225; break zzForNext;
                default: break zzForAction;
              }

            case 225:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 240; break zzForNext;
                case 10: zzIsFinal = true; zzState = 241; break zzForNext;
                default: break zzForAction;
              }

            case 226:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 209; break zzForNext;
                case 10: zzIsFinal = true; zzState = 227; break zzForNext;
                case 9: zzState = 242; break zzForNext;
                default: break zzForAction;
              }

            case 227:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 243; break zzForNext;
                case 9: zzState = 244; break zzForNext;
                default: break zzForAction;
              }

            case 228:
              switch (zzInput) {
                case 23: zzState = 229; break zzForNext;
                default: break zzForAction;
              }

            case 229:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 245; break zzForNext;
                case 10: zzIsFinal = true; zzState = 246; break zzForNext;
                default: break zzForAction;
              }

            case 230:
              switch (zzInput) {
                case 20: zzState = 231; break zzForNext;
                default: break zzForAction;
              }

            case 231:
              switch (zzInput) {
                case 9: zzState = 247; break zzForNext;
                case 21: zzState = 248; break zzForNext;
                default: break zzForAction;
              }

            case 232:
              switch (zzInput) {
                case 18: zzState = 233; break zzForNext;
                default: break zzForAction;
              }

            case 233:
              switch (zzInput) {
                case 9: zzState = 249; break zzForNext;
                case 17: zzState = 250; break zzForNext;
                default: break zzForAction;
              }

            case 234:
              switch (zzInput) {
                case 23: zzState = 235; break zzForNext;
                default: break zzForAction;
              }

            case 235:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 251; break zzForNext;
                case 24: zzState = 252; break zzForNext;
                case 34: zzState = 253; break zzForNext;
                default: break zzForAction;
              }

            case 236:
              switch (zzInput) {
                case 29: zzState = 237; break zzForNext;
                default: break zzForAction;
              }

            case 237:
              switch (zzInput) {
                case 9: zzState = 254; break zzForNext;
                case 30: zzState = 255; break zzForNext;
                default: break zzForAction;
              }

            case 238:
              switch (zzInput) {
                case 23: zzState = 239; break zzForNext;
                default: break zzForAction;
              }

            case 239:
              switch (zzInput) {
                case 9: zzState = 256; break zzForNext;
                case 19: zzState = 257; break zzForNext;
                default: break zzForAction;
              }

            case 240:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 225; break zzForNext;
                case 10: zzIsFinal = true; zzState = 241; break zzForNext;
                case 9: zzState = 258; break zzForNext;
                default: break zzForAction;
              }

            case 241:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 259; break zzForNext;
                case 9: zzState = 260; break zzForNext;
                default: break zzForAction;
              }

            case 242:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 209; break zzForNext;
                default: break zzForAction;
              }

            case 243:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzState = 227; break zzForNext;
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 244:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 243; break zzForNext;
                default: break zzForAction;
              }

            case 245:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 229; break zzForNext;
                case 10: zzIsFinal = true; zzState = 246; break zzForNext;
                case 9: zzState = 261; break zzForNext;
                default: break zzForAction;
              }

            case 246:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 262; break zzForNext;
                case 9: zzState = 263; break zzForNext;
                default: break zzForAction;
              }

            case 247:
              switch (zzInput) {
                case 21: zzState = 248; break zzForNext;
                default: break zzForAction;
              }

            case 248:
              switch (zzInput) {
                case 9: zzState = 264; break zzForNext;
                case 22: zzState = 265; break zzForNext;
                default: break zzForAction;
              }

            case 249:
              switch (zzInput) {
                case 17: zzState = 250; break zzForNext;
                default: break zzForAction;
              }

            case 250:
              switch (zzInput) {
                case 9: zzState = 266; break zzForNext;
                case 27: zzState = 267; break zzForNext;
                default: break zzForAction;
              }

            case 251:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 235; break zzForNext;
                case 24: zzState = 252; break zzForNext;
                case 34: zzState = 253; break zzForNext;
                case 9: zzState = 268; break zzForNext;
                default: break zzForAction;
              }

            case 252:
              switch (zzInput) {
                case 9: zzState = 269; break zzForNext;
                case 20: zzState = 270; break zzForNext;
                default: break zzForAction;
              }

            case 253:
              switch (zzInput) {
                case 9: zzState = 271; break zzForNext;
                case 14: zzState = 272; break zzForNext;
                default: break zzForAction;
              }

            case 254:
              switch (zzInput) {
                case 30: zzState = 255; break zzForNext;
                default: break zzForAction;
              }

            case 255:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 273; break zzForNext;
                case 10: zzState = 274; break zzForNext;
                default: break zzForAction;
              }

            case 256:
              switch (zzInput) {
                case 19: zzState = 257; break zzForNext;
                default: break zzForAction;
              }

            case 257:
              switch (zzInput) {
                case 9: zzState = 275; break zzForNext;
                case 20: zzState = 276; break zzForNext;
                default: break zzForAction;
              }

            case 258:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 225; break zzForNext;
                default: break zzForAction;
              }

            case 259:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzState = 241; break zzForNext;
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 260:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 259; break zzForNext;
                default: break zzForAction;
              }

            case 261:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 229; break zzForNext;
                default: break zzForAction;
              }

            case 262:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzState = 246; break zzForNext;
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 263:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 262; break zzForNext;
                default: break zzForAction;
              }

            case 264:
              switch (zzInput) {
                case 22: zzState = 265; break zzForNext;
                default: break zzForAction;
              }

            case 265:
              switch (zzInput) {
                case 9: zzState = 277; break zzForNext;
                case 23: zzState = 278; break zzForNext;
                default: break zzForAction;
              }

            case 266:
              switch (zzInput) {
                case 27: zzState = 267; break zzForNext;
                default: break zzForAction;
              }

            case 267:
              switch (zzInput) {
                case 9: zzState = 279; break zzForNext;
                case 29: zzState = 280; break zzForNext;
                default: break zzForAction;
              }

            case 268:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 235; break zzForNext;
                case 24: zzState = 252; break zzForNext;
                case 34: zzState = 253; break zzForNext;
                default: break zzForAction;
              }

            case 269:
              switch (zzInput) {
                case 20: zzState = 270; break zzForNext;
                default: break zzForAction;
              }

            case 270:
              switch (zzInput) {
                case 9: zzState = 281; break zzForNext;
                case 14: zzState = 282; break zzForNext;
                default: break zzForAction;
              }

            case 271:
              switch (zzInput) {
                case 14: zzState = 272; break zzForNext;
                default: break zzForAction;
              }

            case 272:
              switch (zzInput) {
                case 9: zzState = 283; break zzForNext;
                case 15: zzState = 284; break zzForNext;
                default: break zzForAction;
              }

            case 273:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 255; break zzForNext;
                case 10: zzState = 274; break zzForNext;
                case 9: zzState = 285; break zzForNext;
                default: break zzForAction;
              }

            case 274:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 286; break zzForNext;
                case 31: 
                case 32: zzState = 287; break zzForNext;
                default: break zzForAction;
              }

            case 275:
              switch (zzInput) {
                case 20: zzState = 276; break zzForNext;
                default: break zzForAction;
              }

            case 276:
              switch (zzInput) {
                case 9: zzState = 288; break zzForNext;
                case 27: zzState = 289; break zzForNext;
                default: break zzForAction;
              }

            case 277:
              switch (zzInput) {
                case 23: zzState = 278; break zzForNext;
                default: break zzForAction;
              }

            case 278:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 290; break zzForNext;
                case 10: zzIsFinal = true; zzState = 291; break zzForNext;
                default: break zzForAction;
              }

            case 279:
              switch (zzInput) {
                case 29: zzState = 280; break zzForNext;
                default: break zzForAction;
              }

            case 280:
              switch (zzInput) {
                case 9: zzState = 292; break zzForNext;
                case 38: zzState = 293; break zzForNext;
                default: break zzForAction;
              }

            case 281:
              switch (zzInput) {
                case 14: zzState = 282; break zzForNext;
                default: break zzForAction;
              }

            case 282:
              switch (zzInput) {
                case 9: zzState = 294; break zzForNext;
                case 15: zzState = 295; break zzForNext;
                default: break zzForAction;
              }

            case 283:
              switch (zzInput) {
                case 15: zzState = 284; break zzForNext;
                default: break zzForAction;
              }

            case 284:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 296; break zzForNext;
                case 22: zzState = 297; break zzForNext;
                default: break zzForAction;
              }

            case 285:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 255; break zzForNext;
                case 10: zzState = 274; break zzForNext;
                default: break zzForAction;
              }

            case 286:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 274; break zzForNext;
                case 31: 
                case 32: zzState = 287; break zzForNext;
                case 9: zzState = 298; break zzForNext;
                default: break zzForAction;
              }

            case 287:
              switch (zzInput) {
                case 9: zzState = 299; break zzForNext;
                case 24: zzState = 300; break zzForNext;
                default: break zzForAction;
              }

            case 288:
              switch (zzInput) {
                case 27: zzState = 289; break zzForNext;
                default: break zzForAction;
              }

            case 289:
              switch (zzInput) {
                case 9: zzState = 301; break zzForNext;
                case 45: zzState = 302; break zzForNext;
                default: break zzForAction;
              }

            case 290:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 278; break zzForNext;
                case 10: zzIsFinal = true; zzState = 291; break zzForNext;
                case 9: zzState = 303; break zzForNext;
                default: break zzForAction;
              }

            case 291:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 304; break zzForNext;
                case 9: zzState = 305; break zzForNext;
                default: break zzForAction;
              }

            case 292:
              switch (zzInput) {
                case 38: zzState = 293; break zzForNext;
                default: break zzForAction;
              }

            case 293:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 306; break zzForNext;
                case 10: zzIsFinal = true; zzState = 307; break zzForNext;
                default: break zzForAction;
              }

            case 294:
              switch (zzInput) {
                case 15: zzState = 295; break zzForNext;
                default: break zzForAction;
              }

            case 295:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: break zzForNext;
                case 9: zzState = 308; break zzForNext;
                case 22: zzState = 309; break zzForNext;
                default: break zzForAction;
              }

            case 296:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 284; break zzForNext;
                case 22: zzState = 297; break zzForNext;
                case 9: zzState = 310; break zzForNext;
                default: break zzForAction;
              }

            case 297:
              switch (zzInput) {
                case 9: zzState = 311; break zzForNext;
                case 25: zzState = 312; break zzForNext;
                default: break zzForAction;
              }

            case 298:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 274; break zzForNext;
                case 31: 
                case 32: zzState = 287; break zzForNext;
                default: break zzForAction;
              }

            case 299:
              switch (zzInput) {
                case 24: zzState = 300; break zzForNext;
                case 9: zzState = 313; break zzForNext;
                default: break zzForAction;
              }

            case 300:
              switch (zzInput) {
                case 9: zzState = 314; break zzForNext;
                case 20: zzState = 315; break zzForNext;
                default: break zzForAction;
              }

            case 301:
              switch (zzInput) {
                case 45: zzState = 302; break zzForNext;
                default: break zzForAction;
              }

            case 302:
              switch (zzInput) {
                case 9: zzState = 316; break zzForNext;
                case 23: zzState = 317; break zzForNext;
                default: break zzForAction;
              }

            case 303:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 278; break zzForNext;
                default: break zzForAction;
              }

            case 304:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzState = 291; break zzForNext;
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 305:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 304; break zzForNext;
                default: break zzForAction;
              }

            case 306:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 293; break zzForNext;
                case 10: zzIsFinal = true; zzState = 307; break zzForNext;
                case 9: zzState = 318; break zzForNext;
                default: break zzForAction;
              }

            case 307:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 319; break zzForNext;
                case 9: zzState = 320; break zzForNext;
                default: break zzForAction;
              }

            case 308:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 295; break zzForNext;
                case 22: zzState = 309; break zzForNext;
                case 9: zzState = 321; break zzForNext;
                default: break zzForAction;
              }

            case 309:
              switch (zzInput) {
                case 9: zzState = 322; break zzForNext;
                case 25: zzState = 323; break zzForNext;
                default: break zzForAction;
              }

            case 310:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 284; break zzForNext;
                case 22: zzState = 297; break zzForNext;
                default: break zzForAction;
              }

            case 311:
              switch (zzInput) {
                case 25: zzState = 312; break zzForNext;
                default: break zzForAction;
              }

            case 312:
              switch (zzInput) {
                case 9: zzState = 324; break zzForNext;
                case 26: zzState = 325; break zzForNext;
                default: break zzForAction;
              }

            case 313:
              switch (zzInput) {
                case 24: zzState = 300; break zzForNext;
                default: break zzForAction;
              }

            case 314:
              switch (zzInput) {
                case 20: zzState = 315; break zzForNext;
                default: break zzForAction;
              }

            case 315:
              switch (zzInput) {
                case 9: zzState = 326; break zzForNext;
                case 20: zzState = 327; break zzForNext;
                default: break zzForAction;
              }

            case 316:
              switch (zzInput) {
                case 23: zzState = 317; break zzForNext;
                default: break zzForAction;
              }

            case 317:
              switch (zzInput) {
                case 9: zzState = 328; break zzForNext;
                case 35: zzState = 329; break zzForNext;
                default: break zzForAction;
              }

            case 318:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 293; break zzForNext;
                default: break zzForAction;
              }

            case 319:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzState = 307; break zzForNext;
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 320:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzState = 319; break zzForNext;
                default: break zzForAction;
              }

            case 321:
              switch (zzInput) {
                case 6: 
                case 7: 
                case 8: zzState = 295; break zzForNext;
                case 22: zzState = 309; break zzForNext;
                default: break zzForAction;
              }

            case 322:
              switch (zzInput) {
                case 25: zzState = 323; break zzForNext;
                default: break zzForAction;
              }

            case 323:
              switch (zzInput) {
                case 9: zzState = 330; break zzForNext;
                case 26: zzState = 331; break zzForNext;
                default: break zzForAction;
              }

            case 324:
              switch (zzInput) {
                case 26: zzState = 325; break zzForNext;
                default: break zzForAction;
              }

            case 325:
              switch (zzInput) {
                case 9: zzState = 332; break zzForNext;
                case 15: zzState = 333; break zzForNext;
                default: break zzForAction;
              }

            case 326:
              switch (zzInput) {
                case 20: zzState = 327; break zzForNext;
                default: break zzForAction;
              }

            case 327:
              switch (zzInput) {
                case 9: zzState = 334; break zzForNext;
                case 22: zzState = 335; break zzForNext;
                default: break zzForAction;
              }

            case 328:
              switch (zzInput) {
                case 35: zzState = 329; break zzForNext;
                default: break zzForAction;
              }

            case 329:
              switch (zzInput) {
                case 20: zzState = 133; break zzForNext;
                case 22: zzState = 134; break zzForNext;
                case 9: zzState = 336; break zzForNext;
                default: break zzForAction;
              }

            case 330:
              switch (zzInput) {
                case 26: zzState = 331; break zzForNext;
                default: break zzForAction;
              }

            case 331:
              switch (zzInput) {
                case 9: zzState = 337; break zzForNext;
                case 15: zzState = 338; break zzForNext;
                default: break zzForAction;
              }

            case 332:
              switch (zzInput) {
                case 15: zzState = 333; break zzForNext;
                default: break zzForAction;
              }

            case 333:
              switch (zzInput) {
                case 9: zzState = 339; break zzForNext;
                case 27: zzState = 340; break zzForNext;
                default: break zzForAction;
              }

            case 334:
              switch (zzInput) {
                case 22: zzState = 335; break zzForNext;
                default: break zzForAction;
              }

            case 335:
              switch (zzInput) {
                case 9: zzState = 341; break zzForNext;
                case 33: zzState = 342; break zzForNext;
                default: break zzForAction;
              }

            case 336:
              switch (zzInput) {
                case 20: zzState = 133; break zzForNext;
                case 22: zzState = 134; break zzForNext;
                default: break zzForAction;
              }

            case 337:
              switch (zzInput) {
                case 15: zzState = 338; break zzForNext;
                default: break zzForAction;
              }

            case 338:
              switch (zzInput) {
                case 9: zzState = 343; break zzForNext;
                case 27: zzState = 344; break zzForNext;
                default: break zzForAction;
              }

            case 339:
              switch (zzInput) {
                case 27: zzState = 340; break zzForNext;
                default: break zzForAction;
              }

            case 340:
              switch (zzInput) {
                case 9: zzState = 345; break zzForNext;
                case 19: zzState = 346; break zzForNext;
                default: break zzForAction;
              }

            case 341:
              switch (zzInput) {
                case 33: zzState = 342; break zzForNext;
                default: break zzForAction;
              }

            case 342:
              switch (zzInput) {
                case 9: zzState = 347; break zzForNext;
                case 28: zzState = 348; break zzForNext;
                default: break zzForAction;
              }

            case 343:
              switch (zzInput) {
                case 27: zzState = 344; break zzForNext;
                default: break zzForAction;
              }

            case 344:
              switch (zzInput) {
                case 9: zzState = 349; break zzForNext;
                case 19: zzState = 350; break zzForNext;
                default: break zzForAction;
              }

            case 345:
              switch (zzInput) {
                case 19: zzState = 346; break zzForNext;
                default: break zzForAction;
              }

            case 346:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 8: break zzForAction;
                default: break zzForNext;
              }

            case 347:
              switch (zzInput) {
                case 28: zzState = 348; break zzForNext;
                default: break zzForAction;
              }

            case 348:
              switch (zzInput) {
                case 9: zzState = 352; break zzForNext;
                case 28: zzState = 353; break zzForNext;
                default: break zzForAction;
              }

            case 349:
              switch (zzInput) {
                case 19: zzState = 350; break zzForNext;
                default: break zzForAction;
              }

            case 350:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 8: break zzForAction;
                default: break zzForNext;
              }

            case 351:
              switch (zzInput) {
                case 9: zzState = 355; break zzForNext;
                case 28: zzState = 356; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 352:
              switch (zzInput) {
                case 28: zzState = 353; break zzForNext;
                default: break zzForAction;
              }

            case 353:
              switch (zzInput) {
                case 9: zzState = 357; break zzForNext;
                case 34: zzState = 358; break zzForNext;
                default: break zzForAction;
              }

            case 354:
              switch (zzInput) {
                case 9: zzState = 359; break zzForNext;
                case 28: zzState = 360; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 355:
              switch (zzInput) {
                case 28: zzState = 356; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 356:
              switch (zzInput) {
                case 28: break zzForNext;
                case 9: zzState = 361; break zzForNext;
                case 17: zzState = 362; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 357:
              switch (zzInput) {
                case 34: zzState = 358; break zzForNext;
                default: break zzForAction;
              }

            case 358:
              switch (zzInput) {
                case 9: zzState = 363; break zzForNext;
                case 34: zzState = 364; break zzForNext;
                default: break zzForAction;
              }

            case 359:
              switch (zzInput) {
                case 28: zzState = 360; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 360:
              switch (zzInput) {
                case 28: break zzForNext;
                case 9: zzState = 365; break zzForNext;
                case 17: zzState = 366; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 361:
              switch (zzInput) {
                case 28: zzState = 356; break zzForNext;
                case 17: zzState = 362; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 362:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 9: zzState = 367; break zzForNext;
                case 20: zzState = 368; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 363:
              switch (zzInput) {
                case 34: zzState = 364; break zzForNext;
                default: break zzForAction;
              }

            case 364:
              switch (zzInput) {
                case 9: zzState = 369; break zzForNext;
                case 34: zzState = 370; break zzForNext;
                default: break zzForAction;
              }

            case 365:
              switch (zzInput) {
                case 28: zzState = 360; break zzForNext;
                case 17: zzState = 366; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 366:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 9: zzState = 371; break zzForNext;
                case 20: zzState = 372; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 367:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 20: zzState = 368; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 368:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 9: zzState = 373; break zzForNext;
                case 17: zzState = 374; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 369:
              switch (zzInput) {
                case 34: zzState = 370; break zzForNext;
                default: break zzForAction;
              }

            case 370:
              switch (zzInput) {
                case 9: zzState = 375; break zzForNext;
                case 35: zzState = 376; break zzForNext;
                default: break zzForAction;
              }

            case 371:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 20: zzState = 372; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 372:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 9: zzState = 377; break zzForNext;
                case 17: zzState = 378; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 373:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 17: zzState = 374; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 374:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 6: 
                case 7: zzState = 379; break zzForNext;
                case 8: zzState = 380; break zzForNext;
                default: zzState = 346; break zzForNext;
              }

            case 375:
              switch (zzInput) {
                case 35: zzState = 376; break zzForNext;
                default: break zzForAction;
              }

            case 376:
              switch (zzInput) {
                case 9: zzState = 381; break zzForNext;
                case 34: zzState = 382; break zzForNext;
                default: break zzForAction;
              }

            case 377:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 17: zzState = 378; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 378:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 6: 
                case 7: zzState = 383; break zzForNext;
                case 8: zzState = 384; break zzForNext;
                case 9: zzState = 385; break zzForNext;
                default: zzState = 350; break zzForNext;
              }

            case 379:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 9: zzState = 386; break zzForNext;
                case 34: zzState = 387; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 380:
              switch (zzInput) {
                case 9: zzState = 388; break zzForNext;
                case 34: zzState = 389; break zzForNext;
                default: break zzForAction;
              }

            case 381:
              switch (zzInput) {
                case 34: zzState = 382; break zzForNext;
                default: break zzForAction;
              }

            case 382:
              switch (zzInput) {
                case 9: zzState = 390; break zzForNext;
                case 36: zzState = 391; break zzForNext;
                default: break zzForAction;
              }

            case 383:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 9: zzState = 392; break zzForNext;
                case 13: zzState = 393; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 384:
              switch (zzInput) {
                case 9: zzState = 394; break zzForNext;
                case 13: zzState = 395; break zzForNext;
                default: break zzForAction;
              }

            case 385:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 6: 
                case 7: zzState = 383; break zzForNext;
                case 8: zzState = 384; break zzForNext;
                case 9: zzState = 396; break zzForNext;
                default: zzState = 350; break zzForNext;
              }

            case 386:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 34: zzState = 387; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 387:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 9: zzState = 397; break zzForNext;
                case 14: zzState = 398; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 388:
              switch (zzInput) {
                case 34: zzState = 389; break zzForNext;
                default: break zzForAction;
              }

            case 389:
              switch (zzInput) {
                case 9: zzState = 399; break zzForNext;
                case 14: zzState = 400; break zzForNext;
                default: break zzForAction;
              }

            case 390:
              switch (zzInput) {
                case 36: zzState = 391; break zzForNext;
                default: break zzForAction;
              }

            case 391:
              switch (zzInput) {
                case 9: zzState = 401; break zzForNext;
                case 35: zzState = 402; break zzForNext;
                default: break zzForAction;
              }

            case 392:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 13: zzState = 393; break zzForNext;
                case 9: zzState = 403; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 393:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 9: zzState = 404; break zzForNext;
                case 24: zzState = 405; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 394:
              switch (zzInput) {
                case 13: zzState = 395; break zzForNext;
                case 9: zzState = 406; break zzForNext;
                default: break zzForAction;
              }

            case 395:
              switch (zzInput) {
                case 9: zzState = 407; break zzForNext;
                case 24: zzState = 408; break zzForNext;
                default: break zzForAction;
              }

            case 396:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 6: 
                case 7: zzState = 383; break zzForNext;
                case 8: zzState = 384; break zzForNext;
                default: zzState = 350; break zzForNext;
              }

            case 397:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 14: zzState = 398; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 398:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 9: zzState = 409; break zzForNext;
                case 15: zzIsFinal = true; zzState = 410; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 399:
              switch (zzInput) {
                case 14: zzState = 400; break zzForNext;
                default: break zzForAction;
              }

            case 400:
              switch (zzInput) {
                case 9: zzState = 411; break zzForNext;
                case 15: zzIsFinal = true; zzState = 412; break zzForNext;
                default: break zzForAction;
              }

            case 401:
              switch (zzInput) {
                case 35: zzState = 402; break zzForNext;
                default: break zzForAction;
              }

            case 402:
              switch (zzInput) {
                case 9: zzState = 413; break zzForNext;
                case 18: zzState = 414; break zzForNext;
                default: break zzForAction;
              }

            case 403:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 13: zzState = 393; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 404:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 24: zzState = 405; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 405:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 9: zzState = 415; break zzForNext;
                case 20: zzState = 416; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 406:
              switch (zzInput) {
                case 13: zzState = 395; break zzForNext;
                default: break zzForAction;
              }

            case 407:
              switch (zzInput) {
                case 24: zzState = 408; break zzForNext;
                default: break zzForAction;
              }

            case 408:
              switch (zzInput) {
                case 9: zzState = 417; break zzForNext;
                case 20: zzState = 418; break zzForNext;
                default: break zzForAction;
              }

            case 409:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 15: zzIsFinal = true; zzState = 410; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 410:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 9: zzIsFinal = true; zzState = 419; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 411:
              switch (zzInput) {
                case 15: zzIsFinal = true; zzState = 412; break zzForNext;
                default: break zzForAction;
              }

            case 412:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 420; break zzForNext;
                default: break zzForAction;
              }

            case 413:
              switch (zzInput) {
                case 18: zzState = 414; break zzForNext;
                default: break zzForAction;
              }

            case 414:
              switch (zzInput) {
                case 9: zzState = 421; break zzForNext;
                case 37: zzState = 422; break zzForNext;
                default: break zzForAction;
              }

            case 415:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 20: zzState = 416; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 416:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 9: zzState = 423; break zzForNext;
                case 14: zzState = 424; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 417:
              switch (zzInput) {
                case 20: zzState = 418; break zzForNext;
                default: break zzForAction;
              }

            case 418:
              switch (zzInput) {
                case 9: zzState = 425; break zzForNext;
                case 14: zzState = 426; break zzForNext;
                default: break zzForAction;
              }

            case 419:
              switch (zzInput) {
                case 28: zzState = 351; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 346; break zzForNext;
              }

            case 421:
              switch (zzInput) {
                case 37: zzState = 422; break zzForNext;
                default: break zzForAction;
              }

            case 422:
              switch (zzInput) {
                case 9: zzState = 427; break zzForNext;
                case 38: zzState = 428; break zzForNext;
                default: break zzForAction;
              }

            case 423:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 14: zzState = 424; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 424:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 9: zzState = 429; break zzForNext;
                case 15: zzIsFinal = true; zzState = 430; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 425:
              switch (zzInput) {
                case 14: zzState = 426; break zzForNext;
                default: break zzForAction;
              }

            case 426:
              switch (zzInput) {
                case 9: zzState = 431; break zzForNext;
                case 15: zzIsFinal = true; zzState = 432; break zzForNext;
                default: break zzForAction;
              }

            case 427:
              switch (zzInput) {
                case 38: zzState = 428; break zzForNext;
                default: break zzForAction;
              }

            case 428:
              switch (zzInput) {
                case 9: zzState = 433; break zzForNext;
                case 28: zzState = 434; break zzForNext;
                default: break zzForAction;
              }

            case 429:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 15: zzIsFinal = true; zzState = 430; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 430:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 9: zzIsFinal = true; zzState = 435; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 431:
              switch (zzInput) {
                case 15: zzIsFinal = true; zzState = 432; break zzForNext;
                default: break zzForAction;
              }

            case 432:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 436; break zzForNext;
                default: break zzForAction;
              }

            case 433:
              switch (zzInput) {
                case 28: zzState = 434; break zzForNext;
                default: break zzForAction;
              }

            case 434:
              switch (zzInput) {
                case 9: zzState = 437; break zzForNext;
                case 39: zzState = 438; break zzForNext;
                default: break zzForAction;
              }

            case 435:
              switch (zzInput) {
                case 28: zzState = 354; break zzForNext;
                case 8: break zzForAction;
                default: zzState = 350; break zzForNext;
              }

            case 437:
              switch (zzInput) {
                case 39: zzState = 438; break zzForNext;
                default: break zzForAction;
              }

            case 438:
              switch (zzInput) {
                case 9: zzState = 439; break zzForNext;
                case 40: zzState = 440; break zzForNext;
                default: break zzForAction;
              }

            case 439:
              switch (zzInput) {
                case 40: zzState = 440; break zzForNext;
                default: break zzForAction;
              }

            case 440:
              switch (zzInput) {
                case 9: zzState = 441; break zzForNext;
                case 40: zzState = 442; break zzForNext;
                default: break zzForAction;
              }

            case 441:
              switch (zzInput) {
                case 40: zzState = 442; break zzForNext;
                default: break zzForAction;
              }

            case 442:
              switch (zzInput) {
                case 9: zzState = 443; break zzForNext;
                case 40: zzState = 444; break zzForNext;
                default: break zzForAction;
              }

            case 443:
              switch (zzInput) {
                case 40: zzState = 444; break zzForNext;
                default: break zzForAction;
              }

            case 444:
              switch (zzInput) {
                case 28: zzState = 394; break zzForNext;
                case 9: zzState = 445; break zzForNext;
                default: break zzForAction;
              }

            case 445:
              switch (zzInput) {
                case 28: zzState = 394; break zzForNext;
                default: break zzForAction;
              }

            default:
              // if this is ever reached, there is a serious bug in JFlex
              zzScanError(ZZ_UNKNOWN_ERROR);
              break;
          } }

          if ( zzIsFinal ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( zzNoLookAhead ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 10: 
          { if (yychar == 0 ) {hasMore = false; return EncodingParserConstants.UTF16BE;}
          }
        case 26: break;
        case 16: 
          { if (yychar == 0 ) {hasMore = false; return EncodingParserConstants.UTF83ByteBOM;}
          }
        case 27: break;
        case 1: 
          { if(yychar > MAX_TO_SCAN) {hasMore=false; return EncodingParserConstants.MAX_CHARS_REACHED;}
          }
        case 28: break;
        case 4: 
          { yybegin(SQ_STRING); string.setLength(0);
          }
        case 29: break;
        case 8: 
          { yypushback(yylength());popState(); valueText = string.toString(); return EncodingParserConstants.UnDelimitedStringValue;
          }
        case 30: break;
        case 5: 
          { string.append( yytext() );
          }
        case 31: break;
        case 9: 
          { yypushback(yylength());popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTermintatedUnDelimitedStringValue;
          }
        case 32: break;
        case 21: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); return JSPHeadTokenizerConstants.PageLanguage;
          }
        case 33: break;
        case 15: 
          { yypushback(yylength()); popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTerminatedStringValue;
          }
        case 34: break;
        case 25: 
          { isXHTML = true;
          }
        case 35: break;
        case 23: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); return JSPHeadTokenizerConstants.PageEncoding;
          }
        case 36: break;
        case 11: 
          { if (yychar == 0 ) {hasMore = false; return EncodingParserConstants.UTF16LE;}
          }
        case 37: break;
        case 7: 
          { popState(); valueText = string.toString(); return EncodingParserConstants.StringValue;
          }
        case 38: break;
        case 14: 
          { yybegin(YYINITIAL);  return JSPHeadTokenizerConstants.PageDirectiveEnd;
          }
        case 39: break;
        case 22: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); return JSPHeadTokenizerConstants.PageContentType;
          }
        case 40: break;
        case 17: 
          { if (yychar == 0 ) {yybegin(ST_XMLDecl); return XMLHeadTokenizerConstants.XMLDeclStart;}
          }
        case 41: break;
        case 2: 
          { yypushback(1); yybegin(UnDelimitedString); string.setLength(0);
          }
        case 42: break;
        case 12: 
          { yybegin(YYINITIAL); return XMLHeadTokenizerConstants.XMLDeclEnd;
          }
        case 43: break;
        case 13: 
          { yybegin(YYINITIAL); return JSPHeadTokenizerConstants.PageDirectiveEnd;
          }
        case 44: break;
        case 24: 
          { isWML = true;
          }
        case 45: break;
        case 18: 
          { yybegin(ST_PAGE_DIRECTIVE); return JSPHeadTokenizerConstants.PageDirectiveStart;
          }
        case 46: break;
        case 6: 
          { yypushback(yylength());popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTerminatedStringValue;
          }
        case 47: break;
        case 20: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); return XMLHeadTokenizerConstants.XMLDelEncoding;
          }
        case 48: break;
        case 19: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); return XMLHeadTokenizerConstants.XMLDeclVersion;
          }
        case 49: break;
        case 3: 
          { yybegin(DQ_STRING); string.setLength(0);
          }
        case 50: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {
                hasMore = false; return EncodingParserConstants.EOF;
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
