/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.jspeditor;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.context.symbol.IBeanMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IBeanPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.internal.impl.JavaUtil;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.jst.jsf.ui.internal.jspeditor.ITestHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;

class BeanSuffixHyperlink
implements IHyperlink,
ITestHyperlink {
    private final IRegion _fRegion;
    private final ISymbol _symbol;

    public BeanSuffixHyperlink(IRegion region, ISymbol symbol) {
        this._fRegion = region;
        this._symbol = symbol;
    }

    public IRegion getHyperlinkRegion() {
        return this._fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        IJavaElement element = this.determineJavaElement();
        if (element != null) {
            ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
            if (compilationUnit != null) {
                return NLS.bind((String)Messages.Hyperlink_Open_JavaMethod, (Object)compilationUnit.getElementName(), (Object)element.getElementName());
            }
            return Messages.Hyperlink_Open_JavaFile;
        }
        return Messages.Hyperlink_Open_JavaElement;
    }

    public void open() {
        IJavaElement element = this.determineJavaElement();
        if (element != null) {
            try {
                IEditorPart editor = JavaUI.openInEditor((IJavaElement)element);
                if (editor != null) {
                    JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)element);
                }
            }
            catch (Exception e) {
                JSFUiPlugin.log(2, e.getMessage(), e);
            }
        }
    }

    @Override
    public IJavaElement determineJavaElement() {
        if (this._symbol instanceof IBeanPropertySymbol) {
            return this.determinePropertyElement((IBeanPropertySymbol)this._symbol);
        }
        if (this._symbol instanceof IBeanMethodSymbol) {
            return JavaUtil.findCorrespondingMethod((IBeanMethodSymbol)((IBeanMethodSymbol)this._symbol));
        }
        return null;
    }

    private IMethod determinePropertyElement(IBeanPropertySymbol propertySymbol) {
        JDTBeanProperty property = JavaUtil.findCorrespondingJDTProperty((IBeanPropertySymbol)propertySymbol);
        if (property != null) {
            if (property.getGetter() != null) {
                return property.getGetter();
            }
            if (property.getSetter() != null) {
                return property.getSetter();
            }
        }
        return null;
    }
}

