/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.AbstractTreeContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.TreeContentMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.provider.DelegatingTreeMergeViewerItemContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.provider.MergeViewerItemProviderConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.provider.TreeContentMergeViewerItemLabelProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.match.impl.NotLoadedFragmentMatch;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.TreeMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.provider.IMergeViewerItemProviderConfiguration;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TreeContentMergeViewer
extends AbstractTreeContentMergeViewer {
    private static final String BUNDLE_NAME = TreeContentMergeViewer.class.getName();
    private final ComposedAdapterFactory fAdapterFactory;
    private AtomicBoolean fSyncExpandedState;
    private Collection<Diff> moveDifferences;

    public TreeContentMergeViewer(int style, ResourceBundle bundle, Composite parent, EMFCompareConfiguration config) {
        super(style, bundle, config);
        LinkedHashMap context = Maps.newLinkedHashMap();
        context.put("comparison", config.getComparison());
        this.fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().createFilteredAdapterFactoryRegistry((Map)context));
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.fSyncExpandedState = new AtomicBoolean();
        this.buildControl(parent);
        this.setContentProvider((IContentProvider)new TreeContentMergeViewerContentProvider(config));
    }

    protected ComposedAdapterFactory getAdapterFactory() {
        return this.fAdapterFactory;
    }

    public TreeContentMergeViewer(Composite parent, EMFCompareConfiguration config) {
        this(0, ResourceBundle.getBundle(BUNDLE_NAME), parent, config);
    }

    @Override
    protected void handleDispose(DisposeEvent event) {
        this.fAdapterFactory.dispose();
        if (this.moveDifferences != null) {
            this.moveDifferences.clear();
        }
        super.handleDispose(event);
    }

    protected AbstractMergeViewer createMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        TreeMergeViewer mergeTreeViewer = new TreeMergeViewer(parent, side, this, this.getCompareConfiguration()){

            protected IAction createAction(MergeMode mode, Diff diff) {
                return new MergeAction(this.getCompareConfiguration(), EMFCompareRCPPlugin.getDefault().getMergerRegistry(), mode, null, (IStructuredSelection)new StructuredSelection((Object)diff));
            }
        };
        IContentProvider contentProvider = this.createMergeViewerContentProvider(side);
        mergeTreeViewer.setContentProvider(contentProvider);
        TreeContentMergeViewerItemLabelProvider labelProvider = new TreeContentMergeViewerItemLabelProvider(this.getResourceBundle(), (AdapterFactory)this.getAdapterFactory(), side);
        mergeTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.hookListeners(mergeTreeViewer);
        return mergeTreeViewer;
    }

    protected IContentProvider createMergeViewerContentProvider(IMergeViewer.MergeViewerSide side) {
        Comparison comparison = this.getCompareConfiguration().getComparison();
        if (comparison == null) {
            return new NullTreeContentProvider();
        }
        IMergeViewerItemProviderConfiguration configuration = this.createMergeViewerItemProviderConfiguration(side);
        return new DelegatingTreeMergeViewerItemContentProvider(comparison, configuration);
    }

    protected IMergeViewerItemProviderConfiguration createMergeViewerItemProviderConfiguration(IMergeViewer.MergeViewerSide side) {
        return new MergeViewerItemProviderConfiguration((AdapterFactory)this.getAdapterFactory(), this.getDifferenceGroupProvider(), this.getDifferenceFilterPredicate(), this.getCompareConfiguration().getComparison(), side);
    }

    @Override
    protected void hookListeners(TreeMergeViewer treeMergeViewer) {
        treeMergeViewer.getStructuredViewer().getTree().addListener(18, (Listener)new ExpandCollapseListener(treeMergeViewer, false));
        treeMergeViewer.getStructuredViewer().getTree().addListener(17, (Listener)new ExpandCollapseListener(treeMergeViewer, true));
        super.hookListeners(treeMergeViewer);
    }

    private Match getContainerMatch(Comparison comparison, EObject value) {
        if (value != null) {
            EObject eContainer = value.eContainer();
            return comparison.getMatch(eContainer);
        }
        return null;
    }

    protected final class ExpandCollapseListener
    implements Listener {
        private final TreeMergeViewer mergeTreeViewer;
        private boolean expanded;

        public ExpandCollapseListener(TreeMergeViewer mergeTreeViewer, boolean expanded) {
            this.mergeTreeViewer = mergeTreeViewer;
            this.expanded = expanded;
        }

        public void handleEvent(Event e) {
            Match match;
            Object data = e.item.getData();
            ArrayList toBeExpanded = Lists.newArrayList();
            toBeExpanded.add(data);
            Object parent = TreeContentMergeViewer.this.getLeftMergeViewer() == this.mergeTreeViewer ? ((IMergeViewerItem)data).getLeft() : (TreeContentMergeViewer.this.getRightMergeViewer() == this.mergeTreeViewer ? ((IMergeViewerItem)data).getRight() : ((IMergeViewerItem)data).getAncestor());
            Comparison comparison = TreeContentMergeViewer.this.getCompareConfiguration().getComparison();
            if (parent instanceof NotLoadedFragmentMatch) {
                MergeViewerItem.Container left = new MergeViewerItem.Container(comparison, null, (Match)parent, IMergeViewer.MergeViewerSide.LEFT, (AdapterFactory)TreeContentMergeViewer.this.getAdapterFactory());
                MergeViewerItem.Container right = new MergeViewerItem.Container(comparison, null, (Match)parent, IMergeViewer.MergeViewerSide.RIGHT, (AdapterFactory)TreeContentMergeViewer.this.getAdapterFactory());
                toBeExpanded.add(left);
                toBeExpanded.add(right);
            } else if (parent instanceof EObject && (match = comparison.getMatch((EObject)parent)) != null) {
                if (TreeContentMergeViewer.this.moveDifferences == null) {
                    TreeContentMergeViewer.this.moveDifferences = Lists.newArrayList((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ReferenceChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE))));
                }
                for (Diff referenceChange : TreeContentMergeViewer.this.moveDifferences) {
                    MergeViewerItem.Container container;
                    Match matchOfValue = comparison.getMatch(((ReferenceChange)referenceChange).getValue());
                    if (matchOfValue == null) continue;
                    Match leftContainerMatch = TreeContentMergeViewer.this.getContainerMatch(comparison, matchOfValue.getLeft());
                    Match rightContainerMatch = TreeContentMergeViewer.this.getContainerMatch(comparison, matchOfValue.getRight());
                    Match originContainerMatch = TreeContentMergeViewer.this.getContainerMatch(comparison, matchOfValue.getOrigin());
                    if (leftContainerMatch != match && rightContainerMatch != match && originContainerMatch != match) continue;
                    if (leftContainerMatch != null && leftContainerMatch != match) {
                        container = new MergeViewerItem.Container(comparison, null, leftContainerMatch, IMergeViewer.MergeViewerSide.LEFT, (AdapterFactory)TreeContentMergeViewer.this.getAdapterFactory());
                        toBeExpanded.add(container);
                    }
                    if (rightContainerMatch != null && rightContainerMatch != match) {
                        container = new MergeViewerItem.Container(comparison, null, rightContainerMatch, IMergeViewer.MergeViewerSide.RIGHT, (AdapterFactory)TreeContentMergeViewer.this.getAdapterFactory());
                        toBeExpanded.add(container);
                    }
                    if (originContainerMatch == null || originContainerMatch == match) continue;
                    container = new MergeViewerItem.Container(comparison, null, originContainerMatch, IMergeViewer.MergeViewerSide.ANCESTOR, (AdapterFactory)TreeContentMergeViewer.this.getAdapterFactory());
                    toBeExpanded.add(container);
                }
            }
            try {
                if (TreeContentMergeViewer.this.fSyncExpandedState.compareAndSet(false, true)) {
                    for (Object object : toBeExpanded) {
                        TreeContentMergeViewer.this.getLeftMergeViewer().setExpandedState(object, this.expanded);
                        TreeContentMergeViewer.this.getRightMergeViewer().setExpandedState(object, this.expanded);
                        TreeContentMergeViewer.this.getAncestorMergeViewer().setExpandedState(object, this.expanded);
                    }
                }
            }
            finally {
                SWTUtil.safeRedraw((Control)TreeContentMergeViewer.this.getCenterControl(), (boolean)true);
                TreeContentMergeViewer.this.fSyncExpandedState.set(false);
            }
        }
    }

    private class NullTreeContentProvider
    implements ITreeContentProvider {
        private NullTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

