/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IBreakpointsExtension;
import org.eclipse.cdt.dsf.gdb.service.GDBBreakpoints_7_0;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointDMData;
import org.eclipse.cdt.dsf.mi.service.MIBreakpoints;
import org.eclipse.cdt.dsf.mi.service.command.output.CLIInfoBreakInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakListInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;

public class GDBBreakpoints_7_2
extends GDBBreakpoints_7_0 {
    private IMICommandControl fConnection;
    private TracepointMode fTracepointMode = TracepointMode.NORMAL_ONLY;

    public GDBBreakpoints_7_2(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                GDBBreakpoints_7_2.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fConnection = (IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class);
        this.setTracepointMode();
        this.register(new String[]{IBreakpoints.class.getName(), IBreakpointsExtension.class.getName(), MIBreakpoints.class.getName(), GDBBreakpoints_7_0.class.getName(), GDBBreakpoints_7_2.class.getName()}, new Hashtable());
        rm.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    @Override
    public void getBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext context, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext[]> drm) {
        if (this.bpThreadGroupInfoAvailable()) {
            super.getBreakpoints(context, drm);
            return;
        }
        if (context == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown execution context", null));
            drm.done();
            return;
        }
        final Map<String, MIBreakpointDMData> breakpointContext = this.getBreakpointMap(context);
        if (breakpointContext == null) {
            drm.setData((Object)new IBreakpoints.IBreakpointDMContext[0]);
            drm.done();
            return;
        }
        this.fConnection.queueCommand(this.fConnection.getCommandFactory().createMIBreakList(context), (DataRequestMonitor)new DataRequestMonitor<MIBreakListInfo>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                final MIBreakpoint[] breakpoints = ((MIBreakListInfo)this.getData()).getMIBreakpoints();
                GDBBreakpoints_7_2.this.fConnection.queueCommand(GDBBreakpoints_7_2.this.fConnection.getCommandFactory().createCLIInfoBreak((IDMContext)context), (DataRequestMonitor)new ImmediateDataRequestMonitor<CLIInfoBreakInfo>((RequestMonitor)drm){

                    protected void handleSuccess() {
                        Map<String, String[]> groupIdMap = ((CLIInfoBreakInfo)this.getData()).getBreakpointToGroupMap();
                        breakpointContext.clear();
                        IBreakpoints.IBreakpointDMContext[] result = new IBreakpoints.IBreakpointDMContext[breakpoints.length];
                        int i = 0;
                        while (i < breakpoints.length) {
                            MIBreakpointDMData breakpointData = GDBBreakpoints_7_2.this.createMIBreakpointDMData(breakpoints[i]);
                            String reference = breakpointData.getReference();
                            String[] groupIds = groupIdMap.get(reference);
                            breakpointData.setGroupIds(groupIds);
                            result[i] = new MIBreakpoints.MIBreakpointDMContext(GDBBreakpoints_7_2.this, new IDMContext[]{context}, reference);
                            breakpointContext.put(reference, breakpointData);
                            ++i;
                        }
                        drm.setData((Object)result);
                        drm.done();
                    }
                });
            }
        });
    }

    private void setTracepointMode() {
        ILaunch launch = (ILaunch)this.getSession().getModelAdapter(ILaunch.class);
        String tpMode = "TP_NORMAL_ONLY";
        try {
            tpMode = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.TRACEPOINT_MODE", "TP_NORMAL_ONLY");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (tpMode.equals("TP_FAST_ONLY")) {
            this.fTracepointMode = TracepointMode.FAST_ONLY;
        } else if (tpMode.equals("TP_NORMAL_ONLY")) {
            this.fTracepointMode = TracepointMode.NORMAL_ONLY;
        } else if (tpMode.equals("TP_FAST_THEN_NORMAL")) {
            this.fTracepointMode = TracepointMode.FAST_THEN_NORMAL;
        } else {
            assert (false) : "Invalid tracepoint mode: " + tpMode;
            this.fTracepointMode = TracepointMode.NORMAL_ONLY;
        }
    }

    protected void sendTracepointCommand(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, boolean isFastTracepoint, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        final Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown breakpoint context", null));
            drm.done();
            return;
        }
        String location = this.formatLocation(attributes);
        if (location.equals("")) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Unknown breakpoint context", null));
            drm.done();
            return;
        }
        Boolean enabled = (Boolean)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", true);
        String condition = (String)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.condition", "");
        this.fConnection.queueCommand(this.fConnection.getCommandFactory().createMIBreakInsert(context, false, isFastTracepoint, condition, 0, location, "0", enabled == false, true), (DataRequestMonitor)new DataRequestMonitor<MIBreakInsertInfo>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                if (((MIBreakInsertInfo)this.getData()).getMIBreakpoints().length == 0) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Breakpoint insertion failure", null));
                    drm.done();
                    return;
                }
                MIBreakpointDMData newBreakpoint = GDBBreakpoints_7_2.this.createMIBreakpointDMData(((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0]);
                String reference = newBreakpoint.getNumber();
                if (reference.isEmpty()) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Breakpoint insertion failure", null));
                    drm.done();
                    return;
                }
                contextBreakpoints.put(reference, newBreakpoint);
                MIBreakpoints.MIBreakpointDMContext dmc = new MIBreakpoints.MIBreakpointDMContext(GDBBreakpoints_7_2.this, new IDMContext[]{context}, reference);
                drm.setData((Object)dmc);
                GDBBreakpoints_7_2.this.getSession().dispatchEvent((Object)new MIBreakpoints.BreakpointAddedEvent(GDBBreakpoints_7_2.this, dmc), GDBBreakpoints_7_2.this.getProperties());
                HashMap<String, Object> delta = new HashMap<String, Object>();
                delta.put("org.eclipse.cdt.dsf.debug.breakpoint.passCount", GDBBreakpoints_7_2.this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.passCount", 0));
                delta.put("org.eclipse.cdt.dsf.debug.breakpoint.commands", GDBBreakpoints_7_2.this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.commands", ""));
                GDBBreakpoints_7_2.this.modifyBreakpoint(dmc, delta, (RequestMonitor)drm, false);
            }

            protected void handleError() {
                drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Breakpoint insertion failure", this.getStatus().getException()));
                drm.done();
            }
        });
    }

    @Override
    protected void addTracepoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        boolean isFastTracepoint = this.fTracepointMode != TracepointMode.NORMAL_ONLY;
        this.sendTracepointCommand(context, attributes, isFastTracepoint, (DataRequestMonitor<IBreakpoints.IBreakpointDMContext>)new ImmediateDataRequestMonitor<IBreakpoints.IBreakpointDMContext>(drm){

            protected void handleSuccess() {
                drm.setData((Object)((IBreakpoints.IBreakpointDMContext)this.getData()));
                drm.done();
            }

            protected void handleError() {
                if (GDBBreakpoints_7_2.this.fTracepointMode == TracepointMode.FAST_THEN_NORMAL) {
                    GDBBreakpoints_7_2.this.sendTracepointCommand(context, attributes, false, (DataRequestMonitor<IBreakpoints.IBreakpointDMContext>)drm);
                } else {
                    drm.setStatus(this.getStatus());
                    drm.done();
                }
            }
        });
    }

    protected boolean bpThreadGroupInfoAvailable() {
        return false;
    }

    private static enum TracepointMode {
        FAST_THEN_NORMAL,
        FAST_ONLY,
        NORMAL_ONLY;

    }
}

