/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.HashSet;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class NonVirtualDestructorChecker
extends AbstractIndexAstChecker {
    public static final String PROBLEM_ID = "org.eclipse.cdt.codan.internal.checkers.NonVirtualDestructorProblem";
    private static HashSet<ICPPClassType> checkedClassTypes = new HashSet();

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new OnEachClass());
    }

    private static ICPPMethod getDestructor(ICPPClassType classType) {
        ICPPMethod[] methods = null;
        methods = classType instanceof ICPPDeferredClassInstance ? ((ICPPDeferredClassInstance)classType).getClassTemplate().getDeclaredMethods() : classType.getDeclaredMethods();
        ICPPMethod[] iCPPMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (method.isDestructor()) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasVirtualDestructor(ICPPClassType classType) {
        ICPPBase[] bases;
        checkedClassTypes.add(classType);
        ICPPMethod destructor = NonVirtualDestructorChecker.getDestructor(classType);
        if (destructor != null && destructor.isVirtual()) {
            return true;
        }
        if (destructor == null && CPPTemplates.isDependentType((IType)classType)) {
            return true;
        }
        ICPPBase[] iCPPBaseArray = bases = classType.getBases();
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType cppClassType;
            ICPPBase base = iCPPBaseArray[n2];
            IBinding baseClass = base.getBaseClass();
            if (baseClass instanceof ICPPClassType ? !checkedClassTypes.contains(cppClassType = (ICPPClassType)baseClass) && NonVirtualDestructorChecker.hasVirtualDestructor(cppClassType) : baseClass instanceof ICPPTemplateTypeParameter) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private class OnEachClass
    extends ASTVisitor {
        OnEachClass() {
            this.shouldVisitDeclSpecifiers = true;
        }

        public int visit(IASTDeclSpecifier decl) {
            if (decl instanceof ICPPASTCompositeTypeSpecifier) {
                ICPPASTCompositeTypeSpecifier spec = (ICPPASTCompositeTypeSpecifier)decl;
                IASTName className = spec.getName();
                IBinding binding = className.resolveBinding();
                if (!(binding instanceof ICPPClassType)) {
                    return 1;
                }
                try {
                    IASTNode[] decls;
                    CPPSemantics.pushLookupPoint((IASTNode)className);
                    ICPPClassType classType = (ICPPClassType)binding;
                    boolean hasVirtualDestructor = NonVirtualDestructorChecker.hasVirtualDestructor(classType);
                    checkedClassTypes.clear();
                    if (hasVirtualDestructor) {
                        return 3;
                    }
                    ICPPMethod virtualMethod = null;
                    ICPPMethod[] iCPPMethodArray = ClassTypeHelper.getAllDeclaredMethods((ICPPClassType)classType);
                    int n = iCPPMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPMethod method = iCPPMethodArray[n2];
                        if (!method.isDestructor() && method.isVirtual()) {
                            virtualMethod = method;
                        }
                        ++n2;
                    }
                    if (virtualMethod == null) {
                        return 3;
                    }
                    ICPPMethod destructor = NonVirtualDestructorChecker.getDestructor(classType);
                    if (destructor != null && destructor.getVisibility() != 1 && classType.getFriends().length == 0) {
                        return 3;
                    }
                    IASTDeclSpecifier node = decl;
                    if (destructor instanceof ICPPInternalBinding && (decls = ((ICPPInternalBinding)destructor).getDeclarations()) != null && decls.length > 0) {
                        node = decls[0];
                    }
                    NonVirtualDestructorChecker.this.reportProblem(NonVirtualDestructorChecker.PROBLEM_ID, (IASTNode)node, new Object[]{new String(className.getSimpleID()), virtualMethod.getName()});
                }
                finally {
                    CPPSemantics.popLookupPoint();
                }
            }
            return 3;
        }
    }
}

