/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.validation.quickfixes;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.ErrorImport;
import org.eclipse.acceleo.ErrorModuleReference;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.VisibilityKind;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.parser.AcceleoAstSerializer;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorCall;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.parser.CombineIterator;
import org.eclipse.acceleo.query.parser.Positions;
import org.eclipse.acceleo.query.parser.quickfixes.AstQuickFix;
import org.eclipse.acceleo.query.parser.quickfixes.AstQuickFixesSwitch;
import org.eclipse.acceleo.query.parser.quickfixes.AstTextReplacement;
import org.eclipse.acceleo.query.parser.quickfixes.IAstQuickFix;
import org.eclipse.acceleo.query.parser.quickfixes.IAstTextReplacement;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class AqlQuickFixesSwitch
extends AstQuickFixesSwitch {
    private static final Pattern EMPTY_MODULE_METAMODEL_PATTERN = Pattern.compile("\\(\\s*\\)");
    private static final Pattern EMPTY_PARAMETER_PATTERN = Pattern.compile("\\(\\s*\\)");
    private final IQualifiedNameQueryEnvironment queryEnvironment;
    private IAcceleoValidationResult validationResult;
    private final Module module;
    private String moduleQualifiedName;
    private String moduleText;
    final int[][] linesAndColumns;
    private final Positions<ASTNode> positions;
    private final String newLine;

    public AqlQuickFixesSwitch(IQualifiedNameQueryEnvironment queryEnvironment, IAcceleoValidationResult validationResult, String moduleQualifiedName, String moduleText, String newLine) {
        super(validationResult.getAcceleoAstResult().getPositions());
        this.queryEnvironment = queryEnvironment;
        this.validationResult = validationResult;
        this.module = validationResult.getAcceleoAstResult().getModule();
        this.moduleQualifiedName = moduleQualifiedName;
        this.moduleText = moduleText;
        this.linesAndColumns = AQLUtils.getLinesAndColumns((String)moduleText);
        this.newLine = newLine;
        this.positions = validationResult.getAcceleoAstResult().getPositions();
    }

    protected IQualifiedNameQueryEnvironment getQueryEnvironment() {
        return this.queryEnvironment;
    }

    public List<IAstQuickFix> caseVarRef(VarRef varRef) {
        Statement containingStatement;
        ArrayList<IAstQuickFix> res = new ArrayList<IAstQuickFix>();
        ModuleElement moduleElement = AcceleoUtil.getContainingModuleElement((ASTNode)varRef);
        if (moduleElement != null) {
            res.addAll(this.getAddParameterQuickFixes(varRef, moduleElement));
        }
        if ((containingStatement = AcceleoUtil.getContainingStatement((ASTNode)varRef)) != null) {
            res.addAll(this.getSurroundWithLetStatementQuickFix(varRef, containingStatement));
        }
        return res;
    }

    private List<IAstQuickFix> getSurroundWithLetStatementQuickFix(VarRef varRef, Statement containingStatement) {
        ArrayList<IAstQuickFix> res = new ArrayList<IAstQuickFix>();
        IQualifiedNameResolver resolver = this.getQueryEnvironment().getLookupEngine().getResolver();
        URI uri = resolver.getSourceURI(this.moduleQualifiedName);
        LetStatement letStatement = AcceleoPackage.eINSTANCE.getAcceleoFactory().createLetStatement();
        Block body = AcceleoPackage.eINSTANCE.getAcceleoFactory().createBlock();
        TextStatement textStatement = AcceleoPackage.eINSTANCE.getAcceleoFactory().createTextStatement();
        int offsetStart = this.positions.getStartPositions((EObject)containingStatement);
        int lineStart = this.positions.getStartLines((EObject)containingStatement);
        int columnStart = this.positions.getStartColumns((EObject)containingStatement);
        int offsetEnd = this.positions.getEndPositions((EObject)containingStatement);
        int lineEnd = this.positions.getEndLines((EObject)containingStatement);
        int columnEnd = this.positions.getEndColumns((EObject)containingStatement);
        String indent = this.moduleText.substring(offsetStart - columnStart, offsetStart);
        String text = indent + this.moduleText.substring(this.positions.getStartPositions((EObject)containingStatement), this.positions.getEndPositions((EObject)containingStatement)).replaceAll("\\R\\s*", "$0  ") + this.newLine + indent;
        textStatement.setValue(text);
        body.getStatements().add((Object)textStatement);
        letStatement.setBody(body);
        Binding binding = AcceleoPackage.eINSTANCE.getAcceleoFactory().createBinding();
        binding.setName(varRef.getVariableName());
        AstResult bindingType = this.parseWhileAqlTypeLiteral("String");
        binding.setType(bindingType);
        binding.setTypeAql(bindingType.getAst());
        Expression initExpression = AcceleoPackage.eINSTANCE.getAcceleoFactory().createExpression();
        AstResult initExpressionAstResult = this.parseWhileAqlExpression("''");
        initExpression.setAst(initExpressionAstResult);
        initExpression.setAql(initExpressionAstResult.getAst());
        binding.setInitExpression(initExpression);
        letStatement.getVariables().add((Object)binding);
        AstQuickFix fix = new AstQuickFix("Surround with Let: " + varRef.getVariableName());
        String replacement = new AcceleoAstSerializer(this.newLine).serialize(letStatement);
        AstTextReplacement textReplacement = new AstTextReplacement(uri, replacement, offsetStart, lineStart, columnStart, offsetEnd, lineEnd, columnEnd);
        fix.getTextReplacements().add(textReplacement);
        res.add((IAstQuickFix)fix);
        return res;
    }

    private List<IAstQuickFix> getAddParameterQuickFixes(VarRef varRef, ModuleElement moduleElement) {
        ArrayList<IAstQuickFix> res = new ArrayList<IAstQuickFix>();
        AstQuickFix fix = new AstQuickFix("Add parameter " + varRef.getVariableName());
        IQualifiedNameResolver resolver = this.getQueryEnvironment().getLookupEngine().getResolver();
        URI uri = resolver.getSourceURI(this.moduleQualifiedName);
        if (moduleElement instanceof Template) {
            Template template = (Template)moduleElement;
            if (!template.getParameters().isEmpty()) {
                Variable lastParameter = (Variable)template.getParameters().get(template.getParameters().size() - 1);
                int offset = this.positions.getEndPositions((EObject)lastParameter);
                int line = this.positions.getEndLines((EObject)lastParameter);
                int column = this.positions.getEndColumns((EObject)lastParameter);
                AstTextReplacement textReplacement = new AstTextReplacement(uri, ", " + varRef.getVariableName() + ": String", offset, line, column, offset, line, column);
                fix.getTextReplacements().add(textReplacement);
                res.add((IAstQuickFix)fix);
            } else {
                int templateStartOffest = this.positions.getStartPositions((EObject)template);
                Matcher matcher = EMPTY_PARAMETER_PATTERN.matcher(this.moduleText.substring(templateStartOffest, this.positions.getEndPositions((EObject)template)));
                if (matcher.find()) {
                    int offset = templateStartOffest + matcher.start();
                    int line = this.linesAndColumns[offset][0];
                    int column = this.linesAndColumns[offset][1];
                    AstTextReplacement textReplacement = new AstTextReplacement(uri, varRef.getVariableName() + ": String", offset, line, column, offset, line, column);
                    fix.getTextReplacements().add(textReplacement);
                    res.add((IAstQuickFix)fix);
                }
            }
        } else if (moduleElement instanceof Query) {
            Query query = (Query)moduleElement;
            if (!query.getParameters().isEmpty()) {
                Variable lastParameter = (Variable)query.getParameters().get(query.getParameters().size() - 1);
                int offset = this.positions.getEndPositions((EObject)lastParameter);
                int line = this.positions.getEndLines((EObject)lastParameter);
                int column = this.positions.getEndColumns((EObject)lastParameter);
                AstTextReplacement textReplacement = new AstTextReplacement(uri, ", " + varRef.getVariableName() + ": String", offset, line, column, offset, line, column);
                fix.getTextReplacements().add(textReplacement);
                res.add((IAstQuickFix)fix);
            } else {
                int queryStartOffest = this.positions.getStartPositions((EObject)query);
                Matcher matcher = EMPTY_PARAMETER_PATTERN.matcher(this.moduleText.substring(queryStartOffest, this.positions.getEndPositions((EObject)query)));
                if (matcher.find()) {
                    int offset = queryStartOffest + matcher.start();
                    int line = this.linesAndColumns[offset][0];
                    int column = this.linesAndColumns[offset][1];
                    AstTextReplacement textReplacement = new AstTextReplacement(uri, varRef.getVariableName() + ": String", offset, line, column, offset, line, column);
                    fix.getTextReplacements().add(textReplacement);
                    res.add((IAstQuickFix)fix);
                }
            }
        }
        return res;
    }

    public List<IAstQuickFix> caseErrorCall(ErrorCall errorCall) {
        ArrayList<IAstQuickFix> res = new ArrayList<IAstQuickFix>();
        if (errorCall.isMissingEndParenthesis()) {
            AstQuickFix fix = new AstQuickFix("Add missing closing parenthesis");
            IQualifiedNameResolver resolver = this.getQueryEnvironment().getLookupEngine().getResolver();
            URI uri = resolver.getSourceURI(this.moduleQualifiedName);
            int offset = this.positions.getEndPositions((EObject)errorCall);
            int line = this.positions.getEndLines((EObject)errorCall);
            int column = this.positions.getEndColumns((EObject)errorCall);
            AstTextReplacement textReplacement = new AstTextReplacement(uri, ")", offset, line, column, offset, line, column);
            fix.getTextReplacements().add(textReplacement);
            res.add((IAstQuickFix)fix);
        }
        return res;
    }

    public List<IAstQuickFix> caseCall(Call call) {
        ArrayList<IAstQuickFix> res;
        block5: {
            block4: {
                res = new ArrayList<IAstQuickFix>();
                if ("aqlFeatureAccess".equals(call.getServiceName())) break block4;
                ClassType returnType = new ClassType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), String.class);
                List<Set<IType>> argumentTypes = this.getArgumentPossibleTypes(call);
                List<EClassifier> missingEClassifiers = this.getEClassifiersWithMissingEPackages(argumentTypes);
                if (!missingEClassifiers.isEmpty()) {
                    List<IAstQuickFix> fixes = this.getAddMetamodelForEClassifierQuickFix(missingEClassifiers);
                    res.addAll(fixes);
                } else {
                    CombineIterator combineIt = new CombineIterator(argumentTypes);
                    List<String> parameterNames = this.getParameterNames(call);
                    while (combineIt.hasNext()) {
                        res.addAll(this.getAddServiceQuickFixes(call.getServiceName(), parameterNames, (IType)returnType, combineIt.next()));
                    }
                }
                break block5;
            }
            if (!this.validationResult.getValidationMessages((ASTNode)call).stream().anyMatch(m -> m.getMessage().endsWith("is not registered in the current environment"))) break block5;
            for (IType type : this.validationResult.getPossibleTypes((org.eclipse.acceleo.query.ast.Expression)call)) {
                if (!(type instanceof EClassifierType)) continue;
                List<IAstQuickFix> fixes = this.getAddMetamodelForEClassifierQuickFix(Collections.singletonList(((EClassifierType)type).getType()));
                res.addAll(fixes);
            }
        }
        return res;
    }

    private List<EClassifier> getEClassifiersWithMissingEPackages(List<Set<IType>> argumentTypes) {
        ArrayList<EClassifier> res = new ArrayList<EClassifier>();
        HashSet<EPackage> knownPackages = new HashSet<EPackage>();
        for (Metamodel metamodel : this.module.getMetamodels()) {
            IQualifiedNameResolver resolver;
            EPackage ePkg;
            if (metamodel.getReferencedPackage() == null || (ePkg = (resolver = this.getQueryEnvironment().getLookupEngine().getResolver()).getEPackage(metamodel.getReferencedPackage())) == null) continue;
            knownPackages.add(ePkg);
        }
        for (Set<IType> types : argumentTypes) {
            for (IType type : types) {
                EClassifier eClassifier;
                if (!(type instanceof EClassifierType) || knownPackages.contains((eClassifier = ((EClassifierType)type).getType()).getEPackage())) continue;
                res.add(eClassifier);
                knownPackages.add(eClassifier.getEPackage());
            }
        }
        return res;
    }

    private List<IAstQuickFix> getAddMetamodelForEClassifierQuickFix(List<EClassifier> eClassifiers) {
        ArrayList<IAstQuickFix> res = new ArrayList<IAstQuickFix>();
        for (EClassifier eClassifier : eClassifiers) {
            int column;
            int line;
            int offset;
            if (eClassifier == null || eClassifier.getEPackage() == null) continue;
            IQualifiedNameResolver resolver = this.getQueryEnvironment().getLookupEngine().getResolver();
            URI uri = resolver.getSourceURI(this.moduleQualifiedName);
            EPackage ePkg = eClassifier.getEPackage();
            AstQuickFix fix = new AstQuickFix("Add " + ePkg.getNsURI());
            if (this.module.getMetamodels().isEmpty()) {
                String moduleHeader = this.moduleText.substring(this.module.getStartHeaderPosition(), this.module.getEndHeaderPosition());
                Matcher matcher = EMPTY_MODULE_METAMODEL_PATTERN.matcher(moduleHeader);
                if (!matcher.find()) continue;
                offset = this.module.getStartHeaderPosition() + matcher.start();
                line = this.linesAndColumns[offset][0];
                column = this.linesAndColumns[offset][1];
                AstTextReplacement textReplacement = new AstTextReplacement(uri, "'" + ePkg.getNsURI() + "'", offset, line, column, offset, line, column);
                fix.getTextReplacements().add(textReplacement);
                res.add((IAstQuickFix)fix);
                continue;
            }
            Metamodel lastMetamodel = (Metamodel)this.module.getMetamodels().get(this.module.getMetamodels().size() - 1);
            offset = this.positions.getEndPositions((EObject)lastMetamodel);
            line = this.positions.getEndLines((EObject)lastMetamodel);
            column = this.positions.getEndColumns((EObject)lastMetamodel);
            AstTextReplacement textReplacement = new AstTextReplacement(uri, ", '" + ePkg.getNsURI() + "'", offset, line, column, offset, line, column);
            fix.getTextReplacements().add(textReplacement);
            res.add((IAstQuickFix)fix);
        }
        return res;
    }

    private List<String> getParameterNames(Call call) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        for (org.eclipse.acceleo.query.ast.Expression argument : call.getArguments()) {
            if (argument instanceof VarRef) {
                res.add(((VarRef)argument).getVariableName());
                continue;
            }
            if (argument instanceof Call) {
                String serviceName = ((Call)argument).getServiceName();
                if ("aqlFeatureAccess".equals(serviceName)) {
                    if (((Call)argument).getArguments().get(1) instanceof StringLiteral) {
                        res.add(((StringLiteral)((Call)argument).getArguments().get(1)).getValue());
                        continue;
                    }
                    res.add("parameter" + i++);
                    continue;
                }
                if (serviceName.startsWith("get")) {
                    res.add(new StringServices().toLowerFirst(serviceName.substring(3)));
                    continue;
                }
                res.add(serviceName);
                continue;
            }
            res.add("parameter" + i++);
        }
        if (((String)res.get(0)).endsWith("s") && call.getType() != CallType.COLLECTIONCALL) {
            String oldName = (String)res.remove(0);
            res.add(0, oldName.substring(0, oldName.length() - 1));
        }
        return res;
    }

    private List<Set<IType>> getArgumentPossibleTypes(Call call) {
        ArrayList<Set<IType>> res = new ArrayList<Set<IType>>();
        Iterator it = call.getArguments().iterator();
        org.eclipse.acceleo.query.ast.Expression receiver = (org.eclipse.acceleo.query.ast.Expression)it.next();
        Set<IType> receiverPossibleTypes = this.validationResult.getPossibleTypes(receiver);
        if (call.getType() == CallType.COLLECTIONCALL) {
            LinkedHashSet<Object> receiverCollectionTypes = new LinkedHashSet<Object>();
            for (IType receiverPossibleType : receiverPossibleTypes) {
                if (receiverPossibleType instanceof ICollectionType) {
                    receiverCollectionTypes.add(receiverPossibleType);
                    continue;
                }
                receiverCollectionTypes.add(new SetType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), receiverPossibleType));
            }
            res.add(receiverCollectionTypes);
        } else {
            LinkedHashSet<IType> receiverRawTypes = new LinkedHashSet<IType>();
            for (IType receiverPossibleType : receiverPossibleTypes) {
                if (receiverPossibleType instanceof ICollectionType) {
                    receiverRawTypes.add(((ICollectionType)receiverPossibleType).getCollectionType());
                    continue;
                }
                receiverRawTypes.add(receiverPossibleType);
            }
            res.add(receiverRawTypes);
        }
        while (it.hasNext()) {
            org.eclipse.acceleo.query.ast.Expression argument = (org.eclipse.acceleo.query.ast.Expression)it.next();
            res.add(this.validationResult.getPossibleTypes(argument));
        }
        return res;
    }

    public List<IAstQuickFix> caseEClassifierTypeLiteral(EClassifierTypeLiteral eClassifierTypeLiteral) {
        String ePackageName = eClassifierTypeLiteral.getEPackageName();
        List<IAstQuickFix> res = this.getQueryEnvironment().getEPackageProvider().getEPackage(ePackageName).isEmpty() ? this.getAddMetamodelsQuickFixes(ePackageName) : Collections.emptyList();
        return res;
    }

    public List<IAstQuickFix> caseEnumLiteral(EnumLiteral enumLiteral) {
        String ePackageName = enumLiteral.getEPackageName();
        List<IAstQuickFix> res = this.getQueryEnvironment().getEPackageProvider().getEPackage(ePackageName).isEmpty() ? this.getAddMetamodelsQuickFixes(ePackageName) : Collections.emptyList();
        return res;
    }

    private List<IAstQuickFix> getAddMetamodelsQuickFixes(String ePackageName) {
        ArrayList<IAstQuickFix> res = new ArrayList<IAstQuickFix>();
        IQualifiedNameResolver resolver = this.getQueryEnvironment().getLookupEngine().getResolver();
        URI uri = resolver.getSourceURI(this.moduleQualifiedName);
        for (String nsURI : resolver.getAvailableNsURIs()) {
            int column;
            int line;
            int offset;
            EPackage ePkg = resolver.getEPackage(nsURI);
            if (ePkg == null || !ePkg.getName().equals(ePackageName)) continue;
            AstQuickFix fix = new AstQuickFix("Add " + ePkg.getNsURI());
            if (this.module.getMetamodels().isEmpty()) {
                String moduleHeader = this.moduleText.substring(this.module.getStartHeaderPosition(), this.module.getEndHeaderPosition());
                Matcher matcher = EMPTY_MODULE_METAMODEL_PATTERN.matcher(moduleHeader);
                if (!matcher.find()) continue;
                offset = this.module.getStartHeaderPosition() + matcher.start();
                line = this.linesAndColumns[offset][0];
                column = this.linesAndColumns[offset][1];
                AstTextReplacement textReplacement = new AstTextReplacement(uri, "'" + ePkg.getNsURI() + "'", offset, line, column, offset, line, column);
                fix.getTextReplacements().add(textReplacement);
                res.add((IAstQuickFix)fix);
                continue;
            }
            Metamodel lastMetamodel = (Metamodel)this.module.getMetamodels().get(this.module.getMetamodels().size() - 1);
            offset = this.positions.getEndPositions((EObject)lastMetamodel);
            line = this.positions.getEndLines((EObject)lastMetamodel);
            column = this.positions.getEndColumns((EObject)lastMetamodel);
            AstTextReplacement textReplacement = new AstTextReplacement(uri, ", '" + ePkg.getNsURI() + "'", offset, line, column, offset, line, column);
            fix.getTextReplacements().add(textReplacement);
            res.add((IAstQuickFix)fix);
        }
        return res;
    }

    private List<IAstQuickFix> getAddServiceQuickFixes(String serviceName, List<String> parameterNames, IType returnType, List<IType> argumentTypes) {
        AstQuickFix fix;
        ArrayList<IAstQuickFix> res = new ArrayList<IAstQuickFix>();
        String signature = this.getSignature(serviceName, argumentTypes);
        IQualifiedNameResolver resolver = this.getQueryEnvironment().getLookupEngine().getResolver();
        URI uri = resolver.getSourceURI(this.moduleQualifiedName);
        if (this.isQueryModule(this.moduleQualifiedName)) {
            fix = new AstQuickFix("Add query " + signature + " to this module");
            if (uri != null && "file".equals(uri.getScheme())) {
                fix.getTextReplacements().add(this.getQueryReplacement(uri, this.module, serviceName, parameterNames, returnType, argumentTypes));
            }
            res.add((IAstQuickFix)fix);
        } else {
            fix = new AstQuickFix("Add template " + signature + " to this module");
            if (uri != null && "file".equals(uri.getScheme())) {
                fix.getTextReplacements().add(this.getTemplateReplacement(uri, this.module, serviceName, parameterNames, returnType, argumentTypes));
            }
            res.add((IAstQuickFix)fix);
        }
        ArrayList<String> qualifiedNames = new ArrayList<String>();
        if (this.module.getExtends() != null && !(this.module.getExtends() instanceof ErrorModuleReference)) {
            qualifiedNames.add(this.module.getExtends().getQualifiedName());
        }
        for (Import imp : this.module.getImports()) {
            if (imp instanceof ErrorImport || imp.getModule() instanceof ErrorModuleReference || !this.validationResult.getValidationMessages(imp.getModule()).isEmpty()) continue;
            qualifiedNames.add(imp.getModule().getQualifiedName());
        }
        for (String qName : qualifiedNames) {
            URI sourceURI;
            Object resolved = resolver.resolve(qName);
            if (resolved instanceof Module) {
                URI sourceURI2;
                AstQuickFix fix2;
                if (this.isQueryModule(qName)) {
                    fix2 = new AstQuickFix("Add query " + signature + " to " + qName);
                    sourceURI2 = resolver.getSourceURI(qName);
                    if (sourceURI2 != null && "file".equals(sourceURI2.getScheme())) {
                        fix2.getTextReplacements().add(this.getQueryReplacement(sourceURI2, (Module)resolved, serviceName, parameterNames, returnType, argumentTypes));
                    }
                    res.add((IAstQuickFix)fix2);
                    continue;
                }
                fix2 = new AstQuickFix("Add template " + signature + " to " + qName);
                sourceURI2 = resolver.getSourceURI(qName);
                if (sourceURI2 != null && "file".equals(sourceURI2.getScheme())) {
                    fix2.getTextReplacements().add(this.getTemplateReplacement(sourceURI2, (Module)resolved, serviceName, parameterNames, returnType, argumentTypes));
                }
                res.add((IAstQuickFix)fix2);
                continue;
            }
            if (!(resolved instanceof Class) || (sourceURI = resolver.getSourceURI(qName)) == null || !"file".equals(sourceURI.getScheme())) continue;
            AstQuickFix fix3 = new AstQuickFix("Add service " + signature + " to " + qName);
            try {
                Throwable throwable = null;
                Object var16_19 = null;
                try (InputStream is = sourceURI.toURL().openStream();){
                    String classContents = AcceleoUtil.getContent(is, StandardCharsets.UTF_8.name());
                    fix3.getTextReplacements().add(this.getServiceReplacement(sourceURI, (Class)resolved, classContents, serviceName, parameterNames, returnType, argumentTypes));
                    res.add((IAstQuickFix)fix3);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    private IAstTextReplacement getQueryReplacement(URI sourceURI, Module module, String serviceName, List<String> parameterNames, IType returnType, List<IType> argumentTypes) {
        Query query = AcceleoPackage.eINSTANCE.getAcceleoFactory().createQuery();
        query.setVisibility(VisibilityKind.PUBLIC);
        query.setName(serviceName);
        query.setType(this.parseWhileAqlTypeLiteral(this.getAqlTypeString(returnType)));
        Expression body = AcceleoPackage.eINSTANCE.getAcceleoFactory().createExpression();
        body.setAst(this.parseWhileAqlExpression("null"));
        query.setBody(body);
        int i = 0;
        for (IType type : argumentTypes) {
            Variable parameter = AcceleoPackage.eINSTANCE.getAcceleoFactory().createVariable();
            parameter.setName(parameterNames.get(i++));
            parameter.setType(this.parseWhileAqlTypeLiteral(this.getAqlTypeString(type)));
            query.getParameters().add((Object)parameter);
        }
        int offset = module.getAst().getEndPosition(module);
        int line = module.getAst().getEndLine(module);
        int column = module.getAst().getEndColumn(module);
        String replacement = column != 0 ? this.newLine + this.newLine + new AcceleoAstSerializer(this.newLine).serialize(query) : this.newLine + new AcceleoAstSerializer(this.newLine).serialize(query);
        AstTextReplacement res = new AstTextReplacement(sourceURI, replacement, offset, line, column, offset, line, column);
        return res;
    }

    private IAstTextReplacement getTemplateReplacement(URI sourceURI, Module module, String serviceName, List<String> parameterNames, IType returnType, List<IType> argumentTypes) {
        Template template = AcceleoPackage.eINSTANCE.getAcceleoFactory().createTemplate();
        template.setVisibility(VisibilityKind.PUBLIC);
        template.setName(serviceName);
        int i = 0;
        for (IType type : argumentTypes) {
            Variable parameter = AcceleoPackage.eINSTANCE.getAcceleoFactory().createVariable();
            parameter.setName(parameterNames.get(i++));
            parameter.setType(this.parseWhileAqlTypeLiteral(this.getAqlTypeString(type)));
            template.getParameters().add((Object)parameter);
        }
        Block body = AcceleoPackage.eINSTANCE.getAcceleoFactory().createBlock();
        template.setBody(body);
        int offset = module.getAst().getEndPosition(module);
        int line = module.getAst().getEndLine(module);
        int column = module.getAst().getEndColumn(module);
        String replacement = column != 0 ? this.newLine + this.newLine + new AcceleoAstSerializer(this.newLine).serialize(template) : this.newLine + new AcceleoAstSerializer(this.newLine).serialize(template);
        AstTextReplacement res = new AstTextReplacement(sourceURI, replacement, offset, line, column, offset, line, column);
        return res;
    }

    private IAstTextReplacement getServiceReplacement(URI sourceURI, Class<?> cls, String classContent, String serviceName, List<String> parameterNames, IType returnType, List<IType> argumentTypes) {
        StringBuilder replacement = new StringBuilder();
        replacement.append("\tpublic ");
        try {
            if (cls.getConstructors().length == 0) {
                replacement.append("static ");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        replacement.append(this.getJavaStringType(returnType));
        replacement.append(" ");
        replacement.append(serviceName);
        replacement.append("(");
        StringJoiner joiner = new StringJoiner(", ");
        int i = 0;
        for (IType type : argumentTypes) {
            joiner.add(this.getJavaStringType(type) + " " + parameterNames.get(i++));
        }
        replacement.append(joiner.toString());
        replacement.append(") {" + this.newLine);
        replacement.append("\t\treturn null;" + this.newLine);
        replacement.append("\t}" + this.newLine);
        int[][] classLinesAndColumns = AQLUtils.getLinesAndColumns((String)classContent);
        int offset = classContent.lastIndexOf("}") - 1;
        int line = classLinesAndColumns[offset][0];
        int column = classLinesAndColumns[offset][1];
        AstTextReplacement res = new AstTextReplacement(sourceURI, replacement.toString(), offset, line, column, offset, line, column);
        return res;
    }

    private String getJavaStringType(IType type) {
        Object res;
        if (type instanceof ICollectionType) {
            res = ((ICollectionType)type).getType().getName() + "<" + this.getJavaStringType(((ICollectionType)type).getCollectionType()) + ">";
        } else if (type instanceof ClassType) {
            res = ((ClassType)type).getType().getSimpleName();
        } else if (type instanceof EClassifierType) {
            EClassifier eClassifier = ((EClassifierType)type).getType();
            res = eClassifier.getInstanceClass() != null ? eClassifier.getInstanceClass().getSimpleName() : eClassifier.getName();
        } else {
            throw new IllegalStateException("unknown type.");
        }
        return res;
    }

    private boolean isQueryModule(String qualifiedName) {
        return qualifiedName.contains("::requests::");
    }

    private String getSignature(String serviceName, List<IType> argumentTypes) {
        StringBuilder res = new StringBuilder();
        res.append(serviceName);
        res.append("(");
        StringJoiner joiner = new StringJoiner(", ");
        for (IType argumentType : argumentTypes) {
            joiner.add(argumentType.toString());
        }
        res.append(joiner.toString());
        res.append(")");
        return res.toString();
    }

    protected AstResult parseWhileAqlExpression(String expression) {
        return AQLUtils.parseWhileAqlExpression((String)expression).getAstResult();
    }

    protected AstResult parseWhileAqlTypeLiteral(String expression) {
        return AQLUtils.parseWhileAqlTypeLiteral((String)expression);
    }

    protected String getAqlTypeString(IType type) {
        return AQLUtils.getAqlTypeString((IType)type);
    }
}

