/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.converter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.params.converter.AnnotationBasedArgumentConverter;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.JavaTimeConversionPattern;

class JavaTimeArgumentConverter
extends AnnotationBasedArgumentConverter<JavaTimeConversionPattern> {
    private static final Map<Class<?>, TemporalQuery<?>> TEMPORAL_QUERIES;

    JavaTimeArgumentConverter() {
    }

    @Override
    protected @Nullable Object convert(@Nullable Object input, Class<?> targetClass, JavaTimeConversionPattern annotation) {
        if (input == null) {
            if (annotation.nullable()) {
                return null;
            }
            throw new ArgumentConversionException("Cannot convert null to " + targetClass.getName() + "; consider setting 'nullable = true'");
        }
        TemporalQuery<?> temporalQuery = TEMPORAL_QUERIES.get(targetClass);
        if (temporalQuery == null) {
            throw new ArgumentConversionException("Cannot convert to " + targetClass.getName() + ": " + String.valueOf(input));
        }
        String pattern = annotation.value();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return formatter.parse((CharSequence)input.toString(), temporalQuery);
    }

    static {
        LinkedHashMap<Class<ZonedDateTime>, TemporalQuery<Object>> queries = new LinkedHashMap<Class<ZonedDateTime>, TemporalQuery<Object>>();
        queries.put(ChronoLocalDate.class, ChronoLocalDate::from);
        queries.put(ChronoLocalDateTime.class, ChronoLocalDateTime::from);
        queries.put(ChronoZonedDateTime.class, ChronoZonedDateTime::from);
        queries.put(LocalDate.class, LocalDate::from);
        queries.put(LocalDateTime.class, LocalDateTime::from);
        queries.put(LocalTime.class, LocalTime::from);
        queries.put(OffsetDateTime.class, OffsetDateTime::from);
        queries.put(OffsetTime.class, OffsetTime::from);
        queries.put(Year.class, Year::from);
        queries.put(YearMonth.class, YearMonth::from);
        queries.put(ZonedDateTime.class, ZonedDateTime::from);
        TEMPORAL_QUERIES = Collections.unmodifiableMap(queries);
    }
}

