/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.NameSection;

public abstract class ReferenceSection
extends NameSection {
    protected CCombo combo;
    protected CLabel comboLabel;
    protected List itemsInCombo = new ArrayList();

    @Override
    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.comboLabel = this.getWidgetFactory().createCLabel(this.composite, "Reference");
        this.combo = this.getWidgetFactory().createCCombo(this.composite);
        this.combo.setBackground(this.composite.getBackground());
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.comboLabel.setLayoutData((Object)data);
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.addListener(24, (Listener)this);
        this.combo.addListener(14, (Listener)this);
        this.combo.addListener(31, (Listener)this);
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.combo) {
            if (this.isListenerEnabled() && !this.isInDoHandle) {
                if (event.type == 31) {
                    if (event.detail == 64 || event.detail == 32) {
                        this.isTraversing = true;
                    }
                } else {
                    this.isInDoHandle = true;
                    this.startDelayedEvent(event);
                    this.isInDoHandle = false;
                }
            }
        } else {
            super.handleEvent(event);
        }
    }

    @Override
    public void refresh() {
        this.combo.removeListener(24, (Listener)this);
        this.combo.removeListener(14, (Listener)this);
        this.combo.removeListener(31, (Listener)this);
        super.refresh();
        List comboItems = this.getComboItems();
        if (comboItems.size() > 0) {
            this.combo.removeAll();
            this.itemsInCombo.clear();
            String currentComboItemName = this.getComboItemName(this.getCurrentComboItem());
            int currentBindingIndex = -1;
            List items = this.getComboItems();
            int index = 0;
            while (index < items.size()) {
                Object item = items.get(index);
                String itemName = this.getComboItemName(item);
                this.combo.add(itemName);
                this.itemsInCombo.add(item);
                if (itemName.equals(currentComboItemName)) {
                    currentBindingIndex = index;
                }
                ++index;
            }
            if (currentBindingIndex != -1) {
                this.combo.select(currentBindingIndex);
            }
        }
        this.setControlForegroundColor((Control)this.combo);
        this.combo.addListener(24, (Listener)this);
        this.combo.addListener(14, (Listener)this);
        this.combo.addListener(31, (Listener)this);
    }

    protected abstract List getComboItems();

    protected abstract Object getCurrentComboItem();

    protected abstract String getComboItemName(Object var1);

    protected abstract void performComboSelection(Object var1);

    @Override
    public boolean shouldUseExtraSpace() {
        return false;
    }

    @Override
    public void doHandleEvent(Event event) {
        int selectionIndex;
        Object selectedItem;
        super.doHandleEvent(event);
        if (event.widget == this.combo && !this.combo.isDisposed() && this.shouldPerformComboSelection(event, selectedItem = this.itemsInCombo.get(selectionIndex = this.combo.getSelectionIndex()))) {
            this.performComboSelection(selectedItem);
            this.refresh();
        }
    }

    @Override
    public void dispose() {
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.removeListener(24, (Listener)this);
            this.combo.removeListener(14, (Listener)this);
            this.combo.removeListener(31, (Listener)this);
        }
        super.dispose();
    }
}

