/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.bower.ui.internal.contentassist;

import java.text.MessageFormat;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonArray;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonObject;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonValue;
import org.eclipse.json.schema.JSONSchemaType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.json.bower.ui.internal.editor.BowerEditorPluginImageHelper;
import org.eclipse.wst.json.ui.contentassist.ContentAssistHelper;
import org.eclipse.wst.json.ui.contentassist.ContentAssistRequest;
import org.eclipse.wst.json.ui.contentassist.HttpCompletionProposalCollector;
import org.eclipse.wst.json.ui.contentassist.ICompletionProposalCollector;
import org.eclipse.wst.json.ui.contentassist.JSONKeyCompletionProposal;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;

public class BowerDependencyCompletionProposalCollector
extends HttpCompletionProposalCollector {
    public final String searchUrl = "https://bower.herokuapp.com/packages/search/{0}";
    public final String packageUrl = "https://bower.herokuapp.com/packages/{0}";

    protected String getUrl(ContentAssistRequest contentAssistRequest, ICompletionProposalCollector.TargetType target) {
        String keyword = contentAssistRequest.getMatchString();
        return MessageFormat.format("https://bower.herokuapp.com/packages/search/{0}", keyword);
    }

    protected void addProposals(JsonValue json, ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, ICompletionProposalCollector.TargetType target) {
        if (json.isArray()) {
            String dependency = null;
            String replacementString = null;
            JsonArray values = (JsonArray)json;
            for (JsonValue value : values) {
                if (!value.isObject()) continue;
                dependency = ((JsonObject)value).get("name").asString();
                replacementString = ContentAssistHelper.getRequiredName((String)dependency, (JSONSchemaType)JSONSchemaType.String);
                Image icon = BowerEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/bower-16.png");
                JSONKeyCompletionProposal proposal = new JSONKeyCompletionProposal(replacementString, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), replacementString.length() - 2, icon, dependency, null, null, 400);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        }
    }
}

