/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.chromium.CallbackSemaphore;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.BreakpointSynchronizer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.LaunchParams;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Messages;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VProjectWorkspaceBridge;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ProgressUtil;

class LaunchInitializationProcedure {
    private final VProjectWorkspaceBridge workspaceBridge;
    private final BreakpointSynchronizer.Direction presetDirection;
    private static final RelayOk SYNCHRONIZER_MUST_RELAY_OK = new RelayOk(){};

    static void startAsync(VProjectWorkspaceBridge workspaceBridge, BreakpointSynchronizer.Direction presetDirection) {
        final LaunchInitializationProcedure procedure = new LaunchInitializationProcedure(workspaceBridge, presetDirection);
        ILaunch launch = workspaceBridge.getConnectedTargetData().getDebugTarget().getLaunch();
        String jobName = NLS.bind((String)Messages.LaunchInitializationProcedure_JOB_NAME, (Object)launch.getLaunchConfiguration().getName());
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                return procedure.execute(monitor);
            }
        };
        job.schedule();
    }

    private LaunchInitializationProcedure(VProjectWorkspaceBridge workspaceBridge, BreakpointSynchronizer.Direction presetDirection) {
        this.workspaceBridge = workspaceBridge;
        this.presetDirection = presetDirection;
    }

    private IStatus execute(IProgressMonitor monitor) {
        this.workspaceBridge.getConnectedTargetData();
        ProgressUtil.MonitorWrapper monitorWrapper = new ProgressUtil.MonitorWrapper(monitor, "");
        monitorWrapper.beginTask();
        try {
            WorkPlan.PREINIT.start(monitorWrapper);
            WorkPlan.PREINIT.finish(monitorWrapper);
            LaunchInitializationProcedure.checkIsCanceled(monitorWrapper);
            WorkPlan.SET_OPTIONS.start(monitorWrapper);
            WorkPlan.SET_OPTIONS.finish(monitorWrapper);
            LaunchInitializationProcedure.checkIsCanceled(monitorWrapper);
            WorkPlan.LOAD_SCRIPTS.start(monitorWrapper);
            this.workspaceBridge.reloadScriptsAtStart();
            WorkPlan.LOAD_SCRIPTS.finish(monitorWrapper);
            LaunchInitializationProcedure.checkIsCanceled(monitorWrapper);
            this.synchronizeBreakpoints(WorkPlan.SYNCHRONIZE_BREAKPOINTS.createSubMonitorWrapper(monitorWrapper));
        }
        finally {
            monitorWrapper.done();
        }
        return Status.OK_STATUS;
    }

    private void synchronizeBreakpoints(ProgressUtil.MonitorWrapper monitor) {
        monitor.beginTask();
        try {
            BreakpointSynchronizer.Direction direction;
            BreakpointsWorkPlan.ANALYZE.start(monitor);
            DebugTargetImpl debugTarget = this.workspaceBridge.getConnectedTargetData().getDebugTarget();
            ILaunchConfiguration launchConfiguration = debugTarget.getLaunch().getLaunchConfiguration();
            if (this.presetDirection == null) {
                try {
                    direction = LaunchParams.readBreakpointSyncDirection(launchConfiguration);
                }
                catch (CoreException e) {
                    ChromiumDebugPlugin.log(new Exception("Failed to read breakpoint synchronization direction from launch configuration " + launchConfiguration.getName(), e));
                    direction = null;
                }
            } else {
                direction = this.presetDirection;
            }
            if (direction == null) {
                return;
            }
            final CallbackSemaphore callbackSemaphore = new CallbackSemaphore();
            BreakpointSynchronizer.Callback callback = new BreakpointSynchronizer.Callback(){

                @Override
                public void onDone(IStatus status) {
                    callbackSemaphore.callbackDone(null);
                }
            };
            this.workspaceBridge.getBreakpointSynchronizer().syncBreakpoints(direction, callback);
            RelayOk relayOk = SYNCHRONIZER_MUST_RELAY_OK;
            LaunchInitializationProcedure.checkIsCanceled(monitor);
            BreakpointsWorkPlan.ANALYZE.finish(monitor);
            BreakpointsWorkPlan.REMOTE_CHANGES.start(monitor);
            callbackSemaphore.tryAcquireDefault(relayOk);
            BreakpointsWorkPlan.REMOTE_CHANGES.finish(monitor);
        }
        finally {
            monitor.done();
        }
    }

    private static void checkIsCanceled(ProgressUtil.MonitorWrapper monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static interface BreakpointsWorkPlan {
        public static final ProgressUtil.Stage ANALYZE = new ProgressUtil.Stage(null, 1.0f);
        public static final ProgressUtil.Stage REMOTE_CHANGES = new ProgressUtil.Stage(null, 1.0f);
        public static final boolean IS_LAYOUTED = ProgressUtil.layoutProgressPlan(ANALYZE, REMOTE_CHANGES);
    }

    private static interface WorkPlan {
        public static final ProgressUtil.Stage PREINIT = new ProgressUtil.Stage(Messages.LaunchInitializationProcedure_UPDATE_DEBUGGER_STATE, 0.1f);
        public static final ProgressUtil.Stage SET_OPTIONS = new ProgressUtil.Stage(Messages.LaunchInitializationProcedure_SET_OPTIONS, 1.0f);
        public static final ProgressUtil.Stage LOAD_SCRIPTS = new ProgressUtil.Stage(Messages.LaunchInitializationProcedure_LOAD_SCRIPTS, 1.0f);
        public static final ProgressUtil.Stage SYNCHRONIZE_BREAKPOINTS = new ProgressUtil.Stage(Messages.LaunchInitializationProcedure_SYNCHRONIZE_BREAKPOINTS, 1.0f);
        public static final boolean IS_INITIZALIZED = ProgressUtil.layoutProgressPlan(PREINIT, SET_OPTIONS, LOAD_SCRIPTS, SYNCHRONIZE_BREAKPOINTS);
    }
}

