/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.reflect;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.eclipse.wb.internal.core.utils.reflect.BundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;

public class CompositeClassLoader
extends ClassLoader {
    private final List<ClassLoader> m_classLoaders = new ArrayList<ClassLoader>();
    private final List<List<String>> m_classNamespaces = new ArrayList<List<String>>();
    private final List<List<String>> m_resourceNamespaces = new ArrayList<List<String>>();

    public List<ClassLoader> getClassLoaders() {
        return this.m_classLoaders;
    }

    public void add(Bundle bundle) {
        BundleClassLoader classLoader = new BundleClassLoader(bundle);
        ArrayList<String> namespaces = new ArrayList<String>();
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        for (BundleCapability bundleCapability : bundleWiring.getCapabilities("osgi.wiring.package")) {
            namespaces.add((String)bundleCapability.getAttributes().get("osgi.wiring.package"));
        }
        this.add(classLoader, namespaces);
    }

    public void add(ClassLoader classLoader, List<String> namespaces) {
        this.add(classLoader, namespaces, namespaces);
    }

    public void add(ClassLoader classLoader, List<String> classPrefixes, List<String> resourcePrefixes) {
        if (classLoader != null) {
            this.m_classLoaders.add(0, classLoader);
            this.m_classNamespaces.add(0, classPrefixes);
            if (resourcePrefixes != null) {
                ArrayList<String> resourceNamespaces = new ArrayList<String>();
                for (String namespace : resourcePrefixes) {
                    resourceNamespaces.add(namespace.replace('.', '/'));
                }
                this.m_resourceNamespaces.add(0, resourceNamespaces);
            } else {
                this.m_resourceNamespaces.add(0, null);
            }
        }
    }

    @Override
    @Deprecated
    protected Package getPackage(String name) {
        try {
            Method method_getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
            method_getPackage.setAccessible(true);
            int i = 0;
            while (i < this.m_classLoaders.size()) {
                ClassLoader classLoader = this.m_classLoaders.get(i);
                Package pkg = (Package)method_getPackage.invoke((Object)classLoader, name);
                if (pkg != null) {
                    return pkg;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.getPackage(name);
    }

    @Override
    public URL getResource(String name) {
        int i = 0;
        while (i < this.m_classLoaders.size()) {
            URL resource;
            ClassLoader classLoader = this.m_classLoaders.get(i);
            List<String> namespaces = this.m_resourceNamespaces.get(i);
            if (CompositeClassLoader.hasNamespace(name, namespaces) && (resource = classLoader.getResource(name)) != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        HashSet allResources = new HashSet();
        for (ClassLoader classLoader : this.m_classLoaders) {
            Enumeration<URL> resources = classLoader.getResources(name);
            CollectionUtils.addAll(allResources, resources);
        }
        return Collections.enumeration(allResources);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        int i = 0;
        while (i < this.m_classLoaders.size()) {
            ClassLoader classLoader = this.m_classLoaders.get(i);
            List<String> namespaces = this.m_classNamespaces.get(i);
            if (CompositeClassLoader.hasNamespace(name, namespaces)) {
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ++i;
        }
        throw new ClassNotFoundException(name);
    }

    private static boolean hasNamespace(String name, List<String> namespaces) {
        if (namespaces != null) {
            for (String namespace : namespaces) {
                if (!name.startsWith(namespace)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

