/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.refactoring;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.UndoTextFileChange;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.wb.internal.core.utils.Messages;

class UndoCompilationUnitChange
extends UndoTextFileChange {
    private final ICompilationUnit fCUnit;

    public UndoCompilationUnitChange(String name, ICompilationUnit unit, UndoEdit undo, ContentStamp stampToRestore, int saveMode) throws CoreException {
        super(name, UndoCompilationUnitChange.getFile(unit), undo, stampToRestore, saveMode);
        this.fCUnit = unit;
    }

    private static IFile getFile(ICompilationUnit cunit) throws CoreException {
        IFile file = (IFile)cunit.getResource();
        if (file == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wb.core", 0, MessageFormat.format(Messages.UndoCompilationUnitChange_noFile, cunit.getElementName()), null));
        }
        return file;
    }

    public Object getModifiedElement() {
        return this.fCUnit;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) throws CoreException {
        return new UndoCompilationUnitChange(this.getName(), this.fCUnit, edit, stampToRestore, this.getSaveMode());
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        pm.beginTask("", 2);
        this.fCUnit.becomeWorkingCopy(null, (IProgressMonitor)subMonitor.split(1));
        try {
            Change change = super.perform((IProgressMonitor)subMonitor.split(1));
            return change;
        }
        finally {
            this.fCUnit.discardWorkingCopy();
        }
    }
}

