/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.viewers.AsynchronousSchedulingRuleFactory;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.profile.core.engine.IProfileSessionListener;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class PHPProfilePerspectiveSwitcher
implements IProfileSessionListener {
    public void profileSessionAdded(ProfilerDB db) {
        final String shouldAsk = ProfilerUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.php.profile.ui.openProfilePerspectiveOnSessionData");
        if (shouldAsk.equals("never")) {
            return;
        }
        SwitchJob switchJob = new SwitchJob(this){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    Shell shell = window.getShell();
                    if (shell != null) {
                        shell.forceActive();
                    }
                } else {
                    return Status.CANCEL_STATUS;
                }
                if (!this.isProfilePerspectiveOpen(window) && (shouldAsk.equals("always") || this.shouldOpenPerspective(window))) {
                    this.switchToProfilePerspective(window);
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        switchJob.schedule();
    }

    public void profileSessionRemoved(ProfilerDB db) {
    }

    public void currentSessionChanged(ProfilerDB current) {
    }

    private boolean isProfilePerspectiveOpen(IWorkbenchWindow window) {
        IPerspectiveDescriptor perspectiveDescriptor;
        boolean isCurrent = false;
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (perspectiveDescriptor = page.getPerspective()) != null) {
            isCurrent = "org.eclipse.php.profile.ui.perspective".equals(perspectiveDescriptor.getId());
        }
        return isCurrent;
    }

    private boolean shouldOpenPerspective(IWorkbenchWindow window) {
        MessageDialogWithToggle dialog;
        Shell shell = window.getShell();
        Shell modal = this.getModalDialogOpen(shell);
        if (shell.getMinimized()) {
            shell.setMinimized(false);
            if (modal != null) {
                modal.setFocus();
            }
        }
        return (dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)PHPProfileUIMessages.getString("ProfilePerspectiveHandler_0"), (String)PHPProfileUIMessages.getString("ProfilePerspectiveHandler_1"), null, (boolean)false, (IPreferenceStore)ProfilerUiPlugin.getDefault().getPreferenceStore(), (String)"org.eclipse.php.profile.ui.openProfilePerspectiveOnSessionData")).getReturnCode() == 2;
    }

    private Shell getModalDialogOpen(Shell shell) {
        Shell[] shells = shell.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell dialog = shells[i];
            if ((dialog.getStyle() & 0x38000) > 0) {
                return dialog;
            }
            ++i;
        }
        return null;
    }

    private void switchToProfilePerspective(IWorkbenchWindow window) {
        try {
            Shell shell = window.getShell();
            Shell dialog = this.getModalDialogOpen(shell);
            window.getWorkbench().showPerspective("org.eclipse.php.profile.ui.perspective", window);
            if (dialog != null) {
                dialog.setFocus();
            }
        }
        catch (WorkbenchException e) {
            ProfilerUiPlugin.log(e);
        }
    }

    private abstract class SwitchJob
    extends Job {
        public SwitchJob() {
            super("Profile Perspective Switch Job");
            this.setSystem(true);
            this.setPriority(10);
            this.setRule(AsynchronousSchedulingRuleFactory.getDefault().newSerialPerObjectRule((Object)this));
        }

        protected IStatus run(final IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Display asyncDisplay = PlatformUI.getWorkbench().getDisplay();
            if (asyncDisplay == null || asyncDisplay.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            asyncDisplay.asyncExec(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        IStatus result = null;
                        Throwable throwable = null;
                        try {
                            try {
                                if (monitor.isCanceled()) {
                                    result = Status.CANCEL_STATUS;
                                    break block8;
                                }
                                result = SwitchJob.this.runInUIThread(monitor);
                            }
                            catch (Throwable t) {
                                throwable = t;
                                if (result == null) {
                                    result = new Status(4, "org.eclipse.ui", 4, "Error", throwable);
                                }
                                SwitchJob.this.done(result);
                            }
                        }
                        finally {
                            if (result == null) {
                                result = new Status(4, "org.eclipse.ui", 4, "Error", throwable);
                            }
                            SwitchJob.this.done(result);
                        }
                    }
                }
            });
            return Job.ASYNC_FINISH;
        }

        public abstract IStatus runInUIThread(IProgressMonitor var1);
    }
}

