/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl.resource;

import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.emftvm.BranchInstruction;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.CodeBlockInstruction;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.FieldInstruction;
import org.eclipse.m2m.atl.emftvm.Findtype;
import org.eclipse.m2m.atl.emftvm.Ifte;
import org.eclipse.m2m.atl.emftvm.Instruction;
import org.eclipse.m2m.atl.emftvm.InvokeInstruction;
import org.eclipse.m2m.atl.emftvm.InvokeOperationInstruction;
import org.eclipse.m2m.atl.emftvm.LocalVariable;
import org.eclipse.m2m.atl.emftvm.LocalVariableInstruction;
import org.eclipse.m2m.atl.emftvm.Match;
import org.eclipse.m2m.atl.emftvm.New;
import org.eclipse.m2m.atl.emftvm.Push;
import org.eclipse.m2m.atl.emftvm.impl.resource.ConstantPool;
import org.eclipse.m2m.atl.emftvm.util.EmftvmSwitch;

public class SaveInstructionParametersSwitch
extends EmftvmSwitch<Instruction> {
    protected final DataOutputStream outputStream;
    protected final ConstantPool constants;

    public SaveInstructionParametersSwitch(DataOutputStream outputStream, ConstantPool constants) {
        this.outputStream = outputStream;
        this.constants = constants;
    }

    @Override
    public Instruction caseBranchInstruction(BranchInstruction object) {
        try {
            Instruction target = object.getTarget();
            if (target != null) {
                if (target.getOwningBlock() != object.getOwningBlock()) {
                    throw new IllegalArgumentException(String.format("Branch target outside code block for %s", object));
                }
                object.eUnset((EStructuralFeature)EmftvmPackage.eINSTANCE.getBranchInstruction_Offset());
            }
            this.outputStream.writeInt(object.getOffset());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseBranchInstruction(object);
    }

    @Override
    public Instruction caseFieldInstruction(FieldInstruction object) {
        try {
            this.outputStream.writeInt(this.constants.indexOf(object.getFieldname()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseFieldInstruction(object);
    }

    @Override
    public Instruction caseFindtype(Findtype object) {
        try {
            this.outputStream.writeInt(this.constants.indexOf(object.getModelname()));
            this.outputStream.writeInt(this.constants.indexOf(object.getTypename()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseFindtype(object);
    }

    @Override
    public Instruction caseInvokeInstruction(InvokeInstruction object) {
        try {
            this.outputStream.writeInt(object.getArgcount());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseInvokeInstruction(object);
    }

    @Override
    public Instruction caseInvokeOperationInstruction(InvokeOperationInstruction object) {
        try {
            this.outputStream.writeInt(this.constants.indexOf(object.getOpname()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseInvokeOperationInstruction(object);
    }

    @Override
    public Instruction caseLocalVariableInstruction(LocalVariableInstruction object) {
        try {
            LocalVariable lv = object.getLocalVariable();
            if (lv != null) {
                object.eUnset((EStructuralFeature)EmftvmPackage.eINSTANCE.getLocalVariableInstruction_CbOffset());
                object.eUnset((EStructuralFeature)EmftvmPackage.eINSTANCE.getLocalVariableInstruction_LocalVariableIndex());
            }
            this.outputStream.writeInt(object.getCbOffset());
            this.outputStream.writeInt(object.getLocalVariableIndex());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseLocalVariableInstruction(object);
    }

    @Override
    public Instruction caseNew(New object) {
        try {
            this.outputStream.writeInt(this.constants.indexOf(object.getModelname()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseNew(object);
    }

    @Override
    public Instruction casePush(Push object) {
        try {
            this.outputStream.writeInt(this.constants.indexOf(object.getValue()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.casePush(object);
    }

    @Override
    public Instruction caseMatch(Match object) {
        try {
            this.outputStream.writeInt(this.constants.indexOf(object.getRulename()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseMatch(object);
    }

    @Override
    public Instruction caseCodeBlockInstruction(CodeBlockInstruction object) {
        try {
            CodeBlock cb = object.getCodeBlock();
            if (cb != null) {
                object.eUnset((EStructuralFeature)EmftvmPackage.eINSTANCE.getCodeBlockInstruction_CbIndex());
            }
            this.outputStream.writeInt(object.getCbIndex());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseCodeBlockInstruction(object);
    }

    @Override
    public Instruction caseIfte(Ifte object) {
        try {
            CodeBlock elseCb;
            CodeBlock thenCb = object.getThenCb();
            if (thenCb != null) {
                object.eUnset((EStructuralFeature)EmftvmPackage.eINSTANCE.getIfte_ThenCbIndex());
            }
            if ((elseCb = object.getElseCb()) != null) {
                object.eUnset((EStructuralFeature)EmftvmPackage.eINSTANCE.getIfte_ElseCbIndex());
            }
            this.outputStream.writeInt(object.getThenCbIndex());
            this.outputStream.writeInt(object.getElseCbIndex());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseIfte(object);
    }
}

