/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.tests.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HttpServer {
    private Server server;
    private int httpPort;
    private int httpsPort = -1;
    private String keyStoreLocation = "resources/ssl/keystore";
    private String keyStorePassword;
    private String trustStoreLocation;
    private String trustStorePassword;
    private boolean needClientAuth;
    private String proxyUsername;
    private String proxyPassword;
    private boolean redirectToHttps;
    private long latency;
    private final Map<String, String> userPasswords = new HashMap<String, String>();
    private final Map<String, String[]> userRoles = new HashMap<String, String[]>();
    private final Map<String, String[]> securedRealms = new HashMap<String, String[]>();
    private final Map<String, File> resourceDirs = new TreeMap(Collections.reverseOrder());
    private final Map<String, String[]> resourceFilters = new HashMap<String, String[]>();
    private final Map<String, String> filterTokens = new HashMap<String, String>();
    private final Collection<String> recordedPatterns = new HashSet<String>();
    private final List<String> recordedRequests = new ArrayList<String>();
    private final Map<String, Map<String, String>> recordedHeaders = new HashMap<String, Map<String, String>>();
    private String storePassword;

    protected Connector newHttpConnector() {
        HttpConfiguration config = new HttpConfiguration();
        config.setSecurePort(this.httpsPort);
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        connector.setPort(this.httpPort);
        return connector;
    }

    protected Connector newHttpsConnector() {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyManagerPassword(this.storePassword);
        sslContextFactory.setKeyStorePath(new File(this.keyStoreLocation).getAbsolutePath());
        sslContextFactory.setKeyStorePassword(this.keyStorePassword);
        if (this.trustStoreLocation != null && !"".equals(this.trustStoreLocation)) {
            sslContextFactory.setTrustStorePath(new File(this.trustStoreLocation).getAbsolutePath());
        }
        if (this.trustStorePassword != null && !"".equals(this.trustStoreLocation)) {
            sslContextFactory.setTrustStorePassword(this.trustStorePassword);
        }
        sslContextFactory.setNeedClientAuth(this.needClientAuth);
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString())});
        connector.setPort(this.httpsPort);
        return connector;
    }

    public HttpServer setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public int getHttpPort() {
        if (this.httpPort >= 0 && this.server != null && this.server.isRunning()) {
            return ((NetworkConnector)this.server.getConnectors()[0]).getLocalPort();
        }
        return this.httpPort;
    }

    public String getHttpUrl() {
        return "http://localhost:" + this.getHttpPort();
    }

    public HttpServer setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public int getHttpsPort() {
        if (this.httpsPort >= 0 && this.server != null && this.server.isRunning()) {
            return ((NetworkConnector)this.server.getConnectors()[this.httpPort < 0 ? 0 : 1]).getLocalPort();
        }
        return this.httpsPort;
    }

    public String getHttpsUrl() {
        return "https://localhost:" + this.getHttpsPort();
    }

    public HttpServer setKeyStore(String path, String password) {
        this.keyStoreLocation = path;
        this.keyStorePassword = password;
        if (this.storePassword == null) {
            this.storePassword = this.keyStorePassword;
        }
        return this;
    }

    public HttpServer setTrustStore(String path, String password) {
        this.trustStoreLocation = path;
        this.trustStorePassword = password;
        return this;
    }

    public HttpServer setStorePassword(String password) {
        this.storePassword = password;
        return this;
    }

    public HttpServer setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public HttpServer setProxyAuth(String username, String password) {
        this.proxyUsername = username;
        this.proxyPassword = password;
        return this;
    }

    protected Handler newProxyHandler() {
        return new Handler.Abstract(){

            public boolean handle(Request request, Response response, Callback callback) throws Exception {
                String auth = request.getHeaders().get(HttpHeader.PROXY_AUTHORIZATION);
                if (auth != null) {
                    auth = auth.substring(auth.indexOf(32) + 1).trim();
                    auth = new String(Base64.getDecoder().decode(auth));
                }
                return false;
            }
        };
    }

    public HttpServer setRedirectToHttps(boolean redirectToHttps) {
        this.redirectToHttps = redirectToHttps;
        return this;
    }

    protected Handler newSslRedirectHandler() {
        return new Handler.Abstract(){

            public boolean handle(Request request, Response response, Callback callback) throws Exception {
                int httpsPort = HttpServer.this.getHttpsPort();
                if (Request.getServerPort((Request)request) != httpsPort) {
                    String url = "https://" + Request.getServerName((Request)request) + ":" + httpsPort + request.getHttpURI().getPath();
                    response.setStatus(301);
                    response.getHeaders().put(HttpHeader.LOCATION, url);
                    callback.succeeded();
                    return true;
                }
                return false;
            }
        };
    }

    public HttpServer addUser(String username, String password, String ... roles) {
        this.userPasswords.put(username, password);
        this.userRoles.put(username, roles == null ? new String[]{} : roles);
        return this;
    }

    public HttpServer addSecuredRealm(String pathSpec, String ... roles) {
        this.securedRealms.put(pathSpec, roles == null ? new String[]{} : roles);
        return this;
    }

    protected SecurityHandler newSecurityHandler() throws IOException {
        Object roles;
        SecurityHandler.PathMapped securityHandler = new SecurityHandler.PathMapped();
        for (String pathSpec : this.securedRealms.keySet()) {
            roles = this.securedRealms.get(pathSpec);
            Constraint constraint = Constraint.from((String)"BASIC", (Constraint.Authorization)Constraint.Authorization.SPECIFIC_ROLE, (String[])roles);
            securityHandler.put(pathSpec, constraint);
        }
        Properties p = new Properties();
        for (String username : this.userPasswords.keySet()) {
            String password = this.userPasswords.get(username);
            String[] roles2 = this.userRoles.get(username);
            StringBuilder entry = new StringBuilder(password);
            String[] stringArray = roles2;
            int n = roles2.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                entry.append(",");
                entry.append(role);
                ++n2;
            }
            p.put(username, entry.toString());
        }
        File propFile = new File("target/users.properties");
        roles = null;
        Object var5_6 = null;
        try (FileOutputStream in = new FileOutputStream(propFile);){
            p.store(in, null);
        }
        catch (Throwable throwable) {
            if (roles == null) {
                roles = throwable;
            } else if (roles != throwable) {
                ((Throwable)roles).addSuppressed(throwable);
            }
            throw roles;
        }
        HashLoginService userRealm = new HashLoginService("TestRealm", new PathResourceFactory().newResource("target/users.properties"));
        this.server.addBean((Object)userRealm);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setLoginService((LoginService)userRealm);
        return securityHandler;
    }

    public HttpServer addResources(String contextRoot, String baseDirectory, String ... filteredExtensions) {
        contextRoot = HttpServer.normalizeContextRoot(contextRoot);
        File basedir = new File(baseDirectory).getAbsoluteFile();
        this.resourceDirs.put(contextRoot, basedir);
        this.resourceFilters.put(contextRoot, filteredExtensions == null ? new String[]{} : filteredExtensions);
        return this;
    }

    public HttpServer enableRecording(String ... patterns) {
        Collections.addAll(this.recordedPatterns, patterns);
        return this;
    }

    public List<String> getRecordedRequests() {
        return this.recordedRequests;
    }

    public Map<String, String> getRecordedHeaders(String uri) {
        return this.recordedHeaders.get(uri);
    }

    public HttpServer setFilterToken(String token, String value) {
        if (value == null) {
            this.filterTokens.remove(token);
        } else {
            this.filterTokens.put(token, value);
        }
        return this;
    }

    protected Handler newResourceHandler() {
        return new ResHandler();
    }

    public HttpServer setLatency(long millis) {
        this.latency = millis;
        return this;
    }

    protected Handler newSleepHandler(final long millis) {
        return new Handler.Abstract(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean handle(Request request, Response response, Callback callback) throws Exception {
                if (millis >= 0L) {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    3 var4_5 = this;
                    synchronized (var4_5) {
                        try {
                            ((Object)((Object)this)).wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return false;
            }
        };
    }

    public HttpServer start() throws Exception {
        if (this.server != null) {
            return this;
        }
        this.recordedRequests.clear();
        this.server = new Server();
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        if (this.httpPort >= 0) {
            connectors.add(this.newHttpConnector());
        }
        if (this.httpsPort >= 0 && this.keyStoreLocation != null) {
            connectors.add(this.newHttpsConnector());
        }
        Handler.Sequence handlerList = new Handler.Sequence(new Handler[0]);
        if (!this.recordedPatterns.isEmpty()) {
            handlerList.addHandler((Handler)new RecordingHandler());
        }
        if (this.latency != 0L) {
            handlerList.addHandler(this.newSleepHandler(this.latency));
        }
        if (this.redirectToHttps) {
            handlerList.addHandler(this.newSslRedirectHandler());
        }
        if (this.proxyUsername != null && this.proxyPassword != null) {
            handlerList.addHandler(this.newProxyHandler());
        }
        SecurityHandler security = null;
        if (!this.securedRealms.isEmpty()) {
            security = this.newSecurityHandler();
            handlerList.addHandler((Handler)security);
        }
        if (!this.resourceDirs.isEmpty()) {
            if (security != null) {
                security.setHandler(this.newResourceHandler());
            } else {
                handlerList.addHandler(this.newResourceHandler());
            }
        }
        handlerList.addHandler((Handler)new DefaultHandler());
        this.server.setHandler((Handler)handlerList);
        this.server.setConnectors(connectors.toArray(new Connector[connectors.size()]));
        this.server.start();
        this.waitForConnectors();
        this.addDefaultFilterTokens();
        return this;
    }

    protected void waitForConnectors() throws Exception {
        ArrayList<Connector> badConnectors = new ArrayList<Connector>(2);
        int r = 10;
        while (r > 0) {
            int i = 200;
            while (i > 0) {
                badConnectors.clear();
                Connector[] connectorArray = this.server.getConnectors();
                int n = connectorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Connector connector = connectorArray[n2];
                    if (((NetworkConnector)connector).getLocalPort() < 0) {
                        badConnectors.add(connector);
                    }
                    ++n2;
                }
                if (badConnectors.isEmpty()) {
                    return;
                }
                try {
                    Thread.sleep(15L);
                }
                catch (InterruptedException e) {
                    return;
                }
                --i;
            }
            System.err.println("WARNING: " + String.valueOf(badConnectors) + " did not start properly, restarting");
            for (Connector connector : badConnectors) {
                connector.stop();
                connector.start();
            }
            --r;
        }
    }

    protected void addDefaultFilterTokens() {
        if (!this.filterTokens.containsKey("@basedir@")) {
            this.filterTokens.put("@basedir@", new File("").getAbsolutePath());
        }
        if (!this.filterTokens.containsKey("@baseurl@")) {
            Object baseurl = "file://" + new File("").toURI().getPath();
            if (((String)baseurl).endsWith("/")) {
                baseurl = ((String)baseurl).substring(0, ((String)baseurl).length() - 1);
            }
            this.filterTokens.put("@baseurl@", (String)baseurl);
        }
        if (!this.filterTokens.containsKey("@baseuri@")) {
            Object baseuri = "file://" + new File("").toURI().getRawPath();
            if (((String)baseuri).endsWith("/")) {
                baseuri = ((String)baseuri).substring(0, ((String)baseuri).length() - 1);
            }
            this.filterTokens.put("@baseuri@", (String)baseuri);
        }
        if (!this.filterTokens.containsKey("@port.http@")) {
            this.filterTokens.put("@port.http@", Integer.toString(this.getHttpPort()));
        }
        if (!this.filterTokens.containsKey("@port.https@")) {
            this.filterTokens.put("@port.https@", Integer.toString(this.getHttpsPort()));
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.server = null;
        }
    }

    private static String normalizeContextRoot(String contextRoot) {
        if (((String)contextRoot).endsWith("/")) {
            contextRoot = ((String)contextRoot).substring(0, ((String)contextRoot).length() - 1);
        }
        if (!((String)contextRoot).startsWith("/")) {
            contextRoot = "/" + (String)contextRoot;
        }
        return contextRoot;
    }

    private static String trimContextRoot(String uri, String contextRoot) {
        if (uri.startsWith(contextRoot)) {
            if (contextRoot.length() == 1) {
                return uri.substring(1);
            }
            if (uri.length() > contextRoot.length() && uri.charAt(contextRoot.length()) == '/') {
                return uri.substring(contextRoot.length() + 1);
            }
        }
        return null;
    }

    public void resetRecording() {
        this.recordedHeaders.clear();
        this.recordedRequests.clear();
    }

    private class RecordingHandler
    extends Handler.Abstract {
        private RecordingHandler() {
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            String uri = request.getHttpURI().getPath();
            for (String pattern : HttpServer.this.recordedPatterns) {
                if (!uri.matches(pattern)) continue;
                String req = request.getMethod() + " " + uri;
                HttpServer.this.recordedRequests.add(req);
                HashMap<String, String> headers = new HashMap<String, String>();
                HttpServer.this.recordedHeaders.put(uri, headers);
                for (HttpField field : request.getHeaders()) {
                    headers.put(field.getName(), field.getValue());
                }
            }
            return false;
        }
    }

    private class ResHandler
    extends Handler.Abstract {
        private ResHandler() {
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            String uri = request.getHttpURI().getPath();
            for (String contextRoot : HttpServer.this.resourceDirs.keySet()) {
                String path = URIUtil.decodePath((String)HttpServer.trimContextRoot(uri, contextRoot));
                if (path == null) continue;
                File basedir = HttpServer.this.resourceDirs.get(contextRoot);
                File file = new File(basedir, path);
                HttpMethod requestMethod = HttpMethod.fromString((String)request.getMethod());
                if (HttpMethod.HEAD == requestMethod) {
                    if (file.exists()) {
                        response.setStatus(200);
                    } else {
                        response.setStatus(404);
                    }
                    callback.succeeded();
                    return true;
                }
                if (HttpMethod.PUT == requestMethod || HttpMethod.POST == requestMethod) {
                    file.getParentFile().mkdirs();
                    Throwable throwable = null;
                    Object var12_14 = null;
                    try (InputStream input = Content.Source.asInputStream((Content.Source)request);){
                        Files.copy(input, file.toPath(), new CopyOption[0]);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    response.setStatus(201);
                    callback.succeeded();
                    return true;
                }
                if (file.isFile()) {
                    byte[] bytes;
                    String filterEncoding = this.getFilterEncoding(path, HttpServer.this.resourceFilters.get(contextRoot));
                    if (filterEncoding == null) {
                        bytes = Files.readAllBytes(file.toPath());
                    } else {
                        String text = Files.readString(file.toPath(), Charset.forName(filterEncoding));
                        text = this.filter(text, HttpServer.this.filterTokens);
                        bytes = text.getBytes(filterEncoding);
                    }
                    response.setStatus(200);
                    response.write(true, ByteBuffer.wrap(bytes), callback);
                    return true;
                }
                return false;
            }
            return false;
        }

        private String getExtension(String path) {
            return path.substring(path.lastIndexOf(46) + 1);
        }

        private String getFilterEncoding(String path, String[] filteredExtensions) {
            String ext = this.getExtension(path);
            if (filteredExtensions != null) {
                String[] stringArray = filteredExtensions;
                int n = filteredExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String filteredExtension = stringArray[n2];
                    if (filteredExtension.startsWith(".")) {
                        filteredExtension = filteredExtension.substring(1);
                    }
                    if (filteredExtension.equalsIgnoreCase(ext)) {
                        return "properties".equalsIgnoreCase(ext) ? "ISO-8859-1" : "UTF-8";
                    }
                    ++n2;
                }
            }
            return null;
        }

        private String filter(String str, Map<String, String> tokens) {
            for (String token : tokens.keySet()) {
                str = str.replace(token, tokens.get(token));
            }
            return str;
        }
    }
}

