/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jpt.common.ui.internal.plugin.JptCommonUiPlugin;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.value.BufferedModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.listener.AbstractChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryFacetPropertyPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class JptProjectPropertiesPage
extends LibraryFacetPropertyPage {
    protected volatile boolean engaged = false;
    protected final ModifiablePropertyValueModel<IProject> projectModel = new SimplePropertyValueModel();
    protected final BufferedModifiablePropertyValueModel.Trigger trigger = new BufferedModifiablePropertyValueModel.Trigger();
    protected final ChangeListener validationListener;
    protected static final Integer ERROR_STATUS = 4;
    protected static final Integer WARNING_STATUS = 2;
    protected static final Integer INFO_STATUS = 1;
    protected static final Integer OK_STATUS = 0;

    public JptProjectPropertiesPage() {
        this.buildModels();
        this.validationListener = this.buildValidationListener();
    }

    protected abstract void buildModels();

    public static boolean flagIsSet(PropertyValueModel<Boolean> flagModel) {
        Boolean flag = (Boolean)flagModel.getValue();
        return flag != null && flag != false;
    }

    protected IPropertyChangeListener buildLibraryProviderListener() {
        return new LibraryProviderListener();
    }

    protected abstract void adjustLibraryProviders();

    protected Control createPageContents(Composite parent) {
        this.disengageListeners();
        this.projectModel.setValue((Object)this.getProject());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createWidgets(composite);
        Dialog.applyDialogFont((Control)composite);
        this.adjustLibraryProviders();
        this.engageListeners();
        this.updateValidation();
        return composite;
    }

    protected abstract void createWidgets(Composite var1);

    protected final void engageListeners() {
        if (!this.engaged) {
            this.engageListeners_();
            this.engaged = true;
        }
    }

    protected void engageListeners_() {
        this.engageValidationListener();
    }

    protected final void disengageListeners() {
        if (this.engaged) {
            this.disengageListeners_();
            this.engaged = false;
        }
    }

    protected void disengageListeners_() {
        this.disengageValidationListener();
    }

    protected Link buildFacetsPageLink(Composite parent, String text) {
        Link facetsPageLink = this.buildLink(parent, text);
        facetsPageLink.addSelectionListener((SelectionListener)new FacetsPageLinkListener());
        return facetsPageLink;
    }

    protected void openProjectFacetsPage() {
        ((IWorkbenchPreferenceContainer)this.getContainer()).openPage("org.eclipse.wst.common.project.facet.ui.FacetsPropertyPage", null);
    }

    public Point computeSize() {
        return this.doComputeSize();
    }

    protected Button buildCheckBox(Composite parent, int horizontalSpan, String text) {
        return this.buildButton(parent, horizontalSpan, text, 32);
    }

    protected Button buildRadioButton(Composite parent, int horizontalSpan, String text) {
        return this.buildButton(parent, horizontalSpan, text, 16);
    }

    protected Button buildButton(Composite parent, int horizontalSpan, String text, int style) {
        Button button = new Button(parent, style);
        button.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = horizontalSpan;
        button.setLayoutData((Object)gd);
        return button;
    }

    protected Combo buildDropDown(Composite parent) {
        return this.buildDropDown(parent, 1);
    }

    protected Combo buildDropDown(Composite parent, int horizontalSpan) {
        Combo combo = new Combo(parent, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = horizontalSpan;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    protected Label buildLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        return label;
    }

    protected Link buildLink(Composite parent, String text) {
        Link link = new Link(parent, 0);
        GridData data = new GridData(3, 2, false, false);
        data.horizontalSpan = 2;
        link.setLayoutData((Object)data);
        link.setText(text);
        return link;
    }

    public boolean performOk() {
        super.performOk();
        try {
            this.buildOkProgressMonitorDialog().run(true, false, this.buildOkRunnableWithProgress());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getTargetException());
        }
        return true;
    }

    protected IRunnableContext buildOkProgressMonitorDialog() {
        return new ProgressMonitorDialog(this.getShell());
    }

    protected IRunnableWithProgress buildOkRunnableWithProgress() {
        return new OkRunnableWithProgress(this.getProject().getWorkspace());
    }

    void performOk_(IProgressMonitor monitor) throws CoreException {
        if (this.isBuffering()) {
            boolean rebuild = this.projectRebuildRequired();
            this.trigger.accept();
            if (rebuild) {
                this.rebuildProject();
            }
            this.getProject().build(6, monitor);
        }
    }

    protected abstract boolean projectRebuildRequired();

    protected abstract void rebuildProject() throws CoreException;

    private boolean isBuffering() {
        BufferedModifiablePropertyValueModel<?>[] bufferedModifiablePropertyValueModelArray = this.buildBufferedModels();
        int n = bufferedModifiablePropertyValueModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferedModifiablePropertyValueModel<?> model = bufferedModifiablePropertyValueModelArray[n2];
            if (model.isBuffering()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected abstract BufferedModifiablePropertyValueModel<?>[] buildBufferedModels();

    protected void performDefaults() {
        super.performDefaults();
        this.trigger.reset();
    }

    public void dispose() {
        this.disengageListeners();
        super.dispose();
    }

    private ChangeListener buildValidationListener() {
        return new ValidationListener();
    }

    protected void validate() {
        if (!this.getControl().isDisposed()) {
            this.updateValidation();
        }
    }

    private void engageValidationListener() {
        Model[] modelArray = this.buildValidationModels();
        int n = modelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.addChangeListener(this.validationListener);
            ++n2;
        }
    }

    protected abstract Model[] buildValidationModels();

    private void disengageValidationListener() {
        Model[] modelArray = this.buildReverseValidationModels();
        int n = modelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.removeChangeListener(this.validationListener);
            ++n2;
        }
    }

    protected Model[] buildReverseValidationModels() {
        return (Model[])ArrayTools.reverse((Object[])this.buildValidationModels());
    }

    protected IStatus buildInfoStatus(String message) {
        return this.buildStatus(1, message);
    }

    protected IStatus buildWarningStatus(String message) {
        return this.buildStatus(2, message);
    }

    protected IStatus buildErrorStatus(String message) {
        return this.buildStatus(4, message);
    }

    protected IStatus buildStatus(int severity, String message) {
        return JptCommonUiPlugin.instance().buildStatus(severity, message);
    }

    protected IStatus performValidation() {
        HashMap<Integer, ArrayList<IStatus>> statuses = new HashMap<Integer, ArrayList<IStatus>>();
        statuses.put(ERROR_STATUS, new ArrayList());
        statuses.put(WARNING_STATUS, new ArrayList());
        statuses.put(INFO_STATUS, new ArrayList());
        statuses.put(OK_STATUS, new ArrayList());
        this.addStatus(super.performValidation(), statuses);
        this.performValidation(statuses);
        ArrayList<IStatus> list = statuses.get(ERROR_STATUS);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        list = statuses.get(WARNING_STATUS);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        list = statuses.get(INFO_STATUS);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return Status.OK_STATUS;
    }

    protected abstract void performValidation(Map<Integer, ArrayList<IStatus>> var1);

    protected void addStatus(IStatus status, Map<Integer, ArrayList<IStatus>> statuses) {
        statuses.get(status.getSeverity()).add(status);
    }

    class FacetsPageLinkListener
    extends SelectionAdapter {
        FacetsPageLinkListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            JptProjectPropertiesPage.this.openProjectFacetsPage();
        }

        public String toString() {
            return ObjectTools.toString((Object)((Object)this));
        }
    }

    protected class LibraryProviderListener
    implements IPropertyChangeListener {
        protected LibraryProviderListener() {
        }

        public void propertyChanged(String property, Object oldValue, Object newValue) {
            if (LibraryInstallDelegate.PROP_AVAILABLE_PROVIDERS.equals(property)) {
                JptProjectPropertiesPage.this.adjustLibraryProviders();
            }
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    protected class OkRunnableWithProgress
    implements IRunnableWithProgress {
        protected final IWorkspace workspace;

        protected OkRunnableWithProgress(IWorkspace workspace) {
            this.workspace = workspace;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.workspace.run((IWorkspaceRunnable)new OkWorkspaceRunnable(), (ISchedulingRule)this.workspace.getRoot(), 1, monitor);
            }
            catch (CoreException ex) {
                throw new InvocationTargetException(ex);
            }
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }

        class OkWorkspaceRunnable
        implements IWorkspaceRunnable {
            OkWorkspaceRunnable() {
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                JptProjectPropertiesPage.this.performOk_(monitor);
            }

            public String toString() {
                return ObjectTools.toString((Object)this);
            }
        }
    }

    class ValidationListener
    extends AbstractChangeListener {
        ValidationListener() {
        }

        protected void modelChanged() {
            JptProjectPropertiesPage.this.validate();
        }
    }
}

