/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java.facade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.facade.AbstractJNode;
import org.eclipse.emf.codegen.merge.java.facade.FacadeFlags;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.JPackage;
import org.eclipse.emf.codegen.merge.java.facade.JType;
import org.eclipse.emf.codegen.merge.java.facade.NodeConverter;
import org.eclipse.emf.codegen.util.CodeGenUtil;

public abstract class FacadeHelper {
    protected static final String CLASS_PREFIX = "org.eclipse.emf.codegen.merge.java.facade.J";
    protected JControlModel controlModel;
    protected Map<Object, JNode> objectToNodeMap;
    protected String compilerCompliance;

    public void reset() {
        if (this.objectToNodeMap != null) {
            for (JNode node : this.objectToNodeMap.values()) {
                this.disposeNode(node);
            }
            this.objectToNodeMap.clear();
        }
    }

    public boolean canMerge() {
        return true;
    }

    protected Map<Object, JNode> getObjectToNodeMap() {
        if (this.objectToNodeMap == null) {
            this.objectToNodeMap = new HashMap<Object, JNode>();
        }
        return this.objectToNodeMap;
    }

    public String getClassPrefix() {
        return CLASS_PREFIX;
    }

    public void dispose(JNode node) {
        for (JNode child : node.getChildren()) {
            this.dispose(child);
        }
        this.disposeNode(node);
    }

    protected void disposeNode(JNode node) {
        if (node instanceof AbstractJNode) {
            ((AbstractJNode)node).dispose();
        }
    }

    public boolean isDisposed(JNode node) {
        return node instanceof AbstractJNode && ((AbstractJNode)node).isDisposed();
    }

    public void setControlModel(JControlModel controlModel) throws IllegalArgumentException {
        if (controlModel != null && controlModel.getFacadeHelper() != this) {
            throw new IllegalArgumentException("Invalid control model");
        }
        if (this.controlModel != null) {
            this.reset();
        }
        this.controlModel = controlModel;
    }

    public JControlModel getControlModel() {
        return this.controlModel;
    }

    public JNode convertToNode(Object object) {
        JNode node = this.getObjectToNodeMap().get(object);
        if (node == null && (node = this.doConvertToNode(object)) != null) {
            this.getObjectToNodeMap().put(object, node);
        }
        return node;
    }

    public abstract JNode cloneNode(Object var1, JNode var2);

    public abstract Object getContext(JNode var1);

    public abstract JCompilationUnit createCompilationUnit(String var1, String var2);

    protected abstract JNode doConvertToNode(Object var1);

    public String getOriginalContents(JCompilationUnit compilationUnit) {
        return null;
    }

    public NodeConverter getNodeConverter() {
        return null;
    }

    public JCompilationUnit getCompilationUnit(JNode node) {
        while (node != null) {
            if (node instanceof JCompilationUnit) {
                return (JCompilationUnit)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public JPackage getPackage(JNode node) {
        JCompilationUnit compilationUnit = this.getCompilationUnit(node);
        if (compilationUnit != null) {
            for (JNode child : compilationUnit.getChildren()) {
                if (!(child instanceof JPackage)) continue;
                return (JPackage)child;
            }
        }
        return null;
    }

    public JType getMainType(JCompilationUnit compilationUnit) {
        for (JType type : this.getChildren(compilationUnit, JType.class)) {
            if (!FacadeFlags.isPublic(type.getFlags())) continue;
            return type;
        }
        return null;
    }

    public <T extends JNode> List<T> getChildren(JNode node, Class<T> cls) {
        if (node != null && cls != null) {
            List<JNode> allChildren = node.getChildren();
            ArrayList<JNode> children = new ArrayList<JNode>(allChildren.size());
            for (JNode child : allChildren) {
                if (!cls.isInstance(child)) continue;
                children.add((JNode)cls.cast(child));
            }
            if (!children.isEmpty()) {
                return Collections.unmodifiableList(children);
            }
        }
        return Collections.emptyList();
    }

    public JNode getFirstChild(JNode node) {
        List<JNode> children;
        if (node != null && !(children = node.getChildren()).isEmpty()) {
            return children.get(0);
        }
        return null;
    }

    public JNode getPrevious(JNode node) {
        return this.getSibiling(node, -1);
    }

    public JNode getNext(JNode node) {
        return this.getSibiling(node, 1);
    }

    protected JNode getSibiling(JNode node, int pos) {
        List<JNode> children;
        int index;
        if (node != null && node.getParent() != null && (index = (children = node.getParent().getChildren()).indexOf(node) + pos) >= 0 && index < children.size()) {
            return children.get(index);
        }
        return null;
    }

    public boolean addChild(JNode node, JNode child) {
        if (node != null && child != null) {
            try {
                return node.getChildren().add(child);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean insertSibling(JNode node, JNode newSibling, boolean before) {
        JNode parent;
        if (node != null && newSibling != null && (parent = node.getParent()) != null) {
            List<JNode> children = parent.getChildren();
            int index = children.indexOf(node);
            if (!before) {
                ++index;
            }
            try {
                if (index == children.size()) {
                    return children.add(newSibling);
                }
                children.add(index, newSibling);
                return children.get(index) == newSibling;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean remove(JNode node) {
        JNode parent;
        if (node != null && (parent = node.getParent()) != null) {
            try {
                return parent.getChildren().remove(node);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    public void commentOut(JNode node) {
        throw new UnsupportedOperationException("This facade implementation cannot comment out nodes.");
    }

    public String applyFormatRules(String value) {
        return this.getControlModel() == null ? value : CodeGenUtil.convertFormat(this.getControlModel().getLeadingTabReplacement(), this.getControlModel().convertToStandardBraceStyle(), value);
    }

    public String toString(Object object) {
        return object == null ? null : object.toString();
    }

    public boolean fixInterfaceBrace() {
        return false;
    }

    public boolean canYieldWrongJavadoc() {
        return false;
    }

    public boolean isSibilingTraversalExpensive() {
        return true;
    }

    public String getCompilerCompliance() {
        return this.compilerCompliance;
    }

    public void setCompilerCompliance(String compilerCompliance) {
        this.compilerCompliance = compilerCompliance;
    }
}

