/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.view;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOObjectHandler;
import org.eclipse.emf.cdo.view.CDOStaleObject;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public interface CDOStaleReferencePolicy {
    public static final CDOStaleReferencePolicy EXCEPTION = new CDOStaleReferencePolicy(){

        @Override
        public Object processStaleReference(EObject source, EStructuralFeature feature, int index, CDOID target) {
            throw new ObjectNotFoundException(target);
        }

        public String toString() {
            return Messages.getString("CDOStaleReferencePolicy.0");
        }
    };
    public static final CDOStaleReferencePolicy PROXY;
    public static final CDOStaleReferencePolicy DEFAULT;

    static {
        DEFAULT = PROXY = new DynamicProxy();
    }

    public Object processStaleReference(EObject var1, EStructuralFeature var2, int var3, CDOID var4);

    public static class DynamicProxy
    implements CDOStaleReferencePolicy {
        private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDOStaleReferencePolicy.class);

        @Override
        public Object processStaleReference(EObject source, EStructuralFeature feature, int index, final CDOID target) {
            final EClassifier type = this.getType(source, feature, index, target);
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    String name = method.getName();
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Proxy invocation: " + target + "." + name + (args == null ? "()" : Arrays.asList(args)));
                    }
                    if (name.equals("cdoID")) {
                        return target;
                    }
                    if (name.equals("eIsProxy")) {
                        return false;
                    }
                    if (name.equals("eClass")) {
                        return type;
                    }
                    if (name.equals("eAdapters")) {
                        return new BasicNotifierImpl.EAdapterList((Notifier)proxy);
                    }
                    if (name.equals("eContainer")) {
                        return null;
                    }
                    if (name.equals("eResource")) {
                        return null;
                    }
                    if (name.equals("eContents")) {
                        return EContentsEList.emptyContentsEList();
                    }
                    if (name.equals("eCrossReferences")) {
                        return ECrossReferenceEList.emptyCrossReferenceEList();
                    }
                    if (name.equals("eInvoke")) {
                        return null;
                    }
                    if (name.equals("eGet") && args != null && args.length >= 1) {
                        EStructuralFeature featureParam = (EStructuralFeature)args[0];
                        if (featureParam.isMany()) {
                            return new BasicInternalEList(Object.class);
                        }
                        return featureParam.getDefaultValue();
                    }
                    if (name.equals("eIsSet")) {
                        return false;
                    }
                    if (name.equals("eSet")) {
                        return null;
                    }
                    if (name.equals("eUnset")) {
                        return null;
                    }
                    if (name.equals("equals") && args != null && args.length == 1) {
                        return target.equals(args[0]);
                    }
                    if (name.equals("hashCode")) {
                        return target.hashCode();
                    }
                    if (name.equals("toString")) {
                        return "StaleReference[" + type.getName() + "@" + target + "]";
                    }
                    Class<?> returnType = method.getReturnType();
                    if (returnType == null || returnType == Void.TYPE) {
                        return null;
                    }
                    if (returnType.isPrimitive()) {
                        if (returnType == Boolean.TYPE) {
                            return false;
                        }
                        if (returnType == Character.TYPE) {
                            return Character.valueOf('\u0000');
                        }
                        if (returnType == Byte.TYPE) {
                            return (byte)0;
                        }
                        if (returnType == Short.TYPE) {
                            return (short)0;
                        }
                        if (returnType == Integer.TYPE) {
                            return 0;
                        }
                        if (returnType == Long.TYPE) {
                            return 0L;
                        }
                        if (returnType == Float.TYPE) {
                            return Float.valueOf(0.0f);
                        }
                        if (returnType == Double.TYPE) {
                            return 0.0;
                        }
                    }
                    if (List.class.isAssignableFrom(returnType)) {
                        return new BasicInternalEList(Object.class);
                    }
                    return null;
                }
            };
            Class<InternalEObject> instanceClass = type.getInstanceClass();
            Class[] interfaces = null;
            if (instanceClass != null && instanceClass.isInterface()) {
                interfaces = new Class[]{InternalEObject.class, CDOStaleObject.class, instanceClass};
            } else {
                if (instanceClass == null) {
                    instanceClass = InternalEObject.class;
                }
                interfaces = new Class[]{InternalEObject.class, CDOStaleObject.class};
            }
            try {
                return Proxy.newProxyInstance(instanceClass.getClassLoader(), interfaces, handler);
            }
            catch (IllegalArgumentException ex) {
                String message = ex.getMessage();
                if (message != null && message.contains("CDOStaleObject")) {
                    interfaces[1] = Logger.class;
                    return Proxy.newProxyInstance(instanceClass.getClassLoader(), interfaces, handler);
                }
                throw ex;
            }
        }

        protected EClassifier getType(EObject source, EStructuralFeature feature, int index, CDOID target) {
            EClassifier type;
            EGenericType reifiedType = EcoreUtil.getReifiedType((EClass)source.eClass(), (EGenericType)feature.getEGenericType());
            EClassifier eClassifier = type = reifiedType != null ? reifiedType.getEClassifier() : null;
            if (type == null) {
                type = feature.getEType();
            }
            return type;
        }

        public String toString() {
            return Messages.getString("CDOStaleReferencePolicy.1");
        }

        public static class Enhanced
        extends DynamicProxy
        implements CDOObjectHandler {
            private final ConcurrentMap<CDOID, EClassifier> types = new ConcurrentHashMap<CDOID, EClassifier>();
            private final CDOView view;
            private final CDOStaleReferencePolicy oldPolicy;

            public Enhanced(CDOView view) {
                this.view = view;
                for (InternalCDOObject object : ((InternalCDOView)view).getObjectsList()) {
                    this.addType(object);
                }
                view.addObjectHandler(this);
                CDOView.Options options = view.options();
                this.oldPolicy = options.getStaleReferencePolicy();
                options.setStaleReferencePolicy(this);
            }

            public void dispose() {
                CDOView.Options options = this.view.options();
                options.setStaleReferencePolicy(this.oldPolicy);
                this.view.removeObjectHandler(this);
                this.types.clear();
            }

            @Override
            public void objectStateChanged(CDOView view, CDOObject object, CDOState oldState, CDOState newState) {
                this.addType(object);
            }

            @Override
            protected EClassifier getType(EObject source, EStructuralFeature feature, int index, CDOID target) {
                EClassifier type = (EClassifier)this.types.get(target);
                if (type != null) {
                    return type;
                }
                return super.getType(source, feature, index, target);
            }

            private void addType(CDOObject object) {
                CDOID id = object.cdoID();
                EClass type = object.eClass();
                if (id != null && type != null) {
                    this.types.putIfAbsent(id, (EClassifier)type);
                }
            }
        }
    }
}

