/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.enablement.ibm.util.DBVersion;
import org.eclipse.datatools.enablement.ibm.util.ReuseStringBuffer;
import org.eclipse.osgi.util.NLS;

public class SQLIdentifier {
    public static String QUALIFIED_NAME_TEMPLATE = "{0}.{1}";
    public static final int PLATFORM_ANY = 0;
    public static final int PLATFORM_LUWO = 1;
    public static final int PLATFORM_390 = 2;
    public static final int PLATFORM_400 = 4;
    public static final int PLATFORM_DB2 = 0;
    public static final int PLATFORM_CLOUDSCAPE = 8;
    public static final int PLATFORM_DERBY = 8;
    public static final int PLATFORM_ALL = 15;
    public static final int PLATFORM_INFORMIX = 32;
    public static final int PLATFORM_ORACLE = 64;
    public static final int PLATFORM_SYBASE = 128;
    public static final int PLATFORM_SQLSERVER = 256;
    public static final int PLATFORM_MYSQL = 512;
    public static final int PLATFORM_OTHER = 0x10000000;
    public static final String PLATFORM_390_KEY = "390_PLATFORM";
    public static final String PLATFORM_400_KEY = "400_PLATFORM";
    public static final String PLATFORM_LUWO_KEY = "LUWO_PLATFORM";
    public static final String PLATFORM_CLOUDSCAPE_KEY = "CLOUDSCAPE_PLATFORM";
    public static final String PLATFORM_OTHER_KEY = "OTHER_PLATFORM";
    public static final String DB2_ZSERIES = "zSeries";
    public static final String DB2_ISERIES = "iSeries";
    public static final String DB2_LUW0 = "DB2 UDB";
    public static final String CLOUDSCAPE = "Cloudscape";
    public static final String DERBY = "Derby";
    public static final String INFORMIX = "Informix";
    public static final String ORACLE = "Oracle";
    public static final String SYBASE = "Sybase";
    public static final String SQLSERVER = "SQL Server";
    public static final String MYSQL = "MySql";
    protected static String ordinaryDigits;
    protected static Hashtable<Object, HashSet<Character>> ordinaryFlagsSet;
    protected static String ordinaryWideDigits;
    protected static ArrayList<String> langsUNO;
    protected static List<String> luwoReserved;
    protected static List<String> os390Reserved;
    protected static List<String> os400Reserved;
    protected static List<String> cloudscapeReserved;
    protected static HashSet<Character> otherOrdinaryFlags;
    protected static Set<String> schemaReserved;
    public static final int TRIM_ALL = 7;
    public static final int TRIM_BOTH = 3;
    public static final int TRIM_INSIDE = 4;
    public static final int TRIM_LEFT = 1;
    public static final int TRIM_RIGHT = 2;
    public static final char DEFAULT_DELIM = '\"';
    public static final String DEFAULT_DELIM_STRING = "\"";
    public static final char DEFAULT_SQUOTE = '\'';
    public static final String EMPTY_STRING = "";

    static {
        ordinaryFlagsSet = new Hashtable(37);
        ordinaryDigits = "0123456789";
        ordinaryWideDigits = "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19";
        schemaReserved = new HashSet<String>(6);
        schemaReserved.add("SYSCAT");
        schemaReserved.add("SYSFUN");
        schemaReserved.add("SYSIBM");
        schemaReserved.add("SYSSTAT");
    }

    public static String convertAuthID(String id, ConnectionInfo conInfo) {
        char delimiter = SQLIdentifier.getDelimiter(conInfo);
        int platform = SQLIdentifier.getPlatform(conInfo);
        return SQLIdentifier.convertAuthID(id, delimiter, platform);
    }

    public static String convertAuthID(String id, DatabaseDefinition dbDef) {
        char delimiter = SQLIdentifier.getDelimiter(dbDef);
        int platform = SQLIdentifier.getPlatform(dbDef);
        return SQLIdentifier.convertAuthID(id, delimiter, platform);
    }

    public static String convertAuthID(String id, char delim, int platforms) {
        if ((platforms & 0x20) == 0 && SQLIdentifier.isUserInputOrdinary(id, delim, platforms)) {
            return id.toUpperCase();
        }
        String sqlid = SQLIdentifier.convertDBID(id, delim, platforms, false);
        boolean reserved = SQLIdentifier.isReservedIdentifier(sqlid, delim, platforms);
        if (reserved) {
            StringBuffer sb = new StringBuffer();
            sb.insert(0, delim).append(sqlid).append(delim);
            return sb.toString();
        }
        return sqlid;
    }

    public static String toCatalogFormat(String id, ConnectionInfo conInfo) {
        char delimiter = SQLIdentifier.getDelimiter(conInfo);
        return SQLIdentifier.convertUserInput(id, delimiter, SQLIdentifier.getPlatform(conInfo));
    }

    public static String toCatalogFormat(String id, DatabaseDefinition dbDef) {
        char delimiter = SQLIdentifier.getDelimiter(dbDef);
        return SQLIdentifier.convertUserInput(id, delimiter, SQLIdentifier.getPlatform(dbDef));
    }

    public static String toSQLFormat(String id, ConnectionInfo conInfo) {
        char delimiter = SQLIdentifier.getDelimiter(conInfo);
        int platform = SQLIdentifier.getPlatform(conInfo);
        String sqlid = SQLIdentifier.convertDBID(id, delimiter, platform, false);
        boolean reserved = platform > 15 ? SQLIdentifier.isReservedIdentifier(sqlid, conInfo) : SQLIdentifier.isReservedIdentifier(sqlid, delimiter, platform);
        if (reserved) {
            StringBuffer sb = new StringBuffer();
            sb.insert(0, delimiter).append(sqlid).append(delimiter);
            return sb.toString();
        }
        return sqlid;
    }

    public static String toSQLFormat(String id, DatabaseDefinition dbDef) {
        char delimiter = SQLIdentifier.getDelimiter(dbDef);
        int platform = SQLIdentifier.getPlatform(dbDef);
        String sqlid = SQLIdentifier.convertDBID(id, delimiter, platform, false);
        boolean reserved = platform > 15 ? SQLIdentifier.isReservedIdentifier(sqlid, dbDef) : SQLIdentifier.isReservedIdentifier(sqlid, delimiter, platform);
        if (reserved) {
            StringBuffer sb = new StringBuffer();
            sb.insert(0, delimiter).append(sqlid).append(delimiter);
            return sb.toString();
        }
        return sqlid;
    }

    public static boolean beginsWith(String id, String prefix, char delimiter) {
        int plen;
        String nid = SQLIdentifier.trim(id, 7, delimiter);
        String pref = SQLIdentifier.trim(prefix, 7, delimiter);
        pref = pref.charAt(0) == delimiter ? (pref.charAt((plen = pref.length()) - 1) == delimiter ? pref.substring(1, plen - 2) : pref.substring(1)) : pref.toUpperCase();
        if (nid.charAt(0) == delimiter) {
            if (nid.length() + 1 < pref.length()) {
                return false;
            }
            nid = nid.substring(1, pref.length() + 1);
        } else {
            if (nid.length() < pref.length()) {
                return false;
            }
            nid = nid.substring(0, pref.length()).toUpperCase();
        }
        return pref.equals(nid);
    }

    public static boolean checkName(Enumeration<String> e, String identifier, char delimiter) {
        while (e.hasMoreElements()) {
            if (!SQLIdentifier.equals(e.nextElement(), identifier, delimiter)) continue;
            return true;
        }
        return false;
    }

    public static String concatIdentifier(String id, Object add, char delimiter) {
        int epos;
        String nid = SQLIdentifier.trim(id, 7, delimiter);
        if (nid.charAt(epos = nid.length() - 1) == delimiter) {
            StringBuffer sb = new StringBuffer();
            sb.append(nid.substring(0, epos)).append(add.toString()).append(delimiter);
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(nid).append(add.toString());
        return sb.toString();
    }

    public static String concatIdentifier(String id, int add, char delimiter) {
        return SQLIdentifier.concatIdentifier(id, (Object)add, delimiter);
    }

    public static String getUniqueVarName(Vector<String> varNames, String name) {
        String uniqueName = name;
        int count = 0;
        boolean found = true;
        if (varNames != null && varNames.size() > 0) {
            while (found) {
                boolean bl = found = !SQLIdentifier.isNameUnique(varNames, uniqueName = SQLIdentifier.concatIdentifier(name, ++count, '\"'));
            }
        } else {
            uniqueName = SQLIdentifier.concatIdentifier(name, ++count, '\"');
        }
        return uniqueName;
    }

    public static boolean isNameUnique(Vector<String> names, String uniqueName) {
        int nameslength = names.size();
        int i = 0;
        while (i < nameslength) {
            if (SQLIdentifier.equals(names.get(i), uniqueName, '\"')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String convertDBID(String id, char delimiter) {
        return SQLIdentifier.convertDBID(id, delimiter, 1, true);
    }

    public static String convertDBID(String id, char delimiter, int platforms) {
        return SQLIdentifier.convertDBID(id, delimiter, platforms, true);
    }

    public static String convertDBID(String id, char delimiter, int platforms, boolean checkReserved) {
        if (id == null || id.length() == 0) {
            return id;
        }
        boolean ordinary = true;
        StringBuffer sb = new StringBuffer();
        char ch = id.charAt(0);
        if (ch == delimiter) {
            sb.append(ch);
            ordinary = false;
        } else if (!SQLIdentifier.isOrdinaryUpperChar(ch, platforms)) {
            ordinary = false;
        }
        sb.append(ch);
        int range = id.length();
        int c = 1;
        while (c < range) {
            ch = id.charAt(c);
            if (ch == delimiter) {
                sb.append(ch);
                ordinary = false;
            } else if (!SQLIdentifier.isOrdinaryUpperChar(ch, platforms) && !SQLIdentifier.isOrdinaryDigit(ch) && ch != '_') {
                ordinary = false;
            }
            sb.append(ch);
            ++c;
        }
        if (checkReserved && SQLIdentifier.isReservedIdentifier(sb.toString(), delimiter, platforms)) {
            ordinary = false;
        }
        if (!ordinary) {
            sb.insert(0, delimiter).append(delimiter);
            return sb.toString();
        }
        return id;
    }

    public static String convertUserInput(String id, char delimiter) {
        return SQLIdentifier.convertUserInput(id, delimiter, 1);
    }

    public static String convertUserInput(String id, ConnectionInfo conInfo) {
        char delimiter = SQLIdentifier.getDelimiter(conInfo);
        int platforms = SQLIdentifier.getPlatform(conInfo);
        return SQLIdentifier.convertUserInput(id, delimiter, platforms);
    }

    public static String convertUserInput(String id, DatabaseDefinition dbDef) {
        char delimiter = SQLIdentifier.getDelimiter(dbDef);
        int platforms = SQLIdentifier.getPlatform(dbDef);
        return SQLIdentifier.convertUserInput(id, delimiter, platforms);
    }

    public static String convertUserInput(String id, char delimiter, int platforms) {
        if (id == null || id.length() == 0) {
            return id;
        }
        if (SQLIdentifier.trim(id, 1, delimiter).length() == 0) {
            return EMPTY_STRING;
        }
        if (SQLIdentifier.trim(id, 1, delimiter).charAt(0) == delimiter) {
            int range;
            StringBuffer sb = new StringBuffer();
            if ((id = SQLIdentifier.trim(id, 7, delimiter)).charAt(range = id.length() - 1) == delimiter) {
                --range;
            }
            boolean precedingDelimiter = false;
            int c = 1;
            while (c <= range) {
                char ch = id.charAt(c);
                if (ch == delimiter) {
                    if (precedingDelimiter) {
                        precedingDelimiter = false;
                    } else {
                        precedingDelimiter = true;
                        sb.append(ch);
                    }
                } else {
                    precedingDelimiter = false;
                    sb.append(ch);
                }
                ++c;
            }
            return sb.toString();
        }
        return SQLIdentifier.trim(id, 3, delimiter).toUpperCase();
    }

    public static String[] getIdentifierParts(String docText, ConnectionInfo conInfo) {
        return SQLIdentifier.getIdentifierParts(docText, conInfo, '.');
    }

    public static String[] getIdentifierParts(String docText, DatabaseDefinition dbDef) {
        return SQLIdentifier.getIdentifierParts(docText, dbDef, '.');
    }

    public static String[] getIdentifierParts(String docText, ConnectionInfo conInfo, char qualifierSeparator) {
        char delim = SQLIdentifier.getDelimiter(conInfo);
        return SQLIdentifier.getIdentifierParts(docText, delim, qualifierSeparator);
    }

    public static String[] getIdentifierParts(String docText, DatabaseDefinition dbDef, char qualifierSeparator) {
        char delim = SQLIdentifier.getDelimiter(dbDef);
        return SQLIdentifier.getIdentifierParts(docText, delim, qualifierSeparator);
    }

    public static String[] getIdentifierParts(String docText, char delim, char qualifierSeparator) {
        String[] parse = new String[2];
        if (docText == null || docText.length() == 0) {
            return parse;
        }
        int dot = SQLIdentifier.getSeparator(docText, delim, qualifierSeparator);
        if (dot == -1 || dot == 0) {
            parse[1] = docText;
        } else if (dot == docText.length() - 1) {
            parse[0] = docText.substring(0, dot);
        } else {
            parse[0] = docText.substring(0, dot);
            parse[1] = docText.substring(dot + 1);
        }
        return parse;
    }

    public static String getIdentifierPart(String docText, int part, ConnectionInfo conInfo) {
        return SQLIdentifier.getIdentifierPart(docText, part, conInfo.getDatabaseDefinition());
    }

    public static String getIdentifierPart(String docText, int part, DatabaseDefinition dbDef) {
        if (docText == null || docText.length() == 0) {
            return null;
        }
        int dot = SQLIdentifier.getDot(docText, dbDef);
        if (part == 0) {
            if (dot <= 0) {
                return null;
            }
            return docText.substring(0, dot);
        }
        if (dot == -1) {
            return docText;
        }
        if (dot == docText.length()) {
            return null;
        }
        return docText.substring(dot + 1);
    }

    public static String getNameOnlyPart(String docText, ConnectionInfo conInfo) {
        return SQLIdentifier.getNameOnlyPart(docText, conInfo.getDatabaseDefinition());
    }

    public static String getNameOnlyPart(String docText, DatabaseDefinition dbDef) {
        if (docText == null || docText.length() == 0) {
            return null;
        }
        int dot = SQLIdentifier.getDot(docText, dbDef);
        if (dot == -1) {
            return docText;
        }
        if (dot > 0 && dot != docText.length()) {
            return docText.substring(dot + 1);
        }
        return null;
    }

    public static int getDot(String docText, ConnectionInfo conInfo) {
        return SQLIdentifier.getSeparator(docText, SQLIdentifier.getDelimiter(conInfo), '.');
    }

    public static int getDot(String docText, DatabaseDefinition dbdef) {
        return SQLIdentifier.getSeparator(docText, SQLIdentifier.getDelimiter(dbdef), '.');
    }

    public static int getSeparator(String docText, ConnectionInfo conInfo, char qualifierSeparator) {
        return SQLIdentifier.getSeparator(docText, SQLIdentifier.getDelimiter(conInfo), qualifierSeparator);
    }

    public static int getDot(String docText, char delim) {
        return SQLIdentifier.getSeparator(docText, delim, '.');
    }

    /*
     * Unable to fully structure code
     */
    public static int getSeparator(String docText, char delim, char qualifierSeparator) {
        docLen = docText.length();
        if (docLen == 0) {
            return -1;
        }
        dot = -1;
        pos1 = docText.indexOf(qualifierSeparator, 0);
        if (pos1 != -1) ** GOTO lbl9
        return -1;
lbl-1000:
        // 1 sources

        {
            pos1 = docText.indexOf(qualifierSeparator, pos1 + 1);
lbl9:
            // 2 sources

            ** while (pos1 > -1)
        }
lbl10:
        // 1 sources

        delims = 0;
        sb = ReuseStringBuffer.getBuffer();
        sb.append(delim).append(delim);
        ddelim = sb.toString();
        sb.setLength(0);
        sb.append(docText.charAt(0));
        pos1 = 1;
        pos2 = docText.indexOf(ddelim, 1);
        while (pos2 > -1) {
            sb.append(docText.substring(pos1, pos2));
            sb.append("--");
            pos1 = pos2 + 2;
            pos2 = docText.indexOf(ddelim, pos1);
        }
        if (pos1 < docLen) {
            sb.append(docText.substring(pos1));
        }
        buffed = ReuseStringBuffer.toString(sb);
        pos1 = 0;
        pos2 = buffed.indexOf(delim, pos1);
        while (pos2 > -1 && pos2 < buffed.length()) {
            ++delims;
            pos2 = buffed.indexOf(delim, pos2 + 1);
        }
        if (delims % 2 == 0) {
            dot = buffed.lastIndexOf(qualifierSeparator);
            if (dot > (pos1 = buffed.lastIndexOf(delim))) {
                return dot;
            }
            pos2 = buffed.lastIndexOf(delim, pos1 - 1);
            while (dot > pos2 && dot > -1) {
                dot = buffed.lastIndexOf(qualifierSeparator, dot - 1);
            }
            if (dot > -1) {
                return dot;
            }
            return -1;
        }
        dot = docText.lastIndexOf(qualifierSeparator);
        if (dot > (pos1 = docText.lastIndexOf(delim))) {
            return dot;
        }
        pos1 = docText.indexOf(delim);
        dot = docText.lastIndexOf(qualifierSeparator, pos1);
        if (dot < pos1) {
            return dot;
        }
        return -1;
    }

    public static boolean equals(String id1, String id2, ConnectionInfo conInfo) {
        char delimiter = SQLIdentifier.getDelimiter(conInfo);
        int platform = SQLIdentifier.getPlatform(conInfo);
        return SQLIdentifier.equals(id1, id2, delimiter, platform);
    }

    public static boolean equals(String id1, String id2, DatabaseDefinition dbDef) {
        char delimiter = SQLIdentifier.getDelimiter(dbDef);
        int platform = SQLIdentifier.getPlatform(dbDef);
        return SQLIdentifier.equals(id1, id2, delimiter, platform);
    }

    public static boolean equals(String ident1, String ident2, char delimiter) {
        return SQLIdentifier.equals(ident1, ident2, delimiter, 1);
    }

    public static boolean equals(String ident1, String ident2, char delimiter, int platforms) {
        return SQLIdentifier.convertDBID(ident1, delimiter, platforms).equals(SQLIdentifier.convertDBID(ident2, delimiter, platforms));
    }

    public static long getCatalogLength(String text, ConnectionInfo aConInfo) {
        long len = 0L;
        int p = SQLIdentifier.getPlatform(aConInfo);
        int[] v = SQLIdentifier.getVersion(aConInfo);
        len = p == 2 && v[0] > 7 ? SQLIdentifier.getUTF8Length(text) : (p == 1 && v[0] > 8 ? SQLIdentifier.getUTF8Length(text) : (long)text.length());
        return len;
    }

    public static long getCatalogLength(String text, DatabaseDefinition dbDef) {
        long len = 0L;
        int p = SQLIdentifier.getPlatform(dbDef);
        int[] v = SQLIdentifier.getVersion(dbDef);
        len = p == 2 && v[0] > 7 ? SQLIdentifier.getUTF8Length(text) : (p == 1 && v[0] > 8 ? SQLIdentifier.getUTF8Length(text) : (long)text.length());
        return len;
    }

    public static long getUTF8Length(String text) {
        long len = 0L;
        if (text != null) {
            long n = text.length();
            int i = 0;
            while ((long)i < n) {
                char c = text.charAt(i);
                len = c < '\u0080' ? ++len : (c < '\u0800' ? (len += 2L) : (c < '\u10000' ? (len += 3L) : (c < '\u200000' ? (len += 4L) : (c < '\u4000000' ? (len += 5L) : (len += 6L)))));
                ++i;
            }
        }
        return len;
    }

    public static String getDelimiterString(ConnectionInfo conInfo) {
        String delim;
        if (conInfo != null && (delim = conInfo.getIdentifierQuoteString()) != null && (delim = delim.trim()).length() > 0) {
            return delim;
        }
        return DEFAULT_DELIM_STRING;
    }

    public static char getDelimiter(ConnectionInfo conInfo) {
        String delim;
        if (conInfo != null && (delim = conInfo.getIdentifierQuoteString()) != null && (delim = delim.trim()).length() > 0) {
            return delim.charAt(0);
        }
        return '\"';
    }

    public static char getDelimiter(Connection connection) {
        try {
            return connection.getMetaData().getIdentifierQuoteString().charAt(0);
        }
        catch (SQLException sQLException) {
            return '\"';
        }
    }

    public static String getDelimiterString(DatabaseDefinition dbDef) {
        if (dbDef != null) {
            try {
                String delim = dbDef.getIdentifierQuoteString();
                if (delim != null && (delim = delim.trim()).length() > 0 && delim.charAt(0) != '\\') {
                    return delim;
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        return DEFAULT_DELIM_STRING;
    }

    public static char getDelimiter(DatabaseDefinition dbDef) {
        if (dbDef != null) {
            try {
                String delim = dbDef.getIdentifierQuoteString();
                if (delim != null && (delim = delim.trim()).length() > 0 && delim.charAt(0) != '\\') {
                    return delim.charAt(0);
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        return '\"';
    }

    public static int getPlatform(ConnectionInfo conInfo) {
        if (conInfo == null) {
            return 0;
        }
        DatabaseDefinition dbDef = conInfo.getDatabaseDefinition();
        return SQLIdentifier.getPlatform(dbDef);
    }

    public static int getPlatform(DatabaseDefinition dbDef) {
        String product;
        if (dbDef != null && (product = dbDef.getProduct()) != null) {
            if (product.indexOf(DB2_ZSERIES) > -1) {
                return 2;
            }
            if (product.indexOf(DB2_ISERIES) > -1) {
                return 4;
            }
            if (product.indexOf(DB2_LUW0) > -1) {
                return 1;
            }
            if (product.indexOf(CLOUDSCAPE) > -1) {
                return 8;
            }
            if (product.indexOf(DERBY) > -1) {
                return 8;
            }
            if (product.indexOf(INFORMIX) > -1) {
                return 32;
            }
            if (product.indexOf(SYBASE) > -1) {
                return 128;
            }
            if (product.indexOf(SQLSERVER) > -1) {
                return 256;
            }
            if (product.indexOf(MYSQL) > -1) {
                return 512;
            }
            if (product.indexOf(ORACLE) > -1) {
                return 64;
            }
        }
        return 0x10000000;
    }

    public static int[] getVersion(ConnectionInfo aConInfo) {
        DBVersion v = DBVersion.getSharedInstance(aConInfo);
        return new int[]{v.getVersion(), v.getRelease(), v.getMod()};
    }

    public static int[] getVersion(DatabaseDefinition dbDef) {
        DBVersion v = DBVersion.getSharedInstance(dbDef);
        return new int[]{v.getVersion(), v.getRelease(), v.getMod()};
    }

    public static boolean isDB2SpecialChar(char c) {
        switch (c) {
            case ' ': 
            case '!': 
            case '\"': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '^': 
            case '_': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    protected static boolean isDBCSLanguage() {
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        return lang.equals("zh") || lang.equals("ja") || lang.equals("ko");
    }

    public static boolean isDBIDOrdinary(String id) {
        return SQLIdentifier.isDBIDOrdinary(id, '\"', 1);
    }

    public static boolean isDBIDOrdinary(String id, int platforms) {
        return SQLIdentifier.isDBIDOrdinary(id, '\"', platforms);
    }

    public static boolean isDBIDOrdinary(String id, char delimiter, int platforms) {
        if (id == null || id.length() == 0) {
            return true;
        }
        char ch = id.charAt(0);
        if (!SQLIdentifier.isOrdinaryUpperChar(ch, platforms)) {
            return false;
        }
        String tid = SQLIdentifier.trim(id, 2, delimiter);
        int range = tid.length() - 1;
        if (range > -1) {
            int c = 1;
            while (c < range) {
                ch = tid.charAt(c);
                if (!SQLIdentifier.isOrdinaryUpperChar(ch, platforms) && !SQLIdentifier.isOrdinaryDigit(ch) && ch != '_') {
                    return false;
                }
                ++c;
            }
            ch = tid.charAt(range);
            if (!SQLIdentifier.isOrdinaryUpperChar(ch, platforms)) {
                return false;
            }
            if (SQLIdentifier.isReservedIdentifier(tid, delimiter, platforms)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isOrdinary390Char(char ch) {
        boolean isOrdinary = false;
        if (!Locale.getDefault().getLanguage().equalsIgnoreCase("en")) {
            isOrdinary = Character.isUnicodeIdentifierStart(ch);
        } else {
            HashSet<Character> flags = ordinaryFlagsSet.get(PLATFORM_390_KEY);
            if (flags == null) {
                flags = SQLIdentifier.initOrdinaryFlags390();
            }
            isOrdinary = flags.contains(Character.valueOf(ch));
        }
        return isOrdinary;
    }

    public static boolean isOrdinary400Char(char ch) {
        boolean isOrdinary = false;
        if (!Locale.getDefault().getLanguage().equalsIgnoreCase("en")) {
            isOrdinary = Character.isUnicodeIdentifierStart(ch);
        } else {
            HashSet<Character> flags = ordinaryFlagsSet.get(PLATFORM_400_KEY);
            if (flags == null) {
                flags = SQLIdentifier.initOrdinaryFlags400();
            }
            isOrdinary = flags.contains(Character.valueOf(ch));
        }
        return isOrdinary;
    }

    public static boolean isOrdinaryChar(char ch, int platforms) {
        boolean ok = false;
        if (otherOrdinaryFlags != null) {
            ok = SQLIdentifier.isOrdinaryOtherChar(ch);
        } else {
            if ((platforms & 1) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 2) > 0) {
                ok = SQLIdentifier.isOrdinary390Char(ch);
            }
            if (!ok && (platforms & 4) > 0) {
                ok = SQLIdentifier.isOrdinary400Char(ch);
            }
            if (!ok && (platforms & 8) > 0) {
                ok = SQLIdentifier.isOrdinaryCloudscapeChar(ch);
            }
            if (!ok && (platforms & 0x20) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 0x40) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 0x80) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 0x100) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 0x200) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 0x10000000) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
        }
        return ok;
    }

    public static boolean isOrdinaryDigit(char c) {
        boolean isOrdinary = false;
        boolean bl = isOrdinary = ordinaryDigits.indexOf(c) > -1;
        if (!isOrdinary && SQLIdentifier.isDBCSLanguage()) {
            isOrdinary = ordinaryWideDigits.indexOf(c) > -1;
        }
        return isOrdinary;
    }

    public static boolean isOrdinaryLUWOChar(char ch) {
        String lang;
        boolean isOrdinary = false;
        if (langsUNO == null) {
            SQLIdentifier.initOrdinaryFlagsLUWO();
        }
        if (!langsUNO.contains(lang = Locale.getDefault().getLanguage().toLowerCase())) {
            isOrdinary = Character.isUnicodeIdentifierStart(ch);
        } else {
            HashSet<Character> flags = ordinaryFlagsSet.get(PLATFORM_LUWO_KEY);
            if (flags == null) {
                flags = SQLIdentifier.initOrdinaryFlagsLUWO();
            }
            isOrdinary = flags.contains(Character.valueOf(ch));
        }
        return isOrdinary;
    }

    public static boolean isOrdinaryCloudscapeChar(char ch) {
        boolean isOrdinary = false;
        if (!Locale.getDefault().getLanguage().equalsIgnoreCase("en")) {
            isOrdinary = Character.isUnicodeIdentifierStart(ch);
        } else {
            HashSet<Character> flags = ordinaryFlagsSet.get(PLATFORM_CLOUDSCAPE_KEY);
            if (flags == null) {
                flags = SQLIdentifier.initOrdinaryFlagsCloudscape();
            }
            isOrdinary = flags.contains(Character.valueOf(ch));
        }
        return isOrdinary;
    }

    public static boolean isOrdinaryOtherChar(char ch) {
        if (otherOrdinaryFlags == null) {
            return SQLIdentifier.isOrdinaryLUWOChar(ch);
        }
        return otherOrdinaryFlags.contains(Character.valueOf(ch));
    }

    public static boolean isOrdinaryUpperChar(char ch, int platforms) {
        boolean ok = false;
        if (otherOrdinaryFlags != null) {
            ok = SQLIdentifier.isOrdinaryOtherChar(ch);
        } else {
            if ((platforms & 1) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 2) > 0) {
                ok = SQLIdentifier.isOrdinary390Char(ch);
            }
            if (!ok && (platforms & 4) > 0) {
                ok = SQLIdentifier.isOrdinary400Char(ch);
            }
            if (!ok && (platforms & 8) > 0) {
                ok = SQLIdentifier.isOrdinaryCloudscapeChar(ch);
            }
            if (!ok && (platforms & 0x20) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 0x40) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 0x80) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 0x100) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 0x200) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 0x10000000) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
        }
        if (ok && (platforms & 0x20) == 0) {
            ok = !Character.isLowerCase(ch);
        }
        return ok;
    }

    public static boolean isReservedIdentifier(String id, char delimiter) {
        return SQLIdentifier.isReservedIdentifier(id, delimiter, 1);
    }

    public static boolean isReservedIdentifier(String id, char delimiter, int platforms) {
        String up = SQLIdentifier.convertUserInput(id, delimiter, platforms);
        boolean ok = false;
        if ((platforms & 1) > 0) {
            if (luwoReserved == null) {
                luwoReserved = SQLIdentifier.initReserved(DB2_LUW0, "V8.2");
            }
            boolean bl = ok = luwoReserved != null && luwoReserved.contains(up);
        }
        if (!ok && (platforms & 2) > 0) {
            if (os390Reserved == null) {
                os390Reserved = SQLIdentifier.initReserved("DB2 UDB zSeries", "V8 (New-Function Mode)");
            }
            boolean bl = ok = os390Reserved != null && os390Reserved.contains(up);
        }
        if (!ok && (platforms & 4) > 0) {
            if (os400Reserved == null) {
                os400Reserved = SQLIdentifier.initReserved("DB2 UDB iSeries", "V5R4");
            }
            boolean bl = ok = os400Reserved != null && os400Reserved.contains(up);
        }
        if (!ok && (platforms & 8) > 0) {
            if (cloudscapeReserved == null) {
                cloudscapeReserved = SQLIdentifier.initReserved("IBM Cloudscape", "10.0");
            }
            boolean bl = ok = cloudscapeReserved != null && cloudscapeReserved.contains(up);
        }
        if (!ok && (platforms & 0x10000000) > 0) {
            if (luwoReserved == null) {
                luwoReserved = SQLIdentifier.initReserved(DB2_LUW0, "V8.2");
            }
            ok = luwoReserved != null && luwoReserved.contains(up);
        }
        return ok;
    }

    public static boolean isReservedIdentifier(String id, ConnectionInfo conInfo) {
        DatabaseDefinition dbDef = conInfo.getDatabaseDefinition();
        return SQLIdentifier.isReservedIdentifier(id, dbDef);
    }

    public static boolean isReservedIdentifier(String id, DatabaseDefinition dbDef) {
        if (dbDef != null) {
            List reslist = dbDef.getSQLKeywords();
            return reslist.contains(id);
        }
        return false;
    }

    public static boolean isReservedSchema(String id, char delimiter) {
        return schemaReserved.contains(SQLIdentifier.convertUserInput(id, delimiter));
    }

    public static boolean isUserInputOrdinary(String id) {
        return SQLIdentifier.isUserInputOrdinary(id, 1);
    }

    public static boolean isUserInputOrdinary(String id, char delimiter, int platforms) {
        int range;
        if (id == null || id.length() == 0) {
            return true;
        }
        boolean delimited = false;
        String upid = id;
        if (upid.charAt(0) == delimiter) {
            delimited = true;
            if ((upid = upid.substring(1)).charAt(range = upid.length() - 1) == delimiter) {
                upid = upid.substring(0, range);
            }
        }
        char ch = upid.charAt(0);
        if (delimited && Character.toUpperCase(ch) != ch || !SQLIdentifier.isOrdinaryChar(ch, platforms)) {
            return false;
        }
        upid = SQLIdentifier.trim(upid, 2, delimiter);
        range = upid.length();
        int c = 1;
        while (c < range) {
            ch = upid.charAt(c);
            if (delimited && Character.toUpperCase(ch) != ch || !SQLIdentifier.isOrdinaryChar(ch, platforms) && !SQLIdentifier.isOrdinaryDigit(ch) && ch != '_') {
                return false;
            }
            ++c;
        }
        return !SQLIdentifier.isReservedIdentifier(upid, delimiter, platforms);
    }

    public static boolean isUserInputOrdinary(String id, ConnectionInfo conInfo) {
        return SQLIdentifier.isUserInputOrdinary(id, SQLIdentifier.getDelimiter(conInfo), SQLIdentifier.getPlatform(conInfo));
    }

    public static boolean isUserInputOrdinary(String id, int platforms) {
        return SQLIdentifier.isUserInputOrdinary(id, '\"', platforms);
    }

    public static void setExtraOrdinaryChars(Connection connection) {
        otherOrdinaryFlags = null;
        if (connection != null) {
            String prod = null;
            try {
                prod = connection.getMetaData().getDatabaseProductName();
            }
            catch (SQLException sQLException) {
                prod = PLATFORM_OTHER_KEY;
            }
            otherOrdinaryFlags = ordinaryFlagsSet.get(prod);
            if (otherOrdinaryFlags == null) {
                String extras = null;
                try {
                    extras = connection.getMetaData().getExtraNameCharacters();
                }
                catch (SQLException sQLException) {
                    return;
                }
                otherOrdinaryFlags = new HashSet(59);
                ordinaryFlagsSet.put(prod, otherOrdinaryFlags);
                if (extras != null) {
                    int elen = extras.length();
                    int i = 0;
                    while (i < elen) {
                        char c = extras.charAt(i);
                        otherOrdinaryFlags.add(Character.valueOf(c));
                        ++i;
                    }
                }
                SQLIdentifier.initCommonOrdinaryFlags(otherOrdinaryFlags);
                otherOrdinaryFlags.add(Character.valueOf('_'));
            }
        }
    }

    public static String trim(String id, int side, char delimiter) {
        int right;
        char ch;
        if (id == null || id.length() == 0) {
            return id;
        }
        int left = 0;
        if ((side & 1) > 0) {
            ch = id.charAt(left);
            while (ch == ' ' && left < id.length()) {
                if (++left >= id.length()) continue;
                ch = id.charAt(left);
            }
        }
        if ((right = id.length() - 1) > -1 && (side & 2) > 0) {
            ch = id.charAt(right);
            while (ch == ' ' && right > -1) {
                if (--right <= -1) continue;
                ch = id.charAt(right);
            }
        }
        if (right > -1) {
            ch = id.charAt(right);
            int r = -1;
            if ((side & 4) > 0 && (side & 2) == 0) {
                while (right > -1 && ch == ' ' && ch != delimiter) {
                    if (--right <= -1) continue;
                    ch = id.charAt(right);
                }
                if (right > -1 && right < id.length() - 1) {
                    r = right + 1;
                }
            }
            if ((side & 4) > 0 && right > 0 && ch == delimiter) {
                ch = id.charAt(--right);
                while (ch == ' ' && right > -1) {
                    if (--right <= -1) continue;
                    ch = id.charAt(right);
                }
                StringBuffer sb2 = new StringBuffer();
                if (right >= left) {
                    sb2.append(id.substring(left, right + 1)).append(delimiter);
                    if (r > -1) {
                        sb2.append(id.substring(r));
                    }
                } else {
                    sb2.append(id.substring(left)).append(delimiter);
                }
                return sb2.toString();
            }
            if (right >= left) {
                if ((side & 4) > 0 && (side & 2) == 0) {
                    return id;
                }
                return id.substring(left, right + 1);
            }
            return id.substring(left);
        }
        return EMPTY_STRING;
    }

    private SQLIdentifier() {
    }

    public static List<String> initReserved(String vendor, String version) {
        DatabaseDefinitionRegistry ddreg;
        DatabaseDefinition ddef;
        RDBCorePlugin rdb = RDBCorePlugin.getDefault();
        if (rdb != null && (ddef = (ddreg = rdb.getDatabaseDefinitionRegistry()).getDefinition(vendor, version)) != null) {
            return ddef.getSQLKeywords();
        }
        return luwoReserved;
    }

    protected static HashSet<Character> initOrdinaryFlagsCloudscape() {
        HashSet<Character> f = new HashSet<Character>(349);
        ordinaryFlagsSet.put(PLATFORM_CLOUDSCAPE_KEY, f);
        SQLIdentifier.initCommonOrdinaryFlags(f);
        f.add(Character.valueOf('\u00aa'));
        f.add(Character.valueOf('\u00b5'));
        f.add(Character.valueOf('\u00ba'));
        f.add(Character.valueOf('\u00c0'));
        f.add(Character.valueOf('\u00c1'));
        f.add(Character.valueOf('\u00c2'));
        f.add(Character.valueOf('\u00c3'));
        f.add(Character.valueOf('\u00c4'));
        f.add(Character.valueOf('\u00c5'));
        f.add(Character.valueOf('\u00c6'));
        f.add(Character.valueOf('\u00c7'));
        f.add(Character.valueOf('\u00c8'));
        f.add(Character.valueOf('\u00c9'));
        f.add(Character.valueOf('\u00ca'));
        f.add(Character.valueOf('\u00cb'));
        f.add(Character.valueOf('\u00cc'));
        f.add(Character.valueOf('\u00cd'));
        f.add(Character.valueOf('\u00ce'));
        f.add(Character.valueOf('\u00cf'));
        f.add(Character.valueOf('\u00d0'));
        f.add(Character.valueOf('\u00d1'));
        f.add(Character.valueOf('\u00d2'));
        f.add(Character.valueOf('\u00d3'));
        f.add(Character.valueOf('\u00d4'));
        f.add(Character.valueOf('\u00d5'));
        f.add(Character.valueOf('\u00d6'));
        f.add(Character.valueOf('\u00d8'));
        f.add(Character.valueOf('\u00d9'));
        f.add(Character.valueOf('\u00da'));
        f.add(Character.valueOf('\u00db'));
        f.add(Character.valueOf('\u00dc'));
        f.add(Character.valueOf('\u00dd'));
        f.add(Character.valueOf('\u00de'));
        f.add(Character.valueOf('\u00df'));
        f.add(Character.valueOf('\u00e0'));
        f.add(Character.valueOf('\u00e1'));
        f.add(Character.valueOf('\u00e2'));
        f.add(Character.valueOf('\u00e3'));
        f.add(Character.valueOf('\u00e4'));
        f.add(Character.valueOf('\u00e5'));
        f.add(Character.valueOf('\u00e6'));
        f.add(Character.valueOf('\u00e7'));
        f.add(Character.valueOf('\u00e8'));
        f.add(Character.valueOf('\u00e9'));
        f.add(Character.valueOf('\u00ea'));
        f.add(Character.valueOf('\u00eb'));
        f.add(Character.valueOf('\u00ec'));
        f.add(Character.valueOf('\u00ed'));
        f.add(Character.valueOf('\u00ee'));
        f.add(Character.valueOf('\u00ef'));
        f.add(Character.valueOf('\u00f0'));
        f.add(Character.valueOf('\u00f1'));
        f.add(Character.valueOf('\u00f2'));
        f.add(Character.valueOf('\u00f3'));
        f.add(Character.valueOf('\u00f4'));
        f.add(Character.valueOf('\u00f5'));
        f.add(Character.valueOf('\u00f6'));
        f.add(Character.valueOf('\u00f8'));
        f.add(Character.valueOf('\u00f9'));
        f.add(Character.valueOf('\u00fa'));
        f.add(Character.valueOf('\u00fb'));
        f.add(Character.valueOf('\u00fc'));
        f.add(Character.valueOf('\u00fd'));
        f.add(Character.valueOf('\u00fe'));
        f.add(Character.valueOf('\u00ff'));
        f.add(Character.valueOf('\u0100'));
        f.add(Character.valueOf('\u0101'));
        f.add(Character.valueOf('\u0102'));
        f.add(Character.valueOf('\u0103'));
        f.add(Character.valueOf('\u0104'));
        f.add(Character.valueOf('\u0105'));
        f.add(Character.valueOf('\u0106'));
        f.add(Character.valueOf('\u0107'));
        f.add(Character.valueOf('\u0108'));
        f.add(Character.valueOf('\u0109'));
        f.add(Character.valueOf('\u010a'));
        f.add(Character.valueOf('\u010b'));
        f.add(Character.valueOf('\u010c'));
        f.add(Character.valueOf('\u010d'));
        f.add(Character.valueOf('\u010e'));
        f.add(Character.valueOf('\u010f'));
        f.add(Character.valueOf('\u0110'));
        f.add(Character.valueOf('\u0111'));
        f.add(Character.valueOf('\u0112'));
        f.add(Character.valueOf('\u0113'));
        f.add(Character.valueOf('\u0114'));
        f.add(Character.valueOf('\u0115'));
        f.add(Character.valueOf('\u0116'));
        f.add(Character.valueOf('\u0117'));
        f.add(Character.valueOf('\u0118'));
        f.add(Character.valueOf('\u0119'));
        f.add(Character.valueOf('\u011a'));
        f.add(Character.valueOf('\u011b'));
        f.add(Character.valueOf('\u011c'));
        f.add(Character.valueOf('\u011d'));
        f.add(Character.valueOf('\u011e'));
        f.add(Character.valueOf('\u011f'));
        f.add(Character.valueOf('\u0120'));
        f.add(Character.valueOf('\u0121'));
        f.add(Character.valueOf('\u0122'));
        f.add(Character.valueOf('\u0123'));
        f.add(Character.valueOf('\u0124'));
        f.add(Character.valueOf('\u0125'));
        f.add(Character.valueOf('\u0126'));
        f.add(Character.valueOf('\u0127'));
        f.add(Character.valueOf('\u0128'));
        f.add(Character.valueOf('\u0129'));
        f.add(Character.valueOf('\u012a'));
        f.add(Character.valueOf('\u012b'));
        f.add(Character.valueOf('\u012c'));
        f.add(Character.valueOf('\u012d'));
        f.add(Character.valueOf('\u012e'));
        f.add(Character.valueOf('\u012f'));
        f.add(Character.valueOf('\u0130'));
        f.add(Character.valueOf('\u0131'));
        f.add(Character.valueOf('\u0132'));
        f.add(Character.valueOf('\u0133'));
        f.add(Character.valueOf('\u0134'));
        f.add(Character.valueOf('\u0135'));
        f.add(Character.valueOf('\u0136'));
        f.add(Character.valueOf('\u0137'));
        f.add(Character.valueOf('\u0138'));
        f.add(Character.valueOf('\u0139'));
        f.add(Character.valueOf('\u013a'));
        f.add(Character.valueOf('\u013b'));
        f.add(Character.valueOf('\u013c'));
        f.add(Character.valueOf('\u013d'));
        f.add(Character.valueOf('\u013e'));
        f.add(Character.valueOf('\u013f'));
        f.add(Character.valueOf('\u0140'));
        f.add(Character.valueOf('\u0141'));
        f.add(Character.valueOf('\u0142'));
        f.add(Character.valueOf('\u0143'));
        f.add(Character.valueOf('\u0144'));
        f.add(Character.valueOf('\u0145'));
        f.add(Character.valueOf('\u0146'));
        f.add(Character.valueOf('\u0147'));
        f.add(Character.valueOf('\u0148'));
        f.add(Character.valueOf('\u0149'));
        f.add(Character.valueOf('\u014a'));
        f.add(Character.valueOf('\u014b'));
        f.add(Character.valueOf('\u014c'));
        f.add(Character.valueOf('\u014d'));
        f.add(Character.valueOf('\u014e'));
        f.add(Character.valueOf('\u014f'));
        f.add(Character.valueOf('\u0150'));
        f.add(Character.valueOf('\u0151'));
        f.add(Character.valueOf('\u0152'));
        f.add(Character.valueOf('\u0153'));
        f.add(Character.valueOf('\u0154'));
        f.add(Character.valueOf('\u0155'));
        f.add(Character.valueOf('\u0156'));
        f.add(Character.valueOf('\u0157'));
        f.add(Character.valueOf('\u0158'));
        f.add(Character.valueOf('\u0159'));
        f.add(Character.valueOf('\u015a'));
        f.add(Character.valueOf('\u015b'));
        f.add(Character.valueOf('\u015c'));
        f.add(Character.valueOf('\u015d'));
        f.add(Character.valueOf('\u015e'));
        f.add(Character.valueOf('\u015f'));
        f.add(Character.valueOf('\u0160'));
        f.add(Character.valueOf('\u0161'));
        f.add(Character.valueOf('\u0162'));
        f.add(Character.valueOf('\u0163'));
        f.add(Character.valueOf('\u0164'));
        f.add(Character.valueOf('\u0165'));
        f.add(Character.valueOf('\u0166'));
        f.add(Character.valueOf('\u0167'));
        f.add(Character.valueOf('\u0168'));
        f.add(Character.valueOf('\u0169'));
        f.add(Character.valueOf('\u016a'));
        f.add(Character.valueOf('\u016b'));
        f.add(Character.valueOf('\u016c'));
        f.add(Character.valueOf('\u016d'));
        f.add(Character.valueOf('\u016e'));
        f.add(Character.valueOf('\u016f'));
        f.add(Character.valueOf('\u0170'));
        f.add(Character.valueOf('\u0171'));
        f.add(Character.valueOf('\u0172'));
        f.add(Character.valueOf('\u0173'));
        f.add(Character.valueOf('\u0174'));
        f.add(Character.valueOf('\u0175'));
        f.add(Character.valueOf('\u0176'));
        f.add(Character.valueOf('\u0177'));
        f.add(Character.valueOf('\u0178'));
        f.add(Character.valueOf('\u0179'));
        f.add(Character.valueOf('\u017a'));
        f.add(Character.valueOf('\u017b'));
        f.add(Character.valueOf('\u017c'));
        f.add(Character.valueOf('\u017d'));
        f.add(Character.valueOf('\u017e'));
        f.add(Character.valueOf('\u017f'));
        f.add(Character.valueOf('\u0180'));
        f.add(Character.valueOf('\u0181'));
        f.add(Character.valueOf('\u0182'));
        f.add(Character.valueOf('\u0183'));
        f.add(Character.valueOf('\u0184'));
        f.add(Character.valueOf('\u0185'));
        f.add(Character.valueOf('\u0186'));
        f.add(Character.valueOf('\u0187'));
        f.add(Character.valueOf('\u0188'));
        f.add(Character.valueOf('\u0189'));
        f.add(Character.valueOf('\u018a'));
        f.add(Character.valueOf('\u018b'));
        f.add(Character.valueOf('\u018c'));
        f.add(Character.valueOf('\u018d'));
        f.add(Character.valueOf('\u018e'));
        f.add(Character.valueOf('\u018f'));
        f.add(Character.valueOf('\u0190'));
        f.add(Character.valueOf('\u0191'));
        f.add(Character.valueOf('\u0192'));
        f.add(Character.valueOf('\u0193'));
        f.add(Character.valueOf('\u0194'));
        f.add(Character.valueOf('\u0195'));
        f.add(Character.valueOf('\u0196'));
        f.add(Character.valueOf('\u0197'));
        f.add(Character.valueOf('\u0198'));
        f.add(Character.valueOf('\u0199'));
        f.add(Character.valueOf('\u019a'));
        f.add(Character.valueOf('\u019b'));
        f.add(Character.valueOf('\u019c'));
        f.add(Character.valueOf('\u019d'));
        f.add(Character.valueOf('\u019e'));
        f.add(Character.valueOf('\u019f'));
        f.add(Character.valueOf('\u01a0'));
        f.add(Character.valueOf('\u01a1'));
        f.add(Character.valueOf('\u01a2'));
        f.add(Character.valueOf('\u01a3'));
        f.add(Character.valueOf('\u01a4'));
        f.add(Character.valueOf('\u01a5'));
        f.add(Character.valueOf('\u01a6'));
        f.add(Character.valueOf('\u01a7'));
        f.add(Character.valueOf('\u01a8'));
        f.add(Character.valueOf('\u01a9'));
        f.add(Character.valueOf('\u01aa'));
        f.add(Character.valueOf('\u01ab'));
        f.add(Character.valueOf('\u01ac'));
        f.add(Character.valueOf('\u01ad'));
        f.add(Character.valueOf('\u01ae'));
        f.add(Character.valueOf('\u01af'));
        f.add(Character.valueOf('\u01b0'));
        f.add(Character.valueOf('\u01b1'));
        f.add(Character.valueOf('\u01b2'));
        f.add(Character.valueOf('\u01b3'));
        f.add(Character.valueOf('\u01b4'));
        f.add(Character.valueOf('\u01b5'));
        f.add(Character.valueOf('\u01b6'));
        f.add(Character.valueOf('\u01b7'));
        f.add(Character.valueOf('\u01b8'));
        f.add(Character.valueOf('\u01b9'));
        f.add(Character.valueOf('\u01ba'));
        f.add(Character.valueOf('\u01bb'));
        f.add(Character.valueOf('\u01bc'));
        f.add(Character.valueOf('\u01bd'));
        f.add(Character.valueOf('\u01be'));
        f.add(Character.valueOf('\u01bf'));
        f.add(Character.valueOf('\u01c0'));
        f.add(Character.valueOf('\u01c1'));
        f.add(Character.valueOf('\u01c2'));
        f.add(Character.valueOf('\u01c3'));
        f.add(Character.valueOf('\u01c4'));
        f.add(Character.valueOf('\u01c5'));
        f.add(Character.valueOf('\u01c6'));
        f.add(Character.valueOf('\u01c7'));
        f.add(Character.valueOf('\u01c8'));
        f.add(Character.valueOf('\u01c9'));
        f.add(Character.valueOf('\u01ca'));
        f.add(Character.valueOf('\u01cb'));
        f.add(Character.valueOf('\u01cc'));
        f.add(Character.valueOf('\u01cd'));
        f.add(Character.valueOf('\u01ce'));
        f.add(Character.valueOf('\u01cf'));
        f.add(Character.valueOf('\u01d0'));
        f.add(Character.valueOf('\u01d1'));
        f.add(Character.valueOf('\u01d2'));
        f.add(Character.valueOf('\u01d3'));
        f.add(Character.valueOf('\u01d4'));
        f.add(Character.valueOf('\u01d5'));
        f.add(Character.valueOf('\u01d6'));
        f.add(Character.valueOf('\u01d7'));
        f.add(Character.valueOf('\u01d8'));
        f.add(Character.valueOf('\u01d9'));
        f.add(Character.valueOf('\u01da'));
        f.add(Character.valueOf('\u01db'));
        f.add(Character.valueOf('\u01dc'));
        f.add(Character.valueOf('\u01dd'));
        f.add(Character.valueOf('\u01de'));
        f.add(Character.valueOf('\u01df'));
        f.add(Character.valueOf('\u01e0'));
        f.add(Character.valueOf('\u01e1'));
        f.add(Character.valueOf('\u01e2'));
        f.add(Character.valueOf('\u01e3'));
        f.add(Character.valueOf('\u01e4'));
        f.add(Character.valueOf('\u01e5'));
        f.add(Character.valueOf('\u01e6'));
        f.add(Character.valueOf('\u01e7'));
        f.add(Character.valueOf('\u01e8'));
        f.add(Character.valueOf('\u01e9'));
        f.add(Character.valueOf('\u01ea'));
        f.add(Character.valueOf('\u01eb'));
        f.add(Character.valueOf('\u01ec'));
        f.add(Character.valueOf('\u01ed'));
        f.add(Character.valueOf('\u01ee'));
        f.add(Character.valueOf('\u01ef'));
        f.add(Character.valueOf('\u01f0'));
        f.add(Character.valueOf('\u01f1'));
        f.add(Character.valueOf('\u01f2'));
        f.add(Character.valueOf('\u01f3'));
        f.add(Character.valueOf('\u01f4'));
        f.add(Character.valueOf('\u01f5'));
        f.add(Character.valueOf('\u01fa'));
        f.add(Character.valueOf('\u01fb'));
        f.add(Character.valueOf('\u01fc'));
        f.add(Character.valueOf('\u01fd'));
        f.add(Character.valueOf('\u01fe'));
        f.add(Character.valueOf('\u01ff'));
        f.add(Character.valueOf('\u0200'));
        f.add(Character.valueOf('\u0201'));
        f.add(Character.valueOf('\u0202'));
        f.add(Character.valueOf('\u0203'));
        f.add(Character.valueOf('\u0204'));
        f.add(Character.valueOf('\u0205'));
        f.add(Character.valueOf('\u0206'));
        f.add(Character.valueOf('\u0207'));
        f.add(Character.valueOf('\u0208'));
        f.add(Character.valueOf('\u0209'));
        f.add(Character.valueOf('\u020a'));
        f.add(Character.valueOf('\u020b'));
        f.add(Character.valueOf('\u020c'));
        f.add(Character.valueOf('\u020d'));
        f.add(Character.valueOf('\u020e'));
        f.add(Character.valueOf('\u020f'));
        f.add(Character.valueOf('\u0210'));
        f.add(Character.valueOf('\u0211'));
        f.add(Character.valueOf('\u0212'));
        f.add(Character.valueOf('\u0213'));
        f.add(Character.valueOf('\u0214'));
        f.add(Character.valueOf('\u0215'));
        f.add(Character.valueOf('\u0216'));
        f.add(Character.valueOf('\u0217'));
        f.add(Character.valueOf('\u0250'));
        f.add(Character.valueOf('\u0251'));
        f.add(Character.valueOf('\u0252'));
        f.add(Character.valueOf('\u0253'));
        f.add(Character.valueOf('\u0254'));
        f.add(Character.valueOf('\u0255'));
        f.add(Character.valueOf('\u0256'));
        f.add(Character.valueOf('\u0257'));
        f.add(Character.valueOf('\u0258'));
        f.add(Character.valueOf('\u0259'));
        f.add(Character.valueOf('\u025a'));
        f.add(Character.valueOf('\u025b'));
        f.add(Character.valueOf('\u025c'));
        f.add(Character.valueOf('\u025d'));
        f.add(Character.valueOf('\u025e'));
        f.add(Character.valueOf('\u025f'));
        f.add(Character.valueOf('\u0260'));
        f.add(Character.valueOf('\u0261'));
        f.add(Character.valueOf('\u0262'));
        f.add(Character.valueOf('\u0263'));
        f.add(Character.valueOf('\u0264'));
        f.add(Character.valueOf('\u0265'));
        f.add(Character.valueOf('\u0266'));
        f.add(Character.valueOf('\u0267'));
        f.add(Character.valueOf('\u0268'));
        f.add(Character.valueOf('\u0269'));
        f.add(Character.valueOf('\u026a'));
        f.add(Character.valueOf('\u026b'));
        f.add(Character.valueOf('\u026c'));
        f.add(Character.valueOf('\u026d'));
        f.add(Character.valueOf('\u026e'));
        f.add(Character.valueOf('\u026f'));
        f.add(Character.valueOf('\u0270'));
        f.add(Character.valueOf('\u0271'));
        f.add(Character.valueOf('\u0272'));
        f.add(Character.valueOf('\u0273'));
        f.add(Character.valueOf('\u0274'));
        f.add(Character.valueOf('\u0275'));
        f.add(Character.valueOf('\u0276'));
        f.add(Character.valueOf('\u0277'));
        f.add(Character.valueOf('\u0278'));
        f.add(Character.valueOf('\u0279'));
        f.add(Character.valueOf('\u027a'));
        f.add(Character.valueOf('\u027b'));
        f.add(Character.valueOf('\u027c'));
        f.add(Character.valueOf('\u027d'));
        f.add(Character.valueOf('\u027e'));
        f.add(Character.valueOf('\u027f'));
        f.add(Character.valueOf('\u0280'));
        f.add(Character.valueOf('\u0281'));
        f.add(Character.valueOf('\u0282'));
        f.add(Character.valueOf('\u0283'));
        f.add(Character.valueOf('\u0284'));
        f.add(Character.valueOf('\u0285'));
        f.add(Character.valueOf('\u0286'));
        f.add(Character.valueOf('\u0287'));
        f.add(Character.valueOf('\u0288'));
        f.add(Character.valueOf('\u0289'));
        f.add(Character.valueOf('\u028a'));
        f.add(Character.valueOf('\u028b'));
        f.add(Character.valueOf('\u028c'));
        f.add(Character.valueOf('\u028d'));
        f.add(Character.valueOf('\u028e'));
        f.add(Character.valueOf('\u028f'));
        f.add(Character.valueOf('\u0290'));
        f.add(Character.valueOf('\u0291'));
        f.add(Character.valueOf('\u0292'));
        f.add(Character.valueOf('\u0293'));
        f.add(Character.valueOf('\u0294'));
        f.add(Character.valueOf('\u0295'));
        f.add(Character.valueOf('\u0296'));
        f.add(Character.valueOf('\u0297'));
        f.add(Character.valueOf('\u0298'));
        f.add(Character.valueOf('\u0299'));
        f.add(Character.valueOf('\u029a'));
        f.add(Character.valueOf('\u029b'));
        f.add(Character.valueOf('\u029c'));
        f.add(Character.valueOf('\u029d'));
        f.add(Character.valueOf('\u029e'));
        f.add(Character.valueOf('\u029f'));
        f.add(Character.valueOf('\u02a0'));
        f.add(Character.valueOf('\u02a1'));
        f.add(Character.valueOf('\u02a2'));
        f.add(Character.valueOf('\u02a3'));
        f.add(Character.valueOf('\u02a4'));
        f.add(Character.valueOf('\u02a5'));
        f.add(Character.valueOf('\u02a6'));
        f.add(Character.valueOf('\u02a7'));
        f.add(Character.valueOf('\u02a8'));
        f.add(Character.valueOf('\u02b0'));
        f.add(Character.valueOf('\u02b1'));
        f.add(Character.valueOf('\u02b2'));
        f.add(Character.valueOf('\u02b3'));
        f.add(Character.valueOf('\u02b4'));
        f.add(Character.valueOf('\u02b5'));
        f.add(Character.valueOf('\u02b6'));
        f.add(Character.valueOf('\u02b7'));
        f.add(Character.valueOf('\u02b8'));
        f.add(Character.valueOf('\u02bb'));
        f.add(Character.valueOf('\u02bc'));
        f.add(Character.valueOf('\u02bd'));
        f.add(Character.valueOf('\u02be'));
        f.add(Character.valueOf('\u02bf'));
        f.add(Character.valueOf('\u02c0'));
        f.add(Character.valueOf('\u02c1'));
        f.add(Character.valueOf('\u02d0'));
        f.add(Character.valueOf('\u02d1'));
        f.add(Character.valueOf('\u02e0'));
        f.add(Character.valueOf('\u02e1'));
        f.add(Character.valueOf('\u02e2'));
        f.add(Character.valueOf('\u02e3'));
        f.add(Character.valueOf('\u02e4'));
        f.add(Character.valueOf('\u037a'));
        f.add(Character.valueOf('\u0386'));
        f.add(Character.valueOf('\u0388'));
        f.add(Character.valueOf('\u0389'));
        f.add(Character.valueOf('\u038a'));
        f.add(Character.valueOf('\u038c'));
        f.add(Character.valueOf('\u038e'));
        f.add(Character.valueOf('\u038f'));
        f.add(Character.valueOf('\u0390'));
        f.add(Character.valueOf('\u0391'));
        f.add(Character.valueOf('\u0392'));
        f.add(Character.valueOf('\u0393'));
        f.add(Character.valueOf('\u0394'));
        f.add(Character.valueOf('\u0395'));
        f.add(Character.valueOf('\u0396'));
        f.add(Character.valueOf('\u0397'));
        f.add(Character.valueOf('\u0398'));
        f.add(Character.valueOf('\u0399'));
        f.add(Character.valueOf('\u039a'));
        f.add(Character.valueOf('\u039b'));
        f.add(Character.valueOf('\u039c'));
        f.add(Character.valueOf('\u039d'));
        f.add(Character.valueOf('\u039e'));
        f.add(Character.valueOf('\u039f'));
        f.add(Character.valueOf('\u03a0'));
        f.add(Character.valueOf('\u03a1'));
        f.add(Character.valueOf('\u03a3'));
        f.add(Character.valueOf('\u03a4'));
        f.add(Character.valueOf('\u03a5'));
        f.add(Character.valueOf('\u03a6'));
        f.add(Character.valueOf('\u03a7'));
        f.add(Character.valueOf('\u03a8'));
        f.add(Character.valueOf('\u03a9'));
        f.add(Character.valueOf('\u03aa'));
        f.add(Character.valueOf('\u03ab'));
        f.add(Character.valueOf('\u03ac'));
        f.add(Character.valueOf('\u03ad'));
        f.add(Character.valueOf('\u03ae'));
        f.add(Character.valueOf('\u03af'));
        f.add(Character.valueOf('\u03b0'));
        f.add(Character.valueOf('\u03b1'));
        f.add(Character.valueOf('\u03b2'));
        f.add(Character.valueOf('\u03b3'));
        f.add(Character.valueOf('\u03b4'));
        f.add(Character.valueOf('\u03b5'));
        f.add(Character.valueOf('\u03b6'));
        f.add(Character.valueOf('\u03b7'));
        f.add(Character.valueOf('\u03b8'));
        f.add(Character.valueOf('\u03b9'));
        f.add(Character.valueOf('\u03ba'));
        f.add(Character.valueOf('\u03bb'));
        f.add(Character.valueOf('\u03bc'));
        f.add(Character.valueOf('\u03bd'));
        f.add(Character.valueOf('\u03be'));
        f.add(Character.valueOf('\u03bf'));
        f.add(Character.valueOf('\u03c0'));
        f.add(Character.valueOf('\u03c1'));
        f.add(Character.valueOf('\u03c2'));
        f.add(Character.valueOf('\u03c3'));
        f.add(Character.valueOf('\u03c4'));
        f.add(Character.valueOf('\u03c5'));
        f.add(Character.valueOf('\u03c6'));
        f.add(Character.valueOf('\u03c7'));
        f.add(Character.valueOf('\u03c8'));
        f.add(Character.valueOf('\u03c9'));
        f.add(Character.valueOf('\u03ca'));
        f.add(Character.valueOf('\u03cb'));
        f.add(Character.valueOf('\u03cc'));
        f.add(Character.valueOf('\u03cd'));
        f.add(Character.valueOf('\u03ce'));
        f.add(Character.valueOf('\u03d0'));
        f.add(Character.valueOf('\u03d1'));
        f.add(Character.valueOf('\u03d2'));
        f.add(Character.valueOf('\u03d3'));
        f.add(Character.valueOf('\u03d4'));
        f.add(Character.valueOf('\u03d5'));
        f.add(Character.valueOf('\u03d6'));
        f.add(Character.valueOf('\u03da'));
        f.add(Character.valueOf('\u03dc'));
        f.add(Character.valueOf('\u03de'));
        f.add(Character.valueOf('\u03e0'));
        f.add(Character.valueOf('\u03e2'));
        f.add(Character.valueOf('\u03e3'));
        f.add(Character.valueOf('\u03e4'));
        f.add(Character.valueOf('\u03e5'));
        f.add(Character.valueOf('\u03e6'));
        f.add(Character.valueOf('\u03e7'));
        f.add(Character.valueOf('\u03e8'));
        f.add(Character.valueOf('\u03e9'));
        f.add(Character.valueOf('\u03ea'));
        f.add(Character.valueOf('\u03eb'));
        f.add(Character.valueOf('\u03ec'));
        f.add(Character.valueOf('\u03ed'));
        f.add(Character.valueOf('\u03ee'));
        f.add(Character.valueOf('\u03ef'));
        f.add(Character.valueOf('\u03f0'));
        f.add(Character.valueOf('\u03f1'));
        f.add(Character.valueOf('\u03f2'));
        f.add(Character.valueOf('\u03f3'));
        f.add(Character.valueOf('\u0401'));
        f.add(Character.valueOf('\u0402'));
        f.add(Character.valueOf('\u0403'));
        f.add(Character.valueOf('\u0404'));
        f.add(Character.valueOf('\u0405'));
        f.add(Character.valueOf('\u0406'));
        f.add(Character.valueOf('\u0407'));
        f.add(Character.valueOf('\u0408'));
        f.add(Character.valueOf('\u0409'));
        f.add(Character.valueOf('\u040a'));
        f.add(Character.valueOf('\u040b'));
        f.add(Character.valueOf('\u040c'));
        f.add(Character.valueOf('\u040e'));
        f.add(Character.valueOf('\u040f'));
        f.add(Character.valueOf('\u0410'));
        f.add(Character.valueOf('\u0411'));
        f.add(Character.valueOf('\u0412'));
        f.add(Character.valueOf('\u0413'));
        f.add(Character.valueOf('\u0414'));
        f.add(Character.valueOf('\u0415'));
        f.add(Character.valueOf('\u0416'));
        f.add(Character.valueOf('\u0417'));
        f.add(Character.valueOf('\u0418'));
        f.add(Character.valueOf('\u0419'));
        f.add(Character.valueOf('\u041a'));
        f.add(Character.valueOf('\u041b'));
        f.add(Character.valueOf('\u041c'));
        f.add(Character.valueOf('\u041d'));
        f.add(Character.valueOf('\u041e'));
        f.add(Character.valueOf('\u041f'));
        f.add(Character.valueOf('\u0420'));
        f.add(Character.valueOf('\u0421'));
        f.add(Character.valueOf('\u0422'));
        f.add(Character.valueOf('\u0423'));
        f.add(Character.valueOf('\u0424'));
        f.add(Character.valueOf('\u0425'));
        f.add(Character.valueOf('\u0426'));
        f.add(Character.valueOf('\u0427'));
        f.add(Character.valueOf('\u0428'));
        f.add(Character.valueOf('\u0429'));
        f.add(Character.valueOf('\u042a'));
        f.add(Character.valueOf('\u042b'));
        f.add(Character.valueOf('\u042c'));
        f.add(Character.valueOf('\u042d'));
        f.add(Character.valueOf('\u042e'));
        f.add(Character.valueOf('\u042f'));
        f.add(Character.valueOf('\u0430'));
        f.add(Character.valueOf('\u0431'));
        f.add(Character.valueOf('\u0432'));
        f.add(Character.valueOf('\u0433'));
        f.add(Character.valueOf('\u0434'));
        f.add(Character.valueOf('\u0435'));
        f.add(Character.valueOf('\u0436'));
        f.add(Character.valueOf('\u0437'));
        f.add(Character.valueOf('\u0438'));
        f.add(Character.valueOf('\u0439'));
        f.add(Character.valueOf('\u043a'));
        f.add(Character.valueOf('\u043b'));
        f.add(Character.valueOf('\u043c'));
        f.add(Character.valueOf('\u043d'));
        f.add(Character.valueOf('\u043e'));
        f.add(Character.valueOf('\u043f'));
        f.add(Character.valueOf('\u0440'));
        f.add(Character.valueOf('\u0441'));
        f.add(Character.valueOf('\u0442'));
        f.add(Character.valueOf('\u0443'));
        f.add(Character.valueOf('\u0444'));
        f.add(Character.valueOf('\u0445'));
        f.add(Character.valueOf('\u0446'));
        f.add(Character.valueOf('\u0447'));
        f.add(Character.valueOf('\u0448'));
        f.add(Character.valueOf('\u0449'));
        f.add(Character.valueOf('\u044a'));
        f.add(Character.valueOf('\u044b'));
        f.add(Character.valueOf('\u044c'));
        f.add(Character.valueOf('\u044d'));
        f.add(Character.valueOf('\u044e'));
        f.add(Character.valueOf('\u044f'));
        f.add(Character.valueOf('\u0451'));
        f.add(Character.valueOf('\u0452'));
        f.add(Character.valueOf('\u0453'));
        f.add(Character.valueOf('\u0454'));
        f.add(Character.valueOf('\u0455'));
        f.add(Character.valueOf('\u0456'));
        f.add(Character.valueOf('\u0457'));
        f.add(Character.valueOf('\u0458'));
        f.add(Character.valueOf('\u0459'));
        f.add(Character.valueOf('\u045a'));
        f.add(Character.valueOf('\u045b'));
        f.add(Character.valueOf('\u045c'));
        f.add(Character.valueOf('\u045e'));
        f.add(Character.valueOf('\u045f'));
        f.add(Character.valueOf('\u0460'));
        f.add(Character.valueOf('\u0461'));
        f.add(Character.valueOf('\u0462'));
        f.add(Character.valueOf('\u0463'));
        f.add(Character.valueOf('\u0464'));
        f.add(Character.valueOf('\u0465'));
        f.add(Character.valueOf('\u0466'));
        f.add(Character.valueOf('\u0467'));
        f.add(Character.valueOf('\u0468'));
        f.add(Character.valueOf('\u0469'));
        f.add(Character.valueOf('\u046a'));
        f.add(Character.valueOf('\u046b'));
        f.add(Character.valueOf('\u046c'));
        f.add(Character.valueOf('\u046d'));
        f.add(Character.valueOf('\u046e'));
        f.add(Character.valueOf('\u046f'));
        f.add(Character.valueOf('\u0470'));
        f.add(Character.valueOf('\u0471'));
        f.add(Character.valueOf('\u0472'));
        f.add(Character.valueOf('\u0473'));
        f.add(Character.valueOf('\u0474'));
        f.add(Character.valueOf('\u0475'));
        f.add(Character.valueOf('\u0476'));
        f.add(Character.valueOf('\u0477'));
        f.add(Character.valueOf('\u0478'));
        f.add(Character.valueOf('\u0479'));
        f.add(Character.valueOf('\u047a'));
        f.add(Character.valueOf('\u047b'));
        f.add(Character.valueOf('\u047c'));
        f.add(Character.valueOf('\u047d'));
        f.add(Character.valueOf('\u047e'));
        f.add(Character.valueOf('\u047f'));
        f.add(Character.valueOf('\u0480'));
        f.add(Character.valueOf('\u0481'));
        f.add(Character.valueOf('\u0490'));
        f.add(Character.valueOf('\u0491'));
        f.add(Character.valueOf('\u0492'));
        f.add(Character.valueOf('\u0493'));
        f.add(Character.valueOf('\u0494'));
        f.add(Character.valueOf('\u0495'));
        f.add(Character.valueOf('\u0496'));
        f.add(Character.valueOf('\u0497'));
        f.add(Character.valueOf('\u0498'));
        f.add(Character.valueOf('\u0499'));
        f.add(Character.valueOf('\u049a'));
        f.add(Character.valueOf('\u049b'));
        f.add(Character.valueOf('\u049c'));
        f.add(Character.valueOf('\u049d'));
        f.add(Character.valueOf('\u049e'));
        f.add(Character.valueOf('\u049f'));
        f.add(Character.valueOf('\u04a0'));
        f.add(Character.valueOf('\u04a1'));
        f.add(Character.valueOf('\u04a2'));
        f.add(Character.valueOf('\u04a3'));
        f.add(Character.valueOf('\u04a4'));
        f.add(Character.valueOf('\u04a5'));
        f.add(Character.valueOf('\u04a6'));
        f.add(Character.valueOf('\u04a7'));
        f.add(Character.valueOf('\u04a8'));
        f.add(Character.valueOf('\u04a9'));
        f.add(Character.valueOf('\u04aa'));
        f.add(Character.valueOf('\u04ab'));
        f.add(Character.valueOf('\u04ac'));
        f.add(Character.valueOf('\u04ad'));
        f.add(Character.valueOf('\u04ae'));
        f.add(Character.valueOf('\u04af'));
        f.add(Character.valueOf('\u04b0'));
        f.add(Character.valueOf('\u04b1'));
        f.add(Character.valueOf('\u04b2'));
        f.add(Character.valueOf('\u04b3'));
        f.add(Character.valueOf('\u04b4'));
        f.add(Character.valueOf('\u04b5'));
        f.add(Character.valueOf('\u04b6'));
        f.add(Character.valueOf('\u04b7'));
        f.add(Character.valueOf('\u04b8'));
        f.add(Character.valueOf('\u04b9'));
        f.add(Character.valueOf('\u04ba'));
        f.add(Character.valueOf('\u04bb'));
        f.add(Character.valueOf('\u04bc'));
        f.add(Character.valueOf('\u04bd'));
        f.add(Character.valueOf('\u04be'));
        f.add(Character.valueOf('\u04bf'));
        f.add(Character.valueOf('\u04c0'));
        f.add(Character.valueOf('\u04c1'));
        f.add(Character.valueOf('\u04c2'));
        f.add(Character.valueOf('\u04c3'));
        f.add(Character.valueOf('\u04c4'));
        f.add(Character.valueOf('\u04c7'));
        f.add(Character.valueOf('\u04c8'));
        f.add(Character.valueOf('\u04cb'));
        f.add(Character.valueOf('\u04cc'));
        f.add(Character.valueOf('\u04d0'));
        f.add(Character.valueOf('\u04d1'));
        f.add(Character.valueOf('\u04d2'));
        f.add(Character.valueOf('\u04d3'));
        f.add(Character.valueOf('\u04d4'));
        f.add(Character.valueOf('\u04d5'));
        f.add(Character.valueOf('\u04d6'));
        f.add(Character.valueOf('\u04d7'));
        f.add(Character.valueOf('\u04d8'));
        f.add(Character.valueOf('\u04d9'));
        f.add(Character.valueOf('\u04da'));
        f.add(Character.valueOf('\u04db'));
        f.add(Character.valueOf('\u04dc'));
        f.add(Character.valueOf('\u04dd'));
        f.add(Character.valueOf('\u04de'));
        f.add(Character.valueOf('\u04df'));
        f.add(Character.valueOf('\u04e0'));
        f.add(Character.valueOf('\u04e1'));
        f.add(Character.valueOf('\u04e2'));
        f.add(Character.valueOf('\u04e3'));
        f.add(Character.valueOf('\u04e4'));
        f.add(Character.valueOf('\u04e5'));
        f.add(Character.valueOf('\u04e6'));
        f.add(Character.valueOf('\u04e7'));
        f.add(Character.valueOf('\u04e8'));
        f.add(Character.valueOf('\u04e9'));
        f.add(Character.valueOf('\u04ea'));
        f.add(Character.valueOf('\u04eb'));
        f.add(Character.valueOf('\u04ee'));
        f.add(Character.valueOf('\u04ef'));
        f.add(Character.valueOf('\u04f0'));
        f.add(Character.valueOf('\u04f1'));
        f.add(Character.valueOf('\u04f2'));
        f.add(Character.valueOf('\u04f3'));
        f.add(Character.valueOf('\u04f4'));
        f.add(Character.valueOf('\u04f5'));
        f.add(Character.valueOf('\u04f8'));
        f.add(Character.valueOf('\u04f9'));
        f.add(Character.valueOf('\u0531'));
        f.add(Character.valueOf('\u0532'));
        f.add(Character.valueOf('\u0533'));
        f.add(Character.valueOf('\u0534'));
        f.add(Character.valueOf('\u0535'));
        f.add(Character.valueOf('\u0536'));
        f.add(Character.valueOf('\u0537'));
        f.add(Character.valueOf('\u0538'));
        f.add(Character.valueOf('\u0539'));
        f.add(Character.valueOf('\u053a'));
        f.add(Character.valueOf('\u053b'));
        f.add(Character.valueOf('\u053c'));
        f.add(Character.valueOf('\u053d'));
        f.add(Character.valueOf('\u053e'));
        f.add(Character.valueOf('\u053f'));
        f.add(Character.valueOf('\u0540'));
        f.add(Character.valueOf('\u0541'));
        f.add(Character.valueOf('\u0542'));
        f.add(Character.valueOf('\u0543'));
        f.add(Character.valueOf('\u0544'));
        f.add(Character.valueOf('\u0545'));
        f.add(Character.valueOf('\u0546'));
        f.add(Character.valueOf('\u0547'));
        f.add(Character.valueOf('\u0548'));
        f.add(Character.valueOf('\u0549'));
        f.add(Character.valueOf('\u054a'));
        f.add(Character.valueOf('\u054b'));
        f.add(Character.valueOf('\u054c'));
        f.add(Character.valueOf('\u054d'));
        f.add(Character.valueOf('\u054e'));
        f.add(Character.valueOf('\u054f'));
        f.add(Character.valueOf('\u0550'));
        f.add(Character.valueOf('\u0551'));
        f.add(Character.valueOf('\u0552'));
        f.add(Character.valueOf('\u0553'));
        f.add(Character.valueOf('\u0554'));
        f.add(Character.valueOf('\u0555'));
        f.add(Character.valueOf('\u0556'));
        f.add(Character.valueOf('\u0559'));
        f.add(Character.valueOf('\u0561'));
        f.add(Character.valueOf('\u0562'));
        f.add(Character.valueOf('\u0563'));
        f.add(Character.valueOf('\u0564'));
        f.add(Character.valueOf('\u0565'));
        f.add(Character.valueOf('\u0566'));
        f.add(Character.valueOf('\u0567'));
        f.add(Character.valueOf('\u0568'));
        f.add(Character.valueOf('\u0569'));
        f.add(Character.valueOf('\u056a'));
        f.add(Character.valueOf('\u056b'));
        f.add(Character.valueOf('\u056c'));
        f.add(Character.valueOf('\u056d'));
        f.add(Character.valueOf('\u056e'));
        f.add(Character.valueOf('\u056f'));
        f.add(Character.valueOf('\u0570'));
        f.add(Character.valueOf('\u0571'));
        f.add(Character.valueOf('\u0572'));
        f.add(Character.valueOf('\u0573'));
        f.add(Character.valueOf('\u0574'));
        f.add(Character.valueOf('\u0575'));
        f.add(Character.valueOf('\u0576'));
        f.add(Character.valueOf('\u0577'));
        f.add(Character.valueOf('\u0578'));
        f.add(Character.valueOf('\u0579'));
        f.add(Character.valueOf('\u057a'));
        f.add(Character.valueOf('\u057b'));
        f.add(Character.valueOf('\u057c'));
        f.add(Character.valueOf('\u057d'));
        f.add(Character.valueOf('\u057e'));
        f.add(Character.valueOf('\u057f'));
        f.add(Character.valueOf('\u0580'));
        f.add(Character.valueOf('\u0581'));
        f.add(Character.valueOf('\u0582'));
        f.add(Character.valueOf('\u0583'));
        f.add(Character.valueOf('\u0584'));
        f.add(Character.valueOf('\u0585'));
        f.add(Character.valueOf('\u0586'));
        f.add(Character.valueOf('\u0587'));
        f.add(Character.valueOf('\u05d0'));
        f.add(Character.valueOf('\u05d1'));
        f.add(Character.valueOf('\u05d2'));
        f.add(Character.valueOf('\u05d3'));
        f.add(Character.valueOf('\u05d4'));
        f.add(Character.valueOf('\u05d5'));
        f.add(Character.valueOf('\u05d6'));
        f.add(Character.valueOf('\u05d7'));
        f.add(Character.valueOf('\u05d8'));
        f.add(Character.valueOf('\u05d9'));
        f.add(Character.valueOf('\u05da'));
        f.add(Character.valueOf('\u05db'));
        f.add(Character.valueOf('\u05dc'));
        f.add(Character.valueOf('\u05dd'));
        f.add(Character.valueOf('\u05de'));
        f.add(Character.valueOf('\u05df'));
        f.add(Character.valueOf('\u05e0'));
        f.add(Character.valueOf('\u05e1'));
        f.add(Character.valueOf('\u05e2'));
        f.add(Character.valueOf('\u05e3'));
        f.add(Character.valueOf('\u05e4'));
        f.add(Character.valueOf('\u05e5'));
        f.add(Character.valueOf('\u05e6'));
        f.add(Character.valueOf('\u05e7'));
        f.add(Character.valueOf('\u05e8'));
        f.add(Character.valueOf('\u05e9'));
        f.add(Character.valueOf('\u05ea'));
        f.add(Character.valueOf('\u05f0'));
        f.add(Character.valueOf('\u05f1'));
        f.add(Character.valueOf('\u05f2'));
        f.add(Character.valueOf('\u0621'));
        f.add(Character.valueOf('\u0622'));
        f.add(Character.valueOf('\u0623'));
        f.add(Character.valueOf('\u0624'));
        f.add(Character.valueOf('\u0625'));
        f.add(Character.valueOf('\u0626'));
        f.add(Character.valueOf('\u0627'));
        f.add(Character.valueOf('\u0628'));
        f.add(Character.valueOf('\u0629'));
        f.add(Character.valueOf('\u062a'));
        f.add(Character.valueOf('\u062b'));
        f.add(Character.valueOf('\u062c'));
        f.add(Character.valueOf('\u062d'));
        f.add(Character.valueOf('\u062e'));
        f.add(Character.valueOf('\u062f'));
        f.add(Character.valueOf('\u0630'));
        f.add(Character.valueOf('\u0631'));
        f.add(Character.valueOf('\u0632'));
        f.add(Character.valueOf('\u0633'));
        f.add(Character.valueOf('\u0634'));
        f.add(Character.valueOf('\u0635'));
        f.add(Character.valueOf('\u0636'));
        f.add(Character.valueOf('\u0637'));
        f.add(Character.valueOf('\u0638'));
        f.add(Character.valueOf('\u0639'));
        f.add(Character.valueOf('\u063a'));
        f.add(Character.valueOf('\u0640'));
        f.add(Character.valueOf('\u0641'));
        f.add(Character.valueOf('\u0642'));
        f.add(Character.valueOf('\u0643'));
        f.add(Character.valueOf('\u0644'));
        f.add(Character.valueOf('\u0645'));
        f.add(Character.valueOf('\u0646'));
        f.add(Character.valueOf('\u0647'));
        f.add(Character.valueOf('\u0648'));
        f.add(Character.valueOf('\u0649'));
        f.add(Character.valueOf('\u064a'));
        f.add(Character.valueOf('\u0671'));
        f.add(Character.valueOf('\u0672'));
        f.add(Character.valueOf('\u0673'));
        f.add(Character.valueOf('\u0674'));
        f.add(Character.valueOf('\u0675'));
        f.add(Character.valueOf('\u0676'));
        f.add(Character.valueOf('\u0677'));
        f.add(Character.valueOf('\u0678'));
        f.add(Character.valueOf('\u0679'));
        f.add(Character.valueOf('\u067a'));
        f.add(Character.valueOf('\u067b'));
        f.add(Character.valueOf('\u067c'));
        f.add(Character.valueOf('\u067d'));
        f.add(Character.valueOf('\u067e'));
        f.add(Character.valueOf('\u067f'));
        f.add(Character.valueOf('\u0680'));
        f.add(Character.valueOf('\u0681'));
        f.add(Character.valueOf('\u0682'));
        f.add(Character.valueOf('\u0683'));
        f.add(Character.valueOf('\u0684'));
        f.add(Character.valueOf('\u0685'));
        f.add(Character.valueOf('\u0686'));
        f.add(Character.valueOf('\u0687'));
        f.add(Character.valueOf('\u0688'));
        f.add(Character.valueOf('\u0689'));
        f.add(Character.valueOf('\u068a'));
        f.add(Character.valueOf('\u068b'));
        f.add(Character.valueOf('\u068c'));
        f.add(Character.valueOf('\u068d'));
        f.add(Character.valueOf('\u068e'));
        f.add(Character.valueOf('\u068f'));
        f.add(Character.valueOf('\u0690'));
        f.add(Character.valueOf('\u0691'));
        f.add(Character.valueOf('\u0692'));
        f.add(Character.valueOf('\u0693'));
        f.add(Character.valueOf('\u0694'));
        f.add(Character.valueOf('\u0695'));
        f.add(Character.valueOf('\u0696'));
        f.add(Character.valueOf('\u0697'));
        f.add(Character.valueOf('\u0698'));
        f.add(Character.valueOf('\u0699'));
        f.add(Character.valueOf('\u069a'));
        f.add(Character.valueOf('\u069b'));
        f.add(Character.valueOf('\u069c'));
        f.add(Character.valueOf('\u069d'));
        f.add(Character.valueOf('\u069e'));
        f.add(Character.valueOf('\u069f'));
        f.add(Character.valueOf('\u06a0'));
        f.add(Character.valueOf('\u06a1'));
        f.add(Character.valueOf('\u06a2'));
        f.add(Character.valueOf('\u06a3'));
        f.add(Character.valueOf('\u06a4'));
        f.add(Character.valueOf('\u06a5'));
        f.add(Character.valueOf('\u06a6'));
        f.add(Character.valueOf('\u06a7'));
        f.add(Character.valueOf('\u06a8'));
        f.add(Character.valueOf('\u06a9'));
        f.add(Character.valueOf('\u06aa'));
        f.add(Character.valueOf('\u06ab'));
        f.add(Character.valueOf('\u06ac'));
        f.add(Character.valueOf('\u06ad'));
        f.add(Character.valueOf('\u06ae'));
        f.add(Character.valueOf('\u06af'));
        f.add(Character.valueOf('\u06b0'));
        f.add(Character.valueOf('\u06b1'));
        f.add(Character.valueOf('\u06b2'));
        f.add(Character.valueOf('\u06b3'));
        f.add(Character.valueOf('\u06b4'));
        f.add(Character.valueOf('\u06b5'));
        f.add(Character.valueOf('\u06b6'));
        f.add(Character.valueOf('\u06b7'));
        f.add(Character.valueOf('\u06ba'));
        f.add(Character.valueOf('\u06bb'));
        f.add(Character.valueOf('\u06bc'));
        f.add(Character.valueOf('\u06bd'));
        f.add(Character.valueOf('\u06be'));
        f.add(Character.valueOf('\u06c0'));
        f.add(Character.valueOf('\u06c1'));
        f.add(Character.valueOf('\u06c2'));
        f.add(Character.valueOf('\u06c3'));
        f.add(Character.valueOf('\u06c4'));
        f.add(Character.valueOf('\u06c5'));
        f.add(Character.valueOf('\u06c6'));
        f.add(Character.valueOf('\u06c7'));
        f.add(Character.valueOf('\u06c8'));
        f.add(Character.valueOf('\u06c9'));
        f.add(Character.valueOf('\u06ca'));
        f.add(Character.valueOf('\u06cb'));
        f.add(Character.valueOf('\u06cc'));
        f.add(Character.valueOf('\u06cd'));
        f.add(Character.valueOf('\u06ce'));
        f.add(Character.valueOf('\u06d0'));
        f.add(Character.valueOf('\u06d1'));
        f.add(Character.valueOf('\u06d2'));
        f.add(Character.valueOf('\u06d3'));
        f.add(Character.valueOf('\u06d5'));
        f.add(Character.valueOf('\u06e5'));
        f.add(Character.valueOf('\u06e6'));
        f.add(Character.valueOf('\u0905'));
        f.add(Character.valueOf('\u0906'));
        f.add(Character.valueOf('\u0907'));
        f.add(Character.valueOf('\u0908'));
        f.add(Character.valueOf('\u0909'));
        f.add(Character.valueOf('\u090a'));
        f.add(Character.valueOf('\u090b'));
        f.add(Character.valueOf('\u090c'));
        f.add(Character.valueOf('\u090d'));
        f.add(Character.valueOf('\u090e'));
        f.add(Character.valueOf('\u090f'));
        f.add(Character.valueOf('\u0910'));
        f.add(Character.valueOf('\u0911'));
        f.add(Character.valueOf('\u0912'));
        f.add(Character.valueOf('\u0913'));
        f.add(Character.valueOf('\u0914'));
        f.add(Character.valueOf('\u0915'));
        f.add(Character.valueOf('\u0916'));
        f.add(Character.valueOf('\u0917'));
        f.add(Character.valueOf('\u0918'));
        f.add(Character.valueOf('\u0919'));
        f.add(Character.valueOf('\u091a'));
        f.add(Character.valueOf('\u091b'));
        f.add(Character.valueOf('\u091c'));
        f.add(Character.valueOf('\u091d'));
        f.add(Character.valueOf('\u091e'));
        f.add(Character.valueOf('\u091f'));
        f.add(Character.valueOf('\u0920'));
        f.add(Character.valueOf('\u0921'));
        f.add(Character.valueOf('\u0922'));
        f.add(Character.valueOf('\u0923'));
        f.add(Character.valueOf('\u0924'));
        f.add(Character.valueOf('\u0925'));
        f.add(Character.valueOf('\u0926'));
        f.add(Character.valueOf('\u0927'));
        f.add(Character.valueOf('\u0928'));
        f.add(Character.valueOf('\u0929'));
        f.add(Character.valueOf('\u092a'));
        f.add(Character.valueOf('\u092b'));
        f.add(Character.valueOf('\u092c'));
        f.add(Character.valueOf('\u092d'));
        f.add(Character.valueOf('\u092e'));
        f.add(Character.valueOf('\u092f'));
        f.add(Character.valueOf('\u0930'));
        f.add(Character.valueOf('\u0931'));
        f.add(Character.valueOf('\u0932'));
        f.add(Character.valueOf('\u0933'));
        f.add(Character.valueOf('\u0934'));
        f.add(Character.valueOf('\u0935'));
        f.add(Character.valueOf('\u0936'));
        f.add(Character.valueOf('\u0937'));
        f.add(Character.valueOf('\u0938'));
        f.add(Character.valueOf('\u0939'));
        f.add(Character.valueOf('\u093d'));
        f.add(Character.valueOf('\u0958'));
        f.add(Character.valueOf('\u0959'));
        f.add(Character.valueOf('\u095a'));
        f.add(Character.valueOf('\u095b'));
        f.add(Character.valueOf('\u095c'));
        f.add(Character.valueOf('\u095d'));
        f.add(Character.valueOf('\u095e'));
        f.add(Character.valueOf('\u095f'));
        f.add(Character.valueOf('\u0960'));
        f.add(Character.valueOf('\u0961'));
        f.add(Character.valueOf('\u0985'));
        f.add(Character.valueOf('\u0986'));
        f.add(Character.valueOf('\u0987'));
        f.add(Character.valueOf('\u0988'));
        f.add(Character.valueOf('\u0989'));
        f.add(Character.valueOf('\u098a'));
        f.add(Character.valueOf('\u098b'));
        f.add(Character.valueOf('\u098c'));
        f.add(Character.valueOf('\u098f'));
        f.add(Character.valueOf('\u0990'));
        f.add(Character.valueOf('\u0993'));
        f.add(Character.valueOf('\u0994'));
        f.add(Character.valueOf('\u0995'));
        f.add(Character.valueOf('\u0996'));
        f.add(Character.valueOf('\u0997'));
        f.add(Character.valueOf('\u0998'));
        f.add(Character.valueOf('\u0999'));
        f.add(Character.valueOf('\u099a'));
        f.add(Character.valueOf('\u099b'));
        f.add(Character.valueOf('\u099c'));
        f.add(Character.valueOf('\u099d'));
        f.add(Character.valueOf('\u099e'));
        f.add(Character.valueOf('\u099f'));
        f.add(Character.valueOf('\u09a0'));
        f.add(Character.valueOf('\u09a1'));
        f.add(Character.valueOf('\u09a2'));
        f.add(Character.valueOf('\u09a3'));
        f.add(Character.valueOf('\u09a4'));
        f.add(Character.valueOf('\u09a5'));
        f.add(Character.valueOf('\u09a6'));
        f.add(Character.valueOf('\u09a7'));
        f.add(Character.valueOf('\u09a8'));
        f.add(Character.valueOf('\u09aa'));
        f.add(Character.valueOf('\u09ab'));
        f.add(Character.valueOf('\u09ac'));
        f.add(Character.valueOf('\u09ad'));
        f.add(Character.valueOf('\u09ae'));
        f.add(Character.valueOf('\u09af'));
        f.add(Character.valueOf('\u09b0'));
        f.add(Character.valueOf('\u09b2'));
        f.add(Character.valueOf('\u09b6'));
        f.add(Character.valueOf('\u09b7'));
        f.add(Character.valueOf('\u09b8'));
        f.add(Character.valueOf('\u09b9'));
        f.add(Character.valueOf('\u09dc'));
        f.add(Character.valueOf('\u09dd'));
        f.add(Character.valueOf('\u09df'));
        f.add(Character.valueOf('\u09e0'));
        f.add(Character.valueOf('\u09e1'));
        f.add(Character.valueOf('\u09f0'));
        f.add(Character.valueOf('\u09f1'));
        f.add(Character.valueOf('\u0a05'));
        f.add(Character.valueOf('\u0a06'));
        f.add(Character.valueOf('\u0a07'));
        f.add(Character.valueOf('\u0a08'));
        f.add(Character.valueOf('\u0a09'));
        f.add(Character.valueOf('\u0a0a'));
        f.add(Character.valueOf('\u0a0f'));
        f.add(Character.valueOf('\u0a10'));
        f.add(Character.valueOf('\u0a13'));
        f.add(Character.valueOf('\u0a14'));
        f.add(Character.valueOf('\u0a15'));
        f.add(Character.valueOf('\u0a16'));
        f.add(Character.valueOf('\u0a17'));
        f.add(Character.valueOf('\u0a18'));
        f.add(Character.valueOf('\u0a19'));
        f.add(Character.valueOf('\u0a1a'));
        f.add(Character.valueOf('\u0a1b'));
        f.add(Character.valueOf('\u0a1c'));
        f.add(Character.valueOf('\u0a1d'));
        f.add(Character.valueOf('\u0a1e'));
        f.add(Character.valueOf('\u0a1f'));
        f.add(Character.valueOf('\u0a20'));
        f.add(Character.valueOf('\u0a21'));
        f.add(Character.valueOf('\u0a22'));
        f.add(Character.valueOf('\u0a23'));
        f.add(Character.valueOf('\u0a24'));
        f.add(Character.valueOf('\u0a25'));
        f.add(Character.valueOf('\u0a26'));
        f.add(Character.valueOf('\u0a27'));
        f.add(Character.valueOf('\u0a28'));
        f.add(Character.valueOf('\u0a2a'));
        f.add(Character.valueOf('\u0a2b'));
        f.add(Character.valueOf('\u0a2c'));
        f.add(Character.valueOf('\u0a2d'));
        f.add(Character.valueOf('\u0a2e'));
        f.add(Character.valueOf('\u0a2f'));
        f.add(Character.valueOf('\u0a30'));
        f.add(Character.valueOf('\u0a32'));
        f.add(Character.valueOf('\u0a33'));
        f.add(Character.valueOf('\u0a35'));
        f.add(Character.valueOf('\u0a36'));
        f.add(Character.valueOf('\u0a38'));
        f.add(Character.valueOf('\u0a39'));
        f.add(Character.valueOf('\u0a59'));
        f.add(Character.valueOf('\u0a5a'));
        f.add(Character.valueOf('\u0a5b'));
        f.add(Character.valueOf('\u0a5c'));
        f.add(Character.valueOf('\u0a5e'));
        f.add(Character.valueOf('\u0a72'));
        f.add(Character.valueOf('\u0a73'));
        f.add(Character.valueOf('\u0a74'));
        f.add(Character.valueOf('\u0a85'));
        f.add(Character.valueOf('\u0a86'));
        f.add(Character.valueOf('\u0a87'));
        f.add(Character.valueOf('\u0a88'));
        f.add(Character.valueOf('\u0a89'));
        f.add(Character.valueOf('\u0a8a'));
        f.add(Character.valueOf('\u0a8b'));
        f.add(Character.valueOf('\u0a8d'));
        f.add(Character.valueOf('\u0a8f'));
        f.add(Character.valueOf('\u0a90'));
        f.add(Character.valueOf('\u0a91'));
        f.add(Character.valueOf('\u0a93'));
        f.add(Character.valueOf('\u0a94'));
        f.add(Character.valueOf('\u0a95'));
        f.add(Character.valueOf('\u0a96'));
        f.add(Character.valueOf('\u0a97'));
        f.add(Character.valueOf('\u0a98'));
        f.add(Character.valueOf('\u0a99'));
        f.add(Character.valueOf('\u0a9a'));
        f.add(Character.valueOf('\u0a9b'));
        f.add(Character.valueOf('\u0a9c'));
        f.add(Character.valueOf('\u0a9d'));
        f.add(Character.valueOf('\u0a9e'));
        f.add(Character.valueOf('\u0a9f'));
        f.add(Character.valueOf('\u0aa0'));
        f.add(Character.valueOf('\u0aa1'));
        f.add(Character.valueOf('\u0aa2'));
        f.add(Character.valueOf('\u0aa3'));
        f.add(Character.valueOf('\u0aa4'));
        f.add(Character.valueOf('\u0aa5'));
        f.add(Character.valueOf('\u0aa6'));
        f.add(Character.valueOf('\u0aa7'));
        f.add(Character.valueOf('\u0aa8'));
        f.add(Character.valueOf('\u0aaa'));
        f.add(Character.valueOf('\u0aab'));
        f.add(Character.valueOf('\u0aac'));
        f.add(Character.valueOf('\u0aad'));
        f.add(Character.valueOf('\u0aae'));
        f.add(Character.valueOf('\u0aaf'));
        f.add(Character.valueOf('\u0ab0'));
        f.add(Character.valueOf('\u0ab2'));
        f.add(Character.valueOf('\u0ab3'));
        f.add(Character.valueOf('\u0ab5'));
        f.add(Character.valueOf('\u0ab6'));
        f.add(Character.valueOf('\u0ab7'));
        f.add(Character.valueOf('\u0ab8'));
        f.add(Character.valueOf('\u0ab9'));
        f.add(Character.valueOf('\u0abd'));
        f.add(Character.valueOf('\u0ae0'));
        f.add(Character.valueOf('\u0b05'));
        f.add(Character.valueOf('\u0b06'));
        f.add(Character.valueOf('\u0b07'));
        f.add(Character.valueOf('\u0b08'));
        f.add(Character.valueOf('\u0b09'));
        f.add(Character.valueOf('\u0b0a'));
        f.add(Character.valueOf('\u0b0b'));
        f.add(Character.valueOf('\u0b0c'));
        f.add(Character.valueOf('\u0b0f'));
        f.add(Character.valueOf('\u0b10'));
        f.add(Character.valueOf('\u0b13'));
        f.add(Character.valueOf('\u0b14'));
        f.add(Character.valueOf('\u0b15'));
        f.add(Character.valueOf('\u0b16'));
        f.add(Character.valueOf('\u0b17'));
        f.add(Character.valueOf('\u0b18'));
        f.add(Character.valueOf('\u0b19'));
        f.add(Character.valueOf('\u0b1a'));
        f.add(Character.valueOf('\u0b1b'));
        f.add(Character.valueOf('\u0b1c'));
        f.add(Character.valueOf('\u0b1d'));
        f.add(Character.valueOf('\u0b1e'));
        f.add(Character.valueOf('\u0b1f'));
        f.add(Character.valueOf('\u0b20'));
        f.add(Character.valueOf('\u0b21'));
        f.add(Character.valueOf('\u0b22'));
        f.add(Character.valueOf('\u0b23'));
        f.add(Character.valueOf('\u0b24'));
        f.add(Character.valueOf('\u0b25'));
        f.add(Character.valueOf('\u0b26'));
        f.add(Character.valueOf('\u0b27'));
        f.add(Character.valueOf('\u0b28'));
        f.add(Character.valueOf('\u0b2a'));
        f.add(Character.valueOf('\u0b2b'));
        f.add(Character.valueOf('\u0b2c'));
        f.add(Character.valueOf('\u0b2d'));
        f.add(Character.valueOf('\u0b2e'));
        f.add(Character.valueOf('\u0b2f'));
        f.add(Character.valueOf('\u0b30'));
        f.add(Character.valueOf('\u0b32'));
        f.add(Character.valueOf('\u0b33'));
        f.add(Character.valueOf('\u0b36'));
        f.add(Character.valueOf('\u0b37'));
        f.add(Character.valueOf('\u0b38'));
        f.add(Character.valueOf('\u0b39'));
        f.add(Character.valueOf('\u0b3d'));
        f.add(Character.valueOf('\u0b5c'));
        f.add(Character.valueOf('\u0b5d'));
        f.add(Character.valueOf('\u0b5f'));
        f.add(Character.valueOf('\u0b60'));
        f.add(Character.valueOf('\u0b61'));
        f.add(Character.valueOf('\u0b85'));
        f.add(Character.valueOf('\u0b86'));
        f.add(Character.valueOf('\u0b87'));
        f.add(Character.valueOf('\u0b88'));
        f.add(Character.valueOf('\u0b89'));
        f.add(Character.valueOf('\u0b8a'));
        f.add(Character.valueOf('\u0b8e'));
        f.add(Character.valueOf('\u0b8f'));
        f.add(Character.valueOf('\u0b90'));
        f.add(Character.valueOf('\u0b92'));
        f.add(Character.valueOf('\u0b93'));
        f.add(Character.valueOf('\u0b94'));
        f.add(Character.valueOf('\u0b95'));
        f.add(Character.valueOf('\u0b99'));
        f.add(Character.valueOf('\u0b9a'));
        f.add(Character.valueOf('\u0b9c'));
        f.add(Character.valueOf('\u0b9e'));
        f.add(Character.valueOf('\u0b9f'));
        f.add(Character.valueOf('\u0ba3'));
        f.add(Character.valueOf('\u0ba4'));
        f.add(Character.valueOf('\u0ba8'));
        f.add(Character.valueOf('\u0ba9'));
        f.add(Character.valueOf('\u0baa'));
        f.add(Character.valueOf('\u0bae'));
        f.add(Character.valueOf('\u0baf'));
        f.add(Character.valueOf('\u0bb0'));
        f.add(Character.valueOf('\u0bb1'));
        f.add(Character.valueOf('\u0bb2'));
        f.add(Character.valueOf('\u0bb3'));
        f.add(Character.valueOf('\u0bb4'));
        f.add(Character.valueOf('\u0bb5'));
        f.add(Character.valueOf('\u0bb7'));
        f.add(Character.valueOf('\u0bb8'));
        f.add(Character.valueOf('\u0bb9'));
        f.add(Character.valueOf('\u0c05'));
        f.add(Character.valueOf('\u0c06'));
        f.add(Character.valueOf('\u0c07'));
        f.add(Character.valueOf('\u0c08'));
        f.add(Character.valueOf('\u0c09'));
        f.add(Character.valueOf('\u0c0a'));
        f.add(Character.valueOf('\u0c0b'));
        f.add(Character.valueOf('\u0c0c'));
        f.add(Character.valueOf('\u0c0e'));
        f.add(Character.valueOf('\u0c0f'));
        f.add(Character.valueOf('\u0c10'));
        f.add(Character.valueOf('\u0c12'));
        f.add(Character.valueOf('\u0c13'));
        f.add(Character.valueOf('\u0c14'));
        f.add(Character.valueOf('\u0c15'));
        f.add(Character.valueOf('\u0c16'));
        f.add(Character.valueOf('\u0c17'));
        f.add(Character.valueOf('\u0c18'));
        f.add(Character.valueOf('\u0c19'));
        f.add(Character.valueOf('\u0c1a'));
        f.add(Character.valueOf('\u0c1b'));
        f.add(Character.valueOf('\u0c1c'));
        f.add(Character.valueOf('\u0c1d'));
        f.add(Character.valueOf('\u0c1e'));
        f.add(Character.valueOf('\u0c1f'));
        f.add(Character.valueOf('\u0c20'));
        f.add(Character.valueOf('\u0c21'));
        f.add(Character.valueOf('\u0c22'));
        f.add(Character.valueOf('\u0c23'));
        f.add(Character.valueOf('\u0c24'));
        f.add(Character.valueOf('\u0c25'));
        f.add(Character.valueOf('\u0c26'));
        f.add(Character.valueOf('\u0c27'));
        f.add(Character.valueOf('\u0c28'));
        f.add(Character.valueOf('\u0c2a'));
        f.add(Character.valueOf('\u0c2b'));
        f.add(Character.valueOf('\u0c2c'));
        f.add(Character.valueOf('\u0c2d'));
        f.add(Character.valueOf('\u0c2e'));
        f.add(Character.valueOf('\u0c2f'));
        f.add(Character.valueOf('\u0c30'));
        f.add(Character.valueOf('\u0c31'));
        f.add(Character.valueOf('\u0c32'));
        f.add(Character.valueOf('\u0c33'));
        f.add(Character.valueOf('\u0c35'));
        f.add(Character.valueOf('\u0c36'));
        f.add(Character.valueOf('\u0c37'));
        f.add(Character.valueOf('\u0c38'));
        f.add(Character.valueOf('\u0c39'));
        f.add(Character.valueOf('\u0c60'));
        f.add(Character.valueOf('\u0c61'));
        f.add(Character.valueOf('\u0c85'));
        f.add(Character.valueOf('\u0c86'));
        f.add(Character.valueOf('\u0c87'));
        f.add(Character.valueOf('\u0c88'));
        f.add(Character.valueOf('\u0c89'));
        f.add(Character.valueOf('\u0c8a'));
        f.add(Character.valueOf('\u0c8b'));
        f.add(Character.valueOf('\u0c8c'));
        f.add(Character.valueOf('\u0c8e'));
        f.add(Character.valueOf('\u0c8f'));
        f.add(Character.valueOf('\u0c90'));
        f.add(Character.valueOf('\u0c92'));
        f.add(Character.valueOf('\u0c93'));
        f.add(Character.valueOf('\u0c94'));
        f.add(Character.valueOf('\u0c95'));
        f.add(Character.valueOf('\u0c96'));
        f.add(Character.valueOf('\u0c97'));
        f.add(Character.valueOf('\u0c98'));
        f.add(Character.valueOf('\u0c99'));
        f.add(Character.valueOf('\u0c9a'));
        f.add(Character.valueOf('\u0c9b'));
        f.add(Character.valueOf('\u0c9c'));
        f.add(Character.valueOf('\u0c9d'));
        f.add(Character.valueOf('\u0c9e'));
        f.add(Character.valueOf('\u0c9f'));
        f.add(Character.valueOf('\u0ca0'));
        f.add(Character.valueOf('\u0ca1'));
        f.add(Character.valueOf('\u0ca2'));
        f.add(Character.valueOf('\u0ca3'));
        f.add(Character.valueOf('\u0ca4'));
        f.add(Character.valueOf('\u0ca5'));
        f.add(Character.valueOf('\u0ca6'));
        f.add(Character.valueOf('\u0ca7'));
        f.add(Character.valueOf('\u0ca8'));
        f.add(Character.valueOf('\u0caa'));
        f.add(Character.valueOf('\u0cab'));
        f.add(Character.valueOf('\u0cac'));
        f.add(Character.valueOf('\u0cad'));
        f.add(Character.valueOf('\u0cae'));
        f.add(Character.valueOf('\u0caf'));
        f.add(Character.valueOf('\u0cb0'));
        f.add(Character.valueOf('\u0cb1'));
        f.add(Character.valueOf('\u0cb2'));
        f.add(Character.valueOf('\u0cb3'));
        f.add(Character.valueOf('\u0cb5'));
        f.add(Character.valueOf('\u0cb6'));
        f.add(Character.valueOf('\u0cb7'));
        f.add(Character.valueOf('\u0cb8'));
        f.add(Character.valueOf('\u0cb9'));
        f.add(Character.valueOf('\u0cde'));
        f.add(Character.valueOf('\u0ce0'));
        f.add(Character.valueOf('\u0ce1'));
        f.add(Character.valueOf('\u0d05'));
        f.add(Character.valueOf('\u0d06'));
        f.add(Character.valueOf('\u0d07'));
        f.add(Character.valueOf('\u0d08'));
        f.add(Character.valueOf('\u0d09'));
        f.add(Character.valueOf('\u0d0a'));
        f.add(Character.valueOf('\u0d0b'));
        f.add(Character.valueOf('\u0d0c'));
        f.add(Character.valueOf('\u0d0e'));
        f.add(Character.valueOf('\u0d0f'));
        f.add(Character.valueOf('\u0d10'));
        f.add(Character.valueOf('\u0d12'));
        f.add(Character.valueOf('\u0d13'));
        f.add(Character.valueOf('\u0d14'));
        f.add(Character.valueOf('\u0d15'));
        f.add(Character.valueOf('\u0d16'));
        f.add(Character.valueOf('\u0d17'));
        f.add(Character.valueOf('\u0d18'));
        f.add(Character.valueOf('\u0d19'));
        f.add(Character.valueOf('\u0d1a'));
        f.add(Character.valueOf('\u0d1b'));
        f.add(Character.valueOf('\u0d1c'));
        f.add(Character.valueOf('\u0d1d'));
        f.add(Character.valueOf('\u0d1e'));
        f.add(Character.valueOf('\u0d1f'));
        f.add(Character.valueOf('\u0d20'));
        f.add(Character.valueOf('\u0d21'));
        f.add(Character.valueOf('\u0d22'));
        f.add(Character.valueOf('\u0d23'));
        f.add(Character.valueOf('\u0d24'));
        f.add(Character.valueOf('\u0d25'));
        f.add(Character.valueOf('\u0d26'));
        f.add(Character.valueOf('\u0d27'));
        f.add(Character.valueOf('\u0d28'));
        f.add(Character.valueOf('\u0d2a'));
        f.add(Character.valueOf('\u0d2b'));
        f.add(Character.valueOf('\u0d2c'));
        f.add(Character.valueOf('\u0d2d'));
        f.add(Character.valueOf('\u0d2e'));
        f.add(Character.valueOf('\u0d2f'));
        f.add(Character.valueOf('\u0d30'));
        f.add(Character.valueOf('\u0d31'));
        f.add(Character.valueOf('\u0d32'));
        f.add(Character.valueOf('\u0d33'));
        f.add(Character.valueOf('\u0d34'));
        f.add(Character.valueOf('\u0d35'));
        f.add(Character.valueOf('\u0d36'));
        f.add(Character.valueOf('\u0d37'));
        f.add(Character.valueOf('\u0d38'));
        f.add(Character.valueOf('\u0d39'));
        f.add(Character.valueOf('\u0d60'));
        f.add(Character.valueOf('\u0d61'));
        f.add(Character.valueOf('\u0e01'));
        f.add(Character.valueOf('\u0e02'));
        f.add(Character.valueOf('\u0e03'));
        f.add(Character.valueOf('\u0e04'));
        f.add(Character.valueOf('\u0e05'));
        f.add(Character.valueOf('\u0e06'));
        f.add(Character.valueOf('\u0e07'));
        f.add(Character.valueOf('\u0e08'));
        f.add(Character.valueOf('\u0e09'));
        f.add(Character.valueOf('\u0e0a'));
        f.add(Character.valueOf('\u0e0b'));
        f.add(Character.valueOf('\u0e0c'));
        f.add(Character.valueOf('\u0e0d'));
        f.add(Character.valueOf('\u0e0e'));
        f.add(Character.valueOf('\u0e0f'));
        f.add(Character.valueOf('\u0e10'));
        f.add(Character.valueOf('\u0e11'));
        f.add(Character.valueOf('\u0e12'));
        f.add(Character.valueOf('\u0e13'));
        f.add(Character.valueOf('\u0e14'));
        f.add(Character.valueOf('\u0e15'));
        f.add(Character.valueOf('\u0e16'));
        f.add(Character.valueOf('\u0e17'));
        f.add(Character.valueOf('\u0e18'));
        f.add(Character.valueOf('\u0e19'));
        f.add(Character.valueOf('\u0e1a'));
        f.add(Character.valueOf('\u0e1b'));
        f.add(Character.valueOf('\u0e1c'));
        f.add(Character.valueOf('\u0e1d'));
        f.add(Character.valueOf('\u0e1e'));
        f.add(Character.valueOf('\u0e1f'));
        f.add(Character.valueOf('\u0e20'));
        f.add(Character.valueOf('\u0e21'));
        f.add(Character.valueOf('\u0e22'));
        f.add(Character.valueOf('\u0e23'));
        f.add(Character.valueOf('\u0e24'));
        f.add(Character.valueOf('\u0e25'));
        f.add(Character.valueOf('\u0e26'));
        f.add(Character.valueOf('\u0e27'));
        f.add(Character.valueOf('\u0e28'));
        f.add(Character.valueOf('\u0e29'));
        f.add(Character.valueOf('\u0e2a'));
        f.add(Character.valueOf('\u0e2b'));
        f.add(Character.valueOf('\u0e2c'));
        f.add(Character.valueOf('\u0e2d'));
        f.add(Character.valueOf('\u0e2e'));
        f.add(Character.valueOf('\u0e30'));
        f.add(Character.valueOf('\u0e32'));
        f.add(Character.valueOf('\u0e33'));
        f.add(Character.valueOf('\u0e40'));
        f.add(Character.valueOf('\u0e41'));
        f.add(Character.valueOf('\u0e42'));
        f.add(Character.valueOf('\u0e43'));
        f.add(Character.valueOf('\u0e44'));
        f.add(Character.valueOf('\u0e45'));
        f.add(Character.valueOf('\u0e46'));
        f.add(Character.valueOf('\u0e81'));
        f.add(Character.valueOf('\u0e82'));
        f.add(Character.valueOf('\u0e84'));
        f.add(Character.valueOf('\u0e87'));
        f.add(Character.valueOf('\u0e88'));
        f.add(Character.valueOf('\u0e8a'));
        f.add(Character.valueOf('\u0e8d'));
        f.add(Character.valueOf('\u0e94'));
        f.add(Character.valueOf('\u0e95'));
        f.add(Character.valueOf('\u0e96'));
        f.add(Character.valueOf('\u0e97'));
        f.add(Character.valueOf('\u0e99'));
        f.add(Character.valueOf('\u0e9a'));
        f.add(Character.valueOf('\u0e9b'));
        f.add(Character.valueOf('\u0e9c'));
        f.add(Character.valueOf('\u0e9d'));
        f.add(Character.valueOf('\u0e9e'));
        f.add(Character.valueOf('\u0e9f'));
        f.add(Character.valueOf('\u0ea1'));
        f.add(Character.valueOf('\u0ea2'));
        f.add(Character.valueOf('\u0ea3'));
        f.add(Character.valueOf('\u0ea5'));
        f.add(Character.valueOf('\u0ea7'));
        f.add(Character.valueOf('\u0eaa'));
        f.add(Character.valueOf('\u0eab'));
        f.add(Character.valueOf('\u0ead'));
        f.add(Character.valueOf('\u0eae'));
        f.add(Character.valueOf('\u0eb0'));
        f.add(Character.valueOf('\u0eb2'));
        f.add(Character.valueOf('\u0eb3'));
        f.add(Character.valueOf('\u0ebd'));
        f.add(Character.valueOf('\u0ec0'));
        f.add(Character.valueOf('\u0ec1'));
        f.add(Character.valueOf('\u0ec2'));
        f.add(Character.valueOf('\u0ec3'));
        f.add(Character.valueOf('\u0ec4'));
        f.add(Character.valueOf('\u0ec6'));
        f.add(Character.valueOf('\u0edc'));
        f.add(Character.valueOf('\u0edd'));
        f.add(Character.valueOf('\u0f40'));
        f.add(Character.valueOf('\u0f41'));
        f.add(Character.valueOf('\u0f42'));
        f.add(Character.valueOf('\u0f43'));
        f.add(Character.valueOf('\u0f44'));
        f.add(Character.valueOf('\u0f45'));
        f.add(Character.valueOf('\u0f46'));
        f.add(Character.valueOf('\u0f47'));
        f.add(Character.valueOf('\u0f49'));
        f.add(Character.valueOf('\u0f4a'));
        f.add(Character.valueOf('\u0f4b'));
        f.add(Character.valueOf('\u0f4c'));
        f.add(Character.valueOf('\u0f4d'));
        f.add(Character.valueOf('\u0f4e'));
        f.add(Character.valueOf('\u0f4f'));
        f.add(Character.valueOf('\u0f50'));
        f.add(Character.valueOf('\u0f51'));
        f.add(Character.valueOf('\u0f52'));
        f.add(Character.valueOf('\u0f53'));
        f.add(Character.valueOf('\u0f54'));
        f.add(Character.valueOf('\u0f55'));
        f.add(Character.valueOf('\u0f56'));
        f.add(Character.valueOf('\u0f57'));
        f.add(Character.valueOf('\u0f58'));
        f.add(Character.valueOf('\u0f59'));
        f.add(Character.valueOf('\u0f5a'));
        f.add(Character.valueOf('\u0f5b'));
        f.add(Character.valueOf('\u0f5c'));
        f.add(Character.valueOf('\u0f5d'));
        f.add(Character.valueOf('\u0f5e'));
        f.add(Character.valueOf('\u0f5f'));
        f.add(Character.valueOf('\u0f60'));
        f.add(Character.valueOf('\u0f61'));
        f.add(Character.valueOf('\u0f62'));
        f.add(Character.valueOf('\u0f63'));
        f.add(Character.valueOf('\u0f64'));
        f.add(Character.valueOf('\u0f65'));
        f.add(Character.valueOf('\u0f66'));
        f.add(Character.valueOf('\u0f67'));
        f.add(Character.valueOf('\u0f68'));
        f.add(Character.valueOf('\u0f69'));
        return f;
    }

    protected static HashSet<Character> initOrdinaryFlags400() {
        HashSet<Character> f = new HashSet<Character>(349);
        ordinaryFlagsSet.put(PLATFORM_400_KEY, f);
        f.add(Character.valueOf('#'));
        f.add(Character.valueOf('$'));
        f.add(Character.valueOf('@'));
        SQLIdentifier.initCommonOrdinaryFlags(f);
        return f;
    }

    protected static HashSet<Character> initOrdinaryFlags390() {
        HashSet<Character> f = new HashSet<Character>(349);
        ordinaryFlagsSet.put(PLATFORM_390_KEY, f);
        f.add(Character.valueOf('#'));
        f.add(Character.valueOf('$'));
        f.add(Character.valueOf('@'));
        SQLIdentifier.initCommonOrdinaryFlags(f);
        return f;
    }

    protected static void initCommonOrdinaryFlags(HashSet<Character> f) {
        f.add(Character.valueOf('A'));
        f.add(Character.valueOf('B'));
        f.add(Character.valueOf('C'));
        f.add(Character.valueOf('D'));
        f.add(Character.valueOf('E'));
        f.add(Character.valueOf('F'));
        f.add(Character.valueOf('G'));
        f.add(Character.valueOf('H'));
        f.add(Character.valueOf('I'));
        f.add(Character.valueOf('J'));
        f.add(Character.valueOf('K'));
        f.add(Character.valueOf('L'));
        f.add(Character.valueOf('M'));
        f.add(Character.valueOf('N'));
        f.add(Character.valueOf('O'));
        f.add(Character.valueOf('P'));
        f.add(Character.valueOf('Q'));
        f.add(Character.valueOf('R'));
        f.add(Character.valueOf('S'));
        f.add(Character.valueOf('T'));
        f.add(Character.valueOf('U'));
        f.add(Character.valueOf('V'));
        f.add(Character.valueOf('W'));
        f.add(Character.valueOf('X'));
        f.add(Character.valueOf('Y'));
        f.add(Character.valueOf('Z'));
        f.add(Character.valueOf('a'));
        f.add(Character.valueOf('b'));
        f.add(Character.valueOf('c'));
        f.add(Character.valueOf('d'));
        f.add(Character.valueOf('e'));
        f.add(Character.valueOf('f'));
        f.add(Character.valueOf('g'));
        f.add(Character.valueOf('h'));
        f.add(Character.valueOf('i'));
        f.add(Character.valueOf('j'));
        f.add(Character.valueOf('k'));
        f.add(Character.valueOf('l'));
        f.add(Character.valueOf('m'));
        f.add(Character.valueOf('n'));
        f.add(Character.valueOf('o'));
        f.add(Character.valueOf('p'));
        f.add(Character.valueOf('q'));
        f.add(Character.valueOf('r'));
        f.add(Character.valueOf('s'));
        f.add(Character.valueOf('t'));
        f.add(Character.valueOf('u'));
        f.add(Character.valueOf('v'));
        f.add(Character.valueOf('w'));
        f.add(Character.valueOf('x'));
        f.add(Character.valueOf('y'));
        f.add(Character.valueOf('z'));
    }

    protected static void initOrdinaryFlagsLUWO(HashSet<Character> f, Locale locale) {
        String lang = locale.getLanguage();
        if (lang.equalsIgnoreCase("cs")) {
            SQLIdentifier.initCSFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("de")) {
            SQLIdentifier.initDEFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("es")) {
            SQLIdentifier.initESFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("fr")) {
            SQLIdentifier.initFRFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("hu")) {
            SQLIdentifier.initHUFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("it")) {
            SQLIdentifier.initITFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("ja")) {
            SQLIdentifier.initJAFlags(f);
        } else if (lang.equalsIgnoreCase("ko")) {
            SQLIdentifier.initKOFlags(f);
        } else if (lang.equalsIgnoreCase("pl")) {
            SQLIdentifier.initPLFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("pt")) {
            SQLIdentifier.initPTFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("ru")) {
            SQLIdentifier.initRUFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("zh")) {
            String country = locale.getCountry();
            if (country.equalsIgnoreCase("TW")) {
                SQLIdentifier.initTWFlags(f);
            } else {
                SQLIdentifier.initZHFlags(f);
            }
        } else {
            SQLIdentifier.initENFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        }
    }

    protected static void initENFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00aa'));
        f.add(Character.valueOf('\u00ba'));
        f.add(Character.valueOf('\u00c0'));
        f.add(Character.valueOf('\u00c1'));
        f.add(Character.valueOf('\u00c2'));
        f.add(Character.valueOf('\u00c3'));
        f.add(Character.valueOf('\u00c4'));
        f.add(Character.valueOf('\u00c5'));
        f.add(Character.valueOf('\u00c6'));
        f.add(Character.valueOf('\u00c7'));
        f.add(Character.valueOf('\u00c8'));
        f.add(Character.valueOf('\u00c9'));
        f.add(Character.valueOf('\u00ca'));
        f.add(Character.valueOf('\u00cb'));
        f.add(Character.valueOf('\u00cc'));
        f.add(Character.valueOf('\u00cd'));
        f.add(Character.valueOf('\u00ce'));
        f.add(Character.valueOf('\u00cf'));
        f.add(Character.valueOf('\u00d0'));
        f.add(Character.valueOf('\u00d1'));
        f.add(Character.valueOf('\u00d2'));
        f.add(Character.valueOf('\u00d3'));
        f.add(Character.valueOf('\u00d4'));
        f.add(Character.valueOf('\u00d5'));
        f.add(Character.valueOf('\u00d6'));
        f.add(Character.valueOf('\u00d8'));
        f.add(Character.valueOf('\u00d9'));
        f.add(Character.valueOf('\u00da'));
        f.add(Character.valueOf('\u00db'));
        f.add(Character.valueOf('\u00dc'));
        f.add(Character.valueOf('\u00dd'));
        f.add(Character.valueOf('\u00de'));
        f.add(Character.valueOf('\u00df'));
        f.add(Character.valueOf('\u00e0'));
        f.add(Character.valueOf('\u00e1'));
        f.add(Character.valueOf('\u00e2'));
        f.add(Character.valueOf('\u00e3'));
        f.add(Character.valueOf('\u00e4'));
        f.add(Character.valueOf('\u00e5'));
        f.add(Character.valueOf('\u00e6'));
        f.add(Character.valueOf('\u00e7'));
        f.add(Character.valueOf('\u00e8'));
        f.add(Character.valueOf('\u00e9'));
        f.add(Character.valueOf('\u00ea'));
        f.add(Character.valueOf('\u00eb'));
        f.add(Character.valueOf('\u00ec'));
        f.add(Character.valueOf('\u00ed'));
        f.add(Character.valueOf('\u00ee'));
        f.add(Character.valueOf('\u00ef'));
        f.add(Character.valueOf('\u00f0'));
        f.add(Character.valueOf('\u00f1'));
        f.add(Character.valueOf('\u00f2'));
        f.add(Character.valueOf('\u00f3'));
        f.add(Character.valueOf('\u00f4'));
        f.add(Character.valueOf('\u00f5'));
        f.add(Character.valueOf('\u00f6'));
        f.add(Character.valueOf('\u00f8'));
        f.add(Character.valueOf('\u00f9'));
        f.add(Character.valueOf('\u00fa'));
        f.add(Character.valueOf('\u00fb'));
        f.add(Character.valueOf('\u00fc'));
        f.add(Character.valueOf('\u00fd'));
        f.add(Character.valueOf('\u00fe'));
        f.add(Character.valueOf('\u00ff'));
        f.add(Character.valueOf('\u0152'));
        f.add(Character.valueOf('\u0153'));
        f.add(Character.valueOf('\u0160'));
        f.add(Character.valueOf('\u0161'));
        f.add(Character.valueOf('\u0178'));
    }

    protected static void init_EU_Flags(HashSet<Character> f) {
        f.add(Character.valueOf('\uff03'));
        f.add(Character.valueOf('\uff04'));
        f.add(Character.valueOf('\uff20'));
        f.add(Character.valueOf('\uff21'));
        f.add(Character.valueOf('\uff22'));
        f.add(Character.valueOf('\uff23'));
        f.add(Character.valueOf('\uff24'));
        f.add(Character.valueOf('\uff25'));
        f.add(Character.valueOf('\uff26'));
        f.add(Character.valueOf('\uff27'));
        f.add(Character.valueOf('\uff28'));
        f.add(Character.valueOf('\uff29'));
        f.add(Character.valueOf('\uff2a'));
        f.add(Character.valueOf('\uff2b'));
        f.add(Character.valueOf('\uff2c'));
        f.add(Character.valueOf('\uff2d'));
        f.add(Character.valueOf('\uff2e'));
        f.add(Character.valueOf('\uff2f'));
        f.add(Character.valueOf('\uff30'));
        f.add(Character.valueOf('\uff31'));
        f.add(Character.valueOf('\uff32'));
        f.add(Character.valueOf('\uff33'));
        f.add(Character.valueOf('\uff34'));
        f.add(Character.valueOf('\uff35'));
        f.add(Character.valueOf('\uff36'));
        f.add(Character.valueOf('\uff37'));
        f.add(Character.valueOf('\uff38'));
        f.add(Character.valueOf('\uff39'));
        f.add(Character.valueOf('\uff3a'));
        f.add(Character.valueOf('\uff41'));
        f.add(Character.valueOf('\uff42'));
        f.add(Character.valueOf('\uff43'));
        f.add(Character.valueOf('\uff44'));
        f.add(Character.valueOf('\uff45'));
        f.add(Character.valueOf('\uff46'));
        f.add(Character.valueOf('\uff47'));
        f.add(Character.valueOf('\uff48'));
        f.add(Character.valueOf('\uff49'));
        f.add(Character.valueOf('\uff4a'));
        f.add(Character.valueOf('\uff4b'));
        f.add(Character.valueOf('\uff4c'));
        f.add(Character.valueOf('\uff4d'));
        f.add(Character.valueOf('\uff4e'));
        f.add(Character.valueOf('\uff4f'));
        f.add(Character.valueOf('\uff50'));
        f.add(Character.valueOf('\uff51'));
        f.add(Character.valueOf('\uff52'));
        f.add(Character.valueOf('\uff53'));
        f.add(Character.valueOf('\uff54'));
        f.add(Character.valueOf('\uff55'));
        f.add(Character.valueOf('\uff56'));
        f.add(Character.valueOf('\uff57'));
        f.add(Character.valueOf('\uff58'));
        f.add(Character.valueOf('\uff59'));
        f.add(Character.valueOf('\uff5a'));
    }

    protected static void initZHFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00a4'));
        f.add(Character.valueOf('\u00a7'));
        f.add(Character.valueOf('\u00a8'));
        f.add(Character.valueOf('\u00b0'));
        f.add(Character.valueOf('\u00b1'));
        f.add(Character.valueOf('\u00b7'));
        f.add(Character.valueOf('\u00d7'));
        f.add(Character.valueOf('\u00e0'));
        f.add(Character.valueOf('\u00e1'));
        f.add(Character.valueOf('\u00e8'));
        f.add(Character.valueOf('\u00e9'));
        f.add(Character.valueOf('\u00ea'));
        f.add(Character.valueOf('\u00ec'));
        f.add(Character.valueOf('\u00ed'));
        f.add(Character.valueOf('\u00f2'));
        f.add(Character.valueOf('\u00f3'));
        f.add(Character.valueOf('\u00f9'));
        f.add(Character.valueOf('\u00fa'));
        f.add(Character.valueOf('\u00fc'));
        f.add(Character.valueOf('\u0101'));
        f.add(Character.valueOf('\u0113'));
        f.add(Character.valueOf('\u011b'));
        f.add(Character.valueOf('\u012b'));
        f.add(Character.valueOf('\u0144'));
        f.add(Character.valueOf('\u0148'));
        f.add(Character.valueOf('\u014d'));
        f.add(Character.valueOf('\u016b'));
        f.add(Character.valueOf('\u01ce'));
        f.add(Character.valueOf('\u01d0'));
        f.add(Character.valueOf('\u01d2'));
        f.add(Character.valueOf('\u01d4'));
        f.add(Character.valueOf('\u01d6'));
        f.add(Character.valueOf('\u01d8'));
        f.add(Character.valueOf('\u01da'));
        f.add(Character.valueOf('\u01dc'));
        f.add(Character.valueOf('\u01f9'));
        f.add(Character.valueOf('\u0251'));
        f.add(Character.valueOf('\u0261'));
        f.add(Character.valueOf('\u02c7'));
        f.add(Character.valueOf('\u02c9'));
        f.add(Character.valueOf('\u02ca'));
        f.add(Character.valueOf('\u02cb'));
        f.add(Character.valueOf('\u02d9'));
        f.add(Character.valueOf('\u0391'));
        f.add(Character.valueOf('\u0392'));
        f.add(Character.valueOf('\u0393'));
        f.add(Character.valueOf('\u0394'));
        f.add(Character.valueOf('\u0395'));
        f.add(Character.valueOf('\u0396'));
        f.add(Character.valueOf('\u0397'));
        f.add(Character.valueOf('\u0398'));
        f.add(Character.valueOf('\u0399'));
        f.add(Character.valueOf('\u039a'));
        f.add(Character.valueOf('\u039b'));
        f.add(Character.valueOf('\u039c'));
        f.add(Character.valueOf('\u039d'));
        f.add(Character.valueOf('\u039e'));
        f.add(Character.valueOf('\u039f'));
        f.add(Character.valueOf('\u03a0'));
        f.add(Character.valueOf('\u03a1'));
        f.add(Character.valueOf('\u03a3'));
        f.add(Character.valueOf('\u03a4'));
        f.add(Character.valueOf('\u03a5'));
        f.add(Character.valueOf('\u03a6'));
        f.add(Character.valueOf('\u03a7'));
        f.add(Character.valueOf('\u03a8'));
        f.add(Character.valueOf('\u03a9'));
        f.add(Character.valueOf('\u03b1'));
        f.add(Character.valueOf('\u03b2'));
        f.add(Character.valueOf('\u03b3'));
        f.add(Character.valueOf('\u03b4'));
        f.add(Character.valueOf('\u03b5'));
        f.add(Character.valueOf('\u03b6'));
        f.add(Character.valueOf('\u03b7'));
        f.add(Character.valueOf('\u03b8'));
        f.add(Character.valueOf('\u03b9'));
        f.add(Character.valueOf('\u03ba'));
        f.add(Character.valueOf('\u03bb'));
        f.add(Character.valueOf('\u03bc'));
        f.add(Character.valueOf('\u03bd'));
        f.add(Character.valueOf('\u03be'));
        f.add(Character.valueOf('\u03bf'));
        f.add(Character.valueOf('\u03c0'));
        f.add(Character.valueOf('\u03c1'));
        f.add(Character.valueOf('\u03c3'));
        f.add(Character.valueOf('\u03c4'));
        f.add(Character.valueOf('\u03c5'));
        f.add(Character.valueOf('\u03c6'));
        f.add(Character.valueOf('\u03c7'));
        f.add(Character.valueOf('\u03c8'));
        f.add(Character.valueOf('\u03c9'));
        f.add(Character.valueOf('\u0401'));
        f.add(Character.valueOf('\u0410'));
        f.add(Character.valueOf('\u0411'));
        f.add(Character.valueOf('\u0412'));
        f.add(Character.valueOf('\u0413'));
        f.add(Character.valueOf('\u0414'));
        f.add(Character.valueOf('\u0415'));
        f.add(Character.valueOf('\u0416'));
        f.add(Character.valueOf('\u0417'));
        f.add(Character.valueOf('\u0418'));
        f.add(Character.valueOf('\u0419'));
        f.add(Character.valueOf('\u041a'));
        f.add(Character.valueOf('\u041b'));
        f.add(Character.valueOf('\u041c'));
        f.add(Character.valueOf('\u041d'));
        f.add(Character.valueOf('\u041e'));
        f.add(Character.valueOf('\u041f'));
        f.add(Character.valueOf('\u0420'));
        f.add(Character.valueOf('\u0421'));
        f.add(Character.valueOf('\u0422'));
        f.add(Character.valueOf('\u0423'));
        f.add(Character.valueOf('\u0424'));
        f.add(Character.valueOf('\u0425'));
        f.add(Character.valueOf('\u0426'));
        f.add(Character.valueOf('\u0427'));
        f.add(Character.valueOf('\u0428'));
        f.add(Character.valueOf('\u0429'));
        f.add(Character.valueOf('\u042a'));
        f.add(Character.valueOf('\u042b'));
        f.add(Character.valueOf('\u042c'));
        f.add(Character.valueOf('\u042d'));
        f.add(Character.valueOf('\u042e'));
        f.add(Character.valueOf('\u042f'));
        f.add(Character.valueOf('\u0430'));
        f.add(Character.valueOf('\u0431'));
        f.add(Character.valueOf('\u0432'));
        f.add(Character.valueOf('\u0433'));
        f.add(Character.valueOf('\u0434'));
        f.add(Character.valueOf('\u0435'));
        f.add(Character.valueOf('\u0436'));
        f.add(Character.valueOf('\u0437'));
        f.add(Character.valueOf('\u0438'));
        f.add(Character.valueOf('\u0439'));
        f.add(Character.valueOf('\u043a'));
        f.add(Character.valueOf('\u043b'));
        f.add(Character.valueOf('\u043c'));
        f.add(Character.valueOf('\u043d'));
        f.add(Character.valueOf('\u043e'));
        f.add(Character.valueOf('\u043f'));
        f.add(Character.valueOf('\u0440'));
        f.add(Character.valueOf('\u0441'));
        f.add(Character.valueOf('\u0442'));
        f.add(Character.valueOf('\u0443'));
        f.add(Character.valueOf('\u0444'));
        f.add(Character.valueOf('\u0445'));
        f.add(Character.valueOf('\u0446'));
        f.add(Character.valueOf('\u0447'));
        f.add(Character.valueOf('\u0448'));
        f.add(Character.valueOf('\u0449'));
        f.add(Character.valueOf('\u044a'));
        f.add(Character.valueOf('\u044b'));
        f.add(Character.valueOf('\u044c'));
        f.add(Character.valueOf('\u044d'));
        f.add(Character.valueOf('\u044e'));
        f.add(Character.valueOf('\u044f'));
        f.add(Character.valueOf('\u0451'));
        f.add(Character.valueOf('\u2010'));
        f.add(Character.valueOf('\u2013'));
        f.add(Character.valueOf('\u2014'));
        f.add(Character.valueOf('\u2015'));
        f.add(Character.valueOf('\u2016'));
        f.add(Character.valueOf('\u2018'));
        f.add(Character.valueOf('\u2019'));
        f.add(Character.valueOf('\u201c'));
        f.add(Character.valueOf('\u201d'));
        f.add(Character.valueOf('\u2025'));
        f.add(Character.valueOf('\u2026'));
        f.add(Character.valueOf('\u2030'));
        f.add(Character.valueOf('\u2032'));
        f.add(Character.valueOf('\u2033'));
        f.add(Character.valueOf('\u2035'));
        f.add(Character.valueOf('\u203b'));
        f.add(Character.valueOf('\u20ac'));
        f.add(Character.valueOf('\u2103'));
        f.add(Character.valueOf('\u2105'));
        f.add(Character.valueOf('\u2109'));
        f.add(Character.valueOf('\u2116'));
        f.add(Character.valueOf('\u2121'));
        f.add(Character.valueOf('\u2160'));
        f.add(Character.valueOf('\u2161'));
        f.add(Character.valueOf('\u2162'));
        f.add(Character.valueOf('\u2163'));
        f.add(Character.valueOf('\u2164'));
        f.add(Character.valueOf('\u2165'));
        f.add(Character.valueOf('\u2166'));
        f.add(Character.valueOf('\u2167'));
        f.add(Character.valueOf('\u2168'));
        f.add(Character.valueOf('\u2169'));
        f.add(Character.valueOf('\u216a'));
        f.add(Character.valueOf('\u216b'));
        f.add(Character.valueOf('\u2170'));
        f.add(Character.valueOf('\u2171'));
        f.add(Character.valueOf('\u2172'));
        f.add(Character.valueOf('\u2173'));
        f.add(Character.valueOf('\u2174'));
        f.add(Character.valueOf('\u2175'));
        f.add(Character.valueOf('\u2176'));
        f.add(Character.valueOf('\u2177'));
        f.add(Character.valueOf('\u2178'));
        f.add(Character.valueOf('\u2179'));
        f.add(Character.valueOf('\u2190'));
        f.add(Character.valueOf('\u2191'));
        f.add(Character.valueOf('\u2192'));
        f.add(Character.valueOf('\u2193'));
        f.add(Character.valueOf('\u2196'));
        f.add(Character.valueOf('\u2197'));
        f.add(Character.valueOf('\u2198'));
        f.add(Character.valueOf('\u2199'));
        f.add(Character.valueOf('\u2208'));
        f.add(Character.valueOf('\u220f'));
        f.add(Character.valueOf('\u2211'));
        f.add(Character.valueOf('\u2215'));
        f.add(Character.valueOf('\u221a'));
        f.add(Character.valueOf('\u221d'));
        f.add(Character.valueOf('\u221e'));
        f.add(Character.valueOf('\u221f'));
        f.add(Character.valueOf('\u2220'));
        f.add(Character.valueOf('\u2223'));
        f.add(Character.valueOf('\u2225'));
        f.add(Character.valueOf('\u2227'));
        f.add(Character.valueOf('\u2228'));
        f.add(Character.valueOf('\u2229'));
        f.add(Character.valueOf('\u222a'));
        f.add(Character.valueOf('\u222b'));
        f.add(Character.valueOf('\u222e'));
        f.add(Character.valueOf('\u2234'));
        f.add(Character.valueOf('\u2235'));
        f.add(Character.valueOf('\u2236'));
        f.add(Character.valueOf('\u2237'));
        f.add(Character.valueOf('\u223d'));
        f.add(Character.valueOf('\u2248'));
        f.add(Character.valueOf('\u224c'));
        f.add(Character.valueOf('\u2252'));
        f.add(Character.valueOf('\u2260'));
        f.add(Character.valueOf('\u2261'));
        f.add(Character.valueOf('\u2264'));
        f.add(Character.valueOf('\u2265'));
        f.add(Character.valueOf('\u2266'));
        f.add(Character.valueOf('\u2267'));
        f.add(Character.valueOf('\u226e'));
        f.add(Character.valueOf('\u226f'));
        f.add(Character.valueOf('\u2295'));
        f.add(Character.valueOf('\u2299'));
        f.add(Character.valueOf('\u22a5'));
        f.add(Character.valueOf('\u22bf'));
        f.add(Character.valueOf('\u2312'));
        f.add(Character.valueOf('\u2460'));
        f.add(Character.valueOf('\u2461'));
        f.add(Character.valueOf('\u2462'));
        f.add(Character.valueOf('\u2463'));
        f.add(Character.valueOf('\u2464'));
        f.add(Character.valueOf('\u2465'));
        f.add(Character.valueOf('\u2466'));
        f.add(Character.valueOf('\u2467'));
        f.add(Character.valueOf('\u2468'));
        f.add(Character.valueOf('\u2469'));
        f.add(Character.valueOf('\u2474'));
        f.add(Character.valueOf('\u2475'));
        f.add(Character.valueOf('\u2476'));
        f.add(Character.valueOf('\u2477'));
        f.add(Character.valueOf('\u2478'));
        f.add(Character.valueOf('\u2479'));
        f.add(Character.valueOf('\u247a'));
        f.add(Character.valueOf('\u247b'));
        f.add(Character.valueOf('\u247c'));
        f.add(Character.valueOf('\u247d'));
        f.add(Character.valueOf('\u247e'));
        f.add(Character.valueOf('\u247f'));
        f.add(Character.valueOf('\u2480'));
        f.add(Character.valueOf('\u2481'));
        f.add(Character.valueOf('\u2482'));
        f.add(Character.valueOf('\u2483'));
        f.add(Character.valueOf('\u2484'));
        f.add(Character.valueOf('\u2485'));
        f.add(Character.valueOf('\u2486'));
        f.add(Character.valueOf('\u2487'));
        f.add(Character.valueOf('\u2488'));
        f.add(Character.valueOf('\u2489'));
        f.add(Character.valueOf('\u248a'));
        f.add(Character.valueOf('\u248b'));
        f.add(Character.valueOf('\u248c'));
        f.add(Character.valueOf('\u248d'));
        f.add(Character.valueOf('\u248e'));
        f.add(Character.valueOf('\u248f'));
        f.add(Character.valueOf('\u2490'));
        f.add(Character.valueOf('\u2491'));
        f.add(Character.valueOf('\u2492'));
        f.add(Character.valueOf('\u2493'));
        f.add(Character.valueOf('\u2494'));
        f.add(Character.valueOf('\u2495'));
        f.add(Character.valueOf('\u2496'));
        f.add(Character.valueOf('\u2497'));
        f.add(Character.valueOf('\u2498'));
        f.add(Character.valueOf('\u2499'));
        f.add(Character.valueOf('\u249a'));
        f.add(Character.valueOf('\u249b'));
        f.add(Character.valueOf('\u2500'));
        f.add(Character.valueOf('\u2501'));
        f.add(Character.valueOf('\u2502'));
        f.add(Character.valueOf('\u2503'));
        f.add(Character.valueOf('\u2504'));
        f.add(Character.valueOf('\u2505'));
        f.add(Character.valueOf('\u2506'));
        f.add(Character.valueOf('\u2507'));
        f.add(Character.valueOf('\u2508'));
        f.add(Character.valueOf('\u2509'));
        f.add(Character.valueOf('\u250a'));
        f.add(Character.valueOf('\u250b'));
        f.add(Character.valueOf('\u250c'));
        f.add(Character.valueOf('\u250d'));
        f.add(Character.valueOf('\u250e'));
        f.add(Character.valueOf('\u250f'));
        f.add(Character.valueOf('\u2510'));
        f.add(Character.valueOf('\u2511'));
        f.add(Character.valueOf('\u2512'));
        f.add(Character.valueOf('\u2513'));
        f.add(Character.valueOf('\u2514'));
        f.add(Character.valueOf('\u2515'));
        f.add(Character.valueOf('\u2516'));
        f.add(Character.valueOf('\u2517'));
        f.add(Character.valueOf('\u2518'));
        f.add(Character.valueOf('\u2519'));
        f.add(Character.valueOf('\u251a'));
        f.add(Character.valueOf('\u251b'));
        f.add(Character.valueOf('\u251c'));
        f.add(Character.valueOf('\u251d'));
        f.add(Character.valueOf('\u251e'));
        f.add(Character.valueOf('\u251f'));
        f.add(Character.valueOf('\u2520'));
        f.add(Character.valueOf('\u2521'));
        f.add(Character.valueOf('\u2522'));
        f.add(Character.valueOf('\u2523'));
        f.add(Character.valueOf('\u2524'));
        f.add(Character.valueOf('\u2525'));
        f.add(Character.valueOf('\u2526'));
        f.add(Character.valueOf('\u2527'));
        f.add(Character.valueOf('\u2528'));
        f.add(Character.valueOf('\u2529'));
        f.add(Character.valueOf('\u252a'));
        f.add(Character.valueOf('\u252b'));
        f.add(Character.valueOf('\u252c'));
        f.add(Character.valueOf('\u252d'));
        f.add(Character.valueOf('\u252e'));
        f.add(Character.valueOf('\u252f'));
        f.add(Character.valueOf('\u2530'));
        f.add(Character.valueOf('\u2531'));
        f.add(Character.valueOf('\u2532'));
        f.add(Character.valueOf('\u2533'));
        f.add(Character.valueOf('\u2534'));
        f.add(Character.valueOf('\u2535'));
        f.add(Character.valueOf('\u2536'));
        f.add(Character.valueOf('\u2537'));
        f.add(Character.valueOf('\u2538'));
        f.add(Character.valueOf('\u2539'));
        f.add(Character.valueOf('\u253a'));
        f.add(Character.valueOf('\u253b'));
        f.add(Character.valueOf('\u253c'));
        f.add(Character.valueOf('\u253d'));
        f.add(Character.valueOf('\u253e'));
        f.add(Character.valueOf('\u253f'));
        f.add(Character.valueOf('\u2540'));
        f.add(Character.valueOf('\u2541'));
        f.add(Character.valueOf('\u2542'));
        f.add(Character.valueOf('\u2543'));
        f.add(Character.valueOf('\u2544'));
        f.add(Character.valueOf('\u2545'));
        f.add(Character.valueOf('\u2546'));
        f.add(Character.valueOf('\u2547'));
        f.add(Character.valueOf('\u2548'));
        f.add(Character.valueOf('\u2549'));
        f.add(Character.valueOf('\u254a'));
        f.add(Character.valueOf('\u254b'));
        f.add(Character.valueOf('\u2550'));
        f.add(Character.valueOf('\u2551'));
        f.add(Character.valueOf('\u2552'));
        f.add(Character.valueOf('\u2553'));
        f.add(Character.valueOf('\u2554'));
        f.add(Character.valueOf('\u2555'));
        f.add(Character.valueOf('\u2556'));
        f.add(Character.valueOf('\u2557'));
        f.add(Character.valueOf('\u2558'));
        f.add(Character.valueOf('\u2559'));
        f.add(Character.valueOf('\u255a'));
        f.add(Character.valueOf('\u255b'));
        f.add(Character.valueOf('\u255c'));
        f.add(Character.valueOf('\u255d'));
        f.add(Character.valueOf('\u255e'));
        f.add(Character.valueOf('\u255f'));
        f.add(Character.valueOf('\u2560'));
        f.add(Character.valueOf('\u2561'));
        f.add(Character.valueOf('\u2562'));
        f.add(Character.valueOf('\u2563'));
        f.add(Character.valueOf('\u2564'));
        f.add(Character.valueOf('\u2565'));
        f.add(Character.valueOf('\u2566'));
        f.add(Character.valueOf('\u2567'));
        f.add(Character.valueOf('\u2568'));
        f.add(Character.valueOf('\u2569'));
        f.add(Character.valueOf('\u256a'));
        f.add(Character.valueOf('\u256b'));
        f.add(Character.valueOf('\u256c'));
        f.add(Character.valueOf('\u256d'));
        f.add(Character.valueOf('\u256e'));
        f.add(Character.valueOf('\u256f'));
        f.add(Character.valueOf('\u2570'));
        f.add(Character.valueOf('\u2571'));
        f.add(Character.valueOf('\u2572'));
        f.add(Character.valueOf('\u2573'));
        f.add(Character.valueOf('\u2581'));
        f.add(Character.valueOf('\u2582'));
        f.add(Character.valueOf('\u2583'));
        f.add(Character.valueOf('\u2584'));
        f.add(Character.valueOf('\u2585'));
        f.add(Character.valueOf('\u2586'));
        f.add(Character.valueOf('\u2587'));
        f.add(Character.valueOf('\u2588'));
        f.add(Character.valueOf('\u2589'));
        f.add(Character.valueOf('\u258a'));
        f.add(Character.valueOf('\u258b'));
        f.add(Character.valueOf('\u258c'));
        f.add(Character.valueOf('\u258d'));
        f.add(Character.valueOf('\u258e'));
        f.add(Character.valueOf('\u258f'));
        f.add(Character.valueOf('\u2593'));
        f.add(Character.valueOf('\u2594'));
        f.add(Character.valueOf('\u2595'));
        f.add(Character.valueOf('\u25a0'));
        f.add(Character.valueOf('\u25a1'));
        f.add(Character.valueOf('\u25b2'));
        f.add(Character.valueOf('\u25b3'));
        f.add(Character.valueOf('\u25bc'));
        f.add(Character.valueOf('\u25bd'));
        f.add(Character.valueOf('\u25c6'));
        f.add(Character.valueOf('\u25c7'));
        f.add(Character.valueOf('\u25cb'));
        f.add(Character.valueOf('\u25ce'));
        f.add(Character.valueOf('\u25cf'));
        f.add(Character.valueOf('\u25e2'));
        f.add(Character.valueOf('\u25e3'));
        f.add(Character.valueOf('\u25e4'));
        f.add(Character.valueOf('\u25e5'));
        f.add(Character.valueOf('\u2605'));
        f.add(Character.valueOf('\u2606'));
        f.add(Character.valueOf('\u2609'));
        f.add(Character.valueOf('\u2640'));
        f.add(Character.valueOf('\u2642'));
        f.add(Character.valueOf('\u2e81'));
        f.add(Character.valueOf('\u2e84'));
        f.add(Character.valueOf('\u2e88'));
        f.add(Character.valueOf('\u2e8b'));
        f.add(Character.valueOf('\u2e8c'));
        f.add(Character.valueOf('\u2e97'));
        f.add(Character.valueOf('\u2ea7'));
        f.add(Character.valueOf('\u2eaa'));
        f.add(Character.valueOf('\u2eae'));
        f.add(Character.valueOf('\u2eb3'));
        f.add(Character.valueOf('\u2eb6'));
        f.add(Character.valueOf('\u2eb7'));
        f.add(Character.valueOf('\u2ebb'));
        f.add(Character.valueOf('\u2eca'));
        f.add(Character.valueOf('\u2ff0'));
        f.add(Character.valueOf('\u2ff1'));
        f.add(Character.valueOf('\u2ff2'));
        f.add(Character.valueOf('\u2ff3'));
        f.add(Character.valueOf('\u2ff4'));
        f.add(Character.valueOf('\u2ff5'));
        f.add(Character.valueOf('\u2ff6'));
        f.add(Character.valueOf('\u2ff7'));
        f.add(Character.valueOf('\u2ff8'));
        f.add(Character.valueOf('\u2ff9'));
        f.add(Character.valueOf('\u2ffa'));
        f.add(Character.valueOf('\u2ffb'));
        f.add(Character.valueOf('\u3001'));
        f.add(Character.valueOf('\u3002'));
        f.add(Character.valueOf('\u3003'));
        f.add(Character.valueOf('\u3005'));
        f.add(Character.valueOf('\u3006'));
        f.add(Character.valueOf('\u3007'));
        f.add(Character.valueOf('\u3008'));
        f.add(Character.valueOf('\u3009'));
        f.add(Character.valueOf('\u300a'));
        f.add(Character.valueOf('\u300b'));
        f.add(Character.valueOf('\u300c'));
        f.add(Character.valueOf('\u300d'));
        f.add(Character.valueOf('\u300e'));
        f.add(Character.valueOf('\u300f'));
        f.add(Character.valueOf('\u3010'));
        f.add(Character.valueOf('\u3011'));
        f.add(Character.valueOf('\u3012'));
        f.add(Character.valueOf('\u3013'));
        f.add(Character.valueOf('\u3014'));
        f.add(Character.valueOf('\u3015'));
        f.add(Character.valueOf('\u3016'));
        f.add(Character.valueOf('\u3017'));
        f.add(Character.valueOf('\u301d'));
        f.add(Character.valueOf('\u301e'));
        f.add(Character.valueOf('\u3021'));
        f.add(Character.valueOf('\u3022'));
        f.add(Character.valueOf('\u3023'));
        f.add(Character.valueOf('\u3024'));
        f.add(Character.valueOf('\u3025'));
        f.add(Character.valueOf('\u3026'));
        f.add(Character.valueOf('\u3027'));
        f.add(Character.valueOf('\u3028'));
        f.add(Character.valueOf('\u3029'));
        f.add(Character.valueOf('\u303e'));
        f.add(Character.valueOf('\u3041'));
        f.add(Character.valueOf('\u3042'));
        f.add(Character.valueOf('\u3043'));
        f.add(Character.valueOf('\u3044'));
        f.add(Character.valueOf('\u3045'));
        f.add(Character.valueOf('\u3046'));
        f.add(Character.valueOf('\u3047'));
        f.add(Character.valueOf('\u3048'));
        f.add(Character.valueOf('\u3049'));
        f.add(Character.valueOf('\u304a'));
        f.add(Character.valueOf('\u304b'));
        f.add(Character.valueOf('\u304c'));
        f.add(Character.valueOf('\u304d'));
        f.add(Character.valueOf('\u304e'));
        f.add(Character.valueOf('\u304f'));
        f.add(Character.valueOf('\u3050'));
        f.add(Character.valueOf('\u3051'));
        f.add(Character.valueOf('\u3052'));
        f.add(Character.valueOf('\u3053'));
        f.add(Character.valueOf('\u3054'));
        f.add(Character.valueOf('\u3055'));
        f.add(Character.valueOf('\u3056'));
        f.add(Character.valueOf('\u3057'));
        f.add(Character.valueOf('\u3058'));
        f.add(Character.valueOf('\u3059'));
        f.add(Character.valueOf('\u305a'));
        f.add(Character.valueOf('\u305b'));
        f.add(Character.valueOf('\u305c'));
        f.add(Character.valueOf('\u305d'));
        f.add(Character.valueOf('\u305e'));
        f.add(Character.valueOf('\u305f'));
        f.add(Character.valueOf('\u3060'));
        f.add(Character.valueOf('\u3061'));
        f.add(Character.valueOf('\u3062'));
        f.add(Character.valueOf('\u3063'));
        f.add(Character.valueOf('\u3064'));
        f.add(Character.valueOf('\u3065'));
        f.add(Character.valueOf('\u3066'));
        f.add(Character.valueOf('\u3067'));
        f.add(Character.valueOf('\u3068'));
        f.add(Character.valueOf('\u3069'));
        f.add(Character.valueOf('\u306a'));
        f.add(Character.valueOf('\u306b'));
        f.add(Character.valueOf('\u306c'));
        f.add(Character.valueOf('\u306d'));
        f.add(Character.valueOf('\u306e'));
        f.add(Character.valueOf('\u306f'));
        f.add(Character.valueOf('\u3070'));
        f.add(Character.valueOf('\u3071'));
        f.add(Character.valueOf('\u3072'));
        f.add(Character.valueOf('\u3073'));
        f.add(Character.valueOf('\u3074'));
        f.add(Character.valueOf('\u3075'));
        f.add(Character.valueOf('\u3076'));
        f.add(Character.valueOf('\u3077'));
        f.add(Character.valueOf('\u3078'));
        f.add(Character.valueOf('\u3079'));
        f.add(Character.valueOf('\u307a'));
        f.add(Character.valueOf('\u307b'));
        f.add(Character.valueOf('\u307c'));
        f.add(Character.valueOf('\u307d'));
        f.add(Character.valueOf('\u307e'));
        f.add(Character.valueOf('\u307f'));
        f.add(Character.valueOf('\u3080'));
        f.add(Character.valueOf('\u3081'));
        f.add(Character.valueOf('\u3082'));
        f.add(Character.valueOf('\u3083'));
        f.add(Character.valueOf('\u3084'));
        f.add(Character.valueOf('\u3085'));
        f.add(Character.valueOf('\u3086'));
        f.add(Character.valueOf('\u3087'));
        f.add(Character.valueOf('\u3088'));
        f.add(Character.valueOf('\u3089'));
        f.add(Character.valueOf('\u308a'));
        f.add(Character.valueOf('\u308b'));
        f.add(Character.valueOf('\u308c'));
        f.add(Character.valueOf('\u308d'));
        f.add(Character.valueOf('\u308e'));
        f.add(Character.valueOf('\u308f'));
        f.add(Character.valueOf('\u3090'));
        f.add(Character.valueOf('\u3091'));
        f.add(Character.valueOf('\u3092'));
        f.add(Character.valueOf('\u3093'));
        f.add(Character.valueOf('\u309b'));
        f.add(Character.valueOf('\u309c'));
        f.add(Character.valueOf('\u309d'));
        f.add(Character.valueOf('\u309e'));
        f.add(Character.valueOf('\u30a1'));
        f.add(Character.valueOf('\u30a2'));
        f.add(Character.valueOf('\u30a3'));
        f.add(Character.valueOf('\u30a4'));
        f.add(Character.valueOf('\u30a5'));
        f.add(Character.valueOf('\u30a6'));
        f.add(Character.valueOf('\u30a7'));
        f.add(Character.valueOf('\u30a8'));
        f.add(Character.valueOf('\u30a9'));
        f.add(Character.valueOf('\u30aa'));
        f.add(Character.valueOf('\u30ab'));
        f.add(Character.valueOf('\u30ac'));
        f.add(Character.valueOf('\u30ad'));
        f.add(Character.valueOf('\u30ae'));
        f.add(Character.valueOf('\u30af'));
        f.add(Character.valueOf('\u30b0'));
        f.add(Character.valueOf('\u30b1'));
        f.add(Character.valueOf('\u30b2'));
        f.add(Character.valueOf('\u30b3'));
        f.add(Character.valueOf('\u30b4'));
        f.add(Character.valueOf('\u30b5'));
        f.add(Character.valueOf('\u30b6'));
        f.add(Character.valueOf('\u30b7'));
        f.add(Character.valueOf('\u30b8'));
        f.add(Character.valueOf('\u30b9'));
        f.add(Character.valueOf('\u30ba'));
        f.add(Character.valueOf('\u30bb'));
        f.add(Character.valueOf('\u30bc'));
        f.add(Character.valueOf('\u30bd'));
        f.add(Character.valueOf('\u30be'));
        f.add(Character.valueOf('\u30bf'));
        f.add(Character.valueOf('\u30c0'));
        f.add(Character.valueOf('\u30c1'));
        f.add(Character.valueOf('\u30c2'));
        f.add(Character.valueOf('\u30c3'));
        f.add(Character.valueOf('\u30c4'));
        f.add(Character.valueOf('\u30c5'));
        f.add(Character.valueOf('\u30c6'));
        f.add(Character.valueOf('\u30c7'));
        f.add(Character.valueOf('\u30c8'));
        f.add(Character.valueOf('\u30c9'));
        f.add(Character.valueOf('\u30ca'));
        f.add(Character.valueOf('\u30cb'));
        f.add(Character.valueOf('\u30cc'));
        f.add(Character.valueOf('\u30cd'));
        f.add(Character.valueOf('\u30ce'));
        f.add(Character.valueOf('\u30cf'));
        f.add(Character.valueOf('\u30d0'));
        f.add(Character.valueOf('\u30d1'));
        f.add(Character.valueOf('\u30d2'));
        f.add(Character.valueOf('\u30d3'));
        f.add(Character.valueOf('\u30d4'));
        f.add(Character.valueOf('\u30d5'));
        f.add(Character.valueOf('\u30d6'));
        f.add(Character.valueOf('\u30d7'));
        f.add(Character.valueOf('\u30d8'));
        f.add(Character.valueOf('\u30d9'));
        f.add(Character.valueOf('\u30da'));
        f.add(Character.valueOf('\u30db'));
        f.add(Character.valueOf('\u30dc'));
        f.add(Character.valueOf('\u30dd'));
        f.add(Character.valueOf('\u30de'));
        f.add(Character.valueOf('\u30df'));
        f.add(Character.valueOf('\u30e0'));
        f.add(Character.valueOf('\u30e1'));
        f.add(Character.valueOf('\u30e2'));
        f.add(Character.valueOf('\u30e3'));
        f.add(Character.valueOf('\u30e4'));
        f.add(Character.valueOf('\u30e5'));
        f.add(Character.valueOf('\u30e6'));
        f.add(Character.valueOf('\u30e7'));
        f.add(Character.valueOf('\u30e8'));
        f.add(Character.valueOf('\u30e9'));
        f.add(Character.valueOf('\u30ea'));
        f.add(Character.valueOf('\u30eb'));
        f.add(Character.valueOf('\u30ec'));
        f.add(Character.valueOf('\u30ed'));
        f.add(Character.valueOf('\u30ee'));
        f.add(Character.valueOf('\u30ef'));
        f.add(Character.valueOf('\u30f0'));
        f.add(Character.valueOf('\u30f1'));
        f.add(Character.valueOf('\u30f2'));
        f.add(Character.valueOf('\u30f3'));
        f.add(Character.valueOf('\u30f4'));
        f.add(Character.valueOf('\u30f5'));
        f.add(Character.valueOf('\u30f6'));
        f.add(Character.valueOf('\u30fc'));
        f.add(Character.valueOf('\u30fd'));
        f.add(Character.valueOf('\u30fe'));
        f.add(Character.valueOf('\u3105'));
        f.add(Character.valueOf('\u3106'));
        f.add(Character.valueOf('\u3107'));
        f.add(Character.valueOf('\u3108'));
        f.add(Character.valueOf('\u3109'));
        f.add(Character.valueOf('\u310a'));
        f.add(Character.valueOf('\u310b'));
        f.add(Character.valueOf('\u310c'));
        f.add(Character.valueOf('\u310d'));
        f.add(Character.valueOf('\u310e'));
        f.add(Character.valueOf('\u310f'));
        f.add(Character.valueOf('\u3110'));
        f.add(Character.valueOf('\u3111'));
        f.add(Character.valueOf('\u3112'));
        f.add(Character.valueOf('\u3113'));
        f.add(Character.valueOf('\u3114'));
        f.add(Character.valueOf('\u3115'));
        f.add(Character.valueOf('\u3116'));
        f.add(Character.valueOf('\u3117'));
        f.add(Character.valueOf('\u3118'));
        f.add(Character.valueOf('\u3119'));
        f.add(Character.valueOf('\u311a'));
        f.add(Character.valueOf('\u311b'));
        f.add(Character.valueOf('\u311c'));
        f.add(Character.valueOf('\u311d'));
        f.add(Character.valueOf('\u311e'));
        f.add(Character.valueOf('\u311f'));
        f.add(Character.valueOf('\u3120'));
        f.add(Character.valueOf('\u3121'));
        f.add(Character.valueOf('\u3122'));
        f.add(Character.valueOf('\u3123'));
        f.add(Character.valueOf('\u3124'));
        f.add(Character.valueOf('\u3125'));
        f.add(Character.valueOf('\u3126'));
        f.add(Character.valueOf('\u3127'));
        f.add(Character.valueOf('\u3128'));
        f.add(Character.valueOf('\u3129'));
        f.add(Character.valueOf('\u3220'));
        f.add(Character.valueOf('\u3221'));
        f.add(Character.valueOf('\u3222'));
        f.add(Character.valueOf('\u3223'));
        f.add(Character.valueOf('\u3224'));
        f.add(Character.valueOf('\u3225'));
        f.add(Character.valueOf('\u3226'));
        f.add(Character.valueOf('\u3227'));
        f.add(Character.valueOf('\u3228'));
        f.add(Character.valueOf('\u3229'));
        f.add(Character.valueOf('\u3231'));
        f.add(Character.valueOf('\u32a3'));
        f.add(Character.valueOf('\u338e'));
        f.add(Character.valueOf('\u338f'));
        f.add(Character.valueOf('\u339c'));
        f.add(Character.valueOf('\u339d'));
        f.add(Character.valueOf('\u339e'));
        f.add(Character.valueOf('\u33a1'));
        f.add(Character.valueOf('\u33c4'));
        f.add(Character.valueOf('\u33ce'));
        f.add(Character.valueOf('\u33d1'));
        f.add(Character.valueOf('\u33d2'));
        f.add(Character.valueOf('\u33d5'));
        f.add(Character.valueOf('\u3447'));
        f.add(Character.valueOf('\u3473'));
        f.add(Character.valueOf('\u359e'));
        f.add(Character.valueOf('\u360e'));
        f.add(Character.valueOf('\u361a'));
        f.add(Character.valueOf('\u3918'));
        f.add(Character.valueOf('\u396e'));
        f.add(Character.valueOf('\u39cf'));
        f.add(Character.valueOf('\u39d0'));
        f.add(Character.valueOf('\u39df'));
        f.add(Character.valueOf('\u3a73'));
        f.add(Character.valueOf('\u3b4e'));
        f.add(Character.valueOf('\u3c6e'));
        f.add(Character.valueOf('\u3ce0'));
        f.add(Character.valueOf('\u4056'));
        f.add(Character.valueOf('\u415f'));
        f.add(Character.valueOf('\u4337'));
        f.add(Character.valueOf('\u43ac'));
        f.add(Character.valueOf('\u43b1'));
        f.add(Character.valueOf('\u43dd'));
        f.add(Character.valueOf('\u44d6'));
        f.add(Character.valueOf('\u464c'));
        f.add(Character.valueOf('\u4661'));
        f.add(Character.valueOf('\u4723'));
        f.add(Character.valueOf('\u4729'));
        f.add(Character.valueOf('\u477c'));
        f.add(Character.valueOf('\u478d'));
        f.add(Character.valueOf('\u4947'));
        f.add(Character.valueOf('\u497a'));
        f.add(Character.valueOf('\u497d'));
        f.add(Character.valueOf('\u4982'));
        f.add(Character.valueOf('\u4983'));
        f.add(Character.valueOf('\u4985'));
        f.add(Character.valueOf('\u4986'));
        f.add(Character.valueOf('\u499b'));
        f.add(Character.valueOf('\u499f'));
        f.add(Character.valueOf('\u49b6'));
        f.add(Character.valueOf('\u49b7'));
        f.add(Character.valueOf('\u4c77'));
        f.add(Character.valueOf('\u4c9f'));
        f.add(Character.valueOf('\u4ca0'));
        f.add(Character.valueOf('\u4ca1'));
        f.add(Character.valueOf('\u4ca2'));
        f.add(Character.valueOf('\u4ca3'));
        f.add(Character.valueOf('\u4d13'));
        f.add(Character.valueOf('\u4d14'));
        f.add(Character.valueOf('\u4d15'));
        f.add(Character.valueOf('\u4d16'));
        f.add(Character.valueOf('\u4d17'));
        f.add(Character.valueOf('\u4d18'));
        f.add(Character.valueOf('\u4d19'));
        f.add(Character.valueOf('\u4dae'));
        f.add(Character.valueOf('\u4e00'));
        f.add(Character.valueOf('\u4e01'));
        f.add(Character.valueOf('\u4e02'));
        f.add(Character.valueOf('\u4e03'));
        f.add(Character.valueOf('\u4e04'));
        f.add(Character.valueOf('\u4e05'));
        f.add(Character.valueOf('\u4e06'));
        f.add(Character.valueOf('\u4e07'));
        f.add(Character.valueOf('\u4e08'));
        f.add(Character.valueOf('\u4e09'));
    }

    protected static void initTWFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00a7'));
        f.add(Character.valueOf('\u00a8'));
        f.add(Character.valueOf('\u00af'));
        f.add(Character.valueOf('\u00b0'));
        f.add(Character.valueOf('\u00b1'));
        f.add(Character.valueOf('\u00b4'));
        f.add(Character.valueOf('\u00b6'));
        f.add(Character.valueOf('\u00b7'));
        f.add(Character.valueOf('\u00d7'));
        f.add(Character.valueOf('\u0100'));
        f.add(Character.valueOf('\u0101'));
        f.add(Character.valueOf('\u0102'));
        f.add(Character.valueOf('\u0103'));
        f.add(Character.valueOf('\u0104'));
        f.add(Character.valueOf('\u0105'));
        f.add(Character.valueOf('\u0106'));
        f.add(Character.valueOf('\u0107'));
        f.add(Character.valueOf('\u0108'));
        f.add(Character.valueOf('\u0109'));
        f.add(Character.valueOf('\u010a'));
        f.add(Character.valueOf('\u010b'));
        f.add(Character.valueOf('\u010c'));
        f.add(Character.valueOf('\u010d'));
        f.add(Character.valueOf('\u010e'));
        f.add(Character.valueOf('\u010f'));
        f.add(Character.valueOf('\u0110'));
        f.add(Character.valueOf('\u0111'));
        f.add(Character.valueOf('\u0112'));
        f.add(Character.valueOf('\u0113'));
        f.add(Character.valueOf('\u0114'));
        f.add(Character.valueOf('\u0115'));
        f.add(Character.valueOf('\u0116'));
        f.add(Character.valueOf('\u0117'));
        f.add(Character.valueOf('\u0118'));
        f.add(Character.valueOf('\u0119'));
        f.add(Character.valueOf('\u011a'));
        f.add(Character.valueOf('\u011b'));
        f.add(Character.valueOf('\u011c'));
        f.add(Character.valueOf('\u011d'));
        f.add(Character.valueOf('\u011e'));
        f.add(Character.valueOf('\u011f'));
        f.add(Character.valueOf('\u0120'));
        f.add(Character.valueOf('\u0121'));
        f.add(Character.valueOf('\u0122'));
        f.add(Character.valueOf('\u0123'));
        f.add(Character.valueOf('\u0124'));
        f.add(Character.valueOf('\u0125'));
        f.add(Character.valueOf('\u0126'));
        f.add(Character.valueOf('\u0127'));
        f.add(Character.valueOf('\u0128'));
        f.add(Character.valueOf('\u0129'));
        f.add(Character.valueOf('\u012a'));
        f.add(Character.valueOf('\u012b'));
        f.add(Character.valueOf('\u012c'));
        f.add(Character.valueOf('\u012d'));
        f.add(Character.valueOf('\u012e'));
        f.add(Character.valueOf('\u012f'));
        f.add(Character.valueOf('\u0130'));
        f.add(Character.valueOf('\u0131'));
        f.add(Character.valueOf('\u0132'));
        f.add(Character.valueOf('\u0133'));
        f.add(Character.valueOf('\u0134'));
        f.add(Character.valueOf('\u0135'));
        f.add(Character.valueOf('\u0136'));
        f.add(Character.valueOf('\u0137'));
        f.add(Character.valueOf('\u0138'));
        f.add(Character.valueOf('\u0139'));
        f.add(Character.valueOf('\u013a'));
        f.add(Character.valueOf('\u013b'));
        f.add(Character.valueOf('\u013c'));
        f.add(Character.valueOf('\u013d'));
        f.add(Character.valueOf('\u013e'));
        f.add(Character.valueOf('\u013f'));
        f.add(Character.valueOf('\u0140'));
        f.add(Character.valueOf('\u0141'));
        f.add(Character.valueOf('\u0142'));
        f.add(Character.valueOf('\u0143'));
        f.add(Character.valueOf('\u0144'));
        f.add(Character.valueOf('\u0145'));
        f.add(Character.valueOf('\u0146'));
        f.add(Character.valueOf('\u0147'));
        f.add(Character.valueOf('\u0148'));
        f.add(Character.valueOf('\u0149'));
        f.add(Character.valueOf('\u014a'));
        f.add(Character.valueOf('\u014b'));
        f.add(Character.valueOf('\u014c'));
        f.add(Character.valueOf('\u014d'));
        f.add(Character.valueOf('\u014e'));
        f.add(Character.valueOf('\u014f'));
        f.add(Character.valueOf('\u0150'));
        f.add(Character.valueOf('\u0151'));
        f.add(Character.valueOf('\u0152'));
        f.add(Character.valueOf('\u0153'));
        f.add(Character.valueOf('\u0154'));
        f.add(Character.valueOf('\u0155'));
        f.add(Character.valueOf('\u0156'));
        f.add(Character.valueOf('\u0157'));
        f.add(Character.valueOf('\u0158'));
        f.add(Character.valueOf('\u0159'));
        f.add(Character.valueOf('\u015a'));
        f.add(Character.valueOf('\u015b'));
        f.add(Character.valueOf('\u015c'));
        f.add(Character.valueOf('\u015d'));
        f.add(Character.valueOf('\u015e'));
        f.add(Character.valueOf('\u015f'));
        f.add(Character.valueOf('\u0160'));
        f.add(Character.valueOf('\u0161'));
        f.add(Character.valueOf('\u0162'));
        f.add(Character.valueOf('\u0163'));
        f.add(Character.valueOf('\u0164'));
        f.add(Character.valueOf('\u0165'));
        f.add(Character.valueOf('\u0166'));
        f.add(Character.valueOf('\u0167'));
        f.add(Character.valueOf('\u0168'));
        f.add(Character.valueOf('\u0169'));
        f.add(Character.valueOf('\u016a'));
        f.add(Character.valueOf('\u016b'));
        f.add(Character.valueOf('\u016c'));
        f.add(Character.valueOf('\u016d'));
        f.add(Character.valueOf('\u016e'));
        f.add(Character.valueOf('\u016f'));
        f.add(Character.valueOf('\u0170'));
        f.add(Character.valueOf('\u0171'));
        f.add(Character.valueOf('\u0172'));
        f.add(Character.valueOf('\u0173'));
        f.add(Character.valueOf('\u0174'));
        f.add(Character.valueOf('\u0175'));
        f.add(Character.valueOf('\u0176'));
        f.add(Character.valueOf('\u0177'));
        f.add(Character.valueOf('\u0178'));
        f.add(Character.valueOf('\u0179'));
        f.add(Character.valueOf('\u017a'));
        f.add(Character.valueOf('\u017b'));
        f.add(Character.valueOf('\u017c'));
        f.add(Character.valueOf('\u017d'));
        f.add(Character.valueOf('\u017e'));
        f.add(Character.valueOf('\u017f'));
        f.add(Character.valueOf('\u0180'));
        f.add(Character.valueOf('\u0181'));
        f.add(Character.valueOf('\u0182'));
        f.add(Character.valueOf('\u0183'));
        f.add(Character.valueOf('\u0184'));
        f.add(Character.valueOf('\u0185'));
        f.add(Character.valueOf('\u0186'));
        f.add(Character.valueOf('\u0187'));
        f.add(Character.valueOf('\u0188'));
        f.add(Character.valueOf('\u0189'));
        f.add(Character.valueOf('\u018a'));
        f.add(Character.valueOf('\u018b'));
        f.add(Character.valueOf('\u018c'));
        f.add(Character.valueOf('\u018d'));
        f.add(Character.valueOf('\u018e'));
        f.add(Character.valueOf('\u018f'));
        f.add(Character.valueOf('\u0190'));
        f.add(Character.valueOf('\u0191'));
        f.add(Character.valueOf('\u0192'));
        f.add(Character.valueOf('\u0193'));
        f.add(Character.valueOf('\u0194'));
        f.add(Character.valueOf('\u0195'));
        f.add(Character.valueOf('\u0196'));
        f.add(Character.valueOf('\u0197'));
        f.add(Character.valueOf('\u0198'));
        f.add(Character.valueOf('\u0199'));
        f.add(Character.valueOf('\u019a'));
        f.add(Character.valueOf('\u019b'));
        f.add(Character.valueOf('\u019c'));
        f.add(Character.valueOf('\u019d'));
        f.add(Character.valueOf('\u019e'));
        f.add(Character.valueOf('\u019f'));
        f.add(Character.valueOf('\u01a0'));
        f.add(Character.valueOf('\u01a1'));
        f.add(Character.valueOf('\u01a2'));
        f.add(Character.valueOf('\u01a3'));
        f.add(Character.valueOf('\u01a4'));
        f.add(Character.valueOf('\u01a5'));
        f.add(Character.valueOf('\u01a6'));
        f.add(Character.valueOf('\u01a7'));
        f.add(Character.valueOf('\u01a8'));
        f.add(Character.valueOf('\u01a9'));
        f.add(Character.valueOf('\u01aa'));
        f.add(Character.valueOf('\u01ab'));
        f.add(Character.valueOf('\u01ac'));
        f.add(Character.valueOf('\u01ad'));
        f.add(Character.valueOf('\u01ae'));
        f.add(Character.valueOf('\u01af'));
        f.add(Character.valueOf('\u01b0'));
        f.add(Character.valueOf('\u01b1'));
        f.add(Character.valueOf('\u01b2'));
        f.add(Character.valueOf('\u01b3'));
        f.add(Character.valueOf('\u01b4'));
        f.add(Character.valueOf('\u01b5'));
        f.add(Character.valueOf('\u01b6'));
        f.add(Character.valueOf('\u01b7'));
        f.add(Character.valueOf('\u01b8'));
        f.add(Character.valueOf('\u01b9'));
        f.add(Character.valueOf('\u01ba'));
        f.add(Character.valueOf('\u01bb'));
        f.add(Character.valueOf('\u01bc'));
        f.add(Character.valueOf('\u01bd'));
        f.add(Character.valueOf('\u01be'));
        f.add(Character.valueOf('\u01bf'));
        f.add(Character.valueOf('\u01c0'));
        f.add(Character.valueOf('\u01c1'));
        f.add(Character.valueOf('\u01c2'));
        f.add(Character.valueOf('\u01c3'));
        f.add(Character.valueOf('\u01c4'));
        f.add(Character.valueOf('\u01c5'));
        f.add(Character.valueOf('\u01c6'));
        f.add(Character.valueOf('\u01c7'));
        f.add(Character.valueOf('\u01c8'));
        f.add(Character.valueOf('\u01c9'));
        f.add(Character.valueOf('\u01ca'));
        f.add(Character.valueOf('\u01cb'));
        f.add(Character.valueOf('\u01cc'));
        f.add(Character.valueOf('\u01cd'));
        f.add(Character.valueOf('\u01ce'));
        f.add(Character.valueOf('\u01cf'));
        f.add(Character.valueOf('\u01d0'));
        f.add(Character.valueOf('\u01d1'));
        f.add(Character.valueOf('\u01d2'));
        f.add(Character.valueOf('\u01d3'));
        f.add(Character.valueOf('\u01d4'));
        f.add(Character.valueOf('\u01d5'));
        f.add(Character.valueOf('\u01d6'));
        f.add(Character.valueOf('\u01d7'));
        f.add(Character.valueOf('\u01d8'));
        f.add(Character.valueOf('\u01d9'));
        f.add(Character.valueOf('\u01da'));
        f.add(Character.valueOf('\u01db'));
        f.add(Character.valueOf('\u01dc'));
        f.add(Character.valueOf('\u01dd'));
        f.add(Character.valueOf('\u01de'));
        f.add(Character.valueOf('\u01df'));
        f.add(Character.valueOf('\u01e0'));
        f.add(Character.valueOf('\u01e1'));
        f.add(Character.valueOf('\u01e2'));
        f.add(Character.valueOf('\u01e3'));
        f.add(Character.valueOf('\u01e4'));
        f.add(Character.valueOf('\u01e5'));
        f.add(Character.valueOf('\u01e6'));
        f.add(Character.valueOf('\u01e7'));
        f.add(Character.valueOf('\u01e8'));
        f.add(Character.valueOf('\u01e9'));
        f.add(Character.valueOf('\u01ea'));
        f.add(Character.valueOf('\u01eb'));
        f.add(Character.valueOf('\u01ec'));
        f.add(Character.valueOf('\u01ed'));
        f.add(Character.valueOf('\u01ee'));
        f.add(Character.valueOf('\u01ef'));
        f.add(Character.valueOf('\u01f0'));
        f.add(Character.valueOf('\u01f1'));
        f.add(Character.valueOf('\u01f2'));
        f.add(Character.valueOf('\u01f3'));
        f.add(Character.valueOf('\u01f4'));
        f.add(Character.valueOf('\u01f5'));
        f.add(Character.valueOf('\u01f6'));
        f.add(Character.valueOf('\u01f7'));
        f.add(Character.valueOf('\u01f8'));
        f.add(Character.valueOf('\u01f9'));
        f.add(Character.valueOf('\u01fa'));
        f.add(Character.valueOf('\u01fb'));
        f.add(Character.valueOf('\u01fc'));
        f.add(Character.valueOf('\u01fd'));
        f.add(Character.valueOf('\u01fe'));
        f.add(Character.valueOf('\u01ff'));
        f.add(Character.valueOf('\u0200'));
        f.add(Character.valueOf('\u0201'));
        f.add(Character.valueOf('\u0202'));
        f.add(Character.valueOf('\u0203'));
        f.add(Character.valueOf('\u0204'));
        f.add(Character.valueOf('\u0205'));
        f.add(Character.valueOf('\u0206'));
        f.add(Character.valueOf('\u0207'));
        f.add(Character.valueOf('\u0208'));
        f.add(Character.valueOf('\u0209'));
        f.add(Character.valueOf('\u020a'));
        f.add(Character.valueOf('\u020b'));
        f.add(Character.valueOf('\u020c'));
        f.add(Character.valueOf('\u020d'));
        f.add(Character.valueOf('\u020e'));
        f.add(Character.valueOf('\u020f'));
        f.add(Character.valueOf('\u0210'));
        f.add(Character.valueOf('\u0211'));
        f.add(Character.valueOf('\u0212'));
        f.add(Character.valueOf('\u0213'));
        f.add(Character.valueOf('\u0214'));
        f.add(Character.valueOf('\u0215'));
        f.add(Character.valueOf('\u0216'));
        f.add(Character.valueOf('\u0217'));
        f.add(Character.valueOf('\u0218'));
        f.add(Character.valueOf('\u0219'));
        f.add(Character.valueOf('\u021a'));
        f.add(Character.valueOf('\u021b'));
        f.add(Character.valueOf('\u021c'));
        f.add(Character.valueOf('\u021d'));
        f.add(Character.valueOf('\u021e'));
        f.add(Character.valueOf('\u021f'));
        f.add(Character.valueOf('\u0220'));
        f.add(Character.valueOf('\u0221'));
        f.add(Character.valueOf('\u0222'));
        f.add(Character.valueOf('\u0223'));
        f.add(Character.valueOf('\u0224'));
        f.add(Character.valueOf('\u0225'));
        f.add(Character.valueOf('\u0226'));
        f.add(Character.valueOf('\u0227'));
        f.add(Character.valueOf('\u0228'));
        f.add(Character.valueOf('\u0229'));
        f.add(Character.valueOf('\u022a'));
        f.add(Character.valueOf('\u022b'));
        f.add(Character.valueOf('\u022c'));
        f.add(Character.valueOf('\u022d'));
        f.add(Character.valueOf('\u022e'));
        f.add(Character.valueOf('\u022f'));
        f.add(Character.valueOf('\u0230'));
        f.add(Character.valueOf('\u0231'));
        f.add(Character.valueOf('\u0232'));
        f.add(Character.valueOf('\u0233'));
        f.add(Character.valueOf('\u0234'));
        f.add(Character.valueOf('\u0235'));
        f.add(Character.valueOf('\u0236'));
        f.add(Character.valueOf('\u0237'));
        f.add(Character.valueOf('\u0238'));
        f.add(Character.valueOf('\u0239'));
        f.add(Character.valueOf('\u023a'));
        f.add(Character.valueOf('\u023b'));
        f.add(Character.valueOf('\u023c'));
        f.add(Character.valueOf('\u023d'));
        f.add(Character.valueOf('\u023e'));
        f.add(Character.valueOf('\u023f'));
        f.add(Character.valueOf('\u0240'));
        f.add(Character.valueOf('\u0241'));
        f.add(Character.valueOf('\u0242'));
        f.add(Character.valueOf('\u0243'));
        f.add(Character.valueOf('\u0244'));
        f.add(Character.valueOf('\u0245'));
        f.add(Character.valueOf('\u0246'));
        f.add(Character.valueOf('\u0247'));
        f.add(Character.valueOf('\u0248'));
        f.add(Character.valueOf('\u0249'));
        f.add(Character.valueOf('\u024a'));
        f.add(Character.valueOf('\u024b'));
        f.add(Character.valueOf('\u024c'));
        f.add(Character.valueOf('\u024d'));
        f.add(Character.valueOf('\u024e'));
        f.add(Character.valueOf('\u024f'));
        f.add(Character.valueOf('\u0250'));
        f.add(Character.valueOf('\u0251'));
        f.add(Character.valueOf('\u0252'));
        f.add(Character.valueOf('\u0253'));
        f.add(Character.valueOf('\u0254'));
        f.add(Character.valueOf('\u0255'));
        f.add(Character.valueOf('\u0256'));
        f.add(Character.valueOf('\u0257'));
        f.add(Character.valueOf('\u0258'));
        f.add(Character.valueOf('\u0259'));
        f.add(Character.valueOf('\u025a'));
        f.add(Character.valueOf('\u025b'));
        f.add(Character.valueOf('\u025c'));
        f.add(Character.valueOf('\u025d'));
        f.add(Character.valueOf('\u025e'));
        f.add(Character.valueOf('\u025f'));
        f.add(Character.valueOf('\u0260'));
        f.add(Character.valueOf('\u0261'));
        f.add(Character.valueOf('\u0262'));
        f.add(Character.valueOf('\u0263'));
        f.add(Character.valueOf('\u0264'));
        f.add(Character.valueOf('\u0265'));
        f.add(Character.valueOf('\u0266'));
        f.add(Character.valueOf('\u0267'));
        f.add(Character.valueOf('\u0268'));
        f.add(Character.valueOf('\u0269'));
        f.add(Character.valueOf('\u026a'));
        f.add(Character.valueOf('\u026b'));
        f.add(Character.valueOf('\u026c'));
        f.add(Character.valueOf('\u026d'));
        f.add(Character.valueOf('\u026e'));
        f.add(Character.valueOf('\u026f'));
        f.add(Character.valueOf('\u0270'));
        f.add(Character.valueOf('\u0271'));
        f.add(Character.valueOf('\u0272'));
        f.add(Character.valueOf('\u0273'));
        f.add(Character.valueOf('\u0274'));
        f.add(Character.valueOf('\u0275'));
        f.add(Character.valueOf('\u0276'));
        f.add(Character.valueOf('\u0277'));
        f.add(Character.valueOf('\u0278'));
        f.add(Character.valueOf('\u0279'));
        f.add(Character.valueOf('\u027a'));
        f.add(Character.valueOf('\u027b'));
        f.add(Character.valueOf('\u027c'));
        f.add(Character.valueOf('\u027d'));
        f.add(Character.valueOf('\u027e'));
        f.add(Character.valueOf('\u027f'));
        f.add(Character.valueOf('\u0280'));
        f.add(Character.valueOf('\u0281'));
        f.add(Character.valueOf('\u0282'));
        f.add(Character.valueOf('\u0283'));
        f.add(Character.valueOf('\u0284'));
        f.add(Character.valueOf('\u0285'));
        f.add(Character.valueOf('\u0286'));
        f.add(Character.valueOf('\u0287'));
        f.add(Character.valueOf('\u0288'));
        f.add(Character.valueOf('\u0289'));
        f.add(Character.valueOf('\u028a'));
        f.add(Character.valueOf('\u028b'));
        f.add(Character.valueOf('\u028c'));
        f.add(Character.valueOf('\u028d'));
        f.add(Character.valueOf('\u028e'));
        f.add(Character.valueOf('\u028f'));
        f.add(Character.valueOf('\u0290'));
        f.add(Character.valueOf('\u0291'));
        f.add(Character.valueOf('\u0292'));
        f.add(Character.valueOf('\u0293'));
        f.add(Character.valueOf('\u0294'));
        f.add(Character.valueOf('\u0295'));
        f.add(Character.valueOf('\u0296'));
        f.add(Character.valueOf('\u0297'));
        f.add(Character.valueOf('\u0298'));
        f.add(Character.valueOf('\u0299'));
        f.add(Character.valueOf('\u029a'));
        f.add(Character.valueOf('\u029b'));
        f.add(Character.valueOf('\u029c'));
        f.add(Character.valueOf('\u029d'));
        f.add(Character.valueOf('\u029e'));
        f.add(Character.valueOf('\u029f'));
        f.add(Character.valueOf('\u02a0'));
        f.add(Character.valueOf('\u02a1'));
        f.add(Character.valueOf('\u02a2'));
        f.add(Character.valueOf('\u02a3'));
        f.add(Character.valueOf('\u02a4'));
        f.add(Character.valueOf('\u02a5'));
        f.add(Character.valueOf('\u02a6'));
        f.add(Character.valueOf('\u02a7'));
        f.add(Character.valueOf('\u02a8'));
        f.add(Character.valueOf('\u02a9'));
        f.add(Character.valueOf('\u02aa'));
        f.add(Character.valueOf('\u02ab'));
        f.add(Character.valueOf('\u02ac'));
        f.add(Character.valueOf('\u02ad'));
        f.add(Character.valueOf('\u02ae'));
        f.add(Character.valueOf('\u02af'));
        f.add(Character.valueOf('\u02b0'));
        f.add(Character.valueOf('\u02b1'));
        f.add(Character.valueOf('\u02b2'));
        f.add(Character.valueOf('\u02b3'));
        f.add(Character.valueOf('\u02b4'));
        f.add(Character.valueOf('\u02b5'));
        f.add(Character.valueOf('\u02b6'));
        f.add(Character.valueOf('\u02b7'));
        f.add(Character.valueOf('\u02b8'));
        f.add(Character.valueOf('\u02b9'));
        f.add(Character.valueOf('\u02ba'));
        f.add(Character.valueOf('\u02bb'));
        f.add(Character.valueOf('\u02bc'));
        f.add(Character.valueOf('\u02bd'));
        f.add(Character.valueOf('\u02be'));
        f.add(Character.valueOf('\u02bf'));
        f.add(Character.valueOf('\u02c0'));
        f.add(Character.valueOf('\u02c1'));
        f.add(Character.valueOf('\u02c2'));
        f.add(Character.valueOf('\u02c3'));
        f.add(Character.valueOf('\u02c4'));
        f.add(Character.valueOf('\u02c5'));
        f.add(Character.valueOf('\u02c6'));
        f.add(Character.valueOf('\u02c7'));
        f.add(Character.valueOf('\u02c8'));
        f.add(Character.valueOf('\u02c9'));
        f.add(Character.valueOf('\u02ca'));
        f.add(Character.valueOf('\u02cb'));
        f.add(Character.valueOf('\u02cc'));
        f.add(Character.valueOf('\u02cd'));
        f.add(Character.valueOf('\u02ce'));
        f.add(Character.valueOf('\u02cf'));
        f.add(Character.valueOf('\u02d0'));
        f.add(Character.valueOf('\u02d1'));
        f.add(Character.valueOf('\u02d2'));
        f.add(Character.valueOf('\u02d3'));
        f.add(Character.valueOf('\u02d4'));
        f.add(Character.valueOf('\u02d5'));
        f.add(Character.valueOf('\u02d6'));
        f.add(Character.valueOf('\u02d7'));
        f.add(Character.valueOf('\u02d8'));
        f.add(Character.valueOf('\u02d9'));
        f.add(Character.valueOf('\u02da'));
        f.add(Character.valueOf('\u02db'));
        f.add(Character.valueOf('\u02dc'));
        f.add(Character.valueOf('\u02dd'));
        f.add(Character.valueOf('\u02de'));
        f.add(Character.valueOf('\u02df'));
        f.add(Character.valueOf('\u02e0'));
        f.add(Character.valueOf('\u02e1'));
        f.add(Character.valueOf('\u02e2'));
        f.add(Character.valueOf('\u02e3'));
        f.add(Character.valueOf('\u02e4'));
        f.add(Character.valueOf('\u02e5'));
        f.add(Character.valueOf('\u02e6'));
        f.add(Character.valueOf('\u02e7'));
        f.add(Character.valueOf('\u02e8'));
        f.add(Character.valueOf('\u02e9'));
        f.add(Character.valueOf('\u02ea'));
        f.add(Character.valueOf('\u02eb'));
        f.add(Character.valueOf('\u02ec'));
        f.add(Character.valueOf('\u02ed'));
        f.add(Character.valueOf('\u02ee'));
        f.add(Character.valueOf('\u02ef'));
        f.add(Character.valueOf('\u02f0'));
        f.add(Character.valueOf('\u02f1'));
        f.add(Character.valueOf('\u02f2'));
        f.add(Character.valueOf('\u02f3'));
        f.add(Character.valueOf('\u02f4'));
        f.add(Character.valueOf('\u02f5'));
        f.add(Character.valueOf('\u02f6'));
        f.add(Character.valueOf('\u02f7'));
        f.add(Character.valueOf('\u02f8'));
        f.add(Character.valueOf('\u02f9'));
        f.add(Character.valueOf('\u02fa'));
        f.add(Character.valueOf('\u02fb'));
        f.add(Character.valueOf('\u02fc'));
        f.add(Character.valueOf('\u02fd'));
        f.add(Character.valueOf('\u02fe'));
        f.add(Character.valueOf('\u02ff'));
        f.add(Character.valueOf('\u0300'));
        f.add(Character.valueOf('\u0301'));
        f.add(Character.valueOf('\u0302'));
        f.add(Character.valueOf('\u0303'));
        f.add(Character.valueOf('\u0304'));
        f.add(Character.valueOf('\u0305'));
        f.add(Character.valueOf('\u0306'));
        f.add(Character.valueOf('\u0307'));
        f.add(Character.valueOf('\u0308'));
        f.add(Character.valueOf('\u0309'));
        f.add(Character.valueOf('\u030a'));
        f.add(Character.valueOf('\u030b'));
        f.add(Character.valueOf('\u030c'));
        f.add(Character.valueOf('\u030d'));
        f.add(Character.valueOf('\u030e'));
        f.add(Character.valueOf('\u030f'));
        f.add(Character.valueOf('\u0310'));
        f.add(Character.valueOf('\u0311'));
        f.add(Character.valueOf('\u0312'));
        f.add(Character.valueOf('\u0313'));
        f.add(Character.valueOf('\u0314'));
        f.add(Character.valueOf('\u0315'));
        f.add(Character.valueOf('\u0316'));
        f.add(Character.valueOf('\u0317'));
        f.add(Character.valueOf('\u0318'));
        f.add(Character.valueOf('\u0319'));
        f.add(Character.valueOf('\u031a'));
        f.add(Character.valueOf('\u031b'));
        f.add(Character.valueOf('\u031c'));
        f.add(Character.valueOf('\u031d'));
        f.add(Character.valueOf('\u031e'));
        f.add(Character.valueOf('\u031f'));
        f.add(Character.valueOf('\u0320'));
        f.add(Character.valueOf('\u0321'));
        f.add(Character.valueOf('\u0322'));
        f.add(Character.valueOf('\u0323'));
        f.add(Character.valueOf('\u0324'));
        f.add(Character.valueOf('\u0325'));
        f.add(Character.valueOf('\u0326'));
        f.add(Character.valueOf('\u0327'));
        f.add(Character.valueOf('\u0328'));
        f.add(Character.valueOf('\u0329'));
        f.add(Character.valueOf('\u032a'));
        f.add(Character.valueOf('\u032b'));
        f.add(Character.valueOf('\u032c'));
        f.add(Character.valueOf('\u032d'));
        f.add(Character.valueOf('\u032e'));
        f.add(Character.valueOf('\u032f'));
        f.add(Character.valueOf('\u0330'));
        f.add(Character.valueOf('\u0331'));
        f.add(Character.valueOf('\u0332'));
        f.add(Character.valueOf('\u0333'));
        f.add(Character.valueOf('\u0334'));
        f.add(Character.valueOf('\u0335'));
        f.add(Character.valueOf('\u0336'));
        f.add(Character.valueOf('\u0337'));
        f.add(Character.valueOf('\u0338'));
        f.add(Character.valueOf('\u0339'));
        f.add(Character.valueOf('\u033a'));
        f.add(Character.valueOf('\u033b'));
        f.add(Character.valueOf('\u033c'));
        f.add(Character.valueOf('\u033d'));
        f.add(Character.valueOf('\u033e'));
        f.add(Character.valueOf('\u033f'));
        f.add(Character.valueOf('\u0340'));
        f.add(Character.valueOf('\u0341'));
        f.add(Character.valueOf('\u0342'));
        f.add(Character.valueOf('\u0343'));
        f.add(Character.valueOf('\u0344'));
        f.add(Character.valueOf('\u0345'));
        f.add(Character.valueOf('\u0346'));
        f.add(Character.valueOf('\u0347'));
        f.add(Character.valueOf('\u0348'));
        f.add(Character.valueOf('\u0349'));
        f.add(Character.valueOf('\u034a'));
        f.add(Character.valueOf('\u034b'));
        f.add(Character.valueOf('\u034c'));
        f.add(Character.valueOf('\u034d'));
        f.add(Character.valueOf('\u034e'));
        f.add(Character.valueOf('\u034f'));
        f.add(Character.valueOf('\u0350'));
        f.add(Character.valueOf('\u0351'));
        f.add(Character.valueOf('\u0352'));
        f.add(Character.valueOf('\u0353'));
        f.add(Character.valueOf('\u0354'));
        f.add(Character.valueOf('\u0355'));
        f.add(Character.valueOf('\u0356'));
        f.add(Character.valueOf('\u0357'));
        f.add(Character.valueOf('\u0358'));
        f.add(Character.valueOf('\u0359'));
        f.add(Character.valueOf('\u035a'));
        f.add(Character.valueOf('\u035b'));
        f.add(Character.valueOf('\u035c'));
        f.add(Character.valueOf('\u035d'));
        f.add(Character.valueOf('\u035e'));
        f.add(Character.valueOf('\u035f'));
        f.add(Character.valueOf('\u0360'));
        f.add(Character.valueOf('\u0361'));
        f.add(Character.valueOf('\u0362'));
        f.add(Character.valueOf('\u0363'));
        f.add(Character.valueOf('\u0364'));
        f.add(Character.valueOf('\u0365'));
        f.add(Character.valueOf('\u0366'));
        f.add(Character.valueOf('\u0367'));
        f.add(Character.valueOf('\u0368'));
        f.add(Character.valueOf('\u0369'));
        f.add(Character.valueOf('\u036a'));
        f.add(Character.valueOf('\u036b'));
        f.add(Character.valueOf('\u036c'));
        f.add(Character.valueOf('\u036d'));
        f.add(Character.valueOf('\u036e'));
        f.add(Character.valueOf('\u036f'));
        f.add(Character.valueOf('\u0370'));
        f.add(Character.valueOf('\u0371'));
        f.add(Character.valueOf('\u0372'));
        f.add(Character.valueOf('\u0373'));
        f.add(Character.valueOf('\u0374'));
        f.add(Character.valueOf('\u0375'));
        f.add(Character.valueOf('\u0376'));
        f.add(Character.valueOf('\u0377'));
        f.add(Character.valueOf('\u0378'));
        f.add(Character.valueOf('\u0379'));
        f.add(Character.valueOf('\u037a'));
        f.add(Character.valueOf('\u037b'));
        f.add(Character.valueOf('\u037c'));
        f.add(Character.valueOf('\u037d'));
        f.add(Character.valueOf('\u037e'));
        f.add(Character.valueOf('\u037f'));
        f.add(Character.valueOf('\u0380'));
        f.add(Character.valueOf('\u0381'));
        f.add(Character.valueOf('\u0382'));
        f.add(Character.valueOf('\u0383'));
        f.add(Character.valueOf('\u0384'));
        f.add(Character.valueOf('\u0385'));
        f.add(Character.valueOf('\u0386'));
        f.add(Character.valueOf('\u0387'));
        f.add(Character.valueOf('\u0388'));
        f.add(Character.valueOf('\u0389'));
        f.add(Character.valueOf('\u038a'));
        f.add(Character.valueOf('\u038b'));
        f.add(Character.valueOf('\u038c'));
        f.add(Character.valueOf('\u038d'));
        f.add(Character.valueOf('\u038e'));
        f.add(Character.valueOf('\u038f'));
        f.add(Character.valueOf('\u0390'));
        f.add(Character.valueOf('\u0391'));
        f.add(Character.valueOf('\u0392'));
        f.add(Character.valueOf('\u0393'));
        f.add(Character.valueOf('\u0394'));
        f.add(Character.valueOf('\u0395'));
        f.add(Character.valueOf('\u0396'));
        f.add(Character.valueOf('\u0397'));
        f.add(Character.valueOf('\u0398'));
        f.add(Character.valueOf('\u0399'));
        f.add(Character.valueOf('\u039a'));
        f.add(Character.valueOf('\u039b'));
        f.add(Character.valueOf('\u039c'));
        f.add(Character.valueOf('\u039d'));
        f.add(Character.valueOf('\u039e'));
        f.add(Character.valueOf('\u039f'));
        f.add(Character.valueOf('\u03a0'));
        f.add(Character.valueOf('\u03a1'));
        f.add(Character.valueOf('\u03a2'));
        f.add(Character.valueOf('\u03a3'));
        f.add(Character.valueOf('\u03a4'));
        f.add(Character.valueOf('\u03a5'));
        f.add(Character.valueOf('\u03a6'));
        f.add(Character.valueOf('\u03a7'));
        f.add(Character.valueOf('\u03a8'));
        f.add(Character.valueOf('\u03a9'));
        f.add(Character.valueOf('\u03aa'));
        f.add(Character.valueOf('\u03ab'));
        f.add(Character.valueOf('\u03ac'));
        f.add(Character.valueOf('\u03ad'));
        f.add(Character.valueOf('\u03ae'));
        f.add(Character.valueOf('\u03af'));
        f.add(Character.valueOf('\u03b0'));
        f.add(Character.valueOf('\u03b1'));
        f.add(Character.valueOf('\u03b2'));
        f.add(Character.valueOf('\u03b3'));
        f.add(Character.valueOf('\u03b4'));
        f.add(Character.valueOf('\u03b5'));
        f.add(Character.valueOf('\u03b6'));
        f.add(Character.valueOf('\u03b7'));
        f.add(Character.valueOf('\u03b8'));
        f.add(Character.valueOf('\u03b9'));
        f.add(Character.valueOf('\u03ba'));
        f.add(Character.valueOf('\u03bb'));
        f.add(Character.valueOf('\u03bc'));
        f.add(Character.valueOf('\u03bd'));
        f.add(Character.valueOf('\u03be'));
        f.add(Character.valueOf('\u03bf'));
        f.add(Character.valueOf('\u03c0'));
        f.add(Character.valueOf('\u03c1'));
        f.add(Character.valueOf('\u03c2'));
        f.add(Character.valueOf('\u03c3'));
        f.add(Character.valueOf('\u03c4'));
        f.add(Character.valueOf('\u03c5'));
        f.add(Character.valueOf('\u03c6'));
        f.add(Character.valueOf('\u03c7'));
        f.add(Character.valueOf('\u03c8'));
        f.add(Character.valueOf('\u03c9'));
        f.add(Character.valueOf('\u03ca'));
        f.add(Character.valueOf('\u03cb'));
        f.add(Character.valueOf('\u03cc'));
        f.add(Character.valueOf('\u03cd'));
        f.add(Character.valueOf('\u03ce'));
        f.add(Character.valueOf('\u03cf'));
        f.add(Character.valueOf('\u03d0'));
        f.add(Character.valueOf('\u03d1'));
        f.add(Character.valueOf('\u03d2'));
        f.add(Character.valueOf('\u03d3'));
        f.add(Character.valueOf('\u03d4'));
        f.add(Character.valueOf('\u03d5'));
        f.add(Character.valueOf('\u03d6'));
        f.add(Character.valueOf('\u03d7'));
        f.add(Character.valueOf('\u03d8'));
        f.add(Character.valueOf('\u03d9'));
        f.add(Character.valueOf('\u03da'));
        f.add(Character.valueOf('\u03db'));
        f.add(Character.valueOf('\u03dc'));
        f.add(Character.valueOf('\u03dd'));
        f.add(Character.valueOf('\u03de'));
        f.add(Character.valueOf('\u03df'));
        f.add(Character.valueOf('\u03e0'));
        f.add(Character.valueOf('\u03e1'));
        f.add(Character.valueOf('\u03e2'));
        f.add(Character.valueOf('\u03e3'));
        f.add(Character.valueOf('\u03e4'));
        f.add(Character.valueOf('\u03e5'));
        f.add(Character.valueOf('\u03e6'));
        f.add(Character.valueOf('\u03e7'));
        f.add(Character.valueOf('\u03e8'));
        f.add(Character.valueOf('\u03e9'));
        f.add(Character.valueOf('\u03ea'));
        f.add(Character.valueOf('\u03eb'));
        f.add(Character.valueOf('\u03ec'));
        f.add(Character.valueOf('\u03ed'));
        f.add(Character.valueOf('\u03ee'));
        f.add(Character.valueOf('\u03ef'));
        f.add(Character.valueOf('\u03f0'));
        f.add(Character.valueOf('\u03f1'));
        f.add(Character.valueOf('\u03f2'));
        f.add(Character.valueOf('\u03f3'));
        f.add(Character.valueOf('\u03f4'));
        f.add(Character.valueOf('\u03f5'));
        f.add(Character.valueOf('\u03f6'));
        f.add(Character.valueOf('\u03f7'));
        f.add(Character.valueOf('\u03f8'));
        f.add(Character.valueOf('\u03f9'));
        f.add(Character.valueOf('\u03fa'));
        f.add(Character.valueOf('\u03fb'));
        f.add(Character.valueOf('\u03fc'));
        f.add(Character.valueOf('\u03fd'));
        f.add(Character.valueOf('\u03fe'));
        f.add(Character.valueOf('\u03ff'));
        f.add(Character.valueOf('\u0400'));
        f.add(Character.valueOf('\u0401'));
        f.add(Character.valueOf('\u0402'));
        f.add(Character.valueOf('\u0403'));
        f.add(Character.valueOf('\u0404'));
        f.add(Character.valueOf('\u0405'));
        f.add(Character.valueOf('\u0406'));
        f.add(Character.valueOf('\u0407'));
        f.add(Character.valueOf('\u0408'));
        f.add(Character.valueOf('\u0409'));
        f.add(Character.valueOf('\u040a'));
        f.add(Character.valueOf('\u040b'));
        f.add(Character.valueOf('\u040c'));
        f.add(Character.valueOf('\u040d'));
        f.add(Character.valueOf('\u040e'));
        f.add(Character.valueOf('\u040f'));
        f.add(Character.valueOf('\u0410'));
        f.add(Character.valueOf('\u0411'));
        f.add(Character.valueOf('\u0412'));
        f.add(Character.valueOf('\u0413'));
        f.add(Character.valueOf('\u0414'));
        f.add(Character.valueOf('\u0415'));
        f.add(Character.valueOf('\u0416'));
        f.add(Character.valueOf('\u0417'));
        f.add(Character.valueOf('\u0418'));
        f.add(Character.valueOf('\u0419'));
        f.add(Character.valueOf('\u041a'));
        f.add(Character.valueOf('\u041b'));
        f.add(Character.valueOf('\u041c'));
        f.add(Character.valueOf('\u041d'));
        f.add(Character.valueOf('\u041e'));
        f.add(Character.valueOf('\u041f'));
        f.add(Character.valueOf('\u0420'));
        f.add(Character.valueOf('\u0421'));
        f.add(Character.valueOf('\u0422'));
        f.add(Character.valueOf('\u0423'));
        f.add(Character.valueOf('\u0424'));
        f.add(Character.valueOf('\u0425'));
        f.add(Character.valueOf('\u0426'));
        f.add(Character.valueOf('\u0427'));
        f.add(Character.valueOf('\u0428'));
        f.add(Character.valueOf('\u0429'));
        f.add(Character.valueOf('\u042a'));
        f.add(Character.valueOf('\u042b'));
        f.add(Character.valueOf('\u042c'));
        f.add(Character.valueOf('\u042d'));
        f.add(Character.valueOf('\u042e'));
        f.add(Character.valueOf('\u042f'));
        f.add(Character.valueOf('\u0430'));
        f.add(Character.valueOf('\u0431'));
        f.add(Character.valueOf('\u0432'));
        f.add(Character.valueOf('\u0433'));
        f.add(Character.valueOf('\u0434'));
        f.add(Character.valueOf('\u0435'));
        f.add(Character.valueOf('\u0436'));
        f.add(Character.valueOf('\u0437'));
        f.add(Character.valueOf('\u0438'));
        f.add(Character.valueOf('\u0439'));
        f.add(Character.valueOf('\u043a'));
        f.add(Character.valueOf('\u043b'));
        f.add(Character.valueOf('\u043c'));
        f.add(Character.valueOf('\u043d'));
        f.add(Character.valueOf('\u043e'));
        f.add(Character.valueOf('\u043f'));
        f.add(Character.valueOf('\u0440'));
        f.add(Character.valueOf('\u0441'));
        f.add(Character.valueOf('\u0442'));
        f.add(Character.valueOf('\u0443'));
        f.add(Character.valueOf('\u0444'));
        f.add(Character.valueOf('\u0445'));
        f.add(Character.valueOf('\u0446'));
        f.add(Character.valueOf('\u0447'));
        f.add(Character.valueOf('\u0448'));
        f.add(Character.valueOf('\u0449'));
        f.add(Character.valueOf('\u044a'));
        f.add(Character.valueOf('\u044b'));
        f.add(Character.valueOf('\u044c'));
        f.add(Character.valueOf('\u044d'));
        f.add(Character.valueOf('\u044e'));
        f.add(Character.valueOf('\u044f'));
        f.add(Character.valueOf('\u0450'));
        f.add(Character.valueOf('\u0451'));
        f.add(Character.valueOf('\u0452'));
        f.add(Character.valueOf('\u0453'));
        f.add(Character.valueOf('\u0454'));
        f.add(Character.valueOf('\u0455'));
        f.add(Character.valueOf('\u0456'));
        f.add(Character.valueOf('\u0457'));
        f.add(Character.valueOf('\u0458'));
        f.add(Character.valueOf('\u0459'));
        f.add(Character.valueOf('\u045a'));
        f.add(Character.valueOf('\u045b'));
        f.add(Character.valueOf('\u045c'));
        f.add(Character.valueOf('\u045d'));
        f.add(Character.valueOf('\u045e'));
        f.add(Character.valueOf('\u045f'));
        f.add(Character.valueOf('\u0460'));
        f.add(Character.valueOf('\u0461'));
        f.add(Character.valueOf('\u0462'));
        f.add(Character.valueOf('\u0463'));
        f.add(Character.valueOf('\u0464'));
        f.add(Character.valueOf('\u0465'));
        f.add(Character.valueOf('\u0466'));
        f.add(Character.valueOf('\u0467'));
        f.add(Character.valueOf('\u0468'));
        f.add(Character.valueOf('\u0469'));
        f.add(Character.valueOf('\u046a'));
        f.add(Character.valueOf('\u046b'));
        f.add(Character.valueOf('\u046c'));
        f.add(Character.valueOf('\u046d'));
        f.add(Character.valueOf('\u046e'));
        f.add(Character.valueOf('\u046f'));
        f.add(Character.valueOf('\u0470'));
        f.add(Character.valueOf('\u0471'));
        f.add(Character.valueOf('\u0472'));
        f.add(Character.valueOf('\u0473'));
        f.add(Character.valueOf('\u0474'));
        f.add(Character.valueOf('\u0475'));
        f.add(Character.valueOf('\u0476'));
        f.add(Character.valueOf('\u0477'));
        f.add(Character.valueOf('\u0478'));
        f.add(Character.valueOf('\u0479'));
        f.add(Character.valueOf('\u047a'));
        f.add(Character.valueOf('\u047b'));
        f.add(Character.valueOf('\u047c'));
        f.add(Character.valueOf('\u047d'));
        f.add(Character.valueOf('\u047e'));
        f.add(Character.valueOf('\u047f'));
        f.add(Character.valueOf('\u0480'));
        f.add(Character.valueOf('\u0481'));
        f.add(Character.valueOf('\u0482'));
        f.add(Character.valueOf('\u0483'));
        f.add(Character.valueOf('\u0484'));
        f.add(Character.valueOf('\u0485'));
        f.add(Character.valueOf('\u0486'));
        f.add(Character.valueOf('\u0487'));
        f.add(Character.valueOf('\u0488'));
        f.add(Character.valueOf('\u0489'));
        f.add(Character.valueOf('\u048a'));
        f.add(Character.valueOf('\u048b'));
        f.add(Character.valueOf('\u048c'));
        f.add(Character.valueOf('\u048d'));
        f.add(Character.valueOf('\u048e'));
        f.add(Character.valueOf('\u048f'));
        f.add(Character.valueOf('\u0490'));
        f.add(Character.valueOf('\u0491'));
        f.add(Character.valueOf('\u0492'));
        f.add(Character.valueOf('\u0493'));
        f.add(Character.valueOf('\u0494'));
        f.add(Character.valueOf('\u0495'));
        f.add(Character.valueOf('\u0496'));
        f.add(Character.valueOf('\u0497'));
        f.add(Character.valueOf('\u0498'));
        f.add(Character.valueOf('\u0499'));
        f.add(Character.valueOf('\u049a'));
        f.add(Character.valueOf('\u049b'));
        f.add(Character.valueOf('\u049c'));
        f.add(Character.valueOf('\u049d'));
        f.add(Character.valueOf('\u049e'));
        f.add(Character.valueOf('\u049f'));
        f.add(Character.valueOf('\u04a0'));
        f.add(Character.valueOf('\u04a1'));
        f.add(Character.valueOf('\u04a2'));
        f.add(Character.valueOf('\u04a3'));
        f.add(Character.valueOf('\u04a4'));
        f.add(Character.valueOf('\u04a5'));
        f.add(Character.valueOf('\u04a6'));
        f.add(Character.valueOf('\u04a7'));
        f.add(Character.valueOf('\u04a8'));
        f.add(Character.valueOf('\u04a9'));
        f.add(Character.valueOf('\u04aa'));
        f.add(Character.valueOf('\u04ab'));
        f.add(Character.valueOf('\u04ac'));
        f.add(Character.valueOf('\u04ad'));
        f.add(Character.valueOf('\u04ae'));
        f.add(Character.valueOf('\u04af'));
        f.add(Character.valueOf('\u04b0'));
        f.add(Character.valueOf('\u04b1'));
        f.add(Character.valueOf('\u04b2'));
        f.add(Character.valueOf('\u04b3'));
        f.add(Character.valueOf('\u04b4'));
        f.add(Character.valueOf('\u04b5'));
        f.add(Character.valueOf('\u04b6'));
        f.add(Character.valueOf('\u04b7'));
        f.add(Character.valueOf('\u04b8'));
        f.add(Character.valueOf('\u04b9'));
        f.add(Character.valueOf('\u04ba'));
        f.add(Character.valueOf('\u04bb'));
        f.add(Character.valueOf('\u04bc'));
        f.add(Character.valueOf('\u04bd'));
        f.add(Character.valueOf('\u04be'));
        f.add(Character.valueOf('\u04bf'));
        f.add(Character.valueOf('\u04c0'));
        f.add(Character.valueOf('\u04c1'));
        f.add(Character.valueOf('\u04c2'));
        f.add(Character.valueOf('\u04c3'));
        f.add(Character.valueOf('\u04c4'));
        f.add(Character.valueOf('\u04c5'));
        f.add(Character.valueOf('\u04c6'));
        f.add(Character.valueOf('\u04c7'));
        f.add(Character.valueOf('\u04c8'));
        f.add(Character.valueOf('\u04c9'));
        f.add(Character.valueOf('\u04ca'));
        f.add(Character.valueOf('\u04cb'));
        f.add(Character.valueOf('\u04cc'));
        f.add(Character.valueOf('\u04cd'));
        f.add(Character.valueOf('\u04ce'));
        f.add(Character.valueOf('\u04cf'));
        f.add(Character.valueOf('\u04d0'));
        f.add(Character.valueOf('\u04d1'));
        f.add(Character.valueOf('\u04d2'));
        f.add(Character.valueOf('\u04d3'));
        f.add(Character.valueOf('\u04d4'));
        f.add(Character.valueOf('\u04d5'));
        f.add(Character.valueOf('\u04d6'));
        f.add(Character.valueOf('\u04d7'));
        f.add(Character.valueOf('\u04d8'));
        f.add(Character.valueOf('\u04d9'));
        f.add(Character.valueOf('\u04da'));
        f.add(Character.valueOf('\u04db'));
        f.add(Character.valueOf('\u04dc'));
        f.add(Character.valueOf('\u04dd'));
        f.add(Character.valueOf('\u04de'));
        f.add(Character.valueOf('\u04df'));
        f.add(Character.valueOf('\u04e0'));
        f.add(Character.valueOf('\u04e1'));
        f.add(Character.valueOf('\u04e2'));
        f.add(Character.valueOf('\u04e3'));
        f.add(Character.valueOf('\u04e4'));
        f.add(Character.valueOf('\u04e5'));
        f.add(Character.valueOf('\u04e6'));
        f.add(Character.valueOf('\u04e7'));
        f.add(Character.valueOf('\u04e8'));
        f.add(Character.valueOf('\u04e9'));
        f.add(Character.valueOf('\u04ea'));
        f.add(Character.valueOf('\u04eb'));
        f.add(Character.valueOf('\u04ec'));
        f.add(Character.valueOf('\u04ed'));
        f.add(Character.valueOf('\u04ee'));
        f.add(Character.valueOf('\u04ef'));
        f.add(Character.valueOf('\u04f0'));
        f.add(Character.valueOf('\u04f1'));
        f.add(Character.valueOf('\u04f2'));
        f.add(Character.valueOf('\u04f3'));
        f.add(Character.valueOf('\u04f4'));
        f.add(Character.valueOf('\u04f5'));
        f.add(Character.valueOf('\u04f6'));
        f.add(Character.valueOf('\u04f7'));
        f.add(Character.valueOf('\u04f8'));
        f.add(Character.valueOf('\u04f9'));
        f.add(Character.valueOf('\u04fa'));
        f.add(Character.valueOf('\u04fb'));
        f.add(Character.valueOf('\u04fc'));
        f.add(Character.valueOf('\u04fd'));
        f.add(Character.valueOf('\u04fe'));
        f.add(Character.valueOf('\u04ff'));
        f.add(Character.valueOf('\u0500'));
        f.add(Character.valueOf('\u0501'));
        f.add(Character.valueOf('\u0502'));
        f.add(Character.valueOf('\u0503'));
        f.add(Character.valueOf('\u0504'));
        f.add(Character.valueOf('\u0505'));
        f.add(Character.valueOf('\u0506'));
        f.add(Character.valueOf('\u0507'));
        f.add(Character.valueOf('\u0508'));
        f.add(Character.valueOf('\u0509'));
        f.add(Character.valueOf('\u050a'));
        f.add(Character.valueOf('\u050b'));
        f.add(Character.valueOf('\u050c'));
        f.add(Character.valueOf('\u050d'));
        f.add(Character.valueOf('\u050e'));
        f.add(Character.valueOf('\u050f'));
        f.add(Character.valueOf('\u0510'));
        f.add(Character.valueOf('\u0511'));
        f.add(Character.valueOf('\u0512'));
        f.add(Character.valueOf('\u0513'));
        f.add(Character.valueOf('\u0514'));
        f.add(Character.valueOf('\u0515'));
        f.add(Character.valueOf('\u0516'));
        f.add(Character.valueOf('\u0517'));
        f.add(Character.valueOf('\u0518'));
        f.add(Character.valueOf('\u0519'));
        f.add(Character.valueOf('\u051a'));
        f.add(Character.valueOf('\u051b'));
        f.add(Character.valueOf('\u051c'));
        f.add(Character.valueOf('\u051d'));
        f.add(Character.valueOf('\u051e'));
        f.add(Character.valueOf('\u051f'));
        f.add(Character.valueOf('\u0520'));
        f.add(Character.valueOf('\u0521'));
        f.add(Character.valueOf('\u0522'));
        f.add(Character.valueOf('\u0523'));
        f.add(Character.valueOf('\u0524'));
        f.add(Character.valueOf('\u0525'));
        f.add(Character.valueOf('\u0526'));
        f.add(Character.valueOf('\u0527'));
        f.add(Character.valueOf('\u0528'));
        f.add(Character.valueOf('\u0529'));
        f.add(Character.valueOf('\u052a'));
        f.add(Character.valueOf('\u052b'));
        f.add(Character.valueOf('\u052c'));
        f.add(Character.valueOf('\u052d'));
        f.add(Character.valueOf('\u052e'));
        f.add(Character.valueOf('\u052f'));
        f.add(Character.valueOf('\u0530'));
        f.add(Character.valueOf('\u0531'));
        f.add(Character.valueOf('\u0532'));
        f.add(Character.valueOf('\u0533'));
        f.add(Character.valueOf('\u0534'));
        f.add(Character.valueOf('\u0535'));
        f.add(Character.valueOf('\u0536'));
        f.add(Character.valueOf('\u0537'));
        f.add(Character.valueOf('\u0538'));
        f.add(Character.valueOf('\u0539'));
        f.add(Character.valueOf('\u053a'));
        f.add(Character.valueOf('\u053b'));
        f.add(Character.valueOf('\u053c'));
        f.add(Character.valueOf('\u053d'));
        f.add(Character.valueOf('\u053e'));
        f.add(Character.valueOf('\u053f'));
        f.add(Character.valueOf('\u0540'));
        f.add(Character.valueOf('\u0541'));
        f.add(Character.valueOf('\u0542'));
        f.add(Character.valueOf('\u0543'));
        f.add(Character.valueOf('\u0544'));
        f.add(Character.valueOf('\u0545'));
        f.add(Character.valueOf('\u0546'));
        f.add(Character.valueOf('\u0547'));
        f.add(Character.valueOf('\u0548'));
        f.add(Character.valueOf('\u0549'));
        f.add(Character.valueOf('\u054a'));
        f.add(Character.valueOf('\u054b'));
        f.add(Character.valueOf('\u054c'));
        f.add(Character.valueOf('\u054d'));
        f.add(Character.valueOf('\u054e'));
        f.add(Character.valueOf('\u054f'));
        f.add(Character.valueOf('\u0550'));
        f.add(Character.valueOf('\u0551'));
        f.add(Character.valueOf('\u0552'));
        f.add(Character.valueOf('\u0553'));
        f.add(Character.valueOf('\u0554'));
        f.add(Character.valueOf('\u0555'));
        f.add(Character.valueOf('\u0556'));
        f.add(Character.valueOf('\u0557'));
        f.add(Character.valueOf('\u0558'));
        f.add(Character.valueOf('\u0559'));
        f.add(Character.valueOf('\u055a'));
        f.add(Character.valueOf('\u055b'));
        f.add(Character.valueOf('\u055c'));
        f.add(Character.valueOf('\u055d'));
        f.add(Character.valueOf('\u055e'));
        f.add(Character.valueOf('\u055f'));
        f.add(Character.valueOf('\u0560'));
        f.add(Character.valueOf('\u0561'));
        f.add(Character.valueOf('\u0562'));
        f.add(Character.valueOf('\u0563'));
        f.add(Character.valueOf('\u0564'));
        f.add(Character.valueOf('\u0565'));
        f.add(Character.valueOf('\u0566'));
        f.add(Character.valueOf('\u0567'));
        f.add(Character.valueOf('\u0568'));
        f.add(Character.valueOf('\u0569'));
        f.add(Character.valueOf('\u056a'));
        f.add(Character.valueOf('\u056b'));
        f.add(Character.valueOf('\u056c'));
        f.add(Character.valueOf('\u056d'));
        f.add(Character.valueOf('\u056e'));
        f.add(Character.valueOf('\u056f'));
        f.add(Character.valueOf('\u0570'));
        f.add(Character.valueOf('\u0571'));
        f.add(Character.valueOf('\u0572'));
        f.add(Character.valueOf('\u0573'));
        f.add(Character.valueOf('\u0574'));
        f.add(Character.valueOf('\u0575'));
        f.add(Character.valueOf('\u0576'));
        f.add(Character.valueOf('\u0577'));
        f.add(Character.valueOf('\u0578'));
        f.add(Character.valueOf('\u0579'));
        f.add(Character.valueOf('\u057a'));
        f.add(Character.valueOf('\u057b'));
        f.add(Character.valueOf('\u057c'));
        f.add(Character.valueOf('\u057d'));
        f.add(Character.valueOf('\u057e'));
        f.add(Character.valueOf('\u057f'));
        f.add(Character.valueOf('\u0580'));
        f.add(Character.valueOf('\u0581'));
        f.add(Character.valueOf('\u0582'));
        f.add(Character.valueOf('\u0583'));
        f.add(Character.valueOf('\u0584'));
        f.add(Character.valueOf('\u0585'));
        f.add(Character.valueOf('\u0586'));
        f.add(Character.valueOf('\u0587'));
    }

    protected static void initRUFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00b5'));
        f.add(Character.valueOf('\u0401'));
        f.add(Character.valueOf('\u0402'));
        f.add(Character.valueOf('\u0403'));
        f.add(Character.valueOf('\u0404'));
        f.add(Character.valueOf('\u0405'));
        f.add(Character.valueOf('\u0406'));
        f.add(Character.valueOf('\u0407'));
        f.add(Character.valueOf('\u0408'));
        f.add(Character.valueOf('\u0409'));
        f.add(Character.valueOf('\u040a'));
        f.add(Character.valueOf('\u040b'));
        f.add(Character.valueOf('\u040c'));
        f.add(Character.valueOf('\u040e'));
        f.add(Character.valueOf('\u040f'));
        f.add(Character.valueOf('\u0410'));
        f.add(Character.valueOf('\u0411'));
        f.add(Character.valueOf('\u0412'));
        f.add(Character.valueOf('\u0413'));
        f.add(Character.valueOf('\u0414'));
        f.add(Character.valueOf('\u0415'));
        f.add(Character.valueOf('\u0416'));
        f.add(Character.valueOf('\u0417'));
        f.add(Character.valueOf('\u0418'));
        f.add(Character.valueOf('\u0419'));
        f.add(Character.valueOf('\u041a'));
        f.add(Character.valueOf('\u041b'));
        f.add(Character.valueOf('\u041c'));
        f.add(Character.valueOf('\u041d'));
        f.add(Character.valueOf('\u041e'));
        f.add(Character.valueOf('\u041f'));
        f.add(Character.valueOf('\u0420'));
        f.add(Character.valueOf('\u0421'));
        f.add(Character.valueOf('\u0422'));
        f.add(Character.valueOf('\u0423'));
        f.add(Character.valueOf('\u0424'));
        f.add(Character.valueOf('\u0425'));
        f.add(Character.valueOf('\u0426'));
        f.add(Character.valueOf('\u0427'));
        f.add(Character.valueOf('\u0428'));
        f.add(Character.valueOf('\u0429'));
        f.add(Character.valueOf('\u042a'));
        f.add(Character.valueOf('\u042b'));
        f.add(Character.valueOf('\u042c'));
        f.add(Character.valueOf('\u042d'));
        f.add(Character.valueOf('\u042e'));
        f.add(Character.valueOf('\u042f'));
        f.add(Character.valueOf('\u0430'));
        f.add(Character.valueOf('\u0431'));
        f.add(Character.valueOf('\u0432'));
        f.add(Character.valueOf('\u0433'));
        f.add(Character.valueOf('\u0434'));
        f.add(Character.valueOf('\u0435'));
        f.add(Character.valueOf('\u0436'));
        f.add(Character.valueOf('\u0437'));
        f.add(Character.valueOf('\u0438'));
        f.add(Character.valueOf('\u0439'));
        f.add(Character.valueOf('\u043a'));
        f.add(Character.valueOf('\u043b'));
        f.add(Character.valueOf('\u043c'));
        f.add(Character.valueOf('\u043d'));
        f.add(Character.valueOf('\u043e'));
        f.add(Character.valueOf('\u043f'));
        f.add(Character.valueOf('\u0440'));
        f.add(Character.valueOf('\u0441'));
        f.add(Character.valueOf('\u0442'));
        f.add(Character.valueOf('\u0443'));
        f.add(Character.valueOf('\u0444'));
        f.add(Character.valueOf('\u0445'));
        f.add(Character.valueOf('\u0446'));
        f.add(Character.valueOf('\u0447'));
        f.add(Character.valueOf('\u0448'));
        f.add(Character.valueOf('\u0449'));
        f.add(Character.valueOf('\u044a'));
        f.add(Character.valueOf('\u044b'));
        f.add(Character.valueOf('\u044c'));
        f.add(Character.valueOf('\u044d'));
        f.add(Character.valueOf('\u044e'));
        f.add(Character.valueOf('\u044f'));
        f.add(Character.valueOf('\u0451'));
        f.add(Character.valueOf('\u0452'));
        f.add(Character.valueOf('\u0453'));
        f.add(Character.valueOf('\u0454'));
        f.add(Character.valueOf('\u0455'));
        f.add(Character.valueOf('\u0456'));
        f.add(Character.valueOf('\u0457'));
        f.add(Character.valueOf('\u0458'));
        f.add(Character.valueOf('\u0459'));
        f.add(Character.valueOf('\u045a'));
        f.add(Character.valueOf('\u045b'));
        f.add(Character.valueOf('\u045c'));
        f.add(Character.valueOf('\u045e'));
        f.add(Character.valueOf('\u045f'));
        f.add(Character.valueOf('\u0490'));
        f.add(Character.valueOf('\u0491'));
    }

    protected static void initPTFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00aa'));
        f.add(Character.valueOf('\u00ba'));
        f.add(Character.valueOf('\u00c0'));
        f.add(Character.valueOf('\u00c1'));
        f.add(Character.valueOf('\u00c2'));
        f.add(Character.valueOf('\u00c3'));
        f.add(Character.valueOf('\u00c4'));
        f.add(Character.valueOf('\u00c5'));
        f.add(Character.valueOf('\u00c6'));
        f.add(Character.valueOf('\u00c7'));
        f.add(Character.valueOf('\u00c8'));
        f.add(Character.valueOf('\u00c9'));
        f.add(Character.valueOf('\u00ca'));
        f.add(Character.valueOf('\u00cb'));
        f.add(Character.valueOf('\u00cc'));
        f.add(Character.valueOf('\u00cd'));
        f.add(Character.valueOf('\u00ce'));
        f.add(Character.valueOf('\u00cf'));
        f.add(Character.valueOf('\u00d0'));
        f.add(Character.valueOf('\u00d1'));
        f.add(Character.valueOf('\u00d2'));
        f.add(Character.valueOf('\u00d3'));
        f.add(Character.valueOf('\u00d4'));
        f.add(Character.valueOf('\u00d5'));
        f.add(Character.valueOf('\u00d6'));
        f.add(Character.valueOf('\u00d8'));
        f.add(Character.valueOf('\u00d9'));
        f.add(Character.valueOf('\u00da'));
        f.add(Character.valueOf('\u00db'));
        f.add(Character.valueOf('\u00dc'));
        f.add(Character.valueOf('\u00dd'));
        f.add(Character.valueOf('\u00de'));
        f.add(Character.valueOf('\u00df'));
        f.add(Character.valueOf('\u00e0'));
        f.add(Character.valueOf('\u00e1'));
        f.add(Character.valueOf('\u00e2'));
        f.add(Character.valueOf('\u00e3'));
        f.add(Character.valueOf('\u00e4'));
        f.add(Character.valueOf('\u00e5'));
        f.add(Character.valueOf('\u00e6'));
        f.add(Character.valueOf('\u00e7'));
        f.add(Character.valueOf('\u00e8'));
        f.add(Character.valueOf('\u00e9'));
        f.add(Character.valueOf('\u00ea'));
        f.add(Character.valueOf('\u00eb'));
        f.add(Character.valueOf('\u00ec'));
        f.add(Character.valueOf('\u00ed'));
        f.add(Character.valueOf('\u00ee'));
        f.add(Character.valueOf('\u00ef'));
        f.add(Character.valueOf('\u00f0'));
        f.add(Character.valueOf('\u00f1'));
        f.add(Character.valueOf('\u00f2'));
        f.add(Character.valueOf('\u00f3'));
        f.add(Character.valueOf('\u00f4'));
        f.add(Character.valueOf('\u00f5'));
        f.add(Character.valueOf('\u00f6'));
        f.add(Character.valueOf('\u00f8'));
        f.add(Character.valueOf('\u00f9'));
        f.add(Character.valueOf('\u00fa'));
        f.add(Character.valueOf('\u00fb'));
        f.add(Character.valueOf('\u00fc'));
        f.add(Character.valueOf('\u00fd'));
        f.add(Character.valueOf('\u00fe'));
        f.add(Character.valueOf('\u00ff'));
        f.add(Character.valueOf('\u0152'));
        f.add(Character.valueOf('\u0153'));
        f.add(Character.valueOf('\u0160'));
        f.add(Character.valueOf('\u0161'));
        f.add(Character.valueOf('\u0178'));
    }

    protected static void initPLFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00b5'));
        f.add(Character.valueOf('\u00c1'));
        f.add(Character.valueOf('\u00c2'));
        f.add(Character.valueOf('\u00c4'));
        f.add(Character.valueOf('\u00c7'));
        f.add(Character.valueOf('\u00c9'));
        f.add(Character.valueOf('\u00cb'));
        f.add(Character.valueOf('\u00cd'));
        f.add(Character.valueOf('\u00ce'));
        f.add(Character.valueOf('\u00d3'));
        f.add(Character.valueOf('\u00d4'));
        f.add(Character.valueOf('\u00d6'));
        f.add(Character.valueOf('\u00da'));
        f.add(Character.valueOf('\u00dc'));
        f.add(Character.valueOf('\u00dd'));
        f.add(Character.valueOf('\u00df'));
        f.add(Character.valueOf('\u00e1'));
        f.add(Character.valueOf('\u00e2'));
        f.add(Character.valueOf('\u00e4'));
        f.add(Character.valueOf('\u00e7'));
        f.add(Character.valueOf('\u00e9'));
        f.add(Character.valueOf('\u00eb'));
        f.add(Character.valueOf('\u00ed'));
        f.add(Character.valueOf('\u00ee'));
        f.add(Character.valueOf('\u00f3'));
        f.add(Character.valueOf('\u00f4'));
        f.add(Character.valueOf('\u00f6'));
        f.add(Character.valueOf('\u00fa'));
        f.add(Character.valueOf('\u00fc'));
        f.add(Character.valueOf('\u00fd'));
        f.add(Character.valueOf('\u0102'));
        f.add(Character.valueOf('\u0103'));
        f.add(Character.valueOf('\u0104'));
        f.add(Character.valueOf('\u0105'));
        f.add(Character.valueOf('\u0106'));
        f.add(Character.valueOf('\u0107'));
        f.add(Character.valueOf('\u010c'));
        f.add(Character.valueOf('\u010d'));
        f.add(Character.valueOf('\u010e'));
        f.add(Character.valueOf('\u010f'));
        f.add(Character.valueOf('\u0110'));
        f.add(Character.valueOf('\u0111'));
        f.add(Character.valueOf('\u0118'));
        f.add(Character.valueOf('\u0119'));
        f.add(Character.valueOf('\u011a'));
        f.add(Character.valueOf('\u011b'));
        f.add(Character.valueOf('\u0139'));
        f.add(Character.valueOf('\u013a'));
        f.add(Character.valueOf('\u013d'));
        f.add(Character.valueOf('\u013e'));
        f.add(Character.valueOf('\u0141'));
        f.add(Character.valueOf('\u0142'));
        f.add(Character.valueOf('\u0143'));
        f.add(Character.valueOf('\u0144'));
        f.add(Character.valueOf('\u0147'));
        f.add(Character.valueOf('\u0148'));
        f.add(Character.valueOf('\u0150'));
        f.add(Character.valueOf('\u0151'));
        f.add(Character.valueOf('\u0154'));
        f.add(Character.valueOf('\u0155'));
        f.add(Character.valueOf('\u0158'));
        f.add(Character.valueOf('\u0159'));
        f.add(Character.valueOf('\u015a'));
        f.add(Character.valueOf('\u015b'));
        f.add(Character.valueOf('\u015e'));
        f.add(Character.valueOf('\u015f'));
        f.add(Character.valueOf('\u0160'));
        f.add(Character.valueOf('\u0161'));
        f.add(Character.valueOf('\u0162'));
        f.add(Character.valueOf('\u0163'));
        f.add(Character.valueOf('\u0164'));
        f.add(Character.valueOf('\u0165'));
        f.add(Character.valueOf('\u016e'));
        f.add(Character.valueOf('\u016f'));
        f.add(Character.valueOf('\u0170'));
        f.add(Character.valueOf('\u0171'));
        f.add(Character.valueOf('\u0179'));
        f.add(Character.valueOf('\u017a'));
        f.add(Character.valueOf('\u017b'));
        f.add(Character.valueOf('\u017c'));
        f.add(Character.valueOf('\u017d'));
        f.add(Character.valueOf('\u017e'));
    }

    protected static void initKOFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00a1'));
        f.add(Character.valueOf('\u00a4'));
        f.add(Character.valueOf('\u00a7'));
        f.add(Character.valueOf('\u00a8'));
        f.add(Character.valueOf('\u00aa'));
        f.add(Character.valueOf('\u00ad'));
        f.add(Character.valueOf('\u00ae'));
        f.add(Character.valueOf('\u00b0'));
        f.add(Character.valueOf('\u00b1'));
        f.add(Character.valueOf('\u00b2'));
        f.add(Character.valueOf('\u00b3'));
        f.add(Character.valueOf('\u00b4'));
        f.add(Character.valueOf('\u00b6'));
        f.add(Character.valueOf('\u00b7'));
        f.add(Character.valueOf('\u00b8'));
        f.add(Character.valueOf('\u00b9'));
        f.add(Character.valueOf('\u00ba'));
        f.add(Character.valueOf('\u00bc'));
        f.add(Character.valueOf('\u00bd'));
        f.add(Character.valueOf('\u00be'));
        f.add(Character.valueOf('\u00bf'));
        f.add(Character.valueOf('\u00c6'));
        f.add(Character.valueOf('\u00d0'));
        f.add(Character.valueOf('\u00d7'));
        f.add(Character.valueOf('\u00d8'));
        f.add(Character.valueOf('\u00de'));
        f.add(Character.valueOf('\u00df'));
        f.add(Character.valueOf('\u00e6'));
        f.add(Character.valueOf('\u00f0'));
        f.add(Character.valueOf('\u00f8'));
        f.add(Character.valueOf('\u00fe'));
        f.add(Character.valueOf('\u0100'));
        f.add(Character.valueOf('\u0101'));
        f.add(Character.valueOf('\u0102'));
        f.add(Character.valueOf('\u0103'));
        f.add(Character.valueOf('\u0104'));
        f.add(Character.valueOf('\u0105'));
        f.add(Character.valueOf('\u0106'));
        f.add(Character.valueOf('\u0107'));
        f.add(Character.valueOf('\u0108'));
        f.add(Character.valueOf('\u0109'));
        f.add(Character.valueOf('\u010a'));
        f.add(Character.valueOf('\u010b'));
        f.add(Character.valueOf('\u010c'));
        f.add(Character.valueOf('\u010d'));
        f.add(Character.valueOf('\u010e'));
        f.add(Character.valueOf('\u010f'));
        f.add(Character.valueOf('\u0110'));
        f.add(Character.valueOf('\u0111'));
        f.add(Character.valueOf('\u0112'));
        f.add(Character.valueOf('\u0113'));
        f.add(Character.valueOf('\u0114'));
        f.add(Character.valueOf('\u0115'));
        f.add(Character.valueOf('\u0116'));
        f.add(Character.valueOf('\u0117'));
        f.add(Character.valueOf('\u0118'));
        f.add(Character.valueOf('\u0119'));
        f.add(Character.valueOf('\u011a'));
        f.add(Character.valueOf('\u011b'));
        f.add(Character.valueOf('\u011c'));
        f.add(Character.valueOf('\u011d'));
        f.add(Character.valueOf('\u011e'));
        f.add(Character.valueOf('\u011f'));
        f.add(Character.valueOf('\u0120'));
        f.add(Character.valueOf('\u0121'));
        f.add(Character.valueOf('\u0122'));
        f.add(Character.valueOf('\u0123'));
        f.add(Character.valueOf('\u0124'));
        f.add(Character.valueOf('\u0125'));
        f.add(Character.valueOf('\u0126'));
        f.add(Character.valueOf('\u0127'));
        f.add(Character.valueOf('\u0128'));
        f.add(Character.valueOf('\u0129'));
        f.add(Character.valueOf('\u012a'));
        f.add(Character.valueOf('\u012b'));
        f.add(Character.valueOf('\u012c'));
        f.add(Character.valueOf('\u012d'));
        f.add(Character.valueOf('\u012e'));
        f.add(Character.valueOf('\u012f'));
        f.add(Character.valueOf('\u0130'));
        f.add(Character.valueOf('\u0131'));
        f.add(Character.valueOf('\u0132'));
        f.add(Character.valueOf('\u0133'));
        f.add(Character.valueOf('\u0134'));
        f.add(Character.valueOf('\u0135'));
        f.add(Character.valueOf('\u0136'));
        f.add(Character.valueOf('\u0137'));
        f.add(Character.valueOf('\u0138'));
        f.add(Character.valueOf('\u0139'));
        f.add(Character.valueOf('\u013a'));
        f.add(Character.valueOf('\u013b'));
        f.add(Character.valueOf('\u013c'));
        f.add(Character.valueOf('\u013d'));
        f.add(Character.valueOf('\u013e'));
        f.add(Character.valueOf('\u013f'));
        f.add(Character.valueOf('\u0140'));
        f.add(Character.valueOf('\u0141'));
        f.add(Character.valueOf('\u0142'));
        f.add(Character.valueOf('\u0143'));
        f.add(Character.valueOf('\u0144'));
        f.add(Character.valueOf('\u0145'));
        f.add(Character.valueOf('\u0146'));
        f.add(Character.valueOf('\u0147'));
        f.add(Character.valueOf('\u0148'));
        f.add(Character.valueOf('\u0149'));
        f.add(Character.valueOf('\u014a'));
        f.add(Character.valueOf('\u014b'));
        f.add(Character.valueOf('\u014c'));
        f.add(Character.valueOf('\u014d'));
        f.add(Character.valueOf('\u014e'));
        f.add(Character.valueOf('\u014f'));
        f.add(Character.valueOf('\u0150'));
        f.add(Character.valueOf('\u0151'));
        f.add(Character.valueOf('\u0152'));
        f.add(Character.valueOf('\u0153'));
        f.add(Character.valueOf('\u0154'));
        f.add(Character.valueOf('\u0155'));
        f.add(Character.valueOf('\u0156'));
        f.add(Character.valueOf('\u0157'));
        f.add(Character.valueOf('\u0158'));
        f.add(Character.valueOf('\u0159'));
        f.add(Character.valueOf('\u015a'));
        f.add(Character.valueOf('\u015b'));
        f.add(Character.valueOf('\u015c'));
        f.add(Character.valueOf('\u015d'));
        f.add(Character.valueOf('\u015e'));
        f.add(Character.valueOf('\u015f'));
        f.add(Character.valueOf('\u0160'));
        f.add(Character.valueOf('\u0161'));
        f.add(Character.valueOf('\u0162'));
        f.add(Character.valueOf('\u0163'));
        f.add(Character.valueOf('\u0164'));
        f.add(Character.valueOf('\u0165'));
        f.add(Character.valueOf('\u0166'));
        f.add(Character.valueOf('\u0167'));
        f.add(Character.valueOf('\u0168'));
        f.add(Character.valueOf('\u0169'));
        f.add(Character.valueOf('\u016a'));
        f.add(Character.valueOf('\u016b'));
        f.add(Character.valueOf('\u016c'));
        f.add(Character.valueOf('\u016d'));
        f.add(Character.valueOf('\u016e'));
        f.add(Character.valueOf('\u016f'));
        f.add(Character.valueOf('\u0170'));
        f.add(Character.valueOf('\u0171'));
        f.add(Character.valueOf('\u0172'));
        f.add(Character.valueOf('\u0173'));
        f.add(Character.valueOf('\u0174'));
        f.add(Character.valueOf('\u0175'));
        f.add(Character.valueOf('\u0176'));
        f.add(Character.valueOf('\u0177'));
        f.add(Character.valueOf('\u0178'));
        f.add(Character.valueOf('\u0179'));
        f.add(Character.valueOf('\u017a'));
        f.add(Character.valueOf('\u017b'));
        f.add(Character.valueOf('\u017c'));
        f.add(Character.valueOf('\u017d'));
        f.add(Character.valueOf('\u017e'));
        f.add(Character.valueOf('\u017f'));
        f.add(Character.valueOf('\u0180'));
        f.add(Character.valueOf('\u0181'));
        f.add(Character.valueOf('\u0182'));
        f.add(Character.valueOf('\u0183'));
        f.add(Character.valueOf('\u0184'));
        f.add(Character.valueOf('\u0185'));
        f.add(Character.valueOf('\u0186'));
        f.add(Character.valueOf('\u0187'));
        f.add(Character.valueOf('\u0188'));
        f.add(Character.valueOf('\u0189'));
        f.add(Character.valueOf('\u018a'));
        f.add(Character.valueOf('\u018b'));
        f.add(Character.valueOf('\u018c'));
        f.add(Character.valueOf('\u018d'));
        f.add(Character.valueOf('\u018e'));
        f.add(Character.valueOf('\u018f'));
        f.add(Character.valueOf('\u0190'));
        f.add(Character.valueOf('\u0191'));
        f.add(Character.valueOf('\u0192'));
        f.add(Character.valueOf('\u0193'));
        f.add(Character.valueOf('\u0194'));
        f.add(Character.valueOf('\u0195'));
        f.add(Character.valueOf('\u0196'));
        f.add(Character.valueOf('\u0197'));
        f.add(Character.valueOf('\u0198'));
        f.add(Character.valueOf('\u0199'));
        f.add(Character.valueOf('\u019a'));
        f.add(Character.valueOf('\u019b'));
        f.add(Character.valueOf('\u019c'));
        f.add(Character.valueOf('\u019d'));
        f.add(Character.valueOf('\u019e'));
        f.add(Character.valueOf('\u019f'));
        f.add(Character.valueOf('\u01a0'));
        f.add(Character.valueOf('\u01a1'));
        f.add(Character.valueOf('\u01a2'));
        f.add(Character.valueOf('\u01a3'));
        f.add(Character.valueOf('\u01a4'));
        f.add(Character.valueOf('\u01a5'));
        f.add(Character.valueOf('\u01a6'));
        f.add(Character.valueOf('\u01a7'));
        f.add(Character.valueOf('\u01a8'));
        f.add(Character.valueOf('\u01a9'));
        f.add(Character.valueOf('\u01aa'));
        f.add(Character.valueOf('\u01ab'));
        f.add(Character.valueOf('\u01ac'));
        f.add(Character.valueOf('\u01ad'));
        f.add(Character.valueOf('\u01ae'));
        f.add(Character.valueOf('\u01af'));
        f.add(Character.valueOf('\u01b0'));
        f.add(Character.valueOf('\u01b1'));
        f.add(Character.valueOf('\u01b2'));
        f.add(Character.valueOf('\u01b3'));
        f.add(Character.valueOf('\u01b4'));
        f.add(Character.valueOf('\u01b5'));
        f.add(Character.valueOf('\u01b6'));
        f.add(Character.valueOf('\u01b7'));
        f.add(Character.valueOf('\u01b8'));
        f.add(Character.valueOf('\u01b9'));
        f.add(Character.valueOf('\u01ba'));
        f.add(Character.valueOf('\u01bb'));
        f.add(Character.valueOf('\u01bc'));
        f.add(Character.valueOf('\u01bd'));
        f.add(Character.valueOf('\u01be'));
        f.add(Character.valueOf('\u01bf'));
        f.add(Character.valueOf('\u01c0'));
        f.add(Character.valueOf('\u01c1'));
        f.add(Character.valueOf('\u01c2'));
        f.add(Character.valueOf('\u01c3'));
        f.add(Character.valueOf('\u01c4'));
        f.add(Character.valueOf('\u01c5'));
        f.add(Character.valueOf('\u01c6'));
        f.add(Character.valueOf('\u01c7'));
        f.add(Character.valueOf('\u01c8'));
        f.add(Character.valueOf('\u01c9'));
        f.add(Character.valueOf('\u01ca'));
        f.add(Character.valueOf('\u01cb'));
        f.add(Character.valueOf('\u01cc'));
        f.add(Character.valueOf('\u01cd'));
        f.add(Character.valueOf('\u01ce'));
        f.add(Character.valueOf('\u01cf'));
        f.add(Character.valueOf('\u01d0'));
        f.add(Character.valueOf('\u01d1'));
        f.add(Character.valueOf('\u01d2'));
        f.add(Character.valueOf('\u01d3'));
        f.add(Character.valueOf('\u01d4'));
        f.add(Character.valueOf('\u01d5'));
        f.add(Character.valueOf('\u01d6'));
        f.add(Character.valueOf('\u01d7'));
        f.add(Character.valueOf('\u01d8'));
        f.add(Character.valueOf('\u01d9'));
        f.add(Character.valueOf('\u01da'));
        f.add(Character.valueOf('\u01db'));
        f.add(Character.valueOf('\u01dc'));
        f.add(Character.valueOf('\u01dd'));
        f.add(Character.valueOf('\u01de'));
        f.add(Character.valueOf('\u01df'));
        f.add(Character.valueOf('\u01e0'));
        f.add(Character.valueOf('\u01e1'));
        f.add(Character.valueOf('\u01e2'));
        f.add(Character.valueOf('\u01e3'));
        f.add(Character.valueOf('\u01e4'));
        f.add(Character.valueOf('\u01e5'));
        f.add(Character.valueOf('\u01e6'));
        f.add(Character.valueOf('\u01e7'));
        f.add(Character.valueOf('\u01e8'));
        f.add(Character.valueOf('\u01e9'));
        f.add(Character.valueOf('\u01ea'));
        f.add(Character.valueOf('\u01eb'));
        f.add(Character.valueOf('\u01ec'));
        f.add(Character.valueOf('\u01ed'));
        f.add(Character.valueOf('\u01ee'));
        f.add(Character.valueOf('\u01ef'));
        f.add(Character.valueOf('\u01f0'));
        f.add(Character.valueOf('\u01f1'));
        f.add(Character.valueOf('\u01f2'));
        f.add(Character.valueOf('\u01f3'));
        f.add(Character.valueOf('\u01f4'));
        f.add(Character.valueOf('\u01f5'));
        f.add(Character.valueOf('\u01f6'));
        f.add(Character.valueOf('\u01f7'));
        f.add(Character.valueOf('\u01f8'));
        f.add(Character.valueOf('\u01f9'));
        f.add(Character.valueOf('\u01fa'));
        f.add(Character.valueOf('\u01fb'));
        f.add(Character.valueOf('\u01fc'));
        f.add(Character.valueOf('\u01fd'));
        f.add(Character.valueOf('\u01fe'));
        f.add(Character.valueOf('\u01ff'));
        f.add(Character.valueOf('\u0200'));
        f.add(Character.valueOf('\u0201'));
        f.add(Character.valueOf('\u0202'));
        f.add(Character.valueOf('\u0203'));
        f.add(Character.valueOf('\u0204'));
        f.add(Character.valueOf('\u0205'));
        f.add(Character.valueOf('\u0206'));
        f.add(Character.valueOf('\u0207'));
        f.add(Character.valueOf('\u0208'));
        f.add(Character.valueOf('\u0209'));
        f.add(Character.valueOf('\u020a'));
        f.add(Character.valueOf('\u020b'));
        f.add(Character.valueOf('\u020c'));
        f.add(Character.valueOf('\u020d'));
        f.add(Character.valueOf('\u020e'));
        f.add(Character.valueOf('\u020f'));
        f.add(Character.valueOf('\u0210'));
        f.add(Character.valueOf('\u0211'));
        f.add(Character.valueOf('\u0212'));
        f.add(Character.valueOf('\u0213'));
        f.add(Character.valueOf('\u0214'));
        f.add(Character.valueOf('\u0215'));
        f.add(Character.valueOf('\u0216'));
        f.add(Character.valueOf('\u0217'));
        f.add(Character.valueOf('\u0218'));
        f.add(Character.valueOf('\u0219'));
        f.add(Character.valueOf('\u021a'));
        f.add(Character.valueOf('\u021b'));
        f.add(Character.valueOf('\u021c'));
        f.add(Character.valueOf('\u021d'));
        f.add(Character.valueOf('\u021e'));
        f.add(Character.valueOf('\u021f'));
        f.add(Character.valueOf('\u0220'));
        f.add(Character.valueOf('\u0221'));
        f.add(Character.valueOf('\u0222'));
        f.add(Character.valueOf('\u0223'));
        f.add(Character.valueOf('\u0224'));
        f.add(Character.valueOf('\u0225'));
        f.add(Character.valueOf('\u0226'));
        f.add(Character.valueOf('\u0227'));
        f.add(Character.valueOf('\u0228'));
        f.add(Character.valueOf('\u0229'));
        f.add(Character.valueOf('\u022a'));
        f.add(Character.valueOf('\u022b'));
        f.add(Character.valueOf('\u022c'));
        f.add(Character.valueOf('\u022d'));
        f.add(Character.valueOf('\u022e'));
        f.add(Character.valueOf('\u022f'));
        f.add(Character.valueOf('\u0230'));
        f.add(Character.valueOf('\u0231'));
        f.add(Character.valueOf('\u0232'));
        f.add(Character.valueOf('\u0233'));
        f.add(Character.valueOf('\u0234'));
        f.add(Character.valueOf('\u0235'));
        f.add(Character.valueOf('\u0236'));
        f.add(Character.valueOf('\u0237'));
        f.add(Character.valueOf('\u0238'));
        f.add(Character.valueOf('\u0239'));
        f.add(Character.valueOf('\u023a'));
        f.add(Character.valueOf('\u023b'));
        f.add(Character.valueOf('\u023c'));
        f.add(Character.valueOf('\u023d'));
        f.add(Character.valueOf('\u023e'));
        f.add(Character.valueOf('\u023f'));
        f.add(Character.valueOf('\u0240'));
        f.add(Character.valueOf('\u0241'));
        f.add(Character.valueOf('\u0242'));
        f.add(Character.valueOf('\u0243'));
        f.add(Character.valueOf('\u0244'));
        f.add(Character.valueOf('\u0245'));
        f.add(Character.valueOf('\u0246'));
        f.add(Character.valueOf('\u0247'));
        f.add(Character.valueOf('\u0248'));
        f.add(Character.valueOf('\u0249'));
        f.add(Character.valueOf('\u024a'));
        f.add(Character.valueOf('\u024b'));
        f.add(Character.valueOf('\u024c'));
        f.add(Character.valueOf('\u024d'));
        f.add(Character.valueOf('\u024e'));
        f.add(Character.valueOf('\u024f'));
        f.add(Character.valueOf('\u0250'));
        f.add(Character.valueOf('\u0251'));
        f.add(Character.valueOf('\u0252'));
        f.add(Character.valueOf('\u0253'));
        f.add(Character.valueOf('\u0254'));
        f.add(Character.valueOf('\u0255'));
        f.add(Character.valueOf('\u0256'));
        f.add(Character.valueOf('\u0257'));
        f.add(Character.valueOf('\u0258'));
        f.add(Character.valueOf('\u0259'));
        f.add(Character.valueOf('\u025a'));
        f.add(Character.valueOf('\u025b'));
        f.add(Character.valueOf('\u025c'));
        f.add(Character.valueOf('\u025d'));
        f.add(Character.valueOf('\u025e'));
        f.add(Character.valueOf('\u025f'));
        f.add(Character.valueOf('\u0260'));
        f.add(Character.valueOf('\u0261'));
        f.add(Character.valueOf('\u0262'));
        f.add(Character.valueOf('\u0263'));
        f.add(Character.valueOf('\u0264'));
        f.add(Character.valueOf('\u0265'));
        f.add(Character.valueOf('\u0266'));
        f.add(Character.valueOf('\u0267'));
        f.add(Character.valueOf('\u0268'));
        f.add(Character.valueOf('\u0269'));
        f.add(Character.valueOf('\u026a'));
        f.add(Character.valueOf('\u026b'));
        f.add(Character.valueOf('\u026c'));
        f.add(Character.valueOf('\u026d'));
        f.add(Character.valueOf('\u026e'));
        f.add(Character.valueOf('\u026f'));
        f.add(Character.valueOf('\u0270'));
        f.add(Character.valueOf('\u0271'));
        f.add(Character.valueOf('\u0272'));
        f.add(Character.valueOf('\u0273'));
        f.add(Character.valueOf('\u0274'));
        f.add(Character.valueOf('\u0275'));
        f.add(Character.valueOf('\u0276'));
        f.add(Character.valueOf('\u0277'));
        f.add(Character.valueOf('\u0278'));
        f.add(Character.valueOf('\u0279'));
        f.add(Character.valueOf('\u027a'));
        f.add(Character.valueOf('\u027b'));
        f.add(Character.valueOf('\u027c'));
        f.add(Character.valueOf('\u027d'));
        f.add(Character.valueOf('\u027e'));
        f.add(Character.valueOf('\u027f'));
        f.add(Character.valueOf('\u0280'));
        f.add(Character.valueOf('\u0281'));
        f.add(Character.valueOf('\u0282'));
        f.add(Character.valueOf('\u0283'));
        f.add(Character.valueOf('\u0284'));
        f.add(Character.valueOf('\u0285'));
        f.add(Character.valueOf('\u0286'));
        f.add(Character.valueOf('\u0287'));
        f.add(Character.valueOf('\u0288'));
        f.add(Character.valueOf('\u0289'));
        f.add(Character.valueOf('\u028a'));
        f.add(Character.valueOf('\u028b'));
        f.add(Character.valueOf('\u028c'));
        f.add(Character.valueOf('\u028d'));
        f.add(Character.valueOf('\u028e'));
        f.add(Character.valueOf('\u028f'));
        f.add(Character.valueOf('\u0290'));
        f.add(Character.valueOf('\u0291'));
        f.add(Character.valueOf('\u0292'));
        f.add(Character.valueOf('\u0293'));
        f.add(Character.valueOf('\u0294'));
        f.add(Character.valueOf('\u0295'));
        f.add(Character.valueOf('\u0296'));
        f.add(Character.valueOf('\u0297'));
        f.add(Character.valueOf('\u0298'));
        f.add(Character.valueOf('\u0299'));
        f.add(Character.valueOf('\u029a'));
        f.add(Character.valueOf('\u029b'));
        f.add(Character.valueOf('\u029c'));
        f.add(Character.valueOf('\u029d'));
        f.add(Character.valueOf('\u029e'));
        f.add(Character.valueOf('\u029f'));
        f.add(Character.valueOf('\u02a0'));
        f.add(Character.valueOf('\u02a1'));
        f.add(Character.valueOf('\u02a2'));
        f.add(Character.valueOf('\u02a3'));
        f.add(Character.valueOf('\u02a4'));
        f.add(Character.valueOf('\u02a5'));
        f.add(Character.valueOf('\u02a6'));
        f.add(Character.valueOf('\u02a7'));
        f.add(Character.valueOf('\u02a8'));
        f.add(Character.valueOf('\u02a9'));
        f.add(Character.valueOf('\u02aa'));
        f.add(Character.valueOf('\u02ab'));
        f.add(Character.valueOf('\u02ac'));
        f.add(Character.valueOf('\u02ad'));
        f.add(Character.valueOf('\u02ae'));
        f.add(Character.valueOf('\u02af'));
        f.add(Character.valueOf('\u02b0'));
        f.add(Character.valueOf('\u02b1'));
        f.add(Character.valueOf('\u02b2'));
        f.add(Character.valueOf('\u02b3'));
        f.add(Character.valueOf('\u02b4'));
        f.add(Character.valueOf('\u02b5'));
        f.add(Character.valueOf('\u02b6'));
        f.add(Character.valueOf('\u02b7'));
        f.add(Character.valueOf('\u02b8'));
        f.add(Character.valueOf('\u02b9'));
        f.add(Character.valueOf('\u02ba'));
        f.add(Character.valueOf('\u02bb'));
        f.add(Character.valueOf('\u02bc'));
        f.add(Character.valueOf('\u02bd'));
        f.add(Character.valueOf('\u02be'));
        f.add(Character.valueOf('\u02bf'));
        f.add(Character.valueOf('\u02c0'));
        f.add(Character.valueOf('\u02c1'));
        f.add(Character.valueOf('\u02c2'));
        f.add(Character.valueOf('\u02c3'));
        f.add(Character.valueOf('\u02c4'));
        f.add(Character.valueOf('\u02c5'));
        f.add(Character.valueOf('\u02c6'));
        f.add(Character.valueOf('\u02c7'));
        f.add(Character.valueOf('\u02c8'));
        f.add(Character.valueOf('\u02c9'));
        f.add(Character.valueOf('\u02ca'));
        f.add(Character.valueOf('\u02cb'));
        f.add(Character.valueOf('\u02cc'));
        f.add(Character.valueOf('\u02cd'));
        f.add(Character.valueOf('\u02ce'));
        f.add(Character.valueOf('\u02cf'));
        f.add(Character.valueOf('\u02d0'));
        f.add(Character.valueOf('\u02d1'));
        f.add(Character.valueOf('\u02d2'));
        f.add(Character.valueOf('\u02d3'));
        f.add(Character.valueOf('\u02d4'));
        f.add(Character.valueOf('\u02d5'));
        f.add(Character.valueOf('\u02d6'));
        f.add(Character.valueOf('\u02d7'));
        f.add(Character.valueOf('\u02d8'));
        f.add(Character.valueOf('\u02d9'));
        f.add(Character.valueOf('\u02da'));
        f.add(Character.valueOf('\u02db'));
        f.add(Character.valueOf('\u02dc'));
        f.add(Character.valueOf('\u02dd'));
        f.add(Character.valueOf('\u02de'));
        f.add(Character.valueOf('\u02df'));
        f.add(Character.valueOf('\u02e0'));
        f.add(Character.valueOf('\u02e1'));
        f.add(Character.valueOf('\u02e2'));
        f.add(Character.valueOf('\u02e3'));
        f.add(Character.valueOf('\u02e4'));
        f.add(Character.valueOf('\u02e5'));
        f.add(Character.valueOf('\u02e6'));
        f.add(Character.valueOf('\u02e7'));
        f.add(Character.valueOf('\u02e8'));
        f.add(Character.valueOf('\u02e9'));
        f.add(Character.valueOf('\u02ea'));
        f.add(Character.valueOf('\u02eb'));
        f.add(Character.valueOf('\u02ec'));
        f.add(Character.valueOf('\u02ed'));
        f.add(Character.valueOf('\u02ee'));
        f.add(Character.valueOf('\u02ef'));
        f.add(Character.valueOf('\u02f0'));
        f.add(Character.valueOf('\u02f1'));
        f.add(Character.valueOf('\u02f2'));
        f.add(Character.valueOf('\u02f3'));
        f.add(Character.valueOf('\u02f4'));
        f.add(Character.valueOf('\u02f5'));
        f.add(Character.valueOf('\u02f6'));
        f.add(Character.valueOf('\u02f7'));
        f.add(Character.valueOf('\u02f8'));
        f.add(Character.valueOf('\u02f9'));
        f.add(Character.valueOf('\u02fa'));
        f.add(Character.valueOf('\u02fb'));
        f.add(Character.valueOf('\u02fc'));
        f.add(Character.valueOf('\u02fd'));
        f.add(Character.valueOf('\u02fe'));
        f.add(Character.valueOf('\u02ff'));
        f.add(Character.valueOf('\u0300'));
        f.add(Character.valueOf('\u0301'));
        f.add(Character.valueOf('\u0302'));
        f.add(Character.valueOf('\u0303'));
        f.add(Character.valueOf('\u0304'));
        f.add(Character.valueOf('\u0305'));
        f.add(Character.valueOf('\u0306'));
        f.add(Character.valueOf('\u0307'));
        f.add(Character.valueOf('\u0308'));
        f.add(Character.valueOf('\u0309'));
        f.add(Character.valueOf('\u030a'));
        f.add(Character.valueOf('\u030b'));
        f.add(Character.valueOf('\u030c'));
        f.add(Character.valueOf('\u030d'));
        f.add(Character.valueOf('\u030e'));
        f.add(Character.valueOf('\u030f'));
        f.add(Character.valueOf('\u0310'));
        f.add(Character.valueOf('\u0311'));
        f.add(Character.valueOf('\u0312'));
        f.add(Character.valueOf('\u0313'));
        f.add(Character.valueOf('\u0314'));
        f.add(Character.valueOf('\u0315'));
        f.add(Character.valueOf('\u0316'));
        f.add(Character.valueOf('\u0317'));
        f.add(Character.valueOf('\u0318'));
        f.add(Character.valueOf('\u0319'));
        f.add(Character.valueOf('\u031a'));
        f.add(Character.valueOf('\u031b'));
        f.add(Character.valueOf('\u031c'));
        f.add(Character.valueOf('\u031d'));
        f.add(Character.valueOf('\u031e'));
        f.add(Character.valueOf('\u031f'));
        f.add(Character.valueOf('\u0320'));
        f.add(Character.valueOf('\u0321'));
        f.add(Character.valueOf('\u0322'));
        f.add(Character.valueOf('\u0323'));
        f.add(Character.valueOf('\u0324'));
        f.add(Character.valueOf('\u0325'));
        f.add(Character.valueOf('\u0326'));
        f.add(Character.valueOf('\u0327'));
        f.add(Character.valueOf('\u0328'));
        f.add(Character.valueOf('\u0329'));
        f.add(Character.valueOf('\u032a'));
        f.add(Character.valueOf('\u032b'));
        f.add(Character.valueOf('\u032c'));
        f.add(Character.valueOf('\u032d'));
        f.add(Character.valueOf('\u032e'));
        f.add(Character.valueOf('\u032f'));
        f.add(Character.valueOf('\u0330'));
        f.add(Character.valueOf('\u0331'));
        f.add(Character.valueOf('\u0332'));
        f.add(Character.valueOf('\u0333'));
        f.add(Character.valueOf('\u0334'));
        f.add(Character.valueOf('\u0335'));
        f.add(Character.valueOf('\u0336'));
        f.add(Character.valueOf('\u0337'));
        f.add(Character.valueOf('\u0338'));
        f.add(Character.valueOf('\u0339'));
        f.add(Character.valueOf('\u033a'));
        f.add(Character.valueOf('\u033b'));
        f.add(Character.valueOf('\u033c'));
        f.add(Character.valueOf('\u033d'));
        f.add(Character.valueOf('\u033e'));
        f.add(Character.valueOf('\u033f'));
        f.add(Character.valueOf('\u0340'));
        f.add(Character.valueOf('\u0341'));
        f.add(Character.valueOf('\u0342'));
        f.add(Character.valueOf('\u0343'));
        f.add(Character.valueOf('\u0344'));
        f.add(Character.valueOf('\u0345'));
        f.add(Character.valueOf('\u0346'));
        f.add(Character.valueOf('\u0347'));
        f.add(Character.valueOf('\u0348'));
        f.add(Character.valueOf('\u0349'));
        f.add(Character.valueOf('\u034a'));
        f.add(Character.valueOf('\u034b'));
        f.add(Character.valueOf('\u034c'));
        f.add(Character.valueOf('\u034d'));
        f.add(Character.valueOf('\u034e'));
        f.add(Character.valueOf('\u034f'));
        f.add(Character.valueOf('\u0350'));
        f.add(Character.valueOf('\u0351'));
        f.add(Character.valueOf('\u0352'));
        f.add(Character.valueOf('\u0353'));
        f.add(Character.valueOf('\u0354'));
        f.add(Character.valueOf('\u0355'));
        f.add(Character.valueOf('\u0356'));
        f.add(Character.valueOf('\u0357'));
        f.add(Character.valueOf('\u0358'));
        f.add(Character.valueOf('\u0359'));
        f.add(Character.valueOf('\u035a'));
        f.add(Character.valueOf('\u035b'));
        f.add(Character.valueOf('\u035c'));
        f.add(Character.valueOf('\u035d'));
        f.add(Character.valueOf('\u035e'));
        f.add(Character.valueOf('\u035f'));
        f.add(Character.valueOf('\u0360'));
        f.add(Character.valueOf('\u0361'));
        f.add(Character.valueOf('\u0362'));
        f.add(Character.valueOf('\u0363'));
        f.add(Character.valueOf('\u0364'));
        f.add(Character.valueOf('\u0365'));
        f.add(Character.valueOf('\u0366'));
        f.add(Character.valueOf('\u0367'));
        f.add(Character.valueOf('\u0368'));
        f.add(Character.valueOf('\u0369'));
        f.add(Character.valueOf('\u036a'));
        f.add(Character.valueOf('\u036b'));
        f.add(Character.valueOf('\u036c'));
        f.add(Character.valueOf('\u036d'));
        f.add(Character.valueOf('\u036e'));
        f.add(Character.valueOf('\u036f'));
        f.add(Character.valueOf('\u0370'));
        f.add(Character.valueOf('\u0371'));
        f.add(Character.valueOf('\u0372'));
        f.add(Character.valueOf('\u0373'));
        f.add(Character.valueOf('\u0374'));
        f.add(Character.valueOf('\u0375'));
        f.add(Character.valueOf('\u0376'));
        f.add(Character.valueOf('\u0377'));
        f.add(Character.valueOf('\u0378'));
        f.add(Character.valueOf('\u0379'));
        f.add(Character.valueOf('\u037a'));
        f.add(Character.valueOf('\u037b'));
        f.add(Character.valueOf('\u037c'));
        f.add(Character.valueOf('\u037d'));
        f.add(Character.valueOf('\u037e'));
        f.add(Character.valueOf('\u037f'));
        f.add(Character.valueOf('\u0380'));
        f.add(Character.valueOf('\u0381'));
        f.add(Character.valueOf('\u0382'));
        f.add(Character.valueOf('\u0383'));
        f.add(Character.valueOf('\u0384'));
        f.add(Character.valueOf('\u0385'));
        f.add(Character.valueOf('\u0386'));
        f.add(Character.valueOf('\u0387'));
        f.add(Character.valueOf('\u0388'));
        f.add(Character.valueOf('\u0389'));
        f.add(Character.valueOf('\u038a'));
        f.add(Character.valueOf('\u038b'));
        f.add(Character.valueOf('\u038c'));
        f.add(Character.valueOf('\u038d'));
        f.add(Character.valueOf('\u038e'));
        f.add(Character.valueOf('\u038f'));
        f.add(Character.valueOf('\u0390'));
        f.add(Character.valueOf('\u0391'));
        f.add(Character.valueOf('\u0392'));
        f.add(Character.valueOf('\u0393'));
        f.add(Character.valueOf('\u0394'));
        f.add(Character.valueOf('\u0395'));
        f.add(Character.valueOf('\u0396'));
        f.add(Character.valueOf('\u0397'));
        f.add(Character.valueOf('\u0398'));
        f.add(Character.valueOf('\u0399'));
        f.add(Character.valueOf('\u039a'));
        f.add(Character.valueOf('\u039b'));
        f.add(Character.valueOf('\u039c'));
        f.add(Character.valueOf('\u039d'));
        f.add(Character.valueOf('\u039e'));
        f.add(Character.valueOf('\u039f'));
        f.add(Character.valueOf('\u03a0'));
        f.add(Character.valueOf('\u03a1'));
        f.add(Character.valueOf('\u03a2'));
        f.add(Character.valueOf('\u03a3'));
        f.add(Character.valueOf('\u03a4'));
        f.add(Character.valueOf('\u03a5'));
        f.add(Character.valueOf('\u03a6'));
        f.add(Character.valueOf('\u03a7'));
        f.add(Character.valueOf('\u03a8'));
        f.add(Character.valueOf('\u03a9'));
        f.add(Character.valueOf('\u03aa'));
        f.add(Character.valueOf('\u03ab'));
        f.add(Character.valueOf('\u03ac'));
        f.add(Character.valueOf('\u03ad'));
        f.add(Character.valueOf('\u03ae'));
        f.add(Character.valueOf('\u03af'));
        f.add(Character.valueOf('\u03b0'));
        f.add(Character.valueOf('\u03b1'));
        f.add(Character.valueOf('\u03b2'));
        f.add(Character.valueOf('\u03b3'));
        f.add(Character.valueOf('\u03b4'));
        f.add(Character.valueOf('\u03b5'));
        f.add(Character.valueOf('\u03b6'));
        f.add(Character.valueOf('\u03b7'));
        f.add(Character.valueOf('\u03b8'));
        f.add(Character.valueOf('\u03b9'));
        f.add(Character.valueOf('\u03ba'));
        f.add(Character.valueOf('\u03bb'));
        f.add(Character.valueOf('\u03bc'));
        f.add(Character.valueOf('\u03bd'));
        f.add(Character.valueOf('\u03be'));
        f.add(Character.valueOf('\u03bf'));
        f.add(Character.valueOf('\u03c0'));
        f.add(Character.valueOf('\u03c1'));
        f.add(Character.valueOf('\u03c2'));
        f.add(Character.valueOf('\u03c3'));
        f.add(Character.valueOf('\u03c4'));
        f.add(Character.valueOf('\u03c5'));
        f.add(Character.valueOf('\u03c6'));
        f.add(Character.valueOf('\u03c7'));
        f.add(Character.valueOf('\u03c8'));
        f.add(Character.valueOf('\u03c9'));
        f.add(Character.valueOf('\u03ca'));
        f.add(Character.valueOf('\u03cb'));
        f.add(Character.valueOf('\u03cc'));
        f.add(Character.valueOf('\u03cd'));
        f.add(Character.valueOf('\u03ce'));
        f.add(Character.valueOf('\u03cf'));
        f.add(Character.valueOf('\u03d0'));
        f.add(Character.valueOf('\u03d1'));
        f.add(Character.valueOf('\u03d2'));
        f.add(Character.valueOf('\u03d3'));
        f.add(Character.valueOf('\u03d4'));
        f.add(Character.valueOf('\u03d5'));
        f.add(Character.valueOf('\u03d6'));
        f.add(Character.valueOf('\u03d7'));
        f.add(Character.valueOf('\u03d8'));
        f.add(Character.valueOf('\u03d9'));
        f.add(Character.valueOf('\u03da'));
        f.add(Character.valueOf('\u03db'));
        f.add(Character.valueOf('\u03dc'));
        f.add(Character.valueOf('\u03dd'));
        f.add(Character.valueOf('\u03de'));
        f.add(Character.valueOf('\u03df'));
        f.add(Character.valueOf('\u03e0'));
        f.add(Character.valueOf('\u03e1'));
        f.add(Character.valueOf('\u03e2'));
        f.add(Character.valueOf('\u03e3'));
        f.add(Character.valueOf('\u03e4'));
        f.add(Character.valueOf('\u03e5'));
        f.add(Character.valueOf('\u03e6'));
        f.add(Character.valueOf('\u03e7'));
        f.add(Character.valueOf('\u03e8'));
        f.add(Character.valueOf('\u03e9'));
        f.add(Character.valueOf('\u03ea'));
        f.add(Character.valueOf('\u03eb'));
        f.add(Character.valueOf('\u03ec'));
        f.add(Character.valueOf('\u03ed'));
        f.add(Character.valueOf('\u03ee'));
        f.add(Character.valueOf('\u03ef'));
        f.add(Character.valueOf('\u03f0'));
        f.add(Character.valueOf('\u03f1'));
        f.add(Character.valueOf('\u03f2'));
        f.add(Character.valueOf('\u03f3'));
        f.add(Character.valueOf('\u03f4'));
        f.add(Character.valueOf('\u03f5'));
        f.add(Character.valueOf('\u03f6'));
        f.add(Character.valueOf('\u03f7'));
        f.add(Character.valueOf('\u03f8'));
        f.add(Character.valueOf('\u03f9'));
        f.add(Character.valueOf('\u03fa'));
        f.add(Character.valueOf('\u03fb'));
        f.add(Character.valueOf('\u03fc'));
        f.add(Character.valueOf('\u03fd'));
        f.add(Character.valueOf('\u03fe'));
        f.add(Character.valueOf('\u03ff'));
        f.add(Character.valueOf('\u0400'));
        f.add(Character.valueOf('\u0401'));
        f.add(Character.valueOf('\u0402'));
        f.add(Character.valueOf('\u0403'));
        f.add(Character.valueOf('\u0404'));
        f.add(Character.valueOf('\u0405'));
        f.add(Character.valueOf('\u0406'));
        f.add(Character.valueOf('\u0407'));
        f.add(Character.valueOf('\u0408'));
        f.add(Character.valueOf('\u0409'));
        f.add(Character.valueOf('\u040a'));
        f.add(Character.valueOf('\u040b'));
        f.add(Character.valueOf('\u040c'));
        f.add(Character.valueOf('\u040d'));
        f.add(Character.valueOf('\u040e'));
        f.add(Character.valueOf('\u040f'));
        f.add(Character.valueOf('\u0410'));
        f.add(Character.valueOf('\u0411'));
        f.add(Character.valueOf('\u0412'));
        f.add(Character.valueOf('\u0413'));
        f.add(Character.valueOf('\u0414'));
        f.add(Character.valueOf('\u0415'));
        f.add(Character.valueOf('\u0416'));
        f.add(Character.valueOf('\u0417'));
        f.add(Character.valueOf('\u0418'));
        f.add(Character.valueOf('\u0419'));
        f.add(Character.valueOf('\u041a'));
        f.add(Character.valueOf('\u041b'));
        f.add(Character.valueOf('\u041c'));
        f.add(Character.valueOf('\u041d'));
        f.add(Character.valueOf('\u041e'));
        f.add(Character.valueOf('\u041f'));
        f.add(Character.valueOf('\u0420'));
        f.add(Character.valueOf('\u0421'));
        f.add(Character.valueOf('\u0422'));
        f.add(Character.valueOf('\u0423'));
        f.add(Character.valueOf('\u0424'));
        f.add(Character.valueOf('\u0425'));
        f.add(Character.valueOf('\u0426'));
        f.add(Character.valueOf('\u0427'));
        f.add(Character.valueOf('\u0428'));
        f.add(Character.valueOf('\u0429'));
        f.add(Character.valueOf('\u042a'));
        f.add(Character.valueOf('\u042b'));
        f.add(Character.valueOf('\u042c'));
        f.add(Character.valueOf('\u042d'));
        f.add(Character.valueOf('\u042e'));
        f.add(Character.valueOf('\u042f'));
        f.add(Character.valueOf('\u0430'));
        f.add(Character.valueOf('\u0431'));
        f.add(Character.valueOf('\u0432'));
        f.add(Character.valueOf('\u0433'));
        f.add(Character.valueOf('\u0434'));
        f.add(Character.valueOf('\u0435'));
        f.add(Character.valueOf('\u0436'));
        f.add(Character.valueOf('\u0437'));
        f.add(Character.valueOf('\u0438'));
        f.add(Character.valueOf('\u0439'));
        f.add(Character.valueOf('\u043a'));
        f.add(Character.valueOf('\u043b'));
        f.add(Character.valueOf('\u043c'));
        f.add(Character.valueOf('\u043d'));
        f.add(Character.valueOf('\u043e'));
        f.add(Character.valueOf('\u043f'));
        f.add(Character.valueOf('\u0440'));
        f.add(Character.valueOf('\u0441'));
        f.add(Character.valueOf('\u0442'));
        f.add(Character.valueOf('\u0443'));
        f.add(Character.valueOf('\u0444'));
        f.add(Character.valueOf('\u0445'));
        f.add(Character.valueOf('\u0446'));
        f.add(Character.valueOf('\u0447'));
        f.add(Character.valueOf('\u0448'));
        f.add(Character.valueOf('\u0449'));
        f.add(Character.valueOf('\u044a'));
        f.add(Character.valueOf('\u044b'));
        f.add(Character.valueOf('\u044c'));
        f.add(Character.valueOf('\u044d'));
        f.add(Character.valueOf('\u044e'));
        f.add(Character.valueOf('\u044f'));
        f.add(Character.valueOf('\u0450'));
        f.add(Character.valueOf('\u0451'));
        f.add(Character.valueOf('\u0452'));
        f.add(Character.valueOf('\u0453'));
        f.add(Character.valueOf('\u0454'));
        f.add(Character.valueOf('\u0455'));
        f.add(Character.valueOf('\u0456'));
        f.add(Character.valueOf('\u0457'));
        f.add(Character.valueOf('\u0458'));
        f.add(Character.valueOf('\u0459'));
        f.add(Character.valueOf('\u045a'));
        f.add(Character.valueOf('\u045b'));
        f.add(Character.valueOf('\u045c'));
        f.add(Character.valueOf('\u045d'));
        f.add(Character.valueOf('\u045e'));
        f.add(Character.valueOf('\u045f'));
        f.add(Character.valueOf('\u0460'));
        f.add(Character.valueOf('\u0461'));
        f.add(Character.valueOf('\u0462'));
        f.add(Character.valueOf('\u0463'));
        f.add(Character.valueOf('\u0464'));
        f.add(Character.valueOf('\u0465'));
        f.add(Character.valueOf('\u0466'));
        f.add(Character.valueOf('\u0467'));
        f.add(Character.valueOf('\u0468'));
        f.add(Character.valueOf('\u0469'));
        f.add(Character.valueOf('\u046a'));
        f.add(Character.valueOf('\u046b'));
        f.add(Character.valueOf('\u046c'));
        f.add(Character.valueOf('\u046d'));
        f.add(Character.valueOf('\u046e'));
        f.add(Character.valueOf('\u046f'));
        f.add(Character.valueOf('\u0470'));
        f.add(Character.valueOf('\u0471'));
        f.add(Character.valueOf('\u0472'));
        f.add(Character.valueOf('\u0473'));
        f.add(Character.valueOf('\u0474'));
        f.add(Character.valueOf('\u0475'));
        f.add(Character.valueOf('\u0476'));
        f.add(Character.valueOf('\u0477'));
        f.add(Character.valueOf('\u0478'));
        f.add(Character.valueOf('\u0479'));
        f.add(Character.valueOf('\u047a'));
        f.add(Character.valueOf('\u047b'));
        f.add(Character.valueOf('\u047c'));
        f.add(Character.valueOf('\u047d'));
        f.add(Character.valueOf('\u047e'));
        f.add(Character.valueOf('\u047f'));
        f.add(Character.valueOf('\u0480'));
        f.add(Character.valueOf('\u0481'));
        f.add(Character.valueOf('\u0482'));
        f.add(Character.valueOf('\u0483'));
        f.add(Character.valueOf('\u0484'));
        f.add(Character.valueOf('\u0485'));
        f.add(Character.valueOf('\u0486'));
        f.add(Character.valueOf('\u0487'));
        f.add(Character.valueOf('\u0488'));
        f.add(Character.valueOf('\u0489'));
        f.add(Character.valueOf('\u048a'));
        f.add(Character.valueOf('\u048b'));
        f.add(Character.valueOf('\u048c'));
        f.add(Character.valueOf('\u048d'));
        f.add(Character.valueOf('\u048e'));
        f.add(Character.valueOf('\u048f'));
        f.add(Character.valueOf('\u0490'));
        f.add(Character.valueOf('\u0491'));
        f.add(Character.valueOf('\u0492'));
        f.add(Character.valueOf('\u0493'));
        f.add(Character.valueOf('\u0494'));
        f.add(Character.valueOf('\u0495'));
        f.add(Character.valueOf('\u0496'));
        f.add(Character.valueOf('\u0497'));
        f.add(Character.valueOf('\u0498'));
        f.add(Character.valueOf('\u0499'));
        f.add(Character.valueOf('\u049a'));
        f.add(Character.valueOf('\u049b'));
        f.add(Character.valueOf('\u049c'));
        f.add(Character.valueOf('\u049d'));
        f.add(Character.valueOf('\u049e'));
        f.add(Character.valueOf('\u049f'));
        f.add(Character.valueOf('\u04a0'));
        f.add(Character.valueOf('\u04a1'));
        f.add(Character.valueOf('\u04a2'));
        f.add(Character.valueOf('\u04a3'));
        f.add(Character.valueOf('\u04a4'));
        f.add(Character.valueOf('\u04a5'));
        f.add(Character.valueOf('\u04a6'));
        f.add(Character.valueOf('\u04a7'));
        f.add(Character.valueOf('\u04a8'));
        f.add(Character.valueOf('\u04a9'));
        f.add(Character.valueOf('\u04aa'));
        f.add(Character.valueOf('\u04ab'));
        f.add(Character.valueOf('\u04ac'));
        f.add(Character.valueOf('\u04ad'));
        f.add(Character.valueOf('\u04ae'));
        f.add(Character.valueOf('\u04af'));
        f.add(Character.valueOf('\u04b0'));
        f.add(Character.valueOf('\u04b1'));
        f.add(Character.valueOf('\u04b2'));
        f.add(Character.valueOf('\u04b3'));
        f.add(Character.valueOf('\u04b4'));
        f.add(Character.valueOf('\u04b5'));
        f.add(Character.valueOf('\u04b6'));
        f.add(Character.valueOf('\u04b7'));
        f.add(Character.valueOf('\u04b8'));
        f.add(Character.valueOf('\u04b9'));
        f.add(Character.valueOf('\u04ba'));
        f.add(Character.valueOf('\u04bb'));
        f.add(Character.valueOf('\u04bc'));
        f.add(Character.valueOf('\u04bd'));
        f.add(Character.valueOf('\u04be'));
        f.add(Character.valueOf('\u04bf'));
        f.add(Character.valueOf('\u04c0'));
        f.add(Character.valueOf('\u04c1'));
        f.add(Character.valueOf('\u04c2'));
        f.add(Character.valueOf('\u04c3'));
        f.add(Character.valueOf('\u04c4'));
        f.add(Character.valueOf('\u04c5'));
        f.add(Character.valueOf('\u04c6'));
        f.add(Character.valueOf('\u04c7'));
        f.add(Character.valueOf('\u04c8'));
        f.add(Character.valueOf('\u04c9'));
        f.add(Character.valueOf('\u04ca'));
        f.add(Character.valueOf('\u04cb'));
        f.add(Character.valueOf('\u04cc'));
        f.add(Character.valueOf('\u04cd'));
        f.add(Character.valueOf('\u04ce'));
        f.add(Character.valueOf('\u04cf'));
        f.add(Character.valueOf('\u04d0'));
        f.add(Character.valueOf('\u04d1'));
        f.add(Character.valueOf('\u04d2'));
        f.add(Character.valueOf('\u04d3'));
        f.add(Character.valueOf('\u04d4'));
        f.add(Character.valueOf('\u04d5'));
        f.add(Character.valueOf('\u04d6'));
        f.add(Character.valueOf('\u04d7'));
        f.add(Character.valueOf('\u04d8'));
        f.add(Character.valueOf('\u04d9'));
        f.add(Character.valueOf('\u04da'));
        f.add(Character.valueOf('\u04db'));
        f.add(Character.valueOf('\u04dc'));
        f.add(Character.valueOf('\u04dd'));
        f.add(Character.valueOf('\u04de'));
        f.add(Character.valueOf('\u04df'));
        f.add(Character.valueOf('\u04e0'));
        f.add(Character.valueOf('\u04e1'));
        f.add(Character.valueOf('\u04e2'));
        f.add(Character.valueOf('\u04e3'));
        f.add(Character.valueOf('\u04e4'));
        f.add(Character.valueOf('\u04e5'));
        f.add(Character.valueOf('\u04e6'));
        f.add(Character.valueOf('\u04e7'));
        f.add(Character.valueOf('\u04e8'));
        f.add(Character.valueOf('\u04e9'));
        f.add(Character.valueOf('\u04ea'));
        f.add(Character.valueOf('\u04eb'));
        f.add(Character.valueOf('\u04ec'));
        f.add(Character.valueOf('\u04ed'));
        f.add(Character.valueOf('\u04ee'));
        f.add(Character.valueOf('\u04ef'));
        f.add(Character.valueOf('\u04f0'));
        f.add(Character.valueOf('\u04f1'));
        f.add(Character.valueOf('\u04f2'));
        f.add(Character.valueOf('\u04f3'));
        f.add(Character.valueOf('\u04f4'));
        f.add(Character.valueOf('\u04f5'));
        f.add(Character.valueOf('\u04f6'));
        f.add(Character.valueOf('\u04f7'));
        f.add(Character.valueOf('\u04f8'));
        f.add(Character.valueOf('\u04f9'));
        f.add(Character.valueOf('\u04fa'));
        f.add(Character.valueOf('\u04fb'));
        f.add(Character.valueOf('\u04fc'));
        f.add(Character.valueOf('\u04fd'));
        f.add(Character.valueOf('\u04fe'));
        f.add(Character.valueOf('\u04ff'));
        f.add(Character.valueOf('\u0500'));
        f.add(Character.valueOf('\u0501'));
        f.add(Character.valueOf('\u0502'));
        f.add(Character.valueOf('\u0503'));
        f.add(Character.valueOf('\u0504'));
        f.add(Character.valueOf('\u0505'));
        f.add(Character.valueOf('\u0506'));
        f.add(Character.valueOf('\u0507'));
        f.add(Character.valueOf('\u0508'));
        f.add(Character.valueOf('\u0509'));
        f.add(Character.valueOf('\u050a'));
        f.add(Character.valueOf('\u050b'));
        f.add(Character.valueOf('\u050c'));
        f.add(Character.valueOf('\u050d'));
        f.add(Character.valueOf('\u050e'));
        f.add(Character.valueOf('\u050f'));
        f.add(Character.valueOf('\u0510'));
        f.add(Character.valueOf('\u0511'));
        f.add(Character.valueOf('\u0512'));
        f.add(Character.valueOf('\u0513'));
        f.add(Character.valueOf('\u0514'));
        f.add(Character.valueOf('\u0515'));
        f.add(Character.valueOf('\u0516'));
        f.add(Character.valueOf('\u0517'));
        f.add(Character.valueOf('\u0518'));
        f.add(Character.valueOf('\u0519'));
        f.add(Character.valueOf('\u051a'));
        f.add(Character.valueOf('\u051b'));
        f.add(Character.valueOf('\u051c'));
        f.add(Character.valueOf('\u051d'));
        f.add(Character.valueOf('\u051e'));
        f.add(Character.valueOf('\u051f'));
        f.add(Character.valueOf('\u0520'));
        f.add(Character.valueOf('\u0521'));
        f.add(Character.valueOf('\u0522'));
        f.add(Character.valueOf('\u0523'));
        f.add(Character.valueOf('\u0524'));
        f.add(Character.valueOf('\u0525'));
        f.add(Character.valueOf('\u0526'));
        f.add(Character.valueOf('\u0527'));
        f.add(Character.valueOf('\u0528'));
        f.add(Character.valueOf('\u0529'));
        f.add(Character.valueOf('\u052a'));
        f.add(Character.valueOf('\u052b'));
        f.add(Character.valueOf('\u052c'));
        f.add(Character.valueOf('\u052d'));
        f.add(Character.valueOf('\u052e'));
        f.add(Character.valueOf('\u052f'));
        f.add(Character.valueOf('\u0530'));
        f.add(Character.valueOf('\u0531'));
        f.add(Character.valueOf('\u0532'));
        f.add(Character.valueOf('\u0533'));
        f.add(Character.valueOf('\u0534'));
        f.add(Character.valueOf('\u0535'));
    }

    protected static void initJAFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00a6'));
        f.add(Character.valueOf('\u00a7'));
        f.add(Character.valueOf('\u00a8'));
        f.add(Character.valueOf('\u00b0'));
        f.add(Character.valueOf('\u00b1'));
        f.add(Character.valueOf('\u00b4'));
        f.add(Character.valueOf('\u00b6'));
        f.add(Character.valueOf('\u00d7'));
        f.add(Character.valueOf('\u0100'));
        f.add(Character.valueOf('\u0101'));
        f.add(Character.valueOf('\u0102'));
        f.add(Character.valueOf('\u0103'));
        f.add(Character.valueOf('\u0104'));
        f.add(Character.valueOf('\u0105'));
        f.add(Character.valueOf('\u0106'));
        f.add(Character.valueOf('\u0107'));
        f.add(Character.valueOf('\u0108'));
        f.add(Character.valueOf('\u0109'));
        f.add(Character.valueOf('\u010a'));
        f.add(Character.valueOf('\u010b'));
        f.add(Character.valueOf('\u010c'));
        f.add(Character.valueOf('\u010d'));
        f.add(Character.valueOf('\u010e'));
        f.add(Character.valueOf('\u010f'));
        f.add(Character.valueOf('\u0110'));
        f.add(Character.valueOf('\u0111'));
        f.add(Character.valueOf('\u0112'));
        f.add(Character.valueOf('\u0113'));
        f.add(Character.valueOf('\u0114'));
        f.add(Character.valueOf('\u0115'));
        f.add(Character.valueOf('\u0116'));
        f.add(Character.valueOf('\u0117'));
        f.add(Character.valueOf('\u0118'));
        f.add(Character.valueOf('\u0119'));
        f.add(Character.valueOf('\u011a'));
        f.add(Character.valueOf('\u011b'));
        f.add(Character.valueOf('\u011c'));
        f.add(Character.valueOf('\u011d'));
        f.add(Character.valueOf('\u011e'));
        f.add(Character.valueOf('\u011f'));
        f.add(Character.valueOf('\u0120'));
        f.add(Character.valueOf('\u0121'));
        f.add(Character.valueOf('\u0122'));
        f.add(Character.valueOf('\u0123'));
        f.add(Character.valueOf('\u0124'));
        f.add(Character.valueOf('\u0125'));
        f.add(Character.valueOf('\u0126'));
        f.add(Character.valueOf('\u0127'));
        f.add(Character.valueOf('\u0128'));
        f.add(Character.valueOf('\u0129'));
        f.add(Character.valueOf('\u012a'));
        f.add(Character.valueOf('\u012b'));
        f.add(Character.valueOf('\u012c'));
        f.add(Character.valueOf('\u012d'));
        f.add(Character.valueOf('\u012e'));
        f.add(Character.valueOf('\u012f'));
        f.add(Character.valueOf('\u0130'));
        f.add(Character.valueOf('\u0131'));
        f.add(Character.valueOf('\u0132'));
        f.add(Character.valueOf('\u0133'));
        f.add(Character.valueOf('\u0134'));
        f.add(Character.valueOf('\u0135'));
        f.add(Character.valueOf('\u0136'));
        f.add(Character.valueOf('\u0137'));
        f.add(Character.valueOf('\u0138'));
        f.add(Character.valueOf('\u0139'));
        f.add(Character.valueOf('\u013a'));
        f.add(Character.valueOf('\u013b'));
        f.add(Character.valueOf('\u013c'));
        f.add(Character.valueOf('\u013d'));
        f.add(Character.valueOf('\u013e'));
        f.add(Character.valueOf('\u013f'));
        f.add(Character.valueOf('\u0140'));
        f.add(Character.valueOf('\u0141'));
        f.add(Character.valueOf('\u0142'));
        f.add(Character.valueOf('\u0143'));
        f.add(Character.valueOf('\u0144'));
        f.add(Character.valueOf('\u0145'));
        f.add(Character.valueOf('\u0146'));
        f.add(Character.valueOf('\u0147'));
        f.add(Character.valueOf('\u0148'));
        f.add(Character.valueOf('\u0149'));
        f.add(Character.valueOf('\u014a'));
        f.add(Character.valueOf('\u014b'));
        f.add(Character.valueOf('\u014c'));
        f.add(Character.valueOf('\u014d'));
        f.add(Character.valueOf('\u014e'));
        f.add(Character.valueOf('\u014f'));
        f.add(Character.valueOf('\u0150'));
        f.add(Character.valueOf('\u0151'));
        f.add(Character.valueOf('\u0152'));
        f.add(Character.valueOf('\u0153'));
        f.add(Character.valueOf('\u0154'));
        f.add(Character.valueOf('\u0155'));
        f.add(Character.valueOf('\u0156'));
        f.add(Character.valueOf('\u0157'));
        f.add(Character.valueOf('\u0158'));
        f.add(Character.valueOf('\u0159'));
        f.add(Character.valueOf('\u015a'));
        f.add(Character.valueOf('\u015b'));
        f.add(Character.valueOf('\u015c'));
        f.add(Character.valueOf('\u015d'));
        f.add(Character.valueOf('\u015e'));
        f.add(Character.valueOf('\u015f'));
        f.add(Character.valueOf('\u0160'));
        f.add(Character.valueOf('\u0161'));
        f.add(Character.valueOf('\u0162'));
        f.add(Character.valueOf('\u0163'));
        f.add(Character.valueOf('\u0164'));
        f.add(Character.valueOf('\u0165'));
        f.add(Character.valueOf('\u0166'));
        f.add(Character.valueOf('\u0167'));
        f.add(Character.valueOf('\u0168'));
        f.add(Character.valueOf('\u0169'));
        f.add(Character.valueOf('\u016a'));
        f.add(Character.valueOf('\u016b'));
        f.add(Character.valueOf('\u016c'));
        f.add(Character.valueOf('\u016d'));
        f.add(Character.valueOf('\u016e'));
        f.add(Character.valueOf('\u016f'));
        f.add(Character.valueOf('\u0170'));
        f.add(Character.valueOf('\u0171'));
        f.add(Character.valueOf('\u0172'));
        f.add(Character.valueOf('\u0173'));
        f.add(Character.valueOf('\u0174'));
        f.add(Character.valueOf('\u0175'));
        f.add(Character.valueOf('\u0176'));
        f.add(Character.valueOf('\u0177'));
        f.add(Character.valueOf('\u0178'));
        f.add(Character.valueOf('\u0179'));
        f.add(Character.valueOf('\u017a'));
        f.add(Character.valueOf('\u017b'));
        f.add(Character.valueOf('\u017c'));
        f.add(Character.valueOf('\u017d'));
        f.add(Character.valueOf('\u017e'));
        f.add(Character.valueOf('\u017f'));
        f.add(Character.valueOf('\u0180'));
        f.add(Character.valueOf('\u0181'));
        f.add(Character.valueOf('\u0182'));
        f.add(Character.valueOf('\u0183'));
        f.add(Character.valueOf('\u0184'));
        f.add(Character.valueOf('\u0185'));
        f.add(Character.valueOf('\u0186'));
        f.add(Character.valueOf('\u0187'));
        f.add(Character.valueOf('\u0188'));
        f.add(Character.valueOf('\u0189'));
        f.add(Character.valueOf('\u018a'));
        f.add(Character.valueOf('\u018b'));
        f.add(Character.valueOf('\u018c'));
        f.add(Character.valueOf('\u018d'));
        f.add(Character.valueOf('\u018e'));
        f.add(Character.valueOf('\u018f'));
        f.add(Character.valueOf('\u0190'));
        f.add(Character.valueOf('\u0191'));
        f.add(Character.valueOf('\u0192'));
        f.add(Character.valueOf('\u0193'));
        f.add(Character.valueOf('\u0194'));
        f.add(Character.valueOf('\u0195'));
        f.add(Character.valueOf('\u0196'));
        f.add(Character.valueOf('\u0197'));
        f.add(Character.valueOf('\u0198'));
        f.add(Character.valueOf('\u0199'));
        f.add(Character.valueOf('\u019a'));
        f.add(Character.valueOf('\u019b'));
        f.add(Character.valueOf('\u019c'));
        f.add(Character.valueOf('\u019d'));
        f.add(Character.valueOf('\u019e'));
        f.add(Character.valueOf('\u019f'));
        f.add(Character.valueOf('\u01a0'));
        f.add(Character.valueOf('\u01a1'));
        f.add(Character.valueOf('\u01a2'));
        f.add(Character.valueOf('\u01a3'));
        f.add(Character.valueOf('\u01a4'));
        f.add(Character.valueOf('\u01a5'));
        f.add(Character.valueOf('\u01a6'));
        f.add(Character.valueOf('\u01a7'));
        f.add(Character.valueOf('\u01a8'));
        f.add(Character.valueOf('\u01a9'));
        f.add(Character.valueOf('\u01aa'));
        f.add(Character.valueOf('\u01ab'));
        f.add(Character.valueOf('\u01ac'));
        f.add(Character.valueOf('\u01ad'));
        f.add(Character.valueOf('\u01ae'));
        f.add(Character.valueOf('\u01af'));
        f.add(Character.valueOf('\u01b0'));
        f.add(Character.valueOf('\u01b1'));
        f.add(Character.valueOf('\u01b2'));
        f.add(Character.valueOf('\u01b3'));
        f.add(Character.valueOf('\u01b4'));
        f.add(Character.valueOf('\u01b5'));
        f.add(Character.valueOf('\u01b6'));
        f.add(Character.valueOf('\u01b7'));
        f.add(Character.valueOf('\u01b8'));
        f.add(Character.valueOf('\u01b9'));
        f.add(Character.valueOf('\u01ba'));
        f.add(Character.valueOf('\u01bb'));
        f.add(Character.valueOf('\u01bc'));
        f.add(Character.valueOf('\u01bd'));
        f.add(Character.valueOf('\u01be'));
        f.add(Character.valueOf('\u01bf'));
        f.add(Character.valueOf('\u01c0'));
        f.add(Character.valueOf('\u01c1'));
        f.add(Character.valueOf('\u01c2'));
        f.add(Character.valueOf('\u01c3'));
        f.add(Character.valueOf('\u01c4'));
        f.add(Character.valueOf('\u01c5'));
        f.add(Character.valueOf('\u01c6'));
        f.add(Character.valueOf('\u01c7'));
        f.add(Character.valueOf('\u01c8'));
        f.add(Character.valueOf('\u01c9'));
        f.add(Character.valueOf('\u01ca'));
        f.add(Character.valueOf('\u01cb'));
        f.add(Character.valueOf('\u01cc'));
        f.add(Character.valueOf('\u01cd'));
        f.add(Character.valueOf('\u01ce'));
        f.add(Character.valueOf('\u01cf'));
        f.add(Character.valueOf('\u01d0'));
        f.add(Character.valueOf('\u01d1'));
        f.add(Character.valueOf('\u01d2'));
        f.add(Character.valueOf('\u01d3'));
        f.add(Character.valueOf('\u01d4'));
        f.add(Character.valueOf('\u01d5'));
        f.add(Character.valueOf('\u01d6'));
        f.add(Character.valueOf('\u01d7'));
        f.add(Character.valueOf('\u01d8'));
        f.add(Character.valueOf('\u01d9'));
        f.add(Character.valueOf('\u01da'));
        f.add(Character.valueOf('\u01db'));
        f.add(Character.valueOf('\u01dc'));
        f.add(Character.valueOf('\u01dd'));
        f.add(Character.valueOf('\u01de'));
        f.add(Character.valueOf('\u01df'));
        f.add(Character.valueOf('\u01e0'));
        f.add(Character.valueOf('\u01e1'));
        f.add(Character.valueOf('\u01e2'));
        f.add(Character.valueOf('\u01e3'));
        f.add(Character.valueOf('\u01e4'));
        f.add(Character.valueOf('\u01e5'));
        f.add(Character.valueOf('\u01e6'));
        f.add(Character.valueOf('\u01e7'));
        f.add(Character.valueOf('\u01e8'));
        f.add(Character.valueOf('\u01e9'));
        f.add(Character.valueOf('\u01ea'));
        f.add(Character.valueOf('\u01eb'));
        f.add(Character.valueOf('\u01ec'));
        f.add(Character.valueOf('\u01ed'));
        f.add(Character.valueOf('\u01ee'));
        f.add(Character.valueOf('\u01ef'));
        f.add(Character.valueOf('\u01f0'));
        f.add(Character.valueOf('\u01f1'));
        f.add(Character.valueOf('\u01f2'));
        f.add(Character.valueOf('\u01f3'));
        f.add(Character.valueOf('\u01f4'));
        f.add(Character.valueOf('\u01f5'));
        f.add(Character.valueOf('\u01f6'));
        f.add(Character.valueOf('\u01f7'));
        f.add(Character.valueOf('\u01f8'));
        f.add(Character.valueOf('\u01f9'));
        f.add(Character.valueOf('\u01fa'));
        f.add(Character.valueOf('\u01fb'));
        f.add(Character.valueOf('\u01fc'));
        f.add(Character.valueOf('\u01fd'));
        f.add(Character.valueOf('\u01fe'));
        f.add(Character.valueOf('\u01ff'));
        f.add(Character.valueOf('\u0200'));
        f.add(Character.valueOf('\u0201'));
        f.add(Character.valueOf('\u0202'));
        f.add(Character.valueOf('\u0203'));
        f.add(Character.valueOf('\u0204'));
        f.add(Character.valueOf('\u0205'));
        f.add(Character.valueOf('\u0206'));
        f.add(Character.valueOf('\u0207'));
        f.add(Character.valueOf('\u0208'));
        f.add(Character.valueOf('\u0209'));
        f.add(Character.valueOf('\u020a'));
        f.add(Character.valueOf('\u020b'));
        f.add(Character.valueOf('\u020c'));
        f.add(Character.valueOf('\u020d'));
        f.add(Character.valueOf('\u020e'));
        f.add(Character.valueOf('\u020f'));
        f.add(Character.valueOf('\u0210'));
        f.add(Character.valueOf('\u0211'));
        f.add(Character.valueOf('\u0212'));
        f.add(Character.valueOf('\u0213'));
        f.add(Character.valueOf('\u0214'));
        f.add(Character.valueOf('\u0215'));
        f.add(Character.valueOf('\u0216'));
        f.add(Character.valueOf('\u0217'));
        f.add(Character.valueOf('\u0218'));
        f.add(Character.valueOf('\u0219'));
        f.add(Character.valueOf('\u021a'));
        f.add(Character.valueOf('\u021b'));
        f.add(Character.valueOf('\u021c'));
        f.add(Character.valueOf('\u021d'));
        f.add(Character.valueOf('\u021e'));
        f.add(Character.valueOf('\u021f'));
        f.add(Character.valueOf('\u0220'));
        f.add(Character.valueOf('\u0221'));
        f.add(Character.valueOf('\u0222'));
        f.add(Character.valueOf('\u0223'));
        f.add(Character.valueOf('\u0224'));
        f.add(Character.valueOf('\u0225'));
        f.add(Character.valueOf('\u0226'));
        f.add(Character.valueOf('\u0227'));
        f.add(Character.valueOf('\u0228'));
        f.add(Character.valueOf('\u0229'));
        f.add(Character.valueOf('\u022a'));
        f.add(Character.valueOf('\u022b'));
        f.add(Character.valueOf('\u022c'));
        f.add(Character.valueOf('\u022d'));
        f.add(Character.valueOf('\u022e'));
        f.add(Character.valueOf('\u022f'));
        f.add(Character.valueOf('\u0230'));
        f.add(Character.valueOf('\u0231'));
        f.add(Character.valueOf('\u0232'));
        f.add(Character.valueOf('\u0233'));
        f.add(Character.valueOf('\u0234'));
        f.add(Character.valueOf('\u0235'));
        f.add(Character.valueOf('\u0236'));
        f.add(Character.valueOf('\u0237'));
        f.add(Character.valueOf('\u0238'));
        f.add(Character.valueOf('\u0239'));
        f.add(Character.valueOf('\u023a'));
        f.add(Character.valueOf('\u023b'));
        f.add(Character.valueOf('\u023c'));
        f.add(Character.valueOf('\u023d'));
        f.add(Character.valueOf('\u023e'));
        f.add(Character.valueOf('\u023f'));
        f.add(Character.valueOf('\u0240'));
        f.add(Character.valueOf('\u0241'));
        f.add(Character.valueOf('\u0242'));
        f.add(Character.valueOf('\u0243'));
        f.add(Character.valueOf('\u0244'));
        f.add(Character.valueOf('\u0245'));
        f.add(Character.valueOf('\u0246'));
        f.add(Character.valueOf('\u0247'));
        f.add(Character.valueOf('\u0248'));
        f.add(Character.valueOf('\u0249'));
        f.add(Character.valueOf('\u024a'));
        f.add(Character.valueOf('\u024b'));
        f.add(Character.valueOf('\u024c'));
        f.add(Character.valueOf('\u024d'));
        f.add(Character.valueOf('\u024e'));
        f.add(Character.valueOf('\u024f'));
        f.add(Character.valueOf('\u0250'));
        f.add(Character.valueOf('\u0251'));
        f.add(Character.valueOf('\u0252'));
        f.add(Character.valueOf('\u0253'));
        f.add(Character.valueOf('\u0254'));
        f.add(Character.valueOf('\u0255'));
        f.add(Character.valueOf('\u0256'));
        f.add(Character.valueOf('\u0257'));
        f.add(Character.valueOf('\u0258'));
        f.add(Character.valueOf('\u0259'));
        f.add(Character.valueOf('\u025a'));
        f.add(Character.valueOf('\u025b'));
        f.add(Character.valueOf('\u025c'));
        f.add(Character.valueOf('\u025d'));
        f.add(Character.valueOf('\u025e'));
        f.add(Character.valueOf('\u025f'));
        f.add(Character.valueOf('\u0260'));
        f.add(Character.valueOf('\u0261'));
        f.add(Character.valueOf('\u0262'));
        f.add(Character.valueOf('\u0263'));
        f.add(Character.valueOf('\u0264'));
        f.add(Character.valueOf('\u0265'));
        f.add(Character.valueOf('\u0266'));
        f.add(Character.valueOf('\u0267'));
        f.add(Character.valueOf('\u0268'));
        f.add(Character.valueOf('\u0269'));
        f.add(Character.valueOf('\u026a'));
        f.add(Character.valueOf('\u026b'));
        f.add(Character.valueOf('\u026c'));
        f.add(Character.valueOf('\u026d'));
        f.add(Character.valueOf('\u026e'));
        f.add(Character.valueOf('\u026f'));
        f.add(Character.valueOf('\u0270'));
        f.add(Character.valueOf('\u0271'));
        f.add(Character.valueOf('\u0272'));
        f.add(Character.valueOf('\u0273'));
        f.add(Character.valueOf('\u0274'));
        f.add(Character.valueOf('\u0275'));
        f.add(Character.valueOf('\u0276'));
        f.add(Character.valueOf('\u0277'));
        f.add(Character.valueOf('\u0278'));
        f.add(Character.valueOf('\u0279'));
        f.add(Character.valueOf('\u027a'));
        f.add(Character.valueOf('\u027b'));
        f.add(Character.valueOf('\u027c'));
        f.add(Character.valueOf('\u027d'));
        f.add(Character.valueOf('\u027e'));
        f.add(Character.valueOf('\u027f'));
        f.add(Character.valueOf('\u0280'));
        f.add(Character.valueOf('\u0281'));
        f.add(Character.valueOf('\u0282'));
        f.add(Character.valueOf('\u0283'));
        f.add(Character.valueOf('\u0284'));
        f.add(Character.valueOf('\u0285'));
        f.add(Character.valueOf('\u0286'));
        f.add(Character.valueOf('\u0287'));
        f.add(Character.valueOf('\u0288'));
        f.add(Character.valueOf('\u0289'));
        f.add(Character.valueOf('\u028a'));
        f.add(Character.valueOf('\u028b'));
        f.add(Character.valueOf('\u028c'));
        f.add(Character.valueOf('\u028d'));
        f.add(Character.valueOf('\u028e'));
        f.add(Character.valueOf('\u028f'));
        f.add(Character.valueOf('\u0290'));
        f.add(Character.valueOf('\u0291'));
        f.add(Character.valueOf('\u0292'));
        f.add(Character.valueOf('\u0293'));
        f.add(Character.valueOf('\u0294'));
        f.add(Character.valueOf('\u0295'));
        f.add(Character.valueOf('\u0296'));
        f.add(Character.valueOf('\u0297'));
        f.add(Character.valueOf('\u0298'));
        f.add(Character.valueOf('\u0299'));
        f.add(Character.valueOf('\u029a'));
        f.add(Character.valueOf('\u029b'));
        f.add(Character.valueOf('\u029c'));
        f.add(Character.valueOf('\u029d'));
        f.add(Character.valueOf('\u029e'));
        f.add(Character.valueOf('\u029f'));
        f.add(Character.valueOf('\u02a0'));
        f.add(Character.valueOf('\u02a1'));
        f.add(Character.valueOf('\u02a2'));
        f.add(Character.valueOf('\u02a3'));
        f.add(Character.valueOf('\u02a4'));
        f.add(Character.valueOf('\u02a5'));
        f.add(Character.valueOf('\u02a6'));
        f.add(Character.valueOf('\u02a7'));
        f.add(Character.valueOf('\u02a8'));
        f.add(Character.valueOf('\u02a9'));
        f.add(Character.valueOf('\u02aa'));
        f.add(Character.valueOf('\u02ab'));
        f.add(Character.valueOf('\u02ac'));
        f.add(Character.valueOf('\u02ad'));
        f.add(Character.valueOf('\u02ae'));
        f.add(Character.valueOf('\u02af'));
        f.add(Character.valueOf('\u02b0'));
        f.add(Character.valueOf('\u02b1'));
        f.add(Character.valueOf('\u02b2'));
        f.add(Character.valueOf('\u02b3'));
        f.add(Character.valueOf('\u02b4'));
        f.add(Character.valueOf('\u02b5'));
        f.add(Character.valueOf('\u02b6'));
        f.add(Character.valueOf('\u02b7'));
        f.add(Character.valueOf('\u02b8'));
        f.add(Character.valueOf('\u02b9'));
        f.add(Character.valueOf('\u02ba'));
        f.add(Character.valueOf('\u02bb'));
        f.add(Character.valueOf('\u02bc'));
        f.add(Character.valueOf('\u02bd'));
        f.add(Character.valueOf('\u02be'));
        f.add(Character.valueOf('\u02bf'));
        f.add(Character.valueOf('\u02c0'));
        f.add(Character.valueOf('\u02c1'));
        f.add(Character.valueOf('\u02c2'));
        f.add(Character.valueOf('\u02c3'));
        f.add(Character.valueOf('\u02c4'));
        f.add(Character.valueOf('\u02c5'));
        f.add(Character.valueOf('\u02c6'));
        f.add(Character.valueOf('\u02c7'));
        f.add(Character.valueOf('\u02c8'));
        f.add(Character.valueOf('\u02c9'));
        f.add(Character.valueOf('\u02ca'));
        f.add(Character.valueOf('\u02cb'));
        f.add(Character.valueOf('\u02cc'));
        f.add(Character.valueOf('\u02cd'));
        f.add(Character.valueOf('\u02ce'));
        f.add(Character.valueOf('\u02cf'));
        f.add(Character.valueOf('\u02d0'));
        f.add(Character.valueOf('\u02d1'));
        f.add(Character.valueOf('\u02d2'));
        f.add(Character.valueOf('\u02d3'));
        f.add(Character.valueOf('\u02d4'));
        f.add(Character.valueOf('\u02d5'));
        f.add(Character.valueOf('\u02d6'));
        f.add(Character.valueOf('\u02d7'));
        f.add(Character.valueOf('\u02d8'));
        f.add(Character.valueOf('\u02d9'));
        f.add(Character.valueOf('\u02da'));
        f.add(Character.valueOf('\u02db'));
        f.add(Character.valueOf('\u02dc'));
        f.add(Character.valueOf('\u02dd'));
        f.add(Character.valueOf('\u02de'));
        f.add(Character.valueOf('\u02df'));
        f.add(Character.valueOf('\u02e0'));
        f.add(Character.valueOf('\u02e1'));
        f.add(Character.valueOf('\u02e2'));
        f.add(Character.valueOf('\u02e3'));
        f.add(Character.valueOf('\u02e4'));
        f.add(Character.valueOf('\u02e5'));
        f.add(Character.valueOf('\u02e6'));
        f.add(Character.valueOf('\u02e7'));
        f.add(Character.valueOf('\u02e8'));
        f.add(Character.valueOf('\u02e9'));
        f.add(Character.valueOf('\u02ea'));
        f.add(Character.valueOf('\u02eb'));
        f.add(Character.valueOf('\u02ec'));
        f.add(Character.valueOf('\u02ed'));
        f.add(Character.valueOf('\u02ee'));
        f.add(Character.valueOf('\u02ef'));
        f.add(Character.valueOf('\u02f0'));
        f.add(Character.valueOf('\u02f1'));
        f.add(Character.valueOf('\u02f2'));
        f.add(Character.valueOf('\u02f3'));
        f.add(Character.valueOf('\u02f4'));
        f.add(Character.valueOf('\u02f5'));
        f.add(Character.valueOf('\u02f6'));
        f.add(Character.valueOf('\u02f7'));
        f.add(Character.valueOf('\u02f8'));
        f.add(Character.valueOf('\u02f9'));
        f.add(Character.valueOf('\u02fa'));
        f.add(Character.valueOf('\u02fb'));
        f.add(Character.valueOf('\u02fc'));
        f.add(Character.valueOf('\u02fd'));
        f.add(Character.valueOf('\u02fe'));
        f.add(Character.valueOf('\u02ff'));
        f.add(Character.valueOf('\u0300'));
        f.add(Character.valueOf('\u0301'));
        f.add(Character.valueOf('\u0302'));
        f.add(Character.valueOf('\u0303'));
        f.add(Character.valueOf('\u0304'));
        f.add(Character.valueOf('\u0305'));
        f.add(Character.valueOf('\u0306'));
        f.add(Character.valueOf('\u0307'));
        f.add(Character.valueOf('\u0308'));
        f.add(Character.valueOf('\u0309'));
        f.add(Character.valueOf('\u030a'));
        f.add(Character.valueOf('\u030b'));
        f.add(Character.valueOf('\u030c'));
        f.add(Character.valueOf('\u030d'));
        f.add(Character.valueOf('\u030e'));
        f.add(Character.valueOf('\u030f'));
        f.add(Character.valueOf('\u0310'));
        f.add(Character.valueOf('\u0311'));
        f.add(Character.valueOf('\u0312'));
        f.add(Character.valueOf('\u0313'));
        f.add(Character.valueOf('\u0314'));
        f.add(Character.valueOf('\u0315'));
        f.add(Character.valueOf('\u0316'));
        f.add(Character.valueOf('\u0317'));
        f.add(Character.valueOf('\u0318'));
        f.add(Character.valueOf('\u0319'));
        f.add(Character.valueOf('\u031a'));
        f.add(Character.valueOf('\u031b'));
        f.add(Character.valueOf('\u031c'));
        f.add(Character.valueOf('\u031d'));
        f.add(Character.valueOf('\u031e'));
        f.add(Character.valueOf('\u031f'));
        f.add(Character.valueOf('\u0320'));
        f.add(Character.valueOf('\u0321'));
        f.add(Character.valueOf('\u0322'));
        f.add(Character.valueOf('\u0323'));
        f.add(Character.valueOf('\u0324'));
        f.add(Character.valueOf('\u0325'));
        f.add(Character.valueOf('\u0326'));
        f.add(Character.valueOf('\u0327'));
        f.add(Character.valueOf('\u0328'));
        f.add(Character.valueOf('\u0329'));
        f.add(Character.valueOf('\u032a'));
        f.add(Character.valueOf('\u032b'));
        f.add(Character.valueOf('\u032c'));
        f.add(Character.valueOf('\u032d'));
        f.add(Character.valueOf('\u032e'));
        f.add(Character.valueOf('\u032f'));
        f.add(Character.valueOf('\u0330'));
        f.add(Character.valueOf('\u0331'));
        f.add(Character.valueOf('\u0332'));
        f.add(Character.valueOf('\u0333'));
        f.add(Character.valueOf('\u0334'));
        f.add(Character.valueOf('\u0335'));
        f.add(Character.valueOf('\u0336'));
        f.add(Character.valueOf('\u0337'));
        f.add(Character.valueOf('\u0338'));
        f.add(Character.valueOf('\u0339'));
        f.add(Character.valueOf('\u033a'));
        f.add(Character.valueOf('\u033b'));
        f.add(Character.valueOf('\u033c'));
        f.add(Character.valueOf('\u033d'));
        f.add(Character.valueOf('\u033e'));
        f.add(Character.valueOf('\u033f'));
        f.add(Character.valueOf('\u0340'));
        f.add(Character.valueOf('\u0341'));
        f.add(Character.valueOf('\u0342'));
        f.add(Character.valueOf('\u0343'));
        f.add(Character.valueOf('\u0344'));
        f.add(Character.valueOf('\u0345'));
        f.add(Character.valueOf('\u0346'));
        f.add(Character.valueOf('\u0347'));
        f.add(Character.valueOf('\u0348'));
        f.add(Character.valueOf('\u0349'));
        f.add(Character.valueOf('\u034a'));
        f.add(Character.valueOf('\u034b'));
        f.add(Character.valueOf('\u034c'));
        f.add(Character.valueOf('\u034d'));
        f.add(Character.valueOf('\u034e'));
        f.add(Character.valueOf('\u034f'));
        f.add(Character.valueOf('\u0350'));
        f.add(Character.valueOf('\u0351'));
        f.add(Character.valueOf('\u0352'));
        f.add(Character.valueOf('\u0353'));
        f.add(Character.valueOf('\u0354'));
        f.add(Character.valueOf('\u0355'));
        f.add(Character.valueOf('\u0356'));
        f.add(Character.valueOf('\u0357'));
        f.add(Character.valueOf('\u0358'));
        f.add(Character.valueOf('\u0359'));
        f.add(Character.valueOf('\u035a'));
        f.add(Character.valueOf('\u035b'));
        f.add(Character.valueOf('\u035c'));
        f.add(Character.valueOf('\u035d'));
        f.add(Character.valueOf('\u035e'));
        f.add(Character.valueOf('\u035f'));
        f.add(Character.valueOf('\u0360'));
        f.add(Character.valueOf('\u0361'));
        f.add(Character.valueOf('\u0362'));
        f.add(Character.valueOf('\u0363'));
        f.add(Character.valueOf('\u0364'));
        f.add(Character.valueOf('\u0365'));
        f.add(Character.valueOf('\u0366'));
        f.add(Character.valueOf('\u0367'));
        f.add(Character.valueOf('\u0368'));
        f.add(Character.valueOf('\u0369'));
        f.add(Character.valueOf('\u036a'));
        f.add(Character.valueOf('\u036b'));
        f.add(Character.valueOf('\u036c'));
        f.add(Character.valueOf('\u036d'));
        f.add(Character.valueOf('\u036e'));
        f.add(Character.valueOf('\u036f'));
        f.add(Character.valueOf('\u0370'));
        f.add(Character.valueOf('\u0371'));
        f.add(Character.valueOf('\u0372'));
        f.add(Character.valueOf('\u0373'));
        f.add(Character.valueOf('\u0374'));
        f.add(Character.valueOf('\u0375'));
        f.add(Character.valueOf('\u0376'));
        f.add(Character.valueOf('\u0377'));
        f.add(Character.valueOf('\u0378'));
        f.add(Character.valueOf('\u0379'));
        f.add(Character.valueOf('\u037a'));
        f.add(Character.valueOf('\u037b'));
        f.add(Character.valueOf('\u037c'));
        f.add(Character.valueOf('\u037d'));
        f.add(Character.valueOf('\u037e'));
        f.add(Character.valueOf('\u037f'));
        f.add(Character.valueOf('\u0380'));
        f.add(Character.valueOf('\u0381'));
        f.add(Character.valueOf('\u0382'));
        f.add(Character.valueOf('\u0383'));
        f.add(Character.valueOf('\u0384'));
        f.add(Character.valueOf('\u0385'));
        f.add(Character.valueOf('\u0386'));
        f.add(Character.valueOf('\u0387'));
        f.add(Character.valueOf('\u0388'));
        f.add(Character.valueOf('\u0389'));
        f.add(Character.valueOf('\u038a'));
        f.add(Character.valueOf('\u038b'));
        f.add(Character.valueOf('\u038c'));
        f.add(Character.valueOf('\u038d'));
        f.add(Character.valueOf('\u038e'));
        f.add(Character.valueOf('\u038f'));
        f.add(Character.valueOf('\u0390'));
        f.add(Character.valueOf('\u0391'));
        f.add(Character.valueOf('\u0392'));
        f.add(Character.valueOf('\u0393'));
        f.add(Character.valueOf('\u0394'));
        f.add(Character.valueOf('\u0395'));
        f.add(Character.valueOf('\u0396'));
        f.add(Character.valueOf('\u0397'));
        f.add(Character.valueOf('\u0398'));
        f.add(Character.valueOf('\u0399'));
        f.add(Character.valueOf('\u039a'));
        f.add(Character.valueOf('\u039b'));
        f.add(Character.valueOf('\u039c'));
        f.add(Character.valueOf('\u039d'));
        f.add(Character.valueOf('\u039e'));
        f.add(Character.valueOf('\u039f'));
        f.add(Character.valueOf('\u03a0'));
        f.add(Character.valueOf('\u03a1'));
        f.add(Character.valueOf('\u03a2'));
        f.add(Character.valueOf('\u03a3'));
        f.add(Character.valueOf('\u03a4'));
        f.add(Character.valueOf('\u03a5'));
        f.add(Character.valueOf('\u03a6'));
        f.add(Character.valueOf('\u03a7'));
        f.add(Character.valueOf('\u03a8'));
        f.add(Character.valueOf('\u03a9'));
        f.add(Character.valueOf('\u03aa'));
        f.add(Character.valueOf('\u03ab'));
        f.add(Character.valueOf('\u03ac'));
        f.add(Character.valueOf('\u03ad'));
        f.add(Character.valueOf('\u03ae'));
        f.add(Character.valueOf('\u03af'));
        f.add(Character.valueOf('\u03b0'));
        f.add(Character.valueOf('\u03b1'));
        f.add(Character.valueOf('\u03b2'));
        f.add(Character.valueOf('\u03b3'));
        f.add(Character.valueOf('\u03b4'));
        f.add(Character.valueOf('\u03b5'));
        f.add(Character.valueOf('\u03b6'));
        f.add(Character.valueOf('\u03b7'));
        f.add(Character.valueOf('\u03b8'));
        f.add(Character.valueOf('\u03b9'));
        f.add(Character.valueOf('\u03ba'));
        f.add(Character.valueOf('\u03bb'));
        f.add(Character.valueOf('\u03bc'));
        f.add(Character.valueOf('\u03bd'));
        f.add(Character.valueOf('\u03be'));
        f.add(Character.valueOf('\u03bf'));
        f.add(Character.valueOf('\u03c0'));
        f.add(Character.valueOf('\u03c1'));
        f.add(Character.valueOf('\u03c2'));
        f.add(Character.valueOf('\u03c3'));
        f.add(Character.valueOf('\u03c4'));
        f.add(Character.valueOf('\u03c5'));
        f.add(Character.valueOf('\u03c6'));
        f.add(Character.valueOf('\u03c7'));
        f.add(Character.valueOf('\u03c8'));
        f.add(Character.valueOf('\u03c9'));
        f.add(Character.valueOf('\u03ca'));
        f.add(Character.valueOf('\u03cb'));
        f.add(Character.valueOf('\u03cc'));
        f.add(Character.valueOf('\u03cd'));
        f.add(Character.valueOf('\u03ce'));
        f.add(Character.valueOf('\u03cf'));
        f.add(Character.valueOf('\u03d0'));
        f.add(Character.valueOf('\u03d1'));
        f.add(Character.valueOf('\u03d2'));
        f.add(Character.valueOf('\u03d3'));
        f.add(Character.valueOf('\u03d4'));
        f.add(Character.valueOf('\u03d5'));
        f.add(Character.valueOf('\u03d6'));
        f.add(Character.valueOf('\u03d7'));
        f.add(Character.valueOf('\u03d8'));
        f.add(Character.valueOf('\u03d9'));
        f.add(Character.valueOf('\u03da'));
        f.add(Character.valueOf('\u03db'));
        f.add(Character.valueOf('\u03dc'));
        f.add(Character.valueOf('\u03dd'));
        f.add(Character.valueOf('\u03de'));
        f.add(Character.valueOf('\u03df'));
        f.add(Character.valueOf('\u03e0'));
        f.add(Character.valueOf('\u03e1'));
        f.add(Character.valueOf('\u03e2'));
        f.add(Character.valueOf('\u03e3'));
        f.add(Character.valueOf('\u03e4'));
        f.add(Character.valueOf('\u03e5'));
        f.add(Character.valueOf('\u03e6'));
        f.add(Character.valueOf('\u03e7'));
        f.add(Character.valueOf('\u03e8'));
        f.add(Character.valueOf('\u03e9'));
        f.add(Character.valueOf('\u03ea'));
        f.add(Character.valueOf('\u03eb'));
        f.add(Character.valueOf('\u03ec'));
        f.add(Character.valueOf('\u03ed'));
        f.add(Character.valueOf('\u03ee'));
        f.add(Character.valueOf('\u03ef'));
        f.add(Character.valueOf('\u03f0'));
        f.add(Character.valueOf('\u03f1'));
        f.add(Character.valueOf('\u03f2'));
        f.add(Character.valueOf('\u03f3'));
        f.add(Character.valueOf('\u03f4'));
        f.add(Character.valueOf('\u03f5'));
        f.add(Character.valueOf('\u03f6'));
        f.add(Character.valueOf('\u03f7'));
        f.add(Character.valueOf('\u03f8'));
        f.add(Character.valueOf('\u03f9'));
        f.add(Character.valueOf('\u03fa'));
        f.add(Character.valueOf('\u03fb'));
        f.add(Character.valueOf('\u03fc'));
        f.add(Character.valueOf('\u03fd'));
        f.add(Character.valueOf('\u03fe'));
        f.add(Character.valueOf('\u03ff'));
        f.add(Character.valueOf('\u0400'));
        f.add(Character.valueOf('\u0401'));
        f.add(Character.valueOf('\u0402'));
        f.add(Character.valueOf('\u0403'));
        f.add(Character.valueOf('\u0404'));
        f.add(Character.valueOf('\u0405'));
        f.add(Character.valueOf('\u0406'));
        f.add(Character.valueOf('\u0407'));
        f.add(Character.valueOf('\u0408'));
        f.add(Character.valueOf('\u0409'));
        f.add(Character.valueOf('\u040a'));
        f.add(Character.valueOf('\u040b'));
        f.add(Character.valueOf('\u040c'));
        f.add(Character.valueOf('\u040d'));
        f.add(Character.valueOf('\u040e'));
        f.add(Character.valueOf('\u040f'));
        f.add(Character.valueOf('\u0410'));
        f.add(Character.valueOf('\u0411'));
        f.add(Character.valueOf('\u0412'));
        f.add(Character.valueOf('\u0413'));
        f.add(Character.valueOf('\u0414'));
        f.add(Character.valueOf('\u0415'));
        f.add(Character.valueOf('\u0416'));
        f.add(Character.valueOf('\u0417'));
        f.add(Character.valueOf('\u0418'));
        f.add(Character.valueOf('\u0419'));
        f.add(Character.valueOf('\u041a'));
        f.add(Character.valueOf('\u041b'));
        f.add(Character.valueOf('\u041c'));
        f.add(Character.valueOf('\u041d'));
        f.add(Character.valueOf('\u041e'));
        f.add(Character.valueOf('\u041f'));
        f.add(Character.valueOf('\u0420'));
        f.add(Character.valueOf('\u0421'));
        f.add(Character.valueOf('\u0422'));
        f.add(Character.valueOf('\u0423'));
        f.add(Character.valueOf('\u0424'));
        f.add(Character.valueOf('\u0425'));
        f.add(Character.valueOf('\u0426'));
        f.add(Character.valueOf('\u0427'));
        f.add(Character.valueOf('\u0428'));
        f.add(Character.valueOf('\u0429'));
        f.add(Character.valueOf('\u042a'));
        f.add(Character.valueOf('\u042b'));
        f.add(Character.valueOf('\u042c'));
        f.add(Character.valueOf('\u042d'));
        f.add(Character.valueOf('\u042e'));
        f.add(Character.valueOf('\u042f'));
        f.add(Character.valueOf('\u0430'));
        f.add(Character.valueOf('\u0431'));
        f.add(Character.valueOf('\u0432'));
        f.add(Character.valueOf('\u0433'));
        f.add(Character.valueOf('\u0434'));
        f.add(Character.valueOf('\u0435'));
        f.add(Character.valueOf('\u0436'));
        f.add(Character.valueOf('\u0437'));
        f.add(Character.valueOf('\u0438'));
        f.add(Character.valueOf('\u0439'));
        f.add(Character.valueOf('\u043a'));
        f.add(Character.valueOf('\u043b'));
        f.add(Character.valueOf('\u043c'));
        f.add(Character.valueOf('\u043d'));
        f.add(Character.valueOf('\u043e'));
        f.add(Character.valueOf('\u043f'));
        f.add(Character.valueOf('\u0440'));
        f.add(Character.valueOf('\u0441'));
        f.add(Character.valueOf('\u0442'));
        f.add(Character.valueOf('\u0443'));
        f.add(Character.valueOf('\u0444'));
        f.add(Character.valueOf('\u0445'));
        f.add(Character.valueOf('\u0446'));
        f.add(Character.valueOf('\u0447'));
        f.add(Character.valueOf('\u0448'));
        f.add(Character.valueOf('\u0449'));
        f.add(Character.valueOf('\u044a'));
        f.add(Character.valueOf('\u044b'));
        f.add(Character.valueOf('\u044c'));
        f.add(Character.valueOf('\u044d'));
        f.add(Character.valueOf('\u044e'));
        f.add(Character.valueOf('\u044f'));
        f.add(Character.valueOf('\u0450'));
        f.add(Character.valueOf('\u0451'));
        f.add(Character.valueOf('\u0452'));
        f.add(Character.valueOf('\u0453'));
        f.add(Character.valueOf('\u0454'));
        f.add(Character.valueOf('\u0455'));
        f.add(Character.valueOf('\u0456'));
        f.add(Character.valueOf('\u0457'));
        f.add(Character.valueOf('\u0458'));
        f.add(Character.valueOf('\u0459'));
        f.add(Character.valueOf('\u045a'));
        f.add(Character.valueOf('\u045b'));
        f.add(Character.valueOf('\u045c'));
        f.add(Character.valueOf('\u045d'));
        f.add(Character.valueOf('\u045e'));
        f.add(Character.valueOf('\u045f'));
        f.add(Character.valueOf('\u0460'));
        f.add(Character.valueOf('\u0461'));
        f.add(Character.valueOf('\u0462'));
        f.add(Character.valueOf('\u0463'));
        f.add(Character.valueOf('\u0464'));
        f.add(Character.valueOf('\u0465'));
        f.add(Character.valueOf('\u0466'));
        f.add(Character.valueOf('\u0467'));
        f.add(Character.valueOf('\u0468'));
    }

    private static void initITFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00aa'));
        f.add(Character.valueOf('\u00ba'));
        f.add(Character.valueOf('\u00c0'));
        f.add(Character.valueOf('\u00c1'));
        f.add(Character.valueOf('\u00c2'));
        f.add(Character.valueOf('\u00c3'));
        f.add(Character.valueOf('\u00c4'));
        f.add(Character.valueOf('\u00c5'));
        f.add(Character.valueOf('\u00c6'));
        f.add(Character.valueOf('\u00c7'));
        f.add(Character.valueOf('\u00c8'));
        f.add(Character.valueOf('\u00c9'));
        f.add(Character.valueOf('\u00ca'));
        f.add(Character.valueOf('\u00cb'));
        f.add(Character.valueOf('\u00cc'));
        f.add(Character.valueOf('\u00cd'));
        f.add(Character.valueOf('\u00ce'));
        f.add(Character.valueOf('\u00cf'));
        f.add(Character.valueOf('\u00d0'));
        f.add(Character.valueOf('\u00d1'));
        f.add(Character.valueOf('\u00d2'));
        f.add(Character.valueOf('\u00d3'));
        f.add(Character.valueOf('\u00d4'));
        f.add(Character.valueOf('\u00d5'));
        f.add(Character.valueOf('\u00d6'));
        f.add(Character.valueOf('\u00d8'));
        f.add(Character.valueOf('\u00d9'));
        f.add(Character.valueOf('\u00da'));
        f.add(Character.valueOf('\u00db'));
        f.add(Character.valueOf('\u00dc'));
        f.add(Character.valueOf('\u00dd'));
        f.add(Character.valueOf('\u00de'));
        f.add(Character.valueOf('\u00df'));
        f.add(Character.valueOf('\u00e0'));
        f.add(Character.valueOf('\u00e1'));
        f.add(Character.valueOf('\u00e2'));
        f.add(Character.valueOf('\u00e3'));
        f.add(Character.valueOf('\u00e4'));
        f.add(Character.valueOf('\u00e5'));
        f.add(Character.valueOf('\u00e6'));
        f.add(Character.valueOf('\u00e7'));
        f.add(Character.valueOf('\u00e8'));
        f.add(Character.valueOf('\u00e9'));
        f.add(Character.valueOf('\u00ea'));
        f.add(Character.valueOf('\u00eb'));
        f.add(Character.valueOf('\u00ec'));
        f.add(Character.valueOf('\u00ed'));
        f.add(Character.valueOf('\u00ee'));
        f.add(Character.valueOf('\u00ef'));
        f.add(Character.valueOf('\u00f0'));
        f.add(Character.valueOf('\u00f1'));
        f.add(Character.valueOf('\u00f2'));
        f.add(Character.valueOf('\u00f3'));
        f.add(Character.valueOf('\u00f4'));
        f.add(Character.valueOf('\u00f5'));
        f.add(Character.valueOf('\u00f6'));
        f.add(Character.valueOf('\u00f8'));
        f.add(Character.valueOf('\u00f9'));
        f.add(Character.valueOf('\u00fa'));
        f.add(Character.valueOf('\u00fb'));
        f.add(Character.valueOf('\u00fc'));
        f.add(Character.valueOf('\u00fd'));
        f.add(Character.valueOf('\u00fe'));
        f.add(Character.valueOf('\u00ff'));
        f.add(Character.valueOf('\u0152'));
        f.add(Character.valueOf('\u0153'));
        f.add(Character.valueOf('\u0160'));
        f.add(Character.valueOf('\u0161'));
        f.add(Character.valueOf('\u0178'));
    }

    protected static void initHUFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00b5'));
        f.add(Character.valueOf('\u00c1'));
        f.add(Character.valueOf('\u00c2'));
        f.add(Character.valueOf('\u00c4'));
        f.add(Character.valueOf('\u00c7'));
        f.add(Character.valueOf('\u00c9'));
        f.add(Character.valueOf('\u00cb'));
        f.add(Character.valueOf('\u00cd'));
        f.add(Character.valueOf('\u00ce'));
        f.add(Character.valueOf('\u00d3'));
        f.add(Character.valueOf('\u00d4'));
        f.add(Character.valueOf('\u00d6'));
        f.add(Character.valueOf('\u00da'));
        f.add(Character.valueOf('\u00dc'));
        f.add(Character.valueOf('\u00dd'));
        f.add(Character.valueOf('\u00df'));
        f.add(Character.valueOf('\u00e1'));
        f.add(Character.valueOf('\u00e2'));
        f.add(Character.valueOf('\u00e4'));
        f.add(Character.valueOf('\u00e7'));
        f.add(Character.valueOf('\u00e9'));
        f.add(Character.valueOf('\u00eb'));
        f.add(Character.valueOf('\u00ed'));
        f.add(Character.valueOf('\u00ee'));
        f.add(Character.valueOf('\u00f3'));
        f.add(Character.valueOf('\u00f4'));
        f.add(Character.valueOf('\u00f6'));
        f.add(Character.valueOf('\u00fa'));
        f.add(Character.valueOf('\u00fc'));
        f.add(Character.valueOf('\u00fd'));
        f.add(Character.valueOf('\u0102'));
        f.add(Character.valueOf('\u0103'));
        f.add(Character.valueOf('\u0104'));
        f.add(Character.valueOf('\u0105'));
        f.add(Character.valueOf('\u0106'));
        f.add(Character.valueOf('\u0107'));
        f.add(Character.valueOf('\u010c'));
        f.add(Character.valueOf('\u010d'));
        f.add(Character.valueOf('\u010e'));
        f.add(Character.valueOf('\u010f'));
        f.add(Character.valueOf('\u0110'));
        f.add(Character.valueOf('\u0111'));
        f.add(Character.valueOf('\u0118'));
        f.add(Character.valueOf('\u0119'));
        f.add(Character.valueOf('\u011a'));
        f.add(Character.valueOf('\u011b'));
        f.add(Character.valueOf('\u0139'));
        f.add(Character.valueOf('\u013a'));
        f.add(Character.valueOf('\u013d'));
        f.add(Character.valueOf('\u013e'));
        f.add(Character.valueOf('\u0141'));
        f.add(Character.valueOf('\u0142'));
        f.add(Character.valueOf('\u0143'));
        f.add(Character.valueOf('\u0144'));
        f.add(Character.valueOf('\u0147'));
        f.add(Character.valueOf('\u0148'));
        f.add(Character.valueOf('\u0150'));
        f.add(Character.valueOf('\u0151'));
        f.add(Character.valueOf('\u0154'));
        f.add(Character.valueOf('\u0155'));
        f.add(Character.valueOf('\u0158'));
        f.add(Character.valueOf('\u0159'));
        f.add(Character.valueOf('\u015a'));
        f.add(Character.valueOf('\u015b'));
        f.add(Character.valueOf('\u015e'));
        f.add(Character.valueOf('\u015f'));
        f.add(Character.valueOf('\u0160'));
        f.add(Character.valueOf('\u0161'));
        f.add(Character.valueOf('\u0162'));
        f.add(Character.valueOf('\u0163'));
        f.add(Character.valueOf('\u0164'));
        f.add(Character.valueOf('\u0165'));
        f.add(Character.valueOf('\u016e'));
        f.add(Character.valueOf('\u016f'));
        f.add(Character.valueOf('\u0170'));
        f.add(Character.valueOf('\u0171'));
        f.add(Character.valueOf('\u0179'));
        f.add(Character.valueOf('\u017a'));
        f.add(Character.valueOf('\u017b'));
        f.add(Character.valueOf('\u017c'));
        f.add(Character.valueOf('\u017d'));
        f.add(Character.valueOf('\u017e'));
    }

    protected static void initFRFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00aa'));
        f.add(Character.valueOf('\u00ba'));
        f.add(Character.valueOf('\u00c0'));
        f.add(Character.valueOf('\u00c1'));
        f.add(Character.valueOf('\u00c2'));
        f.add(Character.valueOf('\u00c3'));
        f.add(Character.valueOf('\u00c4'));
        f.add(Character.valueOf('\u00c5'));
        f.add(Character.valueOf('\u00c6'));
        f.add(Character.valueOf('\u00c7'));
        f.add(Character.valueOf('\u00c8'));
        f.add(Character.valueOf('\u00c9'));
        f.add(Character.valueOf('\u00ca'));
        f.add(Character.valueOf('\u00cb'));
        f.add(Character.valueOf('\u00cc'));
        f.add(Character.valueOf('\u00cd'));
        f.add(Character.valueOf('\u00ce'));
        f.add(Character.valueOf('\u00cf'));
        f.add(Character.valueOf('\u00d0'));
        f.add(Character.valueOf('\u00d1'));
        f.add(Character.valueOf('\u00d2'));
        f.add(Character.valueOf('\u00d3'));
        f.add(Character.valueOf('\u00d4'));
        f.add(Character.valueOf('\u00d5'));
        f.add(Character.valueOf('\u00d6'));
        f.add(Character.valueOf('\u00d8'));
        f.add(Character.valueOf('\u00d9'));
        f.add(Character.valueOf('\u00da'));
        f.add(Character.valueOf('\u00db'));
        f.add(Character.valueOf('\u00dc'));
        f.add(Character.valueOf('\u00dd'));
        f.add(Character.valueOf('\u00de'));
        f.add(Character.valueOf('\u00df'));
        f.add(Character.valueOf('\u00e0'));
        f.add(Character.valueOf('\u00e1'));
        f.add(Character.valueOf('\u00e2'));
        f.add(Character.valueOf('\u00e3'));
        f.add(Character.valueOf('\u00e4'));
        f.add(Character.valueOf('\u00e5'));
        f.add(Character.valueOf('\u00e6'));
        f.add(Character.valueOf('\u00e7'));
        f.add(Character.valueOf('\u00e8'));
        f.add(Character.valueOf('\u00e9'));
        f.add(Character.valueOf('\u00ea'));
        f.add(Character.valueOf('\u00eb'));
        f.add(Character.valueOf('\u00ec'));
        f.add(Character.valueOf('\u00ed'));
        f.add(Character.valueOf('\u00ee'));
        f.add(Character.valueOf('\u00ef'));
        f.add(Character.valueOf('\u00f0'));
        f.add(Character.valueOf('\u00f1'));
        f.add(Character.valueOf('\u00f2'));
        f.add(Character.valueOf('\u00f3'));
        f.add(Character.valueOf('\u00f4'));
        f.add(Character.valueOf('\u00f5'));
        f.add(Character.valueOf('\u00f6'));
        f.add(Character.valueOf('\u00f8'));
        f.add(Character.valueOf('\u00f9'));
        f.add(Character.valueOf('\u00fa'));
        f.add(Character.valueOf('\u00fb'));
        f.add(Character.valueOf('\u00fc'));
        f.add(Character.valueOf('\u00fd'));
        f.add(Character.valueOf('\u00fe'));
        f.add(Character.valueOf('\u00ff'));
        f.add(Character.valueOf('\u0152'));
        f.add(Character.valueOf('\u0153'));
        f.add(Character.valueOf('\u0160'));
        f.add(Character.valueOf('\u0161'));
        f.add(Character.valueOf('\u0178'));
    }

    protected static void initESFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00aa'));
        f.add(Character.valueOf('\u00ba'));
        f.add(Character.valueOf('\u00c0'));
        f.add(Character.valueOf('\u00c1'));
        f.add(Character.valueOf('\u00c2'));
        f.add(Character.valueOf('\u00c3'));
        f.add(Character.valueOf('\u00c4'));
        f.add(Character.valueOf('\u00c5'));
        f.add(Character.valueOf('\u00c6'));
        f.add(Character.valueOf('\u00c7'));
        f.add(Character.valueOf('\u00c8'));
        f.add(Character.valueOf('\u00c9'));
        f.add(Character.valueOf('\u00ca'));
        f.add(Character.valueOf('\u00cb'));
        f.add(Character.valueOf('\u00cc'));
        f.add(Character.valueOf('\u00cd'));
        f.add(Character.valueOf('\u00ce'));
        f.add(Character.valueOf('\u00cf'));
        f.add(Character.valueOf('\u00d0'));
        f.add(Character.valueOf('\u00d1'));
        f.add(Character.valueOf('\u00d2'));
        f.add(Character.valueOf('\u00d3'));
        f.add(Character.valueOf('\u00d4'));
        f.add(Character.valueOf('\u00d5'));
        f.add(Character.valueOf('\u00d6'));
        f.add(Character.valueOf('\u00d8'));
        f.add(Character.valueOf('\u00d9'));
        f.add(Character.valueOf('\u00da'));
        f.add(Character.valueOf('\u00db'));
        f.add(Character.valueOf('\u00dc'));
        f.add(Character.valueOf('\u00dd'));
        f.add(Character.valueOf('\u00de'));
        f.add(Character.valueOf('\u00df'));
        f.add(Character.valueOf('\u00e0'));
        f.add(Character.valueOf('\u00e1'));
        f.add(Character.valueOf('\u00e2'));
        f.add(Character.valueOf('\u00e3'));
        f.add(Character.valueOf('\u00e4'));
        f.add(Character.valueOf('\u00e5'));
        f.add(Character.valueOf('\u00e6'));
        f.add(Character.valueOf('\u00e7'));
        f.add(Character.valueOf('\u00e8'));
        f.add(Character.valueOf('\u00e9'));
        f.add(Character.valueOf('\u00ea'));
        f.add(Character.valueOf('\u00eb'));
        f.add(Character.valueOf('\u00ec'));
        f.add(Character.valueOf('\u00ed'));
        f.add(Character.valueOf('\u00ee'));
        f.add(Character.valueOf('\u00ef'));
        f.add(Character.valueOf('\u00f0'));
        f.add(Character.valueOf('\u00f1'));
        f.add(Character.valueOf('\u00f2'));
        f.add(Character.valueOf('\u00f3'));
        f.add(Character.valueOf('\u00f4'));
        f.add(Character.valueOf('\u00f5'));
        f.add(Character.valueOf('\u00f6'));
        f.add(Character.valueOf('\u00f8'));
        f.add(Character.valueOf('\u00f9'));
        f.add(Character.valueOf('\u00fa'));
        f.add(Character.valueOf('\u00fb'));
        f.add(Character.valueOf('\u00fc'));
        f.add(Character.valueOf('\u00fd'));
        f.add(Character.valueOf('\u00fe'));
        f.add(Character.valueOf('\u00ff'));
        f.add(Character.valueOf('\u0152'));
        f.add(Character.valueOf('\u0153'));
        f.add(Character.valueOf('\u0160'));
        f.add(Character.valueOf('\u0161'));
        f.add(Character.valueOf('\u0178'));
    }

    protected static void initDEFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u00aa'));
        f.add(Character.valueOf('\u00ba'));
        f.add(Character.valueOf('\u00c0'));
        f.add(Character.valueOf('\u00c1'));
        f.add(Character.valueOf('\u00c2'));
        f.add(Character.valueOf('\u00c3'));
        f.add(Character.valueOf('\u00c4'));
        f.add(Character.valueOf('\u00c5'));
        f.add(Character.valueOf('\u00c6'));
        f.add(Character.valueOf('\u00c7'));
        f.add(Character.valueOf('\u00c8'));
        f.add(Character.valueOf('\u00c9'));
        f.add(Character.valueOf('\u00ca'));
        f.add(Character.valueOf('\u00cb'));
        f.add(Character.valueOf('\u00cc'));
        f.add(Character.valueOf('\u00cd'));
        f.add(Character.valueOf('\u00ce'));
        f.add(Character.valueOf('\u00cf'));
        f.add(Character.valueOf('\u00d0'));
        f.add(Character.valueOf('\u00d1'));
        f.add(Character.valueOf('\u00d2'));
        f.add(Character.valueOf('\u00d3'));
        f.add(Character.valueOf('\u00d4'));
        f.add(Character.valueOf('\u00d5'));
        f.add(Character.valueOf('\u00d6'));
        f.add(Character.valueOf('\u00d8'));
        f.add(Character.valueOf('\u00d9'));
        f.add(Character.valueOf('\u00da'));
        f.add(Character.valueOf('\u00db'));
        f.add(Character.valueOf('\u00dc'));
        f.add(Character.valueOf('\u00dd'));
        f.add(Character.valueOf('\u00de'));
        f.add(Character.valueOf('\u00df'));
        f.add(Character.valueOf('\u00e0'));
        f.add(Character.valueOf('\u00e1'));
        f.add(Character.valueOf('\u00e2'));
        f.add(Character.valueOf('\u00e3'));
        f.add(Character.valueOf('\u00e4'));
        f.add(Character.valueOf('\u00e5'));
        f.add(Character.valueOf('\u00e6'));
        f.add(Character.valueOf('\u00e7'));
        f.add(Character.valueOf('\u00e8'));
        f.add(Character.valueOf('\u00e9'));
        f.add(Character.valueOf('\u00ea'));
        f.add(Character.valueOf('\u00eb'));
        f.add(Character.valueOf('\u00ec'));
        f.add(Character.valueOf('\u00ed'));
        f.add(Character.valueOf('\u00ee'));
        f.add(Character.valueOf('\u00ef'));
        f.add(Character.valueOf('\u00f0'));
        f.add(Character.valueOf('\u00f1'));
        f.add(Character.valueOf('\u00f2'));
        f.add(Character.valueOf('\u00f3'));
        f.add(Character.valueOf('\u00f4'));
        f.add(Character.valueOf('\u00f5'));
        f.add(Character.valueOf('\u00f6'));
        f.add(Character.valueOf('\u00f8'));
        f.add(Character.valueOf('\u00f9'));
        f.add(Character.valueOf('\u00fa'));
        f.add(Character.valueOf('\u00fb'));
        f.add(Character.valueOf('\u00fc'));
        f.add(Character.valueOf('\u00fd'));
        f.add(Character.valueOf('\u00fe'));
        f.add(Character.valueOf('\u00ff'));
        f.add(Character.valueOf('\u0152'));
        f.add(Character.valueOf('\u0153'));
        f.add(Character.valueOf('\u0160'));
        f.add(Character.valueOf('\u0161'));
        f.add(Character.valueOf('\u0178'));
    }

    protected static void initCSFlags(HashSet<Character> f) {
        f.add(Character.valueOf('\u05d0'));
        f.add(Character.valueOf('\u05d1'));
        f.add(Character.valueOf('\u05d2'));
        f.add(Character.valueOf('\u05d3'));
        f.add(Character.valueOf('\u05d4'));
        f.add(Character.valueOf('\u05d5'));
        f.add(Character.valueOf('\u05d6'));
        f.add(Character.valueOf('\u05d7'));
        f.add(Character.valueOf('\u05d8'));
        f.add(Character.valueOf('\u05d9'));
        f.add(Character.valueOf('\u05da'));
        f.add(Character.valueOf('\u05db'));
        f.add(Character.valueOf('\u05dc'));
        f.add(Character.valueOf('\u05dd'));
        f.add(Character.valueOf('\u05de'));
        f.add(Character.valueOf('\u05df'));
        f.add(Character.valueOf('\u05e0'));
        f.add(Character.valueOf('\u05e1'));
        f.add(Character.valueOf('\u05e2'));
        f.add(Character.valueOf('\u05e3'));
        f.add(Character.valueOf('\u05e4'));
        f.add(Character.valueOf('\u05e5'));
        f.add(Character.valueOf('\u05e6'));
        f.add(Character.valueOf('\u05e7'));
        f.add(Character.valueOf('\u05e8'));
        f.add(Character.valueOf('\u05e9'));
        f.add(Character.valueOf('\u05ea'));
        f.add(Character.valueOf('\u05f0'));
        f.add(Character.valueOf('\u05f1'));
        f.add(Character.valueOf('\u05f2'));
    }

    protected static HashSet<Character> initOrdinaryFlagsLUWO() {
        langsUNO = new ArrayList();
        langsUNO.add("en");
        langsUNO.add("cs");
        langsUNO.add("de");
        langsUNO.add("es");
        langsUNO.add("fr");
        langsUNO.add("hu");
        langsUNO.add("it");
        langsUNO.add("ja");
        langsUNO.add("ko");
        langsUNO.add("pl");
        langsUNO.add("pt");
        langsUNO.add("ru");
        langsUNO.add("zh");
        HashSet<Character> f = new HashSet<Character>(349);
        ordinaryFlagsSet.put(PLATFORM_LUWO_KEY, f);
        f.add(Character.valueOf('#'));
        f.add(Character.valueOf('$'));
        f.add(Character.valueOf('@'));
        SQLIdentifier.initCommonOrdinaryFlags(f);
        Locale locale = Locale.getDefault();
        SQLIdentifier.initOrdinaryFlagsLUWO(f, locale);
        return f;
    }

    public static String getQualifiedName(String schema, String name, ConnectionInfo conInfo) {
        String sqlName = SQLIdentifier.toSQLFormat(name, conInfo);
        if (schema != null && schema.length() > 0) {
            String sqlSchema = SQLIdentifier.toSQLFormat(schema, conInfo);
            return NLS.bind((String)QUALIFIED_NAME_TEMPLATE, (Object)sqlSchema, (Object)sqlName);
        }
        return sqlName;
    }

    public static String getQualifiedName(String schema, String name, DatabaseDefinition dbDef) {
        String sqlName = SQLIdentifier.toSQLFormat(name, dbDef);
        if (schema != null && schema.length() > 0) {
            String sqlSchema = SQLIdentifier.toSQLFormat(schema, dbDef);
            return NLS.bind((String)QUALIFIED_NAME_TEMPLATE, (Object)sqlSchema, (Object)sqlName);
        }
        return sqlName;
    }

    public static String getQualifiedName(String[] names, ConnectionInfo conInfo) {
        String sqlName1 = null;
        int count = names.length;
        ArrayList<String> nns = new ArrayList<String>(count);
        int n = 0;
        while (n < count) {
            if (names[n] != null && names[n].length() > 0) {
                nns.add(names[n]);
            }
            ++n;
        }
        count = nns.size();
        if (count > 0) {
            sqlName1 = SQLIdentifier.toSQLFormat((String)nns.get(0), conInfo);
            if (count > 1) {
                n = 1;
                while (n < count) {
                    String sqlName2 = SQLIdentifier.toSQLFormat((String)nns.get(n), conInfo);
                    sqlName1 = NLS.bind((String)QUALIFIED_NAME_TEMPLATE, (Object)sqlName1, (Object)sqlName2);
                    ++n;
                }
            }
        }
        return sqlName1;
    }

    public static String getQualifiedName(String[] names, DatabaseDefinition dbDef) {
        String sqlName1 = null;
        int count = names.length;
        ArrayList<String> nns = new ArrayList<String>(count);
        int n = 0;
        while (n < count) {
            if (names[n] != null && names[n].length() > 0) {
                nns.add(names[n]);
            }
            ++n;
        }
        count = nns.size();
        if (count > 0) {
            sqlName1 = SQLIdentifier.toSQLFormat((String)nns.get(0), dbDef);
            if (count > 1) {
                n = 1;
                while (n < count) {
                    String sqlName2 = SQLIdentifier.toSQLFormat((String)nns.get(n), dbDef);
                    sqlName1 = NLS.bind((String)QUALIFIED_NAME_TEMPLATE, (Object)sqlName1, (Object)sqlName2);
                    ++n;
                }
            }
        }
        return sqlName1;
    }
}

