/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process.processes;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SetEnvironmentVariable
extends ProcessRunner {
    private static final String PROJECTNAME_VARNAME = "projectName";
    private static final String VARIABLES_VARNAME = "variables";
    private static final String VARIABLES_NAME_VARNAME = "name";
    private static final String VARIABLES_VALUE_VARNAME = "value";

    @Override
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        IProject project = null;
        LinkedHashMap<String, String> envVars = new LinkedHashMap<String, String>();
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            String argName = arg.getName();
            if (PROJECTNAME_VARNAME.equals(argName)) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(arg.getSimpleValue());
            } else if (VARIABLES_VARNAME.equals(argName)) {
                ProcessArgument[][] processArgumentArray2 = arg.getComplexArrayValue();
                int n3 = processArgumentArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    ProcessArgument[] envVarArgs = processArgumentArray2[n4];
                    String name = null;
                    String value = null;
                    ProcessArgument[] processArgumentArray3 = envVarArgs;
                    int n5 = envVarArgs.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ProcessArgument varArg = processArgumentArray3[n6];
                        String varArgName = varArg.getName();
                        if (VARIABLES_NAME_VARNAME.equals(varArgName)) {
                            name = varArg.getSimpleValue();
                        } else if (VARIABLES_VALUE_VARNAME.equals(varArgName)) {
                            value = varArg.getSimpleValue();
                        }
                        ++n6;
                    }
                    if (name == null) {
                        throw this.missingArgException(processId, VARIABLES_NAME_VARNAME);
                    }
                    if (value == null) {
                        throw this.missingArgException(processId, VARIABLES_VALUE_VARNAME);
                    }
                    envVars.put(name, value);
                    ++n4;
                }
            }
            ++n2;
        }
        if (project == null) {
            throw this.missingArgException(processId, PROJECTNAME_VARNAME);
        }
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(project, true);
        ICConfigurationDescription[] configDescs = des.getConfigurations();
        IContributedEnvironment ice = CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment();
        for (Map.Entry envVar : envVars.entrySet()) {
            String name = (String)envVar.getKey();
            String value = (String)envVar.getValue();
            ICConfigurationDescription[] iCConfigurationDescriptionArray = configDescs;
            int n7 = configDescs.length;
            int n8 = 0;
            while (n8 < n7) {
                ICConfigurationDescription configDesc = iCConfigurationDescriptionArray[n8];
                ice.addVariable(name, value, 1, null, configDesc);
                ++n8;
            }
        }
        try {
            mngr.setProjectDescription(project, des);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }
}

