/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchQuery;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchResult;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.IfBlock;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class AcceleoOccurrencesFinderJob
extends Job {
    public static final String FIND_OCCURENCES_ANNOTATION_TYPE = "org.eclipse.jdt.ui.occurrences";
    private AcceleoEditor editor;
    private ReferencesSearchQuery query;

    public AcceleoOccurrencesFinderJob(AcceleoEditor editor, String name, ReferencesSearchQuery query) {
        super(name);
        this.editor = editor;
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        IAnnotationModel annotationModel;
        boolean shouldContinue;
        ReferencesSearchQuery capturedQuery = this.query;
        AcceleoEditor capturedEditor = this.editor;
        ReferencesSearchResult result = (ReferencesSearchResult)capturedQuery.getSearchResult();
        IStatus status = Status.OK_STATUS;
        int origPriority = Thread.currentThread().getPriority();
        try {
            Thread.currentThread().setPriority(1);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            status = capturedQuery.run(monitor);
        }
        finally {
            try {
                Thread.currentThread().setPriority(origPriority);
            }
            catch (SecurityException securityException) {}
        }
        boolean bl = shouldContinue = capturedEditor != null && capturedEditor.getDocumentProvider() != null && capturedEditor.getEditorInput() != null;
        if (!monitor.isCanceled() && shouldContinue && capturedEditor != null && (annotationModel = capturedEditor.getDocumentProvider().getAnnotationModel((Object)capturedEditor.getEditorInput())) != null) {
            List<Match> matches = this.listOfTheOccurencesInTheCurrentFile(result);
            for (Match match : matches) {
                ReferenceEntry ref = null;
                if (!(match.getElement() instanceof ReferenceEntry)) continue;
                ref = (ReferenceEntry)match.getElement();
                if (monitor.isCanceled()) {
                    status = Status.CANCEL_STATUS;
                }
                if (capturedEditor.getDocumentProvider() == null || capturedEditor.getDocumentProvider().getAnnotationModel((Object)capturedEditor.getEditorInput()) == null) {
                    status = Status.CANCEL_STATUS;
                }
                if (status == Status.CANCEL_STATUS) {
                    return status;
                }
                String description = ref.getMatch().eClass().getName();
                try {
                    description = ref.getMatch().toString();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                HashMap<Annotation, Position> annotations2positions = new HashMap<Annotation, Position>();
                for (Position position : this.computePositions(ref)) {
                    if (position == null) continue;
                    annotations2positions.put(new Annotation(FIND_OCCURENCES_ANNOTATION_TYPE, false, description), position);
                }
                if (annotationModel instanceof IAnnotationModelExtension) {
                    IAnnotationModelExtension annotationModelExtension = (IAnnotationModelExtension)annotationModel;
                    Object object = this.getLockObject(annotationModel);
                    synchronized (object) {
                        annotationModelExtension.replaceAnnotations(new Annotation[0], annotations2positions);
                        continue;
                    }
                }
                Set entrySet = annotations2positions.entrySet();
                for (Map.Entry entry : entrySet) {
                    annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                }
            }
        }
        this.editor = null;
        this.query = null;
        return status;
    }

    private List<Position> computePositions(ReferenceEntry ref) {
        ArrayList<Position> positions = new ArrayList<Position>();
        if (!(ref.getMatch() instanceof ASTNode)) {
            return positions;
        }
        ASTNode astNode = (ASTNode)ref.getMatch();
        if (!(astNode instanceof Block)) {
            positions.add(new Position(astNode.getStartPosition(), astNode.getEndPosition() - astNode.getStartPosition()));
        } else {
            Block block = (Block)astNode;
            if (block.getBody() != null && block.getBody().size() > 0) {
                OCLExpression startBody = (OCLExpression)block.getBody().get(0);
                if (!startBody.eIsProxy() || startBody.getStartPosition() >= block.getStartPosition() && startBody.getStartPosition() <= block.getEndPosition()) {
                    Position startPosition = new Position(block.getStartPosition(), startBody.getStartPosition() - 1 - block.getStartPosition());
                    positions.add(startPosition);
                }
                Position endPosition = null;
                endPosition = block instanceof IfBlock ? this.computeIfEndRegion((IfBlock)block) : (block instanceof LetBlock ? this.computeLetEndRegion((LetBlock)block) : new Position(((OCLExpression)block.getBody().get(block.getBody().size() - 1)).getEndPosition(), block.getEndPosition() - ((OCLExpression)block.getBody().get(block.getBody().size() - 1)).getEndPosition()));
                positions.add(endPosition);
            } else {
                positions.add(new Position(block.getStartPosition(), block.getEndPosition() - block.getStartPosition()));
            }
        }
        return positions;
    }

    private Position computeIfEndRegion(IfBlock iBlock) {
        Position endRegion = null;
        Block else1 = iBlock.getElse();
        EList elseIf = iBlock.getElseIf();
        if (else1 != null && elseIf != null && elseIf.size() > 0) {
            int endPosition2;
            int endPosition = else1.getEndPosition();
            endRegion = endPosition > (endPosition2 = ((IfBlock)elseIf.get(elseIf.size() - 1)).getEndPosition()) ? new Position(endPosition, iBlock.getEndPosition() - endPosition) : new Position(endPosition2, iBlock.getEndPosition() - endPosition2);
        } else if (else1 == null && elseIf != null && elseIf.size() > 0) {
            int endPosition = ((IfBlock)elseIf.get(elseIf.size() - 1)).getEndPosition();
            endRegion = new Position(endPosition, iBlock.getEndPosition() - endPosition);
        } else if (elseIf == null || elseIf.size() == 0) {
            if (else1 != null) {
                int endPosition = else1.getEndPosition();
                endRegion = new Position(endPosition, iBlock.getEndPosition() - endPosition);
            } else {
                endRegion = new Position(((OCLExpression)iBlock.getBody().get(iBlock.getBody().size() - 1)).getEndPosition(), iBlock.getEndPosition() - ((OCLExpression)iBlock.getBody().get(iBlock.getBody().size() - 1)).getEndPosition());
            }
        }
        return endRegion;
    }

    private Position computeLetEndRegion(LetBlock eBlock) {
        Position endRegion = null;
        Block else1 = eBlock.getElse();
        EList elseLet = eBlock.getElseLet();
        if (else1 != null && elseLet != null && elseLet.size() > 0) {
            int endPosition2;
            int endPosition = else1.getEndPosition();
            endRegion = endPosition > (endPosition2 = ((LetBlock)elseLet.get(elseLet.size() - 1)).getEndPosition()) ? new Position(endPosition, eBlock.getEndPosition() - endPosition) : new Position(endPosition2, eBlock.getEndPosition() - endPosition2);
        } else if (else1 == null && elseLet != null && elseLet.size() > 0) {
            int endPosition = ((LetBlock)elseLet.get(elseLet.size() - 1)).getEndPosition();
            endRegion = new Position(endPosition, eBlock.getEndPosition() - endPosition);
        } else if (else1 != null && (elseLet == null || elseLet.size() == 0)) {
            int endPosition = else1.getEndPosition();
            endRegion = new Position(endPosition, eBlock.getEndPosition() - endPosition);
        } else if (else1 == null || elseLet != null && elseLet.size() == 0) {
            endRegion = new Position(((OCLExpression)eBlock.getBody().get(eBlock.getBody().size() - 1)).getEndPosition(), eBlock.getEndPosition() - ((OCLExpression)eBlock.getBody().get(eBlock.getBody().size() - 1)).getEndPosition());
        }
        return endRegion;
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    private List<Match> listOfTheOccurencesInTheCurrentFile(AbstractTextSearchResult result) {
        List<Match> list = new ArrayList<Match>();
        Object[] objectArray = result.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ReferenceEntry && ((ReferenceEntry)object).getRegion() != null) {
                ReferenceEntry ref = (ReferenceEntry)object;
                list.add(new Match((Object)ref, ref.getRegion().getOffset(), ref.getRegion().getLength()));
            }
            ++n2;
        }
        IFile file = this.editor.getFile();
        list = OpenDeclarationUtils.getMatchesFromTheFile(list, file);
        return list;
    }

    protected void canceling() {
        this.editor = null;
        this.query = null;
        super.canceling();
    }

    public void clear() {
        this.editor = null;
        this.query = null;
    }
}

