/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.List;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.typeinference.FakeField;

public class FunctionArgumentsStrategy
extends AbstractCompletionStrategy {
    public FunctionArgumentsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public FunctionArgumentsStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)this.getContext();
        CompletionRequestor requestor = abstractContext.getCompletionRequestor();
        int offset = this.getCompanion().getOffset();
        ISourceModule sourceModule = this.getCompanion().getSourceModule();
        PHPModuleDeclaration moduleDeclaration = this.getCompanion().getModuleDeclaration();
        Declaration declaration = ASTUtils.findDeclarationAfterPHPdoc(moduleDeclaration, offset);
        if (declaration instanceof MethodDeclaration) {
            String prefix = abstractContext.getPrefix();
            ISourceRange replaceRange = this.getReplacementRange(abstractContext);
            String suffix = "";
            List arguments = ((MethodDeclaration)declaration).getArguments();
            for (Argument arg : arguments) {
                String argumentVar = arg.getName();
                if (!argumentVar.startsWith(prefix) || requestor.isContextInformationMode() && argumentVar.length() != prefix.length()) continue;
                reporter.reportField((IField)new FakeField((ModelElement)sourceModule, argumentVar, 0, 0), suffix, replaceRange, false);
            }
        }
    }
}

