/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.websocket.jakarta;

import jakarta.websocket.MessageHandler;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.MessageIssueHandler;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.messages.Message;

public class WebSocketMessageHandler
implements MessageHandler.Whole<String> {
    private final MessageConsumer callback;
    private final MessageJsonHandler jsonHandler;
    private final MessageIssueHandler issueHandler;

    public WebSocketMessageHandler(MessageConsumer callback, MessageJsonHandler jsonHandler, MessageIssueHandler issueHandler) {
        this.callback = callback;
        this.jsonHandler = jsonHandler;
        this.issueHandler = issueHandler;
    }

    public void onMessage(String content) {
        try {
            Message message = this.jsonHandler.parseMessage((CharSequence)content);
            this.callback.consume(message);
        }
        catch (MessageIssueException exception) {
            this.issueHandler.handle(exception.getRpcMessage(), exception.getIssues());
        }
    }
}

