/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.generatedfile;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedFileManager;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedSourceFolderManager;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GeneratedResourceChangeListener
implements IResourceChangeListener {
    private final Set<IResource> deletedResources = Collections.synchronizedSet(new HashSet());

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            IProject p = (IProject)event.getResource();
            if (AptPlugin.DEBUG_GFM) {
                AptPlugin.trace("generated resource change listener got a pre-close event: project = " + p.getName());
            }
            IJavaProject jp = JavaCore.create((IProject)p);
            AptPlugin.getAptProject(jp).projectClosed();
        } else if (event.getType() == 4) {
            IProject p = (IProject)event.getResource();
            if (AptPlugin.DEBUG_GFM) {
                AptPlugin.trace("generated resource change listener got a pre-delete event: project = " + p.getName());
            }
            IJavaProject jp = JavaCore.create((IProject)p);
            AptPlugin.getAptProject(jp).projectDeleted();
            AptPlugin.deleteAptProject(jp);
        } else if (event.getType() == 8) {
            try {
                if (AptPlugin.DEBUG_GFM) {
                    AptPlugin.trace("generated resource change listener got a pre-build event");
                }
                PreBuildVisitor pbv = new PreBuildVisitor();
                for (IResource resource : this.deletedResources) {
                    pbv.handleDeletion(resource);
                }
                event.getDelta().accept((IResourceDeltaVisitor)pbv);
                this.addGeneratedSrcFolderTo(pbv.getProjectsThatNeedGenSrcFolder(), false);
                this.addGeneratedSrcFolderTo(pbv.getProjectsThatNeedGenTestSrcFolder(), true);
                this.deletedResources.clear();
            }
            catch (CoreException ce) {
                AptPlugin.log(ce, "Error during pre-build resource change");
            }
        } else if (event.getType() == 1) {
            if (AptPlugin.DEBUG_GFM) {
                AptPlugin.trace("generated resource change listener got a post-change event");
            }
            PostChangeVisitor pcv = new PostChangeVisitor();
            try {
                event.getDelta().accept((IResourceDeltaVisitor)pcv);
            }
            catch (CoreException ce) {
                AptPlugin.log(ce, "Error during post-change resource event");
            }
        }
    }

    private void addGeneratedSrcFolderTo(Set<IProject> projs, boolean isTestCode) {
        for (IProject proj : projs) {
            IJavaProject javaProj = JavaCore.create((IProject)proj);
            if (!javaProj.getProject().isOpen() || !AptConfig.isEnabled(javaProj)) continue;
            GeneratedSourceFolderManager gsfm = AptPlugin.getAptProject(javaProj).getGeneratedSourceFolderManager(isTestCode);
            gsfm.ensureFolderExists();
        }
    }

    private class PostChangeVisitor
    implements IResourceDeltaVisitor {
        private PostChangeVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getKind() == 2) {
                if (AptPlugin.DEBUG_GFM) {
                    AptPlugin.trace("generated resource post-change listener adding to deletedResources:" + delta.getResource().getName());
                }
                GeneratedResourceChangeListener.this.deletedResources.add(delta.getResource());
            }
            return true;
        }
    }

    private class PreBuildVisitor
    implements IResourceDeltaVisitor {
        private final Set<IProject> _addGenFolderTo = new HashSet<IProject>();
        private final Set<IProject> _addGenTestFolderTo = new HashSet<IProject>();
        private final Set<IProject> _removedProjects = new HashSet<IProject>();

        private PreBuildVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource r = delta.getResource();
            IProject project = r.getProject();
            if (project == null) {
                return true;
            }
            if (delta.getKind() == 2) {
                if (!GeneratedResourceChangeListener.this.deletedResources.contains(r)) {
                    this.handleDeletion(r);
                }
            } else if (r instanceof IProject) {
                IProject proj = (IProject)delta.getResource();
                if (this.canUpdate(proj)) {
                    this._addGenFolderTo.add(proj);
                    this._addGenTestFolderTo.add(proj);
                } else {
                    this._removedProjects.add(proj);
                }
            }
            return true;
        }

        private void handleDeletion(IResource resource) throws CoreException {
            if (AptPlugin.DEBUG_GFM) {
                AptPlugin.trace("handleDeletion: resource = " + resource.getName());
            }
            IProject project = resource.getProject();
            IJavaProject javaProj = JavaCore.create((IProject)project);
            AptProject aptProj = AptPlugin.getAptProject(javaProj);
            if (resource instanceof IFile) {
                GeneratedFileManager gfm = aptProj.getGeneratedFileManager(false);
                IFile f = (IFile)resource;
                gfm.fileDeleted(f);
                aptProj.getGeneratedFileManager(true).fileDeleted(f);
            } else if (resource instanceof IFolder) {
                GeneratedSourceFolderManager testgsfm;
                IFolder f = (IFolder)resource;
                GeneratedSourceFolderManager gsfm = aptProj.getGeneratedSourceFolderManager(false);
                if (gsfm.isGeneratedSourceFolder(f)) {
                    gsfm.folderDeleted();
                    if (!this._removedProjects.contains(project)) {
                        this._addGenFolderTo.add(project);
                    }
                }
                if ((testgsfm = aptProj.getGeneratedSourceFolderManager(true)).isGeneratedSourceFolder(f)) {
                    testgsfm.folderDeleted();
                    if (!this._removedProjects.contains(project)) {
                        this._addGenTestFolderTo.add(project);
                    }
                }
            } else if (resource instanceof IProject) {
                this._removedProjects.add((IProject)resource);
            }
        }

        Set<IProject> getProjectsThatNeedGenSrcFolder() {
            this._addGenFolderTo.removeAll(this._removedProjects);
            return this._addGenFolderTo;
        }

        Set<IProject> getProjectsThatNeedGenTestSrcFolder() {
            this._addGenTestFolderTo.removeAll(this._removedProjects);
            return this._addGenTestFolderTo;
        }

        private boolean canUpdate(IProject proj) throws CoreException {
            return proj.isOpen() && proj.exists() && proj.hasNature("org.eclipse.jdt.core.javanature");
        }
    }
}

