/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.internal.core.search.mixin;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.ExtendedTclMethodDeclaration;
import org.eclipse.dltk.tcl.core.extensions.IMixinBuildVisitorExtension;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinBuildVisitor;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclField;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclFieldDeclaration;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclInstanceVariable;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclMethodDeclaration;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclObjectDeclaration;
import org.eclipse.dltk.xotcl.internal.core.search.mixin.model.XOTclClass;
import org.eclipse.dltk.xotcl.internal.core.search.mixin.model.XOTclClassInstance;
import org.eclipse.dltk.xotcl.internal.core.search.mixin.model.XOTclInstProc;
import org.eclipse.dltk.xotcl.internal.core.search.mixin.model.XOTclObject;
import org.eclipse.dltk.xotcl.internal.core.search.mixin.model.XOTclProc;

public class XOTclMixinBuildVisitorExtension
implements IMixinBuildVisitorExtension {
    public boolean visit(MethodDeclaration s, TclMixinBuildVisitor original) {
        if (s instanceof XOTclMethodDeclaration) {
            this.visitXOTclMethod(s, original);
            return true;
        }
        return false;
    }

    private void visitXOTclMethod(MethodDeclaration s, TclMixinBuildVisitor original) {
        ExtendedTclMethodDeclaration method = (ExtendedTclMethodDeclaration)s;
        IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
        String name = s.getName();
        ASTNode declaringXOTclType = method.getDeclaringType();
        if (declaringXOTclType != null && declaringXOTclType instanceof TypeDeclaration) {
            List levels = TclParseUtil.findLevelsTo((ModuleDeclaration)original.getModuleDeclaration(), (ASTNode)declaringXOTclType);
            info.key = String.valueOf(original.getKeyFromLevels(levels)) + IMixinRequestor.MIXIN_NAME_SEPARATOR + original.tclNameToKey(name);
        }
        if (original.getSignature()) {
            switch (method.getKind()) {
                case 1: {
                    info.object = new XOTclInstProc();
                    break;
                }
                case 0: {
                    info.object = new XOTclProc();
                }
            }
        }
        original.getRequestor().reportElement(info);
    }

    public boolean visit(TypeDeclaration s, TclMixinBuildVisitor original) {
        if ((s.getModifiers() & 0x100000) != 0) {
            IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
            info.key = String.valueOf(original.getNamespacePrefix()) + original.tclNameToKey(s.getName());
            if (info.key.startsWith("{")) {
                info.key = info.key.substring(1);
            }
            original.pushNamespaceName(s);
            if (original.getSignature()) {
                if (s instanceof XOTclObjectDeclaration) {
                    info.object = new XOTclObject();
                } else {
                    XOTclClass tclClass = new XOTclClass();
                    info.object = tclClass;
                    tclClass.setNamespace(original.getNamespacePrefix());
                }
            }
            original.getRequestor().reportElement(info);
            return true;
        }
        return false;
    }

    public boolean visit(Statement s, TclMixinBuildVisitor original) {
        if (s instanceof XOTclInstanceVariable) {
            XOTclInstanceVariable instanceVar = (XOTclInstanceVariable)s;
            List levels = TclParseUtil.findLevelsTo((ModuleDeclaration)original.getModuleDeclaration(), (ASTNode)instanceVar);
            IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
            info.key = original.getKeyFromLevels(levels);
            if (original.getSignature()) {
                info.object = new XOTclClassInstance();
            }
            original.getRequestor().reportElement(info);
            return true;
        }
        if (s instanceof XOTclFieldDeclaration) {
            XOTclFieldDeclaration var = (XOTclFieldDeclaration)s;
            String name = var.getName();
            TypeDeclaration type = var.getDeclaringType();
            List levels = TclParseUtil.findLevelsTo((ModuleDeclaration)original.getModuleDeclaration(), (ASTNode)type);
            IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
            info.key = String.valueOf(original.getKeyFromLevels(levels)) + IMixinRequestor.MIXIN_NAME_SEPARATOR + original.tclNameToKey(name);
            if (original.getSignature()) {
                info.object = new TclField();
            }
            original.getRequestor().reportElement(info);
            return true;
        }
        return false;
    }
}

